/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.common.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class LogWatchHelper {
    private static final Logger log = LoggerFactory.getLogger(LogWatchHelper.class);
    public static final ThreadLocal<LogWatchHelper> threadLocal = new ThreadLocal();
    private StopWatch stopWatch;
    private int logCount = 0;
    private final Map<String, Long> taskCountMap = new LinkedHashMap<String, Long>();
    private final Map<String, String> taskLogMap = new LinkedHashMap<String, String>();

    public static LogWatchHelper getThreadLocalLog() {
        return threadLocal.get();
    }

    public static void setThreadLocalLog(LogWatchHelper logWatchHelper) {
        threadLocal.set(logWatchHelper);
    }

    public static void removeThreadLocalLog() {
        threadLocal.remove();
    }

    public static LogWatchHelper initLog(String logName) {
        LogWatchHelper logWatchHelper = LogWatchHelper.getThreadLocalLog();
        if (logWatchHelper == null) {
            logWatchHelper = new LogWatchHelper();
            logWatchHelper.stopWatch = new StopWatch(logName);
            LogWatchHelper.setThreadLocalLog(logWatchHelper);
        }
        return logWatchHelper;
    }

    public void start(String taskName) {
        LogWatchHelper.newTask(taskName);
    }

    public static void newTask(String taskName) {
        LogWatchHelper logWatchHelper = LogWatchHelper.getThreadLocalLog();
        StopWatch stopWatch = logWatchHelper.stopWatch;
        if (stopWatch.isRunning()) {
            stopWatch.stop();
        }
        stopWatch.start(taskName);
    }

    public static void appendTaskLog(String appendData) {
        LogWatchHelper logWatchHelper = LogWatchHelper.getThreadLocalLog();
        Map<String, String> logDataMap = logWatchHelper.taskLogMap;
        StopWatch stopWatch = logWatchHelper.stopWatch;
        String logData = logDataMap.get(stopWatch.currentTaskName());
        logData = logData == null ? appendData : logData + "\uff1b" + appendData;
        logDataMap.put(stopWatch.currentTaskName(), logData);
    }

    public static void addTaskCount() {
        LogWatchHelper logWatchHelper = LogWatchHelper.getThreadLocalLog();
        Map<String, Long> logCountMap = logWatchHelper.taskCountMap;
        StopWatch stopWatch = logWatchHelper.stopWatch;
        Long taskCount = logCountMap.get(stopWatch.currentTaskName());
        if (taskCount == null) {
            taskCount = 0L;
        }
        taskCount = taskCount + 1L;
        logCountMap.put(stopWatch.currentTaskName(), taskCount);
        logWatchHelper.logCount = ++logWatchHelper.logCount;
    }

    public static void print(String content) {
        try {
            LogWatchHelper logWatchHelper = LogWatchHelper.getThreadLocalLog();
            StopWatch stopWatch = logWatchHelper.stopWatch;
            if (stopWatch.isRunning()) {
                stopWatch.stop();
            }
            log.info(stopWatch.prettyPrint());
            log.info("totalTimeMillis\uff1a{} count\uff1a{}", (Object)BigDecimal.valueOf(stopWatch.getTotalTimeNanos()).divide(BigDecimal.valueOf(1000000L), 4, RoundingMode.HALF_UP).doubleValue(), (Object)logWatchHelper.logCount);
            log.info("taskCountMap info {}", logWatchHelper.taskCountMap);
            log.info("taskLogMap info {}", logWatchHelper.taskLogMap);
            log.info("task info {}", (Object)content);
        }
        finally {
            LogWatchHelper.removeThreadLocalLog();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        LogWatchHelper.initLog("\u7ec4\u7ec7\u67b6\u6784\u6811");
        LogWatchHelper.newTask("\u4efb\u52a11");
        LogWatchHelper.addTaskCount();
        LogWatchHelper.addTaskCount();
        LogWatchHelper.newTask("\u4efb\u52a12");
        LogWatchHelper.addTaskCount();
        LogWatchHelper.appendTaskLog("list size10");
        LogWatchHelper.appendTaskLog("map size70");
        LogWatchHelper.newTask("\u4efb\u52a13");
        LogWatchHelper.print("");
    }
}

