/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.enums;

import java.util.ArrayList;
import java.util.List;

public enum EventMsgEnum {
    OPEN_DOOR_EVENT(1, "\u8fdb\u5e97"),
    CLOSE_DOOR_EVENT(2, "\u51fa\u5e97"),
    ORDER_EVENT(3, "\u8ba2\u5355"),
    START_CLOUD_WATCH_EVENT(4, "\u5f00\u542f\u4e91\u503c\u5b88"),
    END_CLOUD_WATCH_EVENT(5, "\u5173\u95ed\u4e91\u503c\u5b88"),
    STAFF_OPEN_DOOR_EVENT(6, "\u5ba2\u670d\u5f00\u95e8"),
    STAFF_CLOSE_DOOR_EVENT(7, "\u5ba2\u670d\u5173\u95e8"),
    PAY_EVENT(8, "\u4ed8\u6b3e"),
    REFUND_EVENT(9, "\u9000\u6b3e"),
    RECOVERY_EVENT(10, "\u8ffd\u7f34");

    private final int type;
    private final String name;

    private EventMsgEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public static List<Integer> getShowType() {
        ArrayList<Integer> showType = new ArrayList<Integer>();
        for (EventMsgEnum value : EventMsgEnum.values()) {
            if (value.getType() == PAY_EVENT.getType() || value.getType() == RECOVERY_EVENT.getType() || value.getType() == REFUND_EVENT.getType()) continue;
            showType.add(value.getType());
        }
        return showType;
    }

    public static String getNameByType(Integer eventType) {
        for (EventMsgEnum value : EventMsgEnum.values()) {
            if (value.getType() != eventType.intValue()) continue;
            return value.getName();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static boolean containEvent(Integer type) {
        if (type == null) {
            return false;
        }
        for (EventMsgEnum eventMsgEnum : EventMsgEnum.values()) {
            if (type.intValue() != eventMsgEnum.getType()) continue;
            return true;
        }
        return false;
    }
}

