/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.exception;

public enum CloudWatchErrorCode {
    SYSTEM_ERROR(100, "\u7cfb\u7edf\u5185\u90e8\u9519\u8bef"),
    STORE_NOT_INFO(101, "\u7f3a\u5c11\u95e8\u5e97\u4fe1\u606f"),
    FOREIGN_INTERFACE_ERROR(102, "\u8fdc\u7a0b\u63a5\u53e3\u8c03\u7528\u62a5\u9519,\u8bf7\u67e5\u770b\u65e5\u5fd7"),
    PARAMS_FALSE(103, "\u6821\u9a8c\u4f20\u53c2\uff0c\u4f20\u53c2\u62a5\u9519"),
    CLIENT_INFO_NOT(104, "\u7f3a\u5c11\u7528\u6237\u4fe1\u606f"),
    TOKEN_NOT_EXIST(105, "\u7f3a\u5c11token\u4fe1\u606f"),
    TOKEN_NOT_INVALID(106, "token\u5931\u6548"),
    STORE_QUERY_FALSE(107, "\u95e8\u5e97\u67e5\u8be2\u51fa\u9519"),
    CLOUD_WATCH_STATE_NOT(107, "\u95e8\u5e97\u4e91\u503c\u5b88\u72b6\u6001\u4e0d\u4e00\u81f4"),
    MASTER_START_CLOUD_WATCH(108, "\u5f00\u542f\u4e91\u503c\u5b88\u5931\u8d25"),
    CURRENT_STORE_CLOUD_WATCH_ERROR(109, "\u5f53\u524d\u95e8\u5e97\u4e0d\u5904\u4e8e\u4e91\u503c\u5b88\u72b6\u6001\u4e2d"),
    CURRENT_STORE_REPEAT_CLOUD_WATCH_ERROR(110, "\u5f53\u524d\u95e8\u5e97\u5df2\u7ecf\u5904\u4e8e\u4e91\u503c\u5b88\u72b6\u6001\u4e2d"),
    PERMISSION_REJECT(111, "\u5f53\u524d\u7528\u6237\u65e0\u6743\u9650"),
    INTERFACE_PAGE_ERROR(112, "\u8be5\u63a5\u53e3\u4ec5\u652f\u6301\u5206\u9875"),
    START_WATCH_FAIL_NO_CLIENT(113, "\u5f00\u542f\u5931\u8d25\uff0c\u6682\u65e0\u503c\u5b88\u5ba2\u670d"),
    WAN_JI_INTERFACE_ERROR(114, "\u4e07\u96c6\u63a5\u53e3\u8c03\u7528\u5931\u8d25"),
    MASTER_INTERFACE_ERROR(115, "\u4e3b\u7ebf\u63a5\u53e3\u8c03\u7528\u5931\u8d25"),
    WATCH_INTERFACE_ERROR(116, "\u503c\u5b88\u7aef\u63a5\u53e3\u8c03\u7528\u5931\u8d25"),
    LACK_NO_ERROR(117, "\u7f3a\u5c11\u8bc1\u4ef6\u53f7\u7801"),
    NO_PERMISSION_ERROR(118, "\u6240\u5728\u95e8\u5e97\u65e0\u4e91\u503c\u5b88\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u8fd0\u8425\u5728\u5e73\u53f0\u4fa7\u5f00\u542f"),
    DEVICE_DOOR_NOT_BIND_ERROR(119, "\u8be5\u95e8\u5e97\u95e8\u7981\u8fd8\u672a\u7ed1\u5b9a\u4e8c\u7ef4\u7801\uff0c\u8bf7\u5728\u6211\u7684\u8bbe\u5907-\u95e8\u7981\u4e2d\u626b\u7801\u7ed1\u5b9a"),
    STORE_ID_NOT_EXIST(120, "\u6307\u5b9a\u95e8\u5e97id"),
    MASTER_CLOUD_WATCH_STATE_FAIL(121, "\u4e3b\u7ebf\u4e91\u503c\u5b88\u72b6\u6001\u53d8\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u6743\u9650"),
    DEVICE_CLOUD_WATCH_STATE_FAIL(122, "\u4e91\u503c\u5b88\u8bbe\u5907\u901a\u77e5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5907\u662f\u5426\u5728\u7ebf"),
    WATCH_KAKFA_ERROR(123, "kafka\u6d88\u606f\u901a\u77e5\u503c\u5b88\u7aef\u5931\u8d25"),
    CLOUD_WATCH_CUSTOMER_FAIL(124, "\u83b7\u53d6\u503c\u5b88\u4eba\u5458\u5931\u8d25"),
    CLOUD_WATCH_CUSTOMER_NOT_EXIST(125, "\u95e8\u5e97\u65e0\u503c\u5b88\u4eba\u5458"),
    BIND_DEVICE(126, "\u8bf7\u5728\u6211\u7684\u8bbe\u5907\u4e2d\u5148\u7ed1\u5b9a\u8bbe\u5907"),
    STORE_DEVICE_OFFLINE(127, "\u95e8\u5e97\u6709\u8bbe\u5907\u79bb\u7ebf"),
    DEVICE_INFO_FAIL(128, "\u95e8\u5e97\u8bbe\u5907\u4fe1\u606f\u83b7\u53d6\u5931\u8d25"),
    DEVICE_ID_NOT_ONLINE(129, "\u6307\u5b9a\u76f8\u5173\u8bbe\u5907id"),
    INDOOR_OUTDOOR_ERROR(130, "\u65e0\u6cd5\u533a\u5206\u5ba4\u5185\u5ba4\u5916"),
    MASTER_STORE_INFO_ERROR(131, "\u95e8\u5e97\u4fe1\u606f\u83b7\u53d6\u5931\u8d25"),
    CLOUD_WATCH_PLAY_AUDIO_ERROR(132, "\u8bd5\u97f3\u63a5\u53e3\u8c03\u7528\u5931\u8d25"),
    LACK_LICENSE_ERROR(133, "\u7f3a\u5c11\u8425\u4e1a\u6267\u7167");

    private final int code;
    private final String text;

    private CloudWatchErrorCode(int code, String text) {
        this.code = code;
        this.text = text;
    }

    public int getErrorCode() {
        return this.code;
    }

    public String getErrorText() {
        return this.text;
    }

    public String toString() {
        return String.valueOf(this.getErrorCode()) + ":" + this.getErrorText();
    }

    public static CloudWatchErrorCode valueOf(int code) {
        for (CloudWatchErrorCode err : CloudWatchErrorCode.values()) {
            if (err.getErrorCode() != code) continue;
            return err;
        }
        return SYSTEM_ERROR;
    }
}

