/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.exception;

import com.ovopark.cloud.exception.CloudWatchErrorCode;
import org.apache.commons.lang3.StringUtils;

public class CloudWatchException
extends RuntimeException {
    private int errCode;
    private String errMsg;

    public CloudWatchException() {
    }

    public CloudWatchException(String message, Throwable cause) {
        super(message, cause);
        this.errMsg = message;
    }

    public CloudWatchException(String message) {
        super(message);
        this.errMsg = message;
    }

    public CloudWatchException(Throwable cause) {
        super(cause);
    }

    public CloudWatchException(int errCode, String errMsg) {
        super(errCode + ":" + errMsg);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public CloudWatchException(int errCode, String errMsg, Throwable cause) {
        super(errCode + ":" + errMsg, cause);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public CloudWatchException(CloudWatchErrorCode cloudWatchErrorCode, String errorMsg) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(cloudWatchErrorCode.getErrorText());
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            strBuilder.append(":").append(errorMsg);
        }
        this.errCode = cloudWatchErrorCode.getErrorCode();
        this.errMsg = strBuilder.toString();
    }

    public CloudWatchException(CloudWatchErrorCode cloudWatchErrorCode) {
        super(cloudWatchErrorCode.getErrorText());
        this.errCode = cloudWatchErrorCode.getErrorCode();
        this.errMsg = cloudWatchErrorCode.getErrorText();
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

