/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.cloud.DTO.AreaCityDTO;
import com.ovopark.cloud.VO.CloudBankVO;
import com.ovopark.cloud.VO.CloudStoreCategoryVO;
import com.ovopark.cloud.VO.CloudStoreNewCategoryVO;
import com.ovopark.cloud.VO.CredentialResultVO;
import com.ovopark.cloud.VO.OcrCredentialResultVO;
import com.ovopark.cloud.common.TimeService;
import com.ovopark.cloud.dao.state.AreasDao;
import com.ovopark.cloud.dao.state.CitiesDao;
import com.ovopark.cloud.dao.state.HeadOfficeBankDao;
import com.ovopark.cloud.dao.state.ProvincesDao;
import com.ovopark.cloud.entity.AreasDO;
import com.ovopark.cloud.entity.CitiesDO;
import com.ovopark.cloud.entity.HeadOfficeBankDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.entity.ProvincesDO;
import com.ovopark.cloud.enums.CategoryEnum;
import com.ovopark.cloud.enums.CloudStoreCategoryEnum;
import com.ovopark.cloud.enums.CredentialsEnum;
import com.ovopark.cloud.excel.EasyExcelUtils;
import com.ovopark.cloud.excel.model.HeadOfficeBank;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.cloud.mater.MasterStrokeService;
import com.ovopark.cloud.ocr.CloudOcrService;
import com.ovopark.cloud.query.OcrCredentialsQuery;
import com.ovopark.cloud.service.CloudCommonService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class CloudCommonServiceImpl
implements CloudCommonService {
    private static final Logger log = LoggerFactory.getLogger(CloudCommonServiceImpl.class);
    @Autowired
    private CloudOcrService cloudOcrService;
    @Autowired
    private MasterStrokeService masterStrokeService;
    @Autowired
    private ProvincesDao provincesDao;
    @Autowired
    private CitiesDao citiesDao;
    @Autowired
    private AreasDao areasDao;
    @Autowired
    private HeadOfficeBankDao headOfficeBankDao;

    @Override
    public CredentialResultVO recognizeCredentials(OcrCredentialsQuery query) {
        if (query.getFileUrls() == null || query.getFileUrls().isEmpty() || query.getType() == null) {
            throw new CloudWatchException("\u6307\u5b9a\u8bc6\u522b\u7684\u56fe\u7247\u548c\u7c7b\u578b");
        }
        if (!CredentialsEnum.contain((Integer)query.getType())) {
            throw new CloudWatchException("\u6307\u5b9a\u6b63\u786e\u7684\u8bc6\u522b\u7c7b\u578b");
        }
        if (query.getFileUrls().size() > 2) {
            throw new CloudWatchException("\u8eab\u4efd\u8bc1\u4ef6\u4f20\u6b63\u53cd\u9762\u5373\u53ef\uff0c\u4e00\u6b21\u4e00\u4eba");
        }
        HttpResponseEntity responseEntity = this.cloudOcrService.getOcrCredentials(query);
        if (responseEntity.getIsError().booleanValue()) {
            log.error("OCR\u8bc6\u522b\u9519\u8bef\uff1a{}", (Object)responseEntity.toString());
            throw new CloudWatchException("OCR\u8bc6\u522b\u9519\u8bef");
        }
        List ocrCredentialResultList = (List)responseEntity.getData();
        CredentialResultVO result = new CredentialResultVO();
        for (OcrCredentialResultVO ocrResult : ocrCredentialResultList) {
            String cityId;
            CitiesDO cities;
            result.fromOcrCredentialResultVO(ocrResult);
            if (query.getType().equals(CredentialsEnum.LICENSE.getType())) {
                result.setValidStartDate(ocrResult.getEstablishDate());
                result.setValidEndDate(ocrResult.getValidPeriod());
            }
            if ("face".equals(ocrResult.getType())) {
                result.setType(CredentialsEnum.ID_CARD.getName());
                String birthDate = TimeService.normalizeDate((String)ocrResult.getBirthDate());
                result.setBirthDate(birthDate);
            }
            if ("back".equals(ocrResult.getType())) {
                result.setType(CredentialsEnum.ID_CARD.getName());
                result.setIssueAuthority(ocrResult.getIssueAuthority());
                if (StringUtils.isNotEmpty((CharSequence)ocrResult.getValidPeriod())) {
                    String[] validPeriod = ocrResult.getValidPeriod().split("-");
                    if (validPeriod.length > 0) {
                        String start = validPeriod[0];
                        result.setValidStartDate(start.replace(".", "-"));
                    }
                    if (validPeriod.length > 1) {
                        String end = validPeriod[1];
                        result.setValidEndDate(end.replace(".", "-"));
                    }
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)ocrResult.getAddress())) continue;
            String address = ocrResult.getAddress();
            AreaCityDTO areaCity = this.addressResolution(address);
            result.setDistrict(areaCity.getAreaId());
            result.setCity(areaCity.getCityId());
            result.setProvince(areaCity.getProvinceId());
            if ((StringUtils.isEmpty((CharSequence)areaCity.getCityName()) || StringUtils.isEmpty((CharSequence)areaCity.getCityId())) && StringUtils.isNotEmpty((CharSequence)areaCity.getAreaId()) && (cities = (CitiesDO)this.citiesDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CitiesDO::getCityId, (Object)(cityId = areaCity.getAreaId().substring(0, 4) + "00")))) != null) {
                result.setCity(cities.getCityName());
            }
            result.setDistrict(areaCity.getAreaId());
            result.setCity(areaCity.getCityId());
            result.setProvince(areaCity.getProvinceId());
            result.setCityName(areaCity.getProvinceName() + "/" + areaCity.getCityName() + "/" + areaCity.getAreaName());
            int index = address.indexOf(areaCity.getAreaName());
            address = address.substring(index + areaCity.getAreaName().length());
            result.setAddress(address);
        }
        return result;
    }

    @Override
    public List<CloudStoreCategoryVO> getCategoryList() {
        ArrayList<CloudStoreCategoryVO> result = new ArrayList<CloudStoreCategoryVO>();
        for (CategoryEnum category : CategoryEnum.values()) {
            CloudStoreCategoryVO vo = new CloudStoreCategoryVO();
            vo.setName(category.getName());
            vo.setCode(category.getCode());
            result.add(vo);
        }
        return result;
    }

    @Override
    public String importHeadOfficeBank(MultipartFile file) {
        try {
            EasyExcelUtils.doImportProcess((MultipartFile)file, (Integer)0, null, HeadOfficeBank.class, new HashMap());
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return "\u6210\u529f";
    }

    @Override
    public CloudBankVO getBankList(String name, Integer sign) {
        CloudBankVO result = new CloudBankVO();
        List headOfficeBankList = this.headOfficeBankDao.selectBankByNameSign(name, sign, 10);
        if (headOfficeBankList != null && !headOfficeBankList.isEmpty()) {
            int num = 0;
            for (HeadOfficeBankDO headOfficeBank : headOfficeBankList) {
                CloudBankVO.BankVO bankVO = new CloudBankVO.BankVO();
                bankVO.setName(headOfficeBank.getBankName());
                bankVO.setCode(headOfficeBank.getBankNo());
                result.getData().add(bankVO);
                if ((Integer)headOfficeBank.getId() <= num) continue;
                num = (Integer)headOfficeBank.getId();
            }
            result.setSign(Integer.valueOf(num));
        }
        return result;
    }

    @Override
    public List<CloudStoreNewCategoryVO> getNewCategoryList() {
        HashMap<Integer, CloudStoreNewCategoryVO> map = new HashMap<Integer, CloudStoreNewCategoryVO>();
        for (CloudStoreCategoryEnum category : CloudStoreCategoryEnum.values()) {
            CloudStoreNewCategoryVO parent = (CloudStoreNewCategoryVO)map.get(category.getMccParent());
            if (parent == null) {
                parent = new CloudStoreNewCategoryVO();
                parent.setPid(-1);
                parent.setChildren(new ArrayList());
                parent.setId(category.getMccParent());
                parent.setText(category.getFirstName());
                map.put(category.getMccParent(), parent);
            }
            CloudStoreNewCategoryVO child = new CloudStoreNewCategoryVO();
            child.setPid(category.getMccParent());
            child.setId(category.getMcc());
            child.setText(category.getSecondName());
            parent.getChildren().add(child);
        }
        return new ArrayList<CloudStoreNewCategoryVO>(map.values());
    }

    private AreaCityDTO addressResolution(String address) {
        AreaCityDTO result = new AreaCityDTO();
        if (StringUtils.isEmpty((CharSequence)address)) {
            return result;
        }
        int[] regions = new int[3];
        int index = -1;
        index = address.indexOf("\u7701");
        if (index != -1) {
            regions[0] = index + 1;
        } else {
            index = address.indexOf("\u81ea\u6cbb\u533a");
            if (index != -1) {
                regions[0] = index + 3;
            } else {
                index = address.indexOf("\u884c\u653f\u533a");
                if (index != -1) {
                    regions[0] = index + 3;
                }
            }
        }
        if (regions[0] != 0) {
            String province = address.substring(0, regions[0]);
            ProvincesDO provincesDO = (ProvincesDO)this.provincesDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(ProvincesDO::getProvince, (Object)province));
            result.setProvinceName(province);
            if (provincesDO != null) {
                result.setProvinceName(provincesDO.getProvince());
            }
        }
        if ((index = address.indexOf("\u5e02")) != -1) {
            regions[1] = index + 1;
        } else {
            index = address.indexOf("\u81ea\u6cbb\u5dde");
            if (index != -1) {
                regions[1] = index + 3;
            } else {
                index = address.indexOf("\u884c\u653f\u5355\u4f4d");
                if (index != -1) {
                    regions[1] = index + 4;
                } else {
                    index = address.indexOf("\u76df");
                    if (index != -1) {
                        regions[1] = index + 1;
                    } else {
                        index = address.indexOf("\u5e02\u8f96\u533a");
                        if (index != -1) {
                            regions[1] = index + 3;
                        }
                    }
                }
            }
        }
        if (regions[1] != 0) {
            String city = address.substring(regions[0], regions[1]);
            result.setCityName(city);
            List citiesList = this.citiesDao.selectList((Wrapper)new LambdaQueryWrapper().eq(CitiesDO::getCityName, (Object)city));
            if (citiesList.size() > 1 && StringUtils.isNotEmpty((CharSequence)result.getProvinceId())) {
                citiesList = citiesList.stream().filter(citiesDO -> citiesDO.getProvinceId().equals(result.getProvinceId())).collect(Collectors.toList());
            }
            if (citiesList.size() == 1) {
                result.setCityId(((CitiesDO)citiesList.get(0)).getCityId());
            }
        }
        if ((index = address.indexOf("\u53bf")) != -1) {
            regions[2] = index + 1;
        } else {
            index = address.indexOf("\u533a");
            if (index != -1) {
                regions[2] = index + 1;
            } else {
                index = address.indexOf("\u65d7");
                if (index != -1) {
                    regions[2] = index + 1;
                } else {
                    index = address.indexOf("\u6d77\u57df");
                    if (index != -1) {
                        regions[2] = index + 2;
                    } else {
                        index = address.indexOf("\u5c9b");
                        if (index != -1) {
                            regions[2] = index + 1;
                        } else {
                            index = address.indexOf("\u81ea\u6cbb\u53bf");
                            if (index != -1) {
                                regions[2] = index + 3;
                            }
                        }
                    }
                }
            }
        }
        if (regions[2] != 0) {
            String district = "";
            district = regions[1] != 0 ? address.substring(regions[1], regions[2]) : address.substring(regions[0], regions[2]);
            result.setAreaName(district);
            List areasList = this.areasDao.selectList((Wrapper)new LambdaQueryWrapper().eq(AreasDO::getAreaName, (Object)district));
            if (areasList.size() > 1) {
                if (StringUtils.isNotEmpty((CharSequence)result.getCityId())) {
                    areasList = areasList.stream().filter(areasDO -> areasDO.getCityId().equals(result.getCityId())).collect(Collectors.toList());
                } else if (StringUtils.isNotEmpty((CharSequence)result.getProvinceId())) {
                    areasList = areasList.stream().filter(areasDO -> areasDO.getAreaId().substring(0, 2).equals(result.getProvinceId().substring(0, 2))).collect(Collectors.toList());
                }
            }
            if (areasList.size() == 1) {
                result.setAreaId(((AreasDO)areasList.get(0)).getAreaId());
            }
        }
        if ((StringUtils.isEmpty((CharSequence)result.getCityName()) || StringUtils.isEmpty((CharSequence)result.getCityId())) && StringUtils.isNotEmpty((CharSequence)result.getAreaId())) {
            String cityId = result.getAreaId().substring(0, 4) + "00";
            result.setCityId(cityId);
            CitiesDO cities = (CitiesDO)this.citiesDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CitiesDO::getCityId, (Object)cityId));
            if (cities != null) {
                result.setCityName(cities.getCityName());
            }
        }
        if ((StringUtils.isEmpty((CharSequence)result.getProvinceName()) || StringUtils.isEmpty((CharSequence)result.getProvinceId())) && StringUtils.isNotEmpty((CharSequence)result.getAreaId())) {
            String provinceId = result.getAreaId().substring(0, 2) + "0000";
            result.setProvinceId(provinceId);
            ProvincesDO provinces = (ProvincesDO)this.provincesDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(ProvincesDO::getProvinceId, (Object)provinceId));
            if (provinces != null) {
                result.setProvinceName(provinces.getProvince());
            }
        }
        return result;
    }
}

