/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.cloud.BO.DepartmentBizPojo;
import com.ovopark.cloud.DTO.DeptDeviceDTO;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.Mo.DepartmentPageListMo;
import com.ovopark.cloud.VO.DeptDeviceCountVo;
import com.ovopark.cloud.VO.DeptDeviceVo;
import com.ovopark.cloud.VO.YzsDeviceFeignVo;
import com.ovopark.cloud.base.IdNumEntity;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.base.AppUtil;
import com.ovopark.cloud.common.base.BaseDTO;
import com.ovopark.cloud.common.base.CollectionHelper;
import com.ovopark.cloud.common.base.LogWatchHelper;
import com.ovopark.cloud.common.base.PageVo;
import com.ovopark.cloud.dao.state.CloudDeviceIpcSignDao;
import com.ovopark.cloud.entity.CloudDeviceIpcSignDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.mater.MasterStrokeService;
import com.ovopark.cloud.service.CloudDeviceIpcSignService;
import com.ovopark.cloud.watch.WatchForeignService;
import com.ovopark.module.shared.BaseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CloudDeviceIpcSignServiceImpl
extends ServiceImpl<CloudDeviceIpcSignDao, CloudDeviceIpcSignDO>
implements CloudDeviceIpcSignService {
    private static final Logger log = LoggerFactory.getLogger(CloudDeviceIpcSignServiceImpl.class);
    @Resource
    private MasterStrokeService masterStrokeService;
    @Resource
    private WatchForeignService watchForeignService;

    @Override
    public void updateCloudDeviceStatus(CloudDeviceIpcSignDO cloudDeviceIpcSignDO) {
        if (cloudDeviceIpcSignDO == null || cloudDeviceIpcSignDO.getStoreId() == null || cloudDeviceIpcSignDO.getDeviceType() == null || StringUtils.isBlank((CharSequence)cloudDeviceIpcSignDO.getMac())) {
            log.error("CloudDeviceIpcSignServiceImpl \u8bbe\u5907\u4fe1\u606f\u4e0d\u5b8c\u6574\uff1a{}", (Object)JSON.toJSONString((Object)cloudDeviceIpcSignDO));
            return;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)super.lambdaQuery().eq(CloudDeviceIpcSignDO::getStoreId, (Object)cloudDeviceIpcSignDO.getStoreId())).eq(CloudDeviceIpcSignDO::getMac, (Object)cloudDeviceIpcSignDO.getMac())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Long id = (Long)((CloudDeviceIpcSignDO)list.get(0)).getId();
            CloudDeviceIpcSignDO deviceIpcSignDO = new CloudDeviceIpcSignDO();
            deviceIpcSignDO.setId((Object)id);
            deviceIpcSignDO.setOnOffStatus(cloudDeviceIpcSignDO.getOnOffStatus());
            deviceIpcSignDO.setUpdatedTime(new Date());
            log.info("updateCloudDeviceStatus :{}", (Object)JSON.toJSONString((Object)deviceIpcSignDO));
            super.updateById((Object)deviceIpcSignDO);
        } else if (cloudDeviceIpcSignDO.getDeviceType() == 240) {
            cloudDeviceIpcSignDO.setStatus(Integer.valueOf(1));
            cloudDeviceIpcSignDO.setRowStatus(Integer.valueOf(1));
            cloudDeviceIpcSignDO.setCreatedTime(new Date());
            super.save((Object)cloudDeviceIpcSignDO);
        }
    }

    @Override
    public void saveCloudDevice(CloudDeviceIpcSignDO cloudDeviceIpcSignDO) {
        if (cloudDeviceIpcSignDO == null || cloudDeviceIpcSignDO.getStoreId() == null || cloudDeviceIpcSignDO.getDeviceType() == null || StringUtils.isBlank((CharSequence)cloudDeviceIpcSignDO.getMac())) {
            log.error("CloudDeviceIpcSignServiceImpl \u8bbe\u5907\u4fe1\u606f\u4e0d\u5b8c\u6574\uff1a{}", (Object)JSON.toJSONString((Object)cloudDeviceIpcSignDO));
            return;
        }
        if (cloudDeviceIpcSignDO.getDeviceType() == 240) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)super.lambdaQuery().eq(CloudDeviceIpcSignDO::getStoreId, (Object)cloudDeviceIpcSignDO.getStoreId())).eq(CloudDeviceIpcSignDO::getMac, (Object)cloudDeviceIpcSignDO.getMac())).list();
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Long id = (Long)((CloudDeviceIpcSignDO)list.get(0)).getId();
                cloudDeviceIpcSignDO.setId((Object)id);
                cloudDeviceIpcSignDO.setUpdatedTime(new Date());
            } else {
                cloudDeviceIpcSignDO.setCreatedTime(new Date());
            }
            log.info("saveCloudDevice :{}", (Object)JSON.toJSONString((Object)cloudDeviceIpcSignDO));
            super.saveOrUpdate((Object)cloudDeviceIpcSignDO);
        }
    }

    @Override
    public BaseResult<PageVo<DeptDeviceVo>> listDeptDeviceStatus(DeptDeviceDTO deptDeviceDTO) {
        LogWatchHelper logWatchHelper = LogWatchHelper.initLog((String)"listDeptDeviceStatus start");
        DepartmentPageListMo pageListMo = AppUtil.toDutyGuardDeptFeignParam((BaseDTO)deptDeviceDTO);
        pageListMo.setDeptIdList(deptDeviceDTO.getDeptIdList());
        pageListMo.setPageNumber(Integer.valueOf(1));
        pageListMo.setPageSize(Integer.valueOf(1000000));
        PageVo pageVo = new PageVo();
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        logWatchHelper.start("masterStrokeService.listBizDepartment");
        HttpResponseEntity responseEntity = this.masterStrokeService.listBizDepartment(userInfo.getToken(), pageListMo);
        if (responseEntity.getIsError().booleanValue() || responseEntity.getData() == null || CollectionUtils.isEmpty((Collection)((PageVo)responseEntity.getData()).getData())) {
            return BaseResult.success((Object)pageVo);
        }
        logWatchHelper.start("baseMapper.listDeviceStatusCount");
        List deptIdList = ((PageVo)responseEntity.getData()).getData().stream().map(DepartmentBizPojo::getId).collect(Collectors.toList());
        deptDeviceDTO.setDeptIdList(deptIdList);
        Map<Integer, DeptDeviceVo> deptDeviceStatusVoMap = ((CloudDeviceIpcSignDao)this.baseMapper).listDeviceStatusCount(deptDeviceDTO).stream().collect(Collectors.toMap(DeptDeviceVo::getDeptId, a -> a, (k1, k2) -> k1));
        List deviceTypeList = deptDeviceDTO.getUnbindDeviceTypeList();
        logWatchHelper.start("DeptDeviceCountVo");
        DeptDeviceCountVo deviceCountVo = new DeptDeviceCountVo();
        ArrayList<DeptDeviceVo> deptDeviceVos = new ArrayList<DeptDeviceVo>();
        for (DepartmentBizPojo datum : ((PageVo)responseEntity.getData()).getData()) {
            DeptDeviceVo deptDeviceStatusVo = deptDeviceStatusVoMap.get(datum.getId());
            if (deptDeviceDTO.getIsExistsOffline() != null && deptDeviceStatusVo == null || !(!CollectionUtils.isNotEmpty((Collection)deviceTypeList) || deptDeviceStatusVo == null || deviceTypeList.contains(1) && deptDeviceStatusVo.getNvrCount() == 0 || deviceTypeList.contains(2) && deptDeviceStatusVo.getPosCount() == 0) && (!deviceTypeList.contains(3) || deptDeviceStatusVo.getIpcCount() != 0)) continue;
            if (deptDeviceStatusVo == null) {
                deptDeviceStatusVo = new DeptDeviceVo();
            }
            deptDeviceStatusVo.setDeptId(datum.getId());
            deptDeviceStatusVo.setDeptName(datum.getName());
            deptDeviceStatusVo.setDutyGuardServiceOn(datum.getDutyGuardServiceOn());
            deptDeviceStatusVo.setEnterpriseId(datum.getGroupId());
            deptDeviceStatusVo.setEnterpriseName(datum.getGroupName());
            deptDeviceStatusVo.setIpcOnlineCount(Integer.valueOf(deptDeviceStatusVo.getIpcCount() - deptDeviceStatusVo.getIpcOfflineCount()));
            deptDeviceVos.add(deptDeviceStatusVo);
            if (deptDeviceStatusVo.getNvrOfflineCount() > 0 || deptDeviceStatusVo.getPosOfflineCount() > 0 || deptDeviceStatusVo.getIpcOfflineCount() > 0) {
                deviceCountVo.setOfflineCount(Integer.valueOf(deviceCountVo.getOfflineCount() + 1));
            } else if (deptDeviceStatusVo.getNvrCount() > 0 || deptDeviceStatusVo.getPosCount() > 0 || deptDeviceStatusVo.getIpcCount() > 0) {
                deviceCountVo.setOnlineCount(Integer.valueOf(deviceCountVo.getOnlineCount() + 1));
            }
            if (deptDeviceStatusVo.getNvrCount() == 0 || deptDeviceStatusVo.getIpcCount() == 0) {
                deviceCountVo.setUnbindCount(Integer.valueOf(deviceCountVo.getUnbindCount() + 1));
            }
            if (deptDeviceStatusVo.getNvrCount() == 0) {
                deviceCountVo.setUnbindNvrCount(Integer.valueOf(deviceCountVo.getUnbindNvrCount() + 1));
                deptDeviceStatusVo.setNvrStatus(Integer.valueOf(0));
            } else if (deptDeviceStatusVo.getNvrOfflineCount() > 0) {
                deptDeviceStatusVo.setNvrStatus(Integer.valueOf(2));
            } else {
                deptDeviceStatusVo.setNvrStatus(Integer.valueOf(1));
            }
            if (deptDeviceStatusVo.getPosCount() == 0) {
                deviceCountVo.setUnbindPosCount(Integer.valueOf(deviceCountVo.getUnbindPosCount() + 1));
                deptDeviceStatusVo.setPosStatus(Integer.valueOf(0));
            } else if (deptDeviceStatusVo.getPosOfflineCount() > 0) {
                deptDeviceStatusVo.setPosStatus(Integer.valueOf(2));
            } else {
                deptDeviceStatusVo.setPosStatus(Integer.valueOf(1));
            }
            if (deptDeviceStatusVo.getIpcCount() != 0) continue;
            deviceCountVo.setUnbindIpcCount(Integer.valueOf(deviceCountVo.getUnbindIpcCount() + 1));
        }
        PageVo pageByList = deptDeviceDTO.pageByList(deptDeviceVos);
        pageByList.setExtData((Object)deviceCountVo);
        LogWatchHelper.print((String)"listDeptDeviceStatus end");
        return BaseResult.success((Object)pageByList);
    }

    @Override
    @Deprecated
    public BaseResult reloadDeviceDataList(DeptDeviceDTO deptDeviceDTO) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        DepartmentPageListMo pageListMo = AppUtil.toDutyGuardDeptFeignParam((BaseDTO)deptDeviceDTO);
        pageListMo.setDeptIdList(deptDeviceDTO.getDeptIdList());
        pageListMo.setPageNumber(Integer.valueOf(1));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Collection deptList = null;
        if (CollectionUtils.isNotEmpty((Collection)deptDeviceDTO.getDeptIdList2())) {
            HttpResponseEntity departmentByIds = this.masterStrokeService.getDepartmentByIds(deptDeviceDTO.getDeptIdList2());
            if (!departmentByIds.getIsError().booleanValue() && CollectionUtils.isNotEmpty((Collection)((Collection)departmentByIds.getData()))) {
                deptList = CollectionHelper.copy2List((List)((List)departmentByIds.getData()), DepartmentBizPojo::new);
            }
        } else {
            HttpResponseEntity responseEntity = this.masterStrokeService.listBizDepartment(userInfo.getToken(), pageListMo);
            PageVo pojoPageVo = (PageVo)responseEntity.getData();
            if (responseEntity.getIsError().booleanValue() || pojoPageVo == null || CollectionUtils.isEmpty((Collection)pojoPageVo.getData())) {
                return BaseResult.success(hashMap);
            }
            deptList = ((PageVo)responseEntity.getData()).getData();
        }
        if (CollectionUtils.isEmpty(deptList)) {
            return BaseResult.success(hashMap);
        }
        List deptIdList = deptList.stream().map(DepartmentBizPojo::getId).collect(Collectors.toList());
        List oldDeviceList = ((LambdaQueryChainWrapper)super.lambdaQuery().select(new SFunction[]{IdNumEntity::getId, CloudDeviceIpcSignDO::getStoreId, CloudDeviceIpcSignDO::getMac, CloudDeviceIpcSignDO::getDeviceType, CloudDeviceIpcSignDO::getRowStatus, CloudDeviceIpcSignDO::getStatus, CloudDeviceIpcSignDO::getOnOffStatus}).in(CloudDeviceIpcSignDO::getStoreId, deptIdList)).list();
        Map<String, CloudDeviceIpcSignDO> oldDeviceMap = oldDeviceList.stream().collect(Collectors.toMap(s -> s.getStoreId() + "_" + s.getMac(), a -> a, (k1, k2) -> k1));
        ArrayList allDataList = new ArrayList();
        for (DepartmentBizPojo departmentBizPojo : deptList) {
            Integer id = departmentBizPojo.getId();
            HttpResponseEntity listHttpResponseEntity = this.watchForeignService.depDeviceList(id.toString(), null);
            if (listHttpResponseEntity.getIsError().booleanValue() || CollectionUtils.isEmpty((Collection)((Collection)listHttpResponseEntity.getData()))) continue;
            List collect = ((List)listHttpResponseEntity.getData()).stream().filter(s -> s.getDtype() != null && (s.getDtype() == 20 || s.getDtype() == 21 || s.getDtype() == 240)).collect(Collectors.toList());
            departmentBizPojo.setDataList(collect);
            ArrayList<CloudDeviceIpcSignDO> dataList = new ArrayList<CloudDeviceIpcSignDO>();
            departmentBizPojo.setToSavedataList(dataList);
            for (YzsDeviceFeignVo deviceFeignVo : collect) {
                CloudDeviceIpcSignDO deviceIpcSignDO = oldDeviceMap.get(id + "_" + deviceFeignVo.getMac());
                if (deviceFeignVo.getDtype() == 240) {
                    if (deviceIpcSignDO == null) {
                        deviceIpcSignDO = new CloudDeviceIpcSignDO();
                        deviceIpcSignDO.setStoreId(id);
                        deviceIpcSignDO.setMac(deviceFeignVo.getMac());
                        deviceIpcSignDO.setDeviceType(deviceFeignVo.getDtype());
                        deviceIpcSignDO.setDeviceId(deviceFeignVo.getDeviceId());
                        deviceIpcSignDO.setDeviceName(deviceFeignVo.getDeviceName());
                        deviceIpcSignDO.setDeviceIcon(deviceFeignVo.getThumbUrl());
                        deviceIpcSignDO.setRowStatus(Integer.valueOf(1));
                        deviceIpcSignDO.setStatus(Integer.valueOf(1));
                        deviceIpcSignDO.setCreateBy(userInfo.getUserData().getData().getUserName());
                        deviceIpcSignDO.setCreatedTime(new Date());
                    }
                } else if (deviceIpcSignDO == null) continue;
                deviceIpcSignDO.setOnOffStatus(deviceFeignVo.getOnline());
                deviceIpcSignDO.setEnterpriseId(departmentBizPojo.getGroupId());
                deviceIpcSignDO.setDeptName(departmentBizPojo.getName());
                if (deviceIpcSignDO.getId() != null) {
                    deviceIpcSignDO.setUpdateBy(userInfo.getUserData().getData().getUserName());
                    deviceIpcSignDO.setUpdatedTime(new Date());
                }
                dataList.add(deviceIpcSignDO);
            }
            allDataList.addAll(dataList);
            log.info("watchForeignService.depDeviceList :{}", (Object)JSON.toJSONString((Object)listHttpResponseEntity));
        }
        if (deptDeviceDTO.getDoSave() != null && deptDeviceDTO.getDoSave().booleanValue() && CollectionUtils.isNotEmpty(allDataList)) {
            super.saveOrUpdateBatch(allDataList);
        }
        Map<Integer, List<CloudDeviceIpcSignDO>> toSaveGroupAllDataListMap = allDataList.stream().collect(Collectors.groupingBy(CloudDeviceIpcSignDO::getEnterpriseId));
        hashMap.put("deptList", deptList);
        hashMap.put("toSaveAllDataList", allDataList);
        hashMap.put("toSaveGroupAllDataList", toSaveGroupAllDataListMap);
        return BaseResult.success(hashMap);
    }
}

