/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.VO.CloudDeviceGroupListVO;
import com.ovopark.cloud.VO.CloudDeviceUpdateVO;
import com.ovopark.cloud.VO.CloudStoreDeviceVO;
import com.ovopark.cloud.VO.CloudStoreIpcVO;
import com.ovopark.cloud.VO.CloudWatchDeviceIpcVO;
import com.ovopark.cloud.VO.GetDeviceListVO;
import com.ovopark.cloud.VO.StoreDeviceInfoVO;
import com.ovopark.cloud.VO.YzsDeviceFeignVo;
import com.ovopark.cloud.base.IdNumEntity;
import com.ovopark.cloud.common.CloudCommon;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.Result;
import com.ovopark.cloud.common.ToolCommon;
import com.ovopark.cloud.dao.state.CloudDeviceIpcSignDao;
import com.ovopark.cloud.dao.state.CloudStoreSettingsDao;
import com.ovopark.cloud.entity.CloudDeviceIpcSignDO;
import com.ovopark.cloud.entity.CloudStoreSettingsDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.cloud.pos.ShopwebPosForeignService;
import com.ovopark.cloud.query.PosBindDeviceQuery;
import com.ovopark.cloud.service.CloudDeviceService;
import com.ovopark.cloud.service.ShopWebService;
import com.ovopark.cloud.utils.ShopWebCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CloudDeviceServiceImpl
implements CloudDeviceService {
    private static final Logger log = LoggerFactory.getLogger(CloudDeviceServiceImpl.class);
    @Autowired
    private CloudDeviceIpcSignDao cloudDeviceIpcSignDao;
    @Autowired
    private ShopWebCommon shopWebCommon;
    @Autowired
    private ShopWebService shopWebService;
    @Autowired
    private ShopwebPosForeignService shopwebPosForeignService;
    @Autowired
    private CloudCommon cloudCommon;
    @Autowired
    private CloudStoreSettingsDao cloudStoreSettingsDao;

    @Override
    public CloudStoreIpcVO getDeviceIpcInfo(Integer depId) {
        CloudStoreIpcVO cloudStoreIpc = new CloudStoreIpcVO();
        cloudStoreIpc.setDepId(depId);
        CloudStoreSettingsDO cloudStoreSettings = (CloudStoreSettingsDO)this.cloudStoreSettingsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreSettingsDO::getStoreId, (Object)depId));
        if (cloudStoreSettings != null) {
            cloudStoreIpc.setRemark(cloudStoreSettings.getRemark());
        }
        ArrayList<CloudWatchDeviceIpcVO> ipcList = new ArrayList<CloudWatchDeviceIpcVO>();
        List cloudDeviceIpcSignList = this.cloudDeviceIpcSignDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getStoreId, (Object)depId)).eq(CloudDeviceIpcSignDO::getDeviceType, (Object)21)).eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1)).eq(CloudDeviceIpcSignDO::getStatus, (Object)1));
        if (cloudDeviceIpcSignList != null && !cloudDeviceIpcSignList.isEmpty()) {
            List<YzsDeviceFeignVo> deviceList = this.shopWebCommon.getAllDeviceList(depId, null);
            Map<String, YzsDeviceFeignVo> deviceMap = deviceList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getMac()) && item.getDeviceStatusId() != null).collect(Collectors.toMap(item -> ToolCommon.getDeviceKey((String)item.getMac(), (Integer)item.getDeviceStatusId()), item -> item, (k1, k2) -> k1));
            for (CloudDeviceIpcSignDO cloudDeviceIpcSignDO : cloudDeviceIpcSignList) {
                String key = ToolCommon.getDeviceKey((String)cloudDeviceIpcSignDO.getMac(), (Integer)cloudDeviceIpcSignDO.getDeviceId());
                YzsDeviceFeignVo yzsDeviceFeignVo = deviceMap.get(key);
                if (yzsDeviceFeignVo == null) continue;
                CloudWatchDeviceIpcVO cloudWatchDeviceIpcVO = new CloudWatchDeviceIpcVO();
                cloudWatchDeviceIpcVO.setDeviceStatusId(cloudDeviceIpcSignDO.getDeviceId());
                cloudWatchDeviceIpcVO.setDeviceName(cloudDeviceIpcSignDO.getDeviceName());
                cloudWatchDeviceIpcVO.setMac(cloudDeviceIpcSignDO.getMac());
                cloudWatchDeviceIpcVO.setDeviceIcon(cloudDeviceIpcSignDO.getDeviceIcon());
                cloudWatchDeviceIpcVO.setMainDeviceSign(cloudDeviceIpcSignDO.getMainDeviceSign());
                cloudWatchDeviceIpcVO.setCashDeviceSign(cloudDeviceIpcSignDO.getCashDeviceSign());
                cloudWatchDeviceIpcVO.setEnterDeviceSign(cloudDeviceIpcSignDO.getEnterDeviceSign());
                cloudWatchDeviceIpcVO.setDeviceId(yzsDeviceFeignVo.getDeviceId());
                cloudWatchDeviceIpcVO.setIsCanptz(yzsDeviceFeignVo.getIsCanptz());
                cloudWatchDeviceIpcVO.setOnline(yzsDeviceFeignVo.getOnline());
                ipcList.add(cloudWatchDeviceIpcVO);
            }
        }
        cloudStoreIpc.setCloudWatchDeviceIpcList(ipcList);
        return cloudStoreIpc;
    }

    @Override
    @Transactional
    public String insertDeviceIpcSign(CloudStoreDeviceVO storeDeviceVO) {
        if (storeDeviceVO.getDepId() == null || storeDeviceVO.getDeviceInfo() == null || storeDeviceVO.getDeviceInfo().isEmpty()) {
            return "\u65e0\u95e8\u5e97\u6216\u8005\u8bbe\u5907\u4fe1\u606f";
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        List deviceInfo = storeDeviceVO.getDeviceInfo();
        List cloudDeviceIpcSignList = this.cloudDeviceIpcSignDao.selectList((Wrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getStoreId, (Object)storeDeviceVO.getDepId()));
        Map<String, CloudDeviceIpcSignDO> cloudDeviceIpcSignMap = cloudDeviceIpcSignList.stream().collect(Collectors.toMap(item -> ToolCommon.getDeviceKey((String)item.getMac(), (Integer)item.getDeviceId()), cloudDeviceIpcSignDO -> cloudDeviceIpcSignDO));
        for (StoreDeviceInfoVO device : deviceInfo) {
            String key = ToolCommon.getDeviceKey((String)device.getMac(), (Integer)device.getDeviceId());
            if (cloudDeviceIpcSignMap.containsKey(key)) {
                CloudDeviceIpcSignDO cloudDeviceIpcSignDO2 = cloudDeviceIpcSignMap.get(key);
                this.cloudDeviceIpcSignDao.updateCloudDeviceIpcSign((Long)cloudDeviceIpcSignDO2.getId(), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), userInfo.getUserData().getData().getUserName());
                this.cloudDeviceIpcSignDao.updateDeviceStatus((Long)cloudDeviceIpcSignDO2.getId(), Integer.valueOf(1), null);
                continue;
            }
            CloudDeviceIpcSignDO cloudDeviceIpcSign = new CloudDeviceIpcSignDO();
            cloudDeviceIpcSign.setStoreId(storeDeviceVO.getDepId());
            cloudDeviceIpcSign.setDeviceId(device.getDeviceId());
            cloudDeviceIpcSign.setDeviceName(device.getDeviceName());
            cloudDeviceIpcSign.setDeviceIcon(device.getDeviceIcon());
            cloudDeviceIpcSign.setMac(device.getMac());
            cloudDeviceIpcSign.setDeviceType(device.getDeviceType());
            cloudDeviceIpcSign.setMainDeviceSign(Integer.valueOf(0));
            cloudDeviceIpcSign.setCashDeviceSign(Integer.valueOf(0));
            cloudDeviceIpcSign.setEnterDeviceSign(Integer.valueOf(0));
            cloudDeviceIpcSign.setStatus(Integer.valueOf(1));
            cloudDeviceIpcSign.setRowStatus(Integer.valueOf(1));
            cloudDeviceIpcSign.setCreateBy(userInfo.getUserData().getData().getUserName());
            this.cloudDeviceIpcSignDao.insert((Object)cloudDeviceIpcSign);
        }
        this.updateBindDevice(userInfo.getToken(), storeDeviceVO.getDepId());
        this.cloudCommon.checkMainCashDevice(storeDeviceVO.getDepId(), userInfo.getUserData().getData().getUserName());
        return "\u6210\u529f";
    }

    private void updateBindDevice(String authorization, Integer depId) {
        List cloudDeviceIpcSignList = this.cloudDeviceIpcSignDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getStoreId, (Object)depId)).eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1)).eq(CloudDeviceIpcSignDO::getDeviceType, (Object)21));
        PosBindDeviceQuery query = new PosBindDeviceQuery();
        query.setDepId(depId);
        query.setList(cloudDeviceIpcSignList.stream().map(cloudDeviceIpcSignDO -> {
            PosBindDeviceQuery.DeviceMachine deviceMachine = new PosBindDeviceQuery.DeviceMachine();
            deviceMachine.setDeviceId(cloudDeviceIpcSignDO.getDeviceId());
            deviceMachine.setMachineId("001");
            return deviceMachine;
        }).collect(Collectors.toList()));
        HttpResponseEntity response = this.shopwebPosForeignService.posBindDevices(authorization, query);
        if (response.getIsError().booleanValue()) {
            log.info("pos\u66f4\u65b0\u7ed1\u5b9aIPC\u8bbe\u5907\u5931\u8d25\uff1a{}", (Object)response.getMessage());
            throw new CloudWatchException("pos\u66f4\u65b0\u7ed1\u5b9aIPC\u8bbe\u5907\u5931\u8d25");
        }
        log.info("\u66f4\u65b0\u95e8\u5e97\u8bbe\u5907\u7ed1\u5b9a\u4fe1\u606f");
    }

    @Override
    public List<StoreDeviceInfoVO> getNotCloudDevice(Integer depId) {
        ArrayList<StoreDeviceInfoVO> result = new ArrayList<StoreDeviceInfoVO>();
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        List<Object> deviceList = this.shopWebCommon.getAllDeviceList(depId, userInfo.getUserData().getData().getId());
        deviceList = deviceList.stream().filter(item -> item.getDtype().compareTo(20) == 0 || item.getDtype().compareTo(21) == 0).collect(Collectors.toList());
        List cloudDeviceIpcSignList = this.cloudDeviceIpcSignDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getStoreId, (Object)depId)).eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1)).eq(CloudDeviceIpcSignDO::getStatus, (Object)1));
        Set existDeviceIds = cloudDeviceIpcSignList.stream().map(item -> ToolCommon.getDeviceKey((String)item.getMac(), (Integer)item.getDeviceId())).collect(Collectors.toSet());
        for (YzsDeviceFeignVo yzsDeviceFeignVo : deviceList) {
            String key = ToolCommon.getDeviceKey((String)yzsDeviceFeignVo.getMac(), (Integer)yzsDeviceFeignVo.getDeviceStatusId());
            if (existDeviceIds.contains(key)) continue;
            StoreDeviceInfoVO cloudWatchDeviceIpcVO = new StoreDeviceInfoVO();
            cloudWatchDeviceIpcVO.setDeviceId(yzsDeviceFeignVo.getDeviceStatusId());
            cloudWatchDeviceIpcVO.setDeviceName(yzsDeviceFeignVo.getDeviceName());
            cloudWatchDeviceIpcVO.setMac(yzsDeviceFeignVo.getMac());
            cloudWatchDeviceIpcVO.setDeviceType(yzsDeviceFeignVo.getDtype());
            cloudWatchDeviceIpcVO.setDeviceIcon(yzsDeviceFeignVo.getThumbUrl());
            cloudWatchDeviceIpcVO.setPid(yzsDeviceFeignVo.getPid());
            result.add(cloudWatchDeviceIpcVO);
        }
        return result;
    }

    @Override
    @Transactional
    public String deleteDeviceIpcSign(Integer depId, Integer deviceId, String mac) {
        List cloudDeviceIpcSignList;
        if (depId == null) {
            return "\u6307\u5b9a\u95e8\u5e97\u6216\u8005\u8bbe\u5907";
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(CloudDeviceIpcSignDO::getStoreId, (Object)depId)).eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1);
        if (deviceId != null) {
            queryWrapper.eq(CloudDeviceIpcSignDO::getDeviceId, (Object)deviceId);
        }
        if (StringUtils.isNotEmpty((CharSequence)mac)) {
            queryWrapper.eq(CloudDeviceIpcSignDO::getMac, (Object)mac);
        }
        if ((cloudDeviceIpcSignList = this.cloudDeviceIpcSignDao.selectList((Wrapper)queryWrapper)) != null && !cloudDeviceIpcSignList.isEmpty()) {
            List idList = cloudDeviceIpcSignList.stream().map(IdNumEntity::getId).collect(Collectors.toList());
            this.cloudDeviceIpcSignDao.updateCloudDeviceIpcSignList(idList, Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), userInfo.getUserData().getData().getUserName());
        }
        this.updateBindDevice(userInfo.getToken(), depId);
        this.cloudCommon.checkMainCashDevice(depId, userInfo.getUserData().getData().getUserName());
        return "\u6210\u529f";
    }

    @Override
    public String updateDeviceIpcSign(CloudDeviceUpdateVO cloudDeviceUpdate) {
        if (cloudDeviceUpdate.getDeviceId() == null || cloudDeviceUpdate.getDepId() == null || cloudDeviceUpdate.getMac() == null) {
            return "\u6307\u5b9a\u95e8\u5e97\u6216\u8005\u8bbe\u5907";
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        List cloudDeviceIpcSignList = this.cloudDeviceIpcSignDao.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getStoreId, (Object)cloudDeviceUpdate.getDepId())).eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1));
        String key = ToolCommon.getDeviceKey((String)cloudDeviceUpdate.getMac(), (Integer)cloudDeviceUpdate.getDeviceId());
        CloudDeviceIpcSignDO cloudDeviceIpcSignDO = cloudDeviceIpcSignList.stream().filter(item -> {
            String tempKey = ToolCommon.getDeviceKey((String)item.getMac(), (Integer)item.getDeviceId());
            return key.equals(tempKey);
        }).findFirst().orElse(null);
        if (cloudDeviceIpcSignDO != null) {
            this.cloudDeviceIpcSignDao.updateCloudDeviceIpcSign((Long)cloudDeviceIpcSignDO.getId(), null, cloudDeviceUpdate.getMainDeviceSign(), cloudDeviceUpdate.getCashDeviceSign(), cloudDeviceUpdate.getEnterDeviceSign(), userInfo.getUserData().getData().getUserName());
            if (cloudDeviceUpdate.getMainDeviceSign() != null && cloudDeviceUpdate.getMainDeviceSign() == 1 && (cloudDeviceIpcSignDO = (CloudDeviceIpcSignDO)cloudDeviceIpcSignList.stream().filter(item -> item.getMainDeviceSign() == 1).findFirst().orElse(null)) != null) {
                this.cloudDeviceIpcSignDao.updateCloudDeviceIpcSign((Long)cloudDeviceIpcSignDO.getId(), null, Integer.valueOf(0), null, null, userInfo.getUserData().getData().getUserName());
            }
            if (cloudDeviceUpdate.getCashDeviceSign() != null && cloudDeviceUpdate.getCashDeviceSign() == 1 && (cloudDeviceIpcSignDO = (CloudDeviceIpcSignDO)cloudDeviceIpcSignList.stream().filter(item -> item.getCashDeviceSign() == 1).findFirst().orElse(null)) != null) {
                this.cloudDeviceIpcSignDao.updateCloudDeviceIpcSign((Long)cloudDeviceIpcSignDO.getId(), null, null, Integer.valueOf(0), null, userInfo.getUserData().getData().getUserName());
            }
            if (cloudDeviceUpdate.getEnterDeviceSign() != null && cloudDeviceUpdate.getEnterDeviceSign() == 1 && (cloudDeviceIpcSignDO = (CloudDeviceIpcSignDO)cloudDeviceIpcSignList.stream().filter(item -> item.getEnterDeviceSign() == 1).findFirst().orElse(null)) != null) {
                this.cloudDeviceIpcSignDao.updateCloudDeviceIpcSign((Long)cloudDeviceIpcSignDO.getId(), null, null, null, Integer.valueOf(0), userInfo.getUserData().getData().getUserName());
            }
        }
        return "\u6210\u529f";
    }

    @Override
    public List<CloudDeviceGroupListVO> getGroupDeviceList(Integer depId) {
        ArrayList<CloudDeviceGroupListVO> result = new ArrayList<CloudDeviceGroupListVO>();
        Result<List<GetDeviceListVO>> deviceListResult = this.shopWebService.getDeviceList(depId);
        if (deviceListResult.getData() == null) {
            throw new CloudWatchException("\u83b7\u53d6\u8bbe\u5907\u5931\u8d25");
        }
        List deviceList = (List)deviceListResult.getData();
        List cloudDeviceIpcSignList = this.cloudDeviceIpcSignDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getStoreId, (Object)depId)).eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1)).eq(CloudDeviceIpcSignDO::getStatus, (Object)1));
        Map<String, CloudDeviceIpcSignDO> cloudDeviceIpcSignMap = cloudDeviceIpcSignList.stream().collect(Collectors.toMap(item -> ToolCommon.getDeviceKey((String)item.getMac(), (Integer)item.getDeviceId()), item -> item));
        HashMap<Integer, List> groupList = new HashMap<Integer, List>();
        for (GetDeviceListVO getDeviceList : deviceList) {
            String key = ToolCommon.getDeviceKey((String)getDeviceList.getMac(), (Integer)getDeviceList.getId());
            CloudDeviceIpcSignDO cloudDeviceIpcSignDO = cloudDeviceIpcSignMap.get(key);
            if (getDeviceList.getDType() != null && (getDeviceList.getDType() == 21 || getDeviceList.getDType() == 20) && cloudDeviceIpcSignDO == null) continue;
            if (cloudDeviceIpcSignDO != null) {
                getDeviceList.setCashDeviceSign(cloudDeviceIpcSignDO.getCashDeviceSign());
                getDeviceList.setEnterDeviceSign(cloudDeviceIpcSignDO.getEnterDeviceSign());
                getDeviceList.setMainDeviceSign(cloudDeviceIpcSignDO.getMainDeviceSign());
            }
            if (getDeviceList.getDType() != null && getDeviceList.getDType() == 20) {
                List list = groupList.computeIfAbsent(getDeviceList.getId(), k -> new ArrayList());
                list.add(getDeviceList);
                continue;
            }
            Integer pid = getDeviceList.getPid() == null ? 0 : getDeviceList.getPid();
            List list = groupList.computeIfAbsent(pid, k -> new ArrayList());
            list.add(getDeviceList);
        }
        int index = 1;
        for (Map.Entry entry : groupList.entrySet()) {
            CloudDeviceGroupListVO cloudDeviceGroupListVO = new CloudDeviceGroupListVO();
            cloudDeviceGroupListVO.setGroupName("\u8bbe\u5907\u7ec4" + index);
            cloudDeviceGroupListVO.setDeviceList((List)entry.getValue());
            result.add(cloudDeviceGroupListVO);
            ++index;
        }
        return result;
    }
}

