/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ovopark.cloud.DTO.YiBaoJoinResultDTO;
import com.ovopark.cloud.DTO.YibaoAuthDTO;
import com.ovopark.cloud.DTO.YibaoRegisterAccountDTO;
import com.ovopark.cloud.DTO.YibaoRegisterAddressDTO;
import com.ovopark.cloud.DTO.YibaoRegisterCategoryDTO;
import com.ovopark.cloud.DTO.YibaoRegisterContractDTO;
import com.ovopark.cloud.DTO.YibaoRegisterFunctionServiceQualificationDTO;
import com.ovopark.cloud.DTO.YibaoRegisterLegalDTO;
import com.ovopark.cloud.DTO.YibaoRegisterMerchantAcquireDTO;
import com.ovopark.cloud.DTO.YibaoRegisterMerchantSubjectDTO;
import com.ovopark.cloud.DTO.YibaoRegisterProductDTO;
import com.ovopark.cloud.DTO.YibaoRegisterProductQualificationDTO;
import com.ovopark.cloud.DTO.YibaoRegisterSignatoryDTO;
import com.ovopark.cloud.VO.CloudStoreBankVO;
import com.ovopark.cloud.VO.CloudStoreContractVo;
import com.ovopark.cloud.VO.CrmContractContentVO;
import com.ovopark.cloud.VO.CrmEnterpriseVO;
import com.ovopark.cloud.VO.GetDepartmentInfoVO;
import com.ovopark.cloud.VO.StoreContractListVO;
import com.ovopark.cloud.dao.state.CloudSearchDepartmentsDao;
import com.ovopark.cloud.dao.state.CloudStoreContractDao;
import com.ovopark.cloud.dao.state.CloudStoreSettingsDao;
import com.ovopark.cloud.dao.state.CloudYiBaoApplyDao;
import com.ovopark.cloud.entity.CloudSearchDepartmentsDO;
import com.ovopark.cloud.entity.CloudStoreContractDO;
import com.ovopark.cloud.entity.CloudStoreSettingsDO;
import com.ovopark.cloud.entity.CloudYiBaoApplyDO;
import com.ovopark.cloud.enums.StoreReviewStateEnum;
import com.ovopark.cloud.enums.YibaoAuthStateEnum;
import com.ovopark.cloud.enums.YibaoFeeTypeEnum;
import com.ovopark.cloud.enums.YibaoProductEnum;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.cloud.service.CloudForeignService;
import com.ovopark.cloud.task.StoreApprovedTask;
import com.ovopark.cloud.utils.ShopWebCommon;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.service.mer.MerClient;
import com.yeepay.yop.sdk.service.mer.MerClientBuilder;
import com.yeepay.yop.sdk.service.mer.model.AuthStateQueryV2IdentityAuthDtoResult;
import com.yeepay.yop.sdk.service.mer.model.MerchantInfoModifyMerchantInfoModifyRespDTOResult;
import com.yeepay.yop.sdk.service.mer.model.RegisterSaasMerchantV2ContributeMerchantNetInRespDtoResult;
import com.yeepay.yop.sdk.service.mer.request.AuthStateQueryV2Request;
import com.yeepay.yop.sdk.service.mer.request.MerchantInfoModifyRequest;
import com.yeepay.yop.sdk.service.mer.request.RegisterSaasMerchantV2Request;
import com.yeepay.yop.sdk.service.mer.response.AuthStateQueryV2Response;
import com.yeepay.yop.sdk.service.mer.response.MerchantInfoModifyResponse;
import com.yeepay.yop.sdk.service.mer.response.RegisterSaasMerchantV2Response;
import com.yeepay.yop.sdk.service.sys.SysClient;
import com.yeepay.yop.sdk.service.sys.SysClientBuilder;
import com.yeepay.yop.sdk.service.sys.model.MerchantQualUploadMerFileUploadRespDtoResult;
import com.yeepay.yop.sdk.service.sys.request.MerchantQualUploadRequest;
import com.yeepay.yop.sdk.service.sys.response.MerchantQualUploadResponse;
import com.yeepay.yop.sdk.utils.DigitalEnvelopeUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CloudForeignServiceImpl
implements CloudForeignService {
    private static final Logger log = LoggerFactory.getLogger(CloudForeignServiceImpl.class);
    @Autowired
    private CloudSearchDepartmentsDao cloudSearchDepartmentsDao;
    @Autowired
    private CloudStoreSettingsDao cloudStoreSettingsDao;
    @Autowired
    private CloudYiBaoApplyDao cloudYiBaoApplyDao;
    @Autowired
    private StoreApprovedTask storeApprovedTask;
    @Autowired
    private CloudStoreContractDao cloudStoreContractDao;
    @Autowired
    private ShopWebCommon shopWebCommon;
    @Value(value="yibao.callback")
    private String yibaoCallback;
    private static final MerClient api = (MerClient)MerClientBuilder.builder().build();
    private static final SysClient sysClient = (SysClient)SysClientBuilder.builder().build();

    @Override
    public String getCrmContract(CrmContractContentVO crmContractContent) {
        log.info("CRM\u7b7e\u7ea6\u56de\u8c03\u4fe1\u606f\uff1a{}", (Object)crmContractContent.toString());
        CloudStoreSettingsDO cloudStore = (CloudStoreSettingsDO)this.cloudStoreSettingsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreSettingsDO::getStoreId, (Object)crmContractContent.getStoreId()));
        if (cloudStore != null) {
            this.cloudStoreSettingsDao.updateStoreStatus((Integer)cloudStore.getId(), null, null, "CRM", null, crmContractContent.getStatus());
        } else {
            cloudStore = new CloudStoreSettingsDO();
            cloudStore.setStoreId(crmContractContent.getStoreId());
            cloudStore.setContractStatus(crmContractContent.getStatus());
            cloudStore.setCreateBy("CRM");
            this.cloudStoreSettingsDao.insert((Object)cloudStore);
        }
        return "\u6210\u529f";
    }

    @Override
    public CrmEnterpriseVO getEnterpriseInfo(Integer depId) {
        if (depId == null) {
            throw new CloudWatchException("\u9700\u8981\u6709\u4f01\u4e1a\u4fe1\u606f");
        }
        CloudSearchDepartmentsDO cloudSearchDepartments = (CloudSearchDepartmentsDO)this.cloudSearchDepartmentsDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudSearchDepartmentsDO::getId, (Object)depId)).eq(CloudSearchDepartmentsDO::getRowStatus, (Object)1));
        CrmEnterpriseVO crmEnterprise = new CrmEnterpriseVO();
        if (cloudSearchDepartments != null) {
            crmEnterprise.setEnterpriseName(cloudSearchDepartments.getLicenseName());
            crmEnterprise.setCreditCode(cloudSearchDepartments.getUnifiedSocialCreditCode());
            crmEnterprise.setLegalPersonName(cloudSearchDepartments.getLegalRepresentative());
            crmEnterprise.setAttachmentBusinessUrl(cloudSearchDepartments.getLicensePic());
            crmEnterprise.setIdName(cloudSearchDepartments.getIdName());
            crmEnterprise.setIdCode(cloudSearchDepartments.getIdNo());
            crmEnterprise.setAttachmentIDPositiveUrl(cloudSearchDepartments.getIdFrontPic());
            crmEnterprise.setAttachmentIDTheOtherSideUrl(cloudSearchDepartments.getIdBackendPic());
            crmEnterprise.setPhone(cloudSearchDepartments.getContactPhone());
        }
        return crmEnterprise;
    }

    @Override
    public String getYibaoResult(HttpServletRequest req) {
        String contentTypeStr = req.getContentType();
        if (!StringUtils.startsWith((CharSequence)contentTypeStr, (CharSequence)"application/x-www-form-urlencoded")) {
            log.error("\u6613\u5b9d\u56de\u8c03 == \u63a5\u53e3RSA\u56de\u8c03\u8bf7\u6c42\u4ec5\u652f\u6301form\u683c\u5f0f");
            throw new IllegalArgumentException("RSA\u56de\u8c03\u8bf7\u6c42\u4ec5\u652f\u6301form\u683c\u5f0f");
        }
        String response = req.getParameter("response");
        String appKey = req.getParameter("customerIdentification");
        log.info("\u6613\u5b9d\u56de\u8c03 == response :{}, customerIdentification:{}", (Object)response, (Object)appKey);
        String plaintText = DigitalEnvelopeUtils.decrypt((String)response, (String)"RSA2048");
        log.info("\u6613\u5b9d\u56de\u8c03 == \u89e3\u5bc6\u7ed3\u679c\uff1a{}", (Object)plaintText);
        try {
            YiBaoJoinResultDTO yiBaoJoinResult = (YiBaoJoinResultDTO)JSON.parseObject((String)plaintText, YiBaoJoinResultDTO.class);
            CloudYiBaoApplyDO cloudYiBaoApplyDO = new CloudYiBaoApplyDO();
            cloudYiBaoApplyDO.setId((Object)Integer.valueOf(yiBaoJoinResult.getRequestNo()));
            cloudYiBaoApplyDO.setAgreementSignUrl(yiBaoJoinResult.getAgreementSignUrl());
            cloudYiBaoApplyDO.setApplicationStatus(yiBaoJoinResult.getApplicationStatus());
            cloudYiBaoApplyDO.setAuditOpinion(yiBaoJoinResult.getAuditOpinion());
            cloudYiBaoApplyDO.setProgressDescription(yiBaoJoinResult.getProgressDescription());
            cloudYiBaoApplyDO.setStatus(Integer.valueOf(3));
            this.cloudYiBaoApplyDao.updateById((Object)cloudYiBaoApplyDO);
            this.storeApprovedTask.addMessage((Integer)cloudYiBaoApplyDO.getId());
            return "success";
        }
        catch (Exception e) {
            log.error("\u6613\u5b9d\u56de\u8c03 == \u89e3\u6790\u6613\u5b9d\u56de\u8c03\u7ed3\u679c\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("RSA\u56de\u8c03\u8bf7\u6c42\u4ec5\u652f\u6301form\u683c\u5f0f");
        }
    }

    @Override
    public String sendYibaoJoin(Integer depId) {
        CloudYiBaoApplyDO cloudYiBaoApply;
        String message;
        Integer status;
        GetDepartmentInfoVO departmentInfo;
        block12: {
            departmentInfo = this.shopWebCommon.getDepartmentInfo(null, depId);
            if (departmentInfo == null) {
                log.error("\u6613\u5b9d\u7b7e\u7ea6 == \u65e0\u6b64\u95e8\u5e97\uff1a{}", (Object)depId);
                return "\u65e0\u6b64\u95e8\u5e97";
            }
            CloudStoreContractDO cloudStoreContract = (CloudStoreContractDO)this.cloudStoreContractDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudStoreContractDO::getStoreId, (Object)depId)).eq(CloudStoreContractDO::getRowStatus, (Object)1));
            status = 0;
            message = "";
            cloudYiBaoApply = new CloudYiBaoApplyDO();
            cloudYiBaoApply.setStoreId(depId);
            this.cloudYiBaoApplyDao.insert((Object)cloudYiBaoApply);
            if (cloudStoreContract == null || cloudStoreContract.getYibaoSign() == 0) {
                cloudYiBaoApply.setType(Integer.valueOf(0));
                log.info("\u6613\u5b9d\u7b7e\u7ea6 == \u5f00\u59cb\u5165\u7f51\uff1a{}", (Object)departmentInfo.getDepId());
                RegisterSaasMerchantV2Request request = this.getRegisterSaasMerchantV2Request(departmentInfo);
                request.setRequestNo(((Integer)cloudYiBaoApply.getId()).toString());
                try {
                    RegisterSaasMerchantV2Response response = api.registerSaasMerchantV2(request);
                    RegisterSaasMerchantV2ContributeMerchantNetInRespDtoResult result = response.getResult();
                    if ("NIG00000".equals(result.getReturnCode())) {
                        log.info("\u6613\u5b9d\u7b7e\u7ea6 == \u5165\u7f51\u8bf7\u6c42\u53d1\u9001\u6210\u529f\uff1a{}", (Object)result.toString());
                        status = StoreReviewStateEnum.YIBAO_REVIEWING.getCode();
                        cloudYiBaoApply.setApplicationStatus(result.getApplicationStatus());
                        cloudYiBaoApply.setApplicationNo(result.getApplicationNo());
                        cloudYiBaoApply.setMerchantNo(result.getMerchantNo());
                        break block12;
                    }
                    log.error("\u6613\u5b9d\u7b7e\u7ea6 == \u5165\u7f51\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff1a{}", (Object)result.toString());
                    message = result.getReturnMsg();
                    status = StoreReviewStateEnum.YIBAO_REJECTED.getCode();
                }
                catch (YopClientException e) {
                    message = e.getMessage();
                    status = StoreReviewStateEnum.YIBAO_FAIL.getCode();
                    log.error("\u6613\u5b9d\u7b7e\u7ea6 == \u5165\u7f51\u8bf7\u6c42\u53d1\u9001\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                }
            } else {
                cloudYiBaoApply.setType(Integer.valueOf(1));
                log.info("\u6613\u5b9d == \u5f00\u59cb\u4fe1\u606f\u53d8\u66f4\uff1a{}", (Object)departmentInfo.getDepId());
                MerchantInfoModifyRequest request = this.getMerchantInfoModifyRequest(depId);
                request.setRequestNo(((Integer)cloudYiBaoApply.getId()).toString());
                try {
                    MerchantInfoModifyResponse response = api.merchantInfoModify(request);
                    MerchantInfoModifyMerchantInfoModifyRespDTOResult result = response.getResult();
                    if ("NIG00000".equals(result.getReturnCode())) {
                        log.info("\u6613\u5b9d == \u4fe1\u606f\u53d8\u66f4\u8bf7\u6c42\u53d1\u9001\u6210\u529f\uff1a{}", (Object)result.toString());
                        status = StoreReviewStateEnum.YIBAO_REVIEWING.getCode();
                        cloudYiBaoApply.setApplicationStatus(result.getApplicationStatus());
                        cloudYiBaoApply.setApplicationNo(result.getApplicationNo());
                        cloudYiBaoApply.setMerchantNo(result.getMerchantNo());
                    } else {
                        log.error("\u6613\u5b9d == \u4fe1\u606f\u53d8\u66f4\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff1a{}", (Object)result.toString());
                        message = result.getReturnMsg();
                        status = StoreReviewStateEnum.YIBAO_REJECTED.getCode();
                    }
                }
                catch (YopClientException e) {
                    message = e.getMessage();
                    status = StoreReviewStateEnum.YIBAO_FAIL.getCode();
                    log.error("\u6613\u5b9d == \u5165\u4fe1\u606f\u53d8\u66f4\u8bf7\u6c42\u53d1\u9001\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
        }
        if (StoreReviewStateEnum.YIBAO_REJECTED.getCode().equals(status) || StoreReviewStateEnum.YIBAO_FAIL.getCode().equals(status)) {
            cloudYiBaoApply.setStatus(Integer.valueOf(2));
            cloudYiBaoApply.setAuditOpinion(message);
        } else {
            cloudYiBaoApply.setStatus(Integer.valueOf(1));
        }
        this.cloudYiBaoApplyDao.updateById((Object)cloudYiBaoApply);
        this.cloudSearchDepartmentsDao.updateDepartmentStatus((long)departmentInfo.getDepId().intValue(), status);
        return "\u6210\u529f";
    }

    @Override
    public YibaoAuthDTO getYibaoAuth(String merchantNo) {
        YibaoAuthDTO yibaoAuthDTO = new YibaoAuthDTO();
        yibaoAuthDTO.setMerchantNo(merchantNo);
        AuthStateQueryV2Request request = new AuthStateQueryV2Request();
        request.setMerchantNo(merchantNo);
        AuthStateQueryV2Response response = null;
        Integer weixinAuth = null;
        Integer alipayAuth = null;
        try {
            response = api.authStateQueryV2(request);
            log.info("\u6613\u5b9d\u6388\u6743\u7ed3\u679c\u67e5\u8be2,result:{}", (Object)response.getResult());
            if (response != null && "NIG00000".equals(response.getResult().getReturnCode())) {
                for (AuthStateQueryV2IdentityAuthDtoResult identityAuthDto : response.getResult().getIdentityAuthDtos()) {
                    YibaoAuthStateEnum yibaoAuthStateEnum;
                    if (YibaoFeeTypeEnum.ALIPUTONG.getName().equals(identityAuthDto.getFeeType())) {
                        yibaoAuthStateEnum = YibaoAuthStateEnum.fetchByCode((String)identityAuthDto.getAuthorizeState());
                        if (yibaoAuthStateEnum == null) continue;
                        alipayAuth = yibaoAuthStateEnum.getCode();
                        continue;
                    }
                    yibaoAuthStateEnum = YibaoAuthStateEnum.fetchByCode((String)identityAuthDto.getAuthorizeState());
                    if (yibaoAuthStateEnum == null) continue;
                    weixinAuth = yibaoAuthStateEnum.getCode();
                }
            }
            yibaoAuthDTO.setWeixinAuth(weixinAuth);
            yibaoAuthDTO.setAlipayAuth(alipayAuth);
        }
        catch (YopClientException e) {
            log.error("Exception when calling MerClient#authStateQueryV2, ex:", (Throwable)e);
        }
        return yibaoAuthDTO;
    }

    @Override
    public List<CloudStoreContractVo> getStoreContract(StoreContractListVO request) {
        List cloudStoreContractDOS;
        if (CollectionUtils.isEmpty((Collection)request.getStoreIdList())) {
            throw new CloudWatchException("\u53c2\u6570\u9519\u8bef");
        }
        LambdaQueryWrapper wr = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(CloudStoreContractDO::getStoreId, (Collection)request.getStoreIdList());
        if (StringUtils.isNotEmpty((CharSequence)request.getMerchantNo())) {
            wr.eq(CloudStoreContractDO::getMerchantNo, (Object)request.getMerchantNo());
        }
        List<CloudStoreContractVo> result = CollectionUtils.isEmpty((Collection)(cloudStoreContractDOS = this.cloudStoreContractDao.selectList((Wrapper)wr))) ? Collections.emptyList() : cloudStoreContractDOS.stream().map(doObj -> {
            CloudStoreContractVo vo = new CloudStoreContractVo();
            BeanUtils.copyProperties((Object)doObj, (Object)vo);
            return vo;
        }).collect(Collectors.toList());
        return result;
    }

    private MerchantInfoModifyRequest getMerchantInfoModifyRequest(Integer depId) {
        MerchantInfoModifyRequest request = new MerchantInfoModifyRequest();
        return request;
    }

    private RegisterSaasMerchantV2Request getRegisterSaasMerchantV2Request(GetDepartmentInfoVO departmentInfo) {
        RegisterSaasMerchantV2Request request = new RegisterSaasMerchantV2Request();
        request.setBusinessRole("ORDINARY_MERCHANT");
        request.setParentMerchantNo("10091431969");
        YibaoRegisterMerchantSubjectDTO merchantSubjectInfo = new YibaoRegisterMerchantSubjectDTO();
        merchantSubjectInfo.setLicenceNo(departmentInfo.getUnifiedSocialCreditCode());
        merchantSubjectInfo.setSignName(departmentInfo.getLicenseName());
        merchantSubjectInfo.setShortName(merchantSubjectInfo.getSignName());
        if (departmentInfo.getBusinessType() == 1) {
            merchantSubjectInfo.setSignType("INDIVIDUAL");
        } else if (departmentInfo.getBusinessType() == 2) {
            merchantSubjectInfo.setSignType("ENTERPRISE");
        }
        merchantSubjectInfo.setLicenceUrl(this.copyYibaoFile(departmentInfo.getLicensePic()));
        request.setMerchantSubjectInfo(JSON.toJSONString((Object)merchantSubjectInfo));
        YibaoRegisterLegalDTO legalInfo = new YibaoRegisterLegalDTO();
        legalInfo.setLegalName(departmentInfo.getIdName());
        if (departmentInfo.getIdType() != 0) {
            throw new CloudWatchException("\u6cd5\u4eba\u65e0\u6709\u6548\u8bc1\u4ef6\u7c7b\u578b " + departmentInfo.getIdType());
        }
        legalInfo.setLegalLicenceType("ID_CARD");
        legalInfo.setLegalLicenceNo(departmentInfo.getIdNo());
        legalInfo.setLegalLicenceFrontUrl(this.copyYibaoFile(departmentInfo.getIdFrontPic()));
        legalInfo.setLegalLicenceBackUrl(this.copyYibaoFile(departmentInfo.getIdBackendPic()));
        request.setMerchantCorporationInfo(JSON.toJSONString((Object)legalInfo));
        YibaoRegisterContractDTO contractInfo = new YibaoRegisterContractDTO();
        contractInfo.setContactName(departmentInfo.getLicenseName());
        contractInfo.setContactMobile(departmentInfo.getContactPhone());
        contractInfo.setContactEmail("hanshuai@ovopark.com");
        request.setMerchantContactInfo(JSON.toJSONString((Object)contractInfo));
        request.setNotifyUrl(this.yibaoCallback);
        LinkedList<YibaoRegisterProductDTO> productInfo = new LinkedList<YibaoRegisterProductDTO>();
        for (YibaoProductEnum yibaoProductEnum : YibaoProductEnum.values()) {
            YibaoRegisterProductDTO product = new YibaoRegisterProductDTO();
            product.setProductCode(yibaoProductEnum.getName());
            product.setRateType(yibaoProductEnum.getWay());
            if ("SINGLE_PERCENT".equals(yibaoProductEnum.getWay())) {
                product.setPercentRate(yibaoProductEnum.getPrice().toString());
            } else if ("SINGLE_FIXED".equals(yibaoProductEnum.getWay())) {
                product.setFixedRate(yibaoProductEnum.getPrice().toString());
            }
            productInfo.add(product);
        }
        request.setProductInfo(JSONArray.toJSONString(productInfo));
        YibaoRegisterCategoryDTO categoryInfo = new YibaoRegisterCategoryDTO();
        categoryInfo.setMcc(String.valueOf(departmentInfo.getBusinessCategory()));
        request.setIndustryCategoryInfo(JSON.toJSONString((Object)categoryInfo));
        YibaoRegisterAccountDTO accountInfo = new YibaoRegisterAccountDTO();
        accountInfo.setSettlementDirection("ACCOUNT");
        CloudStoreBankVO bankAccountInfo = departmentInfo.getCloudStoreBankVO();
        accountInfo.setBankCardNo(bankAccountInfo.getBankAccountNo());
        accountInfo.setBankCode(bankAccountInfo.getBankNo());
        if (bankAccountInfo.getType() == 1) {
            accountInfo.setBankAccountType("ENTERPRISE_ACCOUNT");
        } else if (bankAccountInfo.getType() == 2) {
            accountInfo.setBankAccountType("DEBIT_CARD");
            accountInfo.setBankAccountName(departmentInfo.getIdName());
            accountInfo.setLicenceType("ID_CARD");
            accountInfo.setLicenceNo(departmentInfo.getIdNo());
            accountInfo.setBankCardUrl(this.copyYibaoFile(bankAccountInfo.getBankFrontPic()));
            accountInfo.setRelation("SHAREHOLDER_OR_EMPLOY");
            accountInfo.setRelationCertUrl(merchantSubjectInfo.getLicenceUrl());
        } else {
            throw new CloudWatchException("\u7ed3\u8d26\u8d26\u6237\u4fe1\u606f\u65e0\u6709\u6548\u8d26\u6237\u7c7b\u578b " + bankAccountInfo.getType());
        }
        request.setSettlementAccountInfo(JSON.toJSONString((Object)accountInfo));
        YibaoRegisterProductQualificationDTO productQualificationInfo = new YibaoRegisterProductQualificationDTO();
        productQualificationInfo.setMcc(String.valueOf(departmentInfo.getBusinessCategory()));
        productQualificationInfo.setScenePhotoUrl(this.copyYibaoFile(departmentInfo.getDoorPic()));
        productQualificationInfo.setBusinessPlacePhotoUrl(this.copyYibaoFile(departmentInfo.getShelvesPic()));
        request.setProductQualificationInfo(JSON.toJSONString((Object)productQualificationInfo));
        LinkedList<String> functionService = new LinkedList<String>();
        functionService.add("SHARE");
        request.setFunctionService(JSONArray.toJSONString(functionService));
        YibaoRegisterFunctionServiceQualificationDTO functionServiceQualificationInfo = new YibaoRegisterFunctionServiceQualificationDTO();
        functionServiceQualificationInfo.setShareScene("FZ_FJ004");
        request.setFunctionServiceQualificationInfo(JSON.toJSONString((Object)functionServiceQualificationInfo));
        request.setDirectAgentNo("10091431969");
        YibaoRegisterSignatoryDTO signatoryInfo = new YibaoRegisterSignatoryDTO();
        signatoryInfo.setSignatoryName(departmentInfo.getLegalRepresentative());
        signatoryInfo.setSignatoryMobile(departmentInfo.getContactPhone());
        request.setMerchantAgreementInfo(JSON.toJSONString((Object)signatoryInfo));
        YibaoRegisterAddressDTO addressInfo = YibaoRegisterAddressDTO.builder().province(departmentInfo.getProvince()).city(departmentInfo.getCity()).district(departmentInfo.getDistrict()).address(departmentInfo.getIdAddress()).build();
        request.setBusinessAddressInfo(JSON.toJSONString((Object)addressInfo));
        YibaoRegisterMerchantAcquireDTO merchantAcquireInfo = new YibaoRegisterMerchantAcquireDTO();
        merchantAcquireInfo.setBusinessSceneList(Arrays.asList("POS", "STATICQR"));
        merchantAcquireInfo.setIsAppIdConfig("YES");
        merchantAcquireInfo.setAppIdConfigType("MERCHANT");
        merchantAcquireInfo.setAppId("wx774665fa755041a6");
        request.setBusinessScene(JSON.toJSONString((Object)merchantAcquireInfo));
        return request;
    }

    private String copyYibaoFile(String url) {
        File file = this.downloadFile(url);
        if (file == null) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25:{}", (Object)url);
            throw new CloudWatchException("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
        }
        MerchantQualUploadRequest uploadRequest = new MerchantQualUploadRequest();
        uploadRequest.setMerQual(file);
        MerchantQualUploadResponse uploadResponse = sysClient.merchantQualUpload(uploadRequest);
        MerchantQualUploadMerFileUploadRespDtoResult result = uploadResponse.getResult();
        if ("REG00000".equals(result.getReturnCode())) {
            return result.getMerQualUrl();
        }
        log.error("\u6613\u5b9d == \u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a{}", (Object)result.getReturnMsg());
        throw new CloudWatchException("\u4e0a\u4f20\u6587\u4ef6\u5230\u6613\u5b9d\u4e0a\u5931\u8d25" + result.getReturnMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadFile(String url) {
        File file;
        try {
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            String[] prefix = fileName.split("\\.");
            file = File.createTempFile(prefix[0], "." + prefix[1]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int index = 0;
        while (index < 3) {
            HttpURLConnection connection = null;
            try {
                URL fileUrl = new URL(url);
                connection = (HttpURLConnection)fileUrl.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 ( compatible ) ");
                connection.setRequestProperty("Accept", "*/*");
                InputStream inputStream = connection.getInputStream();
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
                File file2 = file;
                return file2;
            }
            catch (Exception exception) {
                log.error("url\u89e3\u6790\u5f02\u5e38,url\u4e3a:" + url + ",\u5f02\u5e38\u4fe1\u606f\u4e3a:" + exception.getMessage() + "\uff0c\u5f02\u5e38\uff1a" + exception.toString());
                try {
                    if (connection != null) {
                        InputStream errorStream = connection.getErrorStream();
                        String errorString = IOUtils.toString((InputStream)errorStream, (Charset)StandardCharsets.UTF_8);
                        log.error("url\u89e3\u6790\u5f02\u5e38,\u8fd4\u56de\u503c\u4e3a:" + errorString);
                    }
                }
                catch (IOException e) {
                    log.error("url\u89e3\u6790\u5f02\u5e38,url:" + url + ",\u83b7\u53d6\u51fa\u9519\u6d41\u5f02\u5e38\uff1a:" + exception.getMessage());
                }
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
            log.error("url\u91cd\u65b0\u83b7\u53d6\u4e0a\u4f20 : {}, \u91cd\u8bd5\u6b21\u6570\uff1a{}", (Object)url, (Object)(++index));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        log.error("url\u89e3\u6790\u5f02\u5e38,url:" + url + ",\u91cd\u8bd5\u6b21\u6570\u5df2\u8d85\u8fc73\u6b21");
        return null;
    }
}

