/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.cloud.DTO.CloudMonthNumDTO;
import com.ovopark.cloud.DTO.CloudOnlineTimeDTO;
import com.ovopark.cloud.DTO.NumberWanJiDTO;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.DTO.WanJiYearSaleDTO;
import com.ovopark.cloud.DTO.WatchServiceRecordDTO;
import com.ovopark.cloud.DTO.WatchServiceRecordInfoDTO;
import com.ovopark.cloud.VO.CloudAvgTimeVO;
import com.ovopark.cloud.VO.CloudDutyRecordVO;
import com.ovopark.cloud.VO.CloudKeySearchHistoryVO;
import com.ovopark.cloud.VO.CloudManageSaleBaseVO;
import com.ovopark.cloud.VO.CloudMonthSaleVO;
import com.ovopark.cloud.VO.CloudOperateStateVO;
import com.ovopark.cloud.VO.CloudServiceClientInfoVO;
import com.ovopark.cloud.VO.CloudServiceClientStoreVO;
import com.ovopark.cloud.VO.CloudServiceEnterStoreVO;
import com.ovopark.cloud.VO.CloudServiceRecordVO;
import com.ovopark.cloud.VO.CloudTopSaleVO;
import com.ovopark.cloud.VO.CloudTopWatchVO;
import com.ovopark.cloud.VO.CloudWatchRecordVO;
import com.ovopark.cloud.VO.GetSelectDepByUserIdVo;
import com.ovopark.cloud.VO.OvoparkUserInfoEntity;
import com.ovopark.cloud.base.PageBaseQuery;
import com.ovopark.cloud.base.PageBaseResult;
import com.ovopark.cloud.base.ResponseBaseParent;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.TimeService;
import com.ovopark.cloud.dao.state.CloudClientOssDao;
import com.ovopark.cloud.dao.state.CloudClientStoreHistoryDao;
import com.ovopark.cloud.entity.CloudClientOssDO;
import com.ovopark.cloud.entity.CloudClientStoreHistoryDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.enums.CloudStoreStateEnum;
import com.ovopark.cloud.exception.CloudWatchErrorCode;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.cloud.map.CloudStoreStateVOMapper;
import com.ovopark.cloud.query.CloudDutyQuery;
import com.ovopark.cloud.query.CloudManageFilterQuery;
import com.ovopark.cloud.query.OrderDetailQuery;
import com.ovopark.cloud.query.PullUserQuery;
import com.ovopark.cloud.query.UserUpdateQuery;
import com.ovopark.cloud.query.WanJiHistoryQuery;
import com.ovopark.cloud.query.WanJiMonthSaleQuery;
import com.ovopark.cloud.query.WanJiYearStoreQuery;
import com.ovopark.cloud.service.CloudManageService;
import com.ovopark.cloud.service.CloudStoreService;
import com.ovopark.cloud.utils.ShopWebCommon;
import com.ovopark.cloud.wanji.WanJiForeignService;
import com.ovopark.cloud.watch.WatchForeignService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CloudManageServiceImpl
implements CloudManageService {
    private static final Logger log = LoggerFactory.getLogger(CloudManageServiceImpl.class);
    @Autowired
    private WanJiForeignService wanJiForeignService;
    @Autowired
    private CloudClientOssDao cloudClientOssDao;
    @Autowired
    private CloudClientStoreHistoryDao cloudClientStoreHistoryDao;
    @Autowired
    private WatchForeignService watchForeignService;
    @Autowired
    private CloudStoreService cloudStoreService;
    @Resource
    private ShopWebCommon shopWebCommon;

    @Override
    public CloudOperateStateVO pullBlackUser(UserUpdateQuery query) {
        return this.operateBlackUser(query, true);
    }

    @Override
    public CloudOperateStateVO resumeUser(UserUpdateQuery query) {
        return this.operateBlackUser(query, false);
    }

    @Override
    public PageBaseResult<List<CloudKeySearchHistoryVO>> WanJiHistoryQuery(PageBaseQuery<WanJiHistoryQuery> query) {
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        WanJiHistoryQuery wanJiHistoryQuery = (WanJiHistoryQuery)query.getFilter();
        wanJiHistoryQuery.setWdzEntId(String.valueOf(threadUserDTO.getUserData().getData().getGroupId()));
        wanJiHistoryQuery.setPageSize(query.getLimit().intValue());
        wanJiHistoryQuery.setPageNumber(query.getSkip().intValue() + 1);
        ResponseBaseParent wanJiSearchResult = this.wanJiForeignService.queryKeyword(wanJiHistoryQuery);
        if (wanJiSearchResult.getCode() != 0) {
            throw new CloudWatchException(CloudWatchErrorCode.WAN_JI_INTERFACE_ERROR);
        }
        PageBaseResult result = new PageBaseResult();
        result.initFromCloudManageFilterQueryPage((IPage)wanJiSearchResult.getData(), query);
        return result;
    }

    @Override
    public CloudTopSaleVO querySaleTop() {
        CloudTopSaleVO result = new CloudTopSaleVO();
        WanJiMonthSaleQuery saleQuery = this.getMonthSaleQuery();
        ResponseBaseParent productTop = this.wanJiForeignService.queryGoodsTop(saleQuery);
        ResponseBaseParent saleTop = this.wanJiForeignService.queryStoreSaleTop(saleQuery);
        if (productTop.getCode() != 200 || saleTop.getCode() != 200) {
            throw new CloudWatchException(CloudWatchErrorCode.WAN_JI_INTERFACE_ERROR);
        }
        result.setSaleTop((List)saleTop.getData());
        result.setProductTop((List)productTop.getData());
        return result;
    }

    @Override
    public List<CloudMonthSaleVO> queryMonthSale(String storeId) {
        LinkedList<CloudMonthSaleVO> result = new LinkedList<CloudMonthSaleVO>();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        String groupId = String.valueOf(threadUserDTO.getUserData().getData().getGroupId());
        int year = TimeService.getYear((int)0);
        int month = TimeService.getMonth((int)0);
        WanJiYearStoreQuery storeQuery = new WanJiYearStoreQuery();
        storeQuery.setYear(year);
        if (StringUtils.isNotEmpty((CharSequence)storeId)) {
            storeQuery.setWdzDeptId(storeId);
        }
        storeQuery.setWdzEntId(groupId);
        ResponseBaseParent responseBaseParent = this.wanJiForeignService.queryAllStoreSale(storeQuery);
        if (responseBaseParent.getCode() != 200) {
            throw new CloudWatchException(CloudWatchErrorCode.WAN_JI_INTERFACE_ERROR);
        }
        List wanJiYearSaleDTOList = (List)responseBaseParent.getData();
        for (int index = 1; index <= month; ++index) {
            CloudMonthSaleVO cloudMonthSaleVO = new CloudMonthSaleVO();
            cloudMonthSaleVO.setMonth(index);
            String monthStr = String.valueOf(index);
            cloudMonthSaleVO.setMonthName(monthStr + "\u6708");
            List<Object> storeSaleMonth = new LinkedList();
            BigDecimal sumSale = new BigDecimal(0);
            for (WanJiYearSaleDTO wanJiYearSaleDTO : wanJiYearSaleDTOList) {
                Map monthSale = wanJiYearSaleDTO.getMothAndSale();
                CloudMonthSaleVO.CloudMonthStoreSaleVO cloudMonthStoreSaleVO = new CloudMonthSaleVO.CloudMonthStoreSaleVO();
                String wdzDeptId = wanJiYearSaleDTO.getWdzDeptId();
                cloudMonthStoreSaleVO.setWdzDeptId(wdzDeptId);
                cloudMonthStoreSaleVO.setSalePrice(BigDecimal.valueOf(monthSale.containsKey(monthStr) ? (Double)monthSale.get(monthStr) : 0.0));
                cloudMonthStoreSaleVO.setStoreName(wanJiYearSaleDTO.getStoreName());
                sumSale = sumSale.add(cloudMonthStoreSaleVO.getSalePrice());
                storeSaleMonth.add(cloudMonthStoreSaleVO);
            }
            storeSaleMonth = storeSaleMonth.stream().sorted(Comparator.comparing(CloudMonthSaleVO.CloudMonthStoreSaleVO::getSalePrice).reversed()).collect(Collectors.toList());
            cloudMonthSaleVO.setStoreSaleMonth(storeSaleMonth);
            cloudMonthSaleVO.setSaleMonth(sumSale);
            result.add(cloudMonthSaleVO);
        }
        return result;
    }

    @Override
    public CloudManageSaleBaseVO querySaleManageBase(String storeId) {
        CloudManageSaleBaseVO cloudManageSaleBaseVO = new CloudManageSaleBaseVO();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        String groupId = String.valueOf(threadUserDTO.getUserData().getData().getGroupId());
        WanJiMonthSaleQuery saleQuery = new WanJiMonthSaleQuery();
        saleQuery.setWdzEntId(groupId);
        if (StringUtils.isNotEmpty((CharSequence)storeId)) {
            saleQuery.setWdzDeptId(storeId);
        }
        saleQuery.setStartTime(TimeService.getStartTimeDay());
        saleQuery.setEndTime(TimeService.getEndTimeDay());
        Future saleFuture = this.wanJiForeignService.queryCloudSales(saleQuery);
        Future orderFuture = this.wanJiForeignService.queryCloudOrder(saleQuery);
        Future clientFuture = this.wanJiForeignService.queryCloudClient(saleQuery);
        HttpResponseEntity serviceNumResponse = this.watchForeignService.queryServiceNum(saleQuery.getWdzEntId(), saleQuery.getStartTime(), saleQuery.getEndTime(), saleQuery.getWdzDeptId());
        if (serviceNumResponse.getIsError().booleanValue()) {
            throw new CloudWatchException(CloudWatchErrorCode.WATCH_INTERFACE_ERROR);
        }
        try {
            ResponseBaseParent responseBaseParent = (ResponseBaseParent)saleFuture.get();
            ResponseBaseParent baseParent = (ResponseBaseParent)orderFuture.get();
            ResponseBaseParent parent = (ResponseBaseParent)clientFuture.get();
            if (responseBaseParent.getCode() != 200 || baseParent.getCode() != 200 || parent.getCode() != 200) {
                throw new CloudWatchException(CloudWatchErrorCode.WAN_JI_INTERFACE_ERROR);
            }
            cloudManageSaleBaseVO.setSale(BigDecimal.valueOf(((NumberWanJiDTO)responseBaseParent.getData()).getNum()));
            cloudManageSaleBaseVO.setOrder((int)((NumberWanJiDTO)baseParent.getData()).getNum());
            cloudManageSaleBaseVO.setClient((int)((NumberWanJiDTO)parent.getData()).getNum());
            cloudManageSaleBaseVO.setService(((Integer)serviceNumResponse.getData()).intValue());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return cloudManageSaleBaseVO;
    }

    @Override
    public PageBaseResult<List<CloudDutyRecordVO>> queryDutyRecords(PageBaseQuery<CloudDutyQuery> cloudDutyQuery) {
        HttpResponseEntity responseEntity;
        Boolean isAdmin;
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        OvoparkUserInfoEntity userData = threadUserDTO.getUserData().getData();
        List<Object> depIds = new ArrayList();
        PageBaseResult result = new PageBaseResult();
        if (userData != null && userData.getGroupId() != null && !(isAdmin = this.shopWebCommon.userIsAdmin(threadUserDTO.getToken(), userData.getId(), userData.getGroupId())).booleanValue() && CollectionUtils.isEmpty(depIds = this.shopWebCommon.getPrivilegeDepIdsByUserId(threadUserDTO.getToken(), userData.getId(), userData.getGroupId()))) {
            return result;
        }
        Integer groupId = threadUserDTO.getUserData().getData().getGroupId();
        CloudDutyQuery query = (CloudDutyQuery)cloudDutyQuery.getFilter();
        if (groupId != null) {
            query.setEnterpriseId(String.valueOf(groupId));
        }
        if (StringUtils.isEmpty((CharSequence)query.getEnterpriseId())) {
            query.setEnterpriseId("");
        }
        if (StringUtils.isEmpty((CharSequence)query.getOrderByField())) {
            query.setOrderByField("");
        }
        if (StringUtils.isEmpty((CharSequence)query.getServiceUserId())) {
            query.setServiceUserId("");
        }
        if (!CollectionUtils.isEmpty(depIds)) {
            query.setDepIds(depIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        } else {
            query.setDepIds("");
        }
        if (query.getStartTime() != null) {
            query.setStartTimeStr(query.getStartTime());
            query.setStartTime(null);
        }
        if (query.getEndTime() != null) {
            query.setEndTimeStr(query.getEndTime());
            query.setEndTime(null);
        }
        query.setPageNumber(Long.valueOf(cloudDutyQuery.getSkip() + 1L));
        query.setPageSize(cloudDutyQuery.getLimit());
        String responseBody = "";
        try {
            responseBody = this.watchForeignService.userServiceRecordsRootPost(query);
        }
        catch (CloudWatchException e) {
            log.error("\u67e5\u8be2\u7528\u6237\u670d\u52a1\u8bb0\u5f55\u5f02\u5e38{}", (Throwable)e);
            throw new CloudWatchException(CloudWatchErrorCode.WATCH_INTERFACE_ERROR);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            responseEntity = (HttpResponseEntity)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<HttpResponseEntity<WatchServiceRecordDTO<CloudDutyRecordVO>>>(){});
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        if (responseEntity.getIsError().booleanValue()) {
            throw new CloudWatchException(CloudWatchErrorCode.WATCH_INTERFACE_ERROR);
        }
        WatchServiceRecordDTO watchServiceRecordDTO = (WatchServiceRecordDTO)responseEntity.getData();
        result.setData(this.formatData(watchServiceRecordDTO.getRecords()));
        result.initWatchServiceRecordDTO(watchServiceRecordDTO, cloudDutyQuery);
        return result;
    }

    private List<CloudDutyRecordVO> formatData(List<CloudDutyRecordVO> records) {
        if (records == null) {
            return records;
        }
        for (int index = 0; index < records.size(); ++index) {
            CloudDutyRecordVO cloudDutyRecordVO = records.get(index);
            cloudDutyRecordVO.setOnlineTimeFormat(this.translateTime(cloudDutyRecordVO.getOnlineTime()));
            cloudDutyRecordVO.setServiceTimeFormat(this.translateTime(cloudDutyRecordVO.getServiceTime()));
            records.set(index, cloudDutyRecordVO);
        }
        return records;
    }

    private String translateTime(Long onlineTime) {
        if (onlineTime <= 0L) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (onlineTime >= 3600L) {
            stringBuilder.append(onlineTime / 3600L).append("\u65f6");
            onlineTime = onlineTime % 3600L;
        }
        if (onlineTime >= 60L) {
            stringBuilder.append(onlineTime / 60L).append("\u5206");
            onlineTime = onlineTime % 60L;
        }
        stringBuilder.append(onlineTime).append("\u79d2");
        return stringBuilder.toString();
    }

    @Override
    public CloudTopWatchVO queryWatchTop() {
        CloudTopWatchVO watchVO = new CloudTopWatchVO();
        WanJiMonthSaleQuery query = this.getMonthSaleQuery();
        Future futureOnline = this.watchForeignService.queryOnlineTime(query.getWdzEntId(), query.getStartTime(), query.getEndTime(), query.getNum());
        Future futurePrice = this.watchForeignService.queryRankingOfBusinessVolume(query.getWdzEntId(), query.getStartTime(), query.getEndTime(), query.getNum());
        Future futureRate = this.watchForeignService.queryRankingOfCloseRate(query.getWdzEntId(), query.getStartTime(), query.getEndTime(), query.getNum());
        Future futureMonthMap = this.watchForeignService.queryMonthServiceNum(query.getWdzEntId(), TimeService.getYearFirstTime(), TimeService.getNextYearFirstTime());
        try {
            HttpResponseEntity onlineResponse = (HttpResponseEntity)futureOnline.get();
            HttpResponseEntity pricesResponse = (HttpResponseEntity)futurePrice.get();
            HttpResponseEntity rateResponse = (HttpResponseEntity)futureRate.get();
            HttpResponseEntity monthResponse = (HttpResponseEntity)futureMonthMap.get();
            if (onlineResponse.getIsError().booleanValue() && pricesResponse.getIsError().booleanValue() && rateResponse.getIsError().booleanValue() && monthResponse.getIsError().booleanValue()) {
                throw new CloudWatchException(CloudWatchErrorCode.WATCH_INTERFACE_ERROR);
            }
            List onlineTimeList = (List)onlineResponse.getData();
            for (int index = 0; index < onlineTimeList.size(); ++index) {
                CloudOnlineTimeDTO onlineTimeDTO = (CloudOnlineTimeDTO)onlineTimeList.get(index);
                onlineTimeDTO.setOnlineTimeFormat(this.translateTime(onlineTimeDTO.getOnlineTime()));
                onlineTimeList.set(index, onlineTimeDTO);
            }
            watchVO.setOnlineTime(onlineTimeList);
            watchVO.setBusinessRate((List)rateResponse.getData());
            watchVO.setBusinessPrice((List)pricesResponse.getData());
            watchVO.setMonthNum(CloudMonthNumDTO.fromMonthServiceMap((Map)((Map)monthResponse.getData())));
        }
        catch (Exception e) {
            throw new CloudWatchException(CloudWatchErrorCode.WATCH_INTERFACE_ERROR);
        }
        return watchVO;
    }

    @Override
    public List<CloudAvgTimeVO> queryClientAvgTime(String storeId, String sign) {
        boolean hasDay = sign.equals("day");
        WanJiMonthSaleQuery query = this.getAvgTimeQuery(hasDay);
        HttpResponseEntity avgTimeResponse = this.watchForeignService.queryAvgDurationInStore(query.getWdzEntId(), query.getStartTime(), query.getEndTime(), sign);
        if (avgTimeResponse.getIsError().booleanValue()) {
            throw new CloudWatchException(CloudWatchErrorCode.WATCH_INTERFACE_ERROR);
        }
        Map avgTimeMap = (Map)avgTimeResponse.getData();
        List<Object> timeRange = new LinkedList();
        if (!hasDay) {
            timeRange = this.getTimeWeekRange(-3);
        }
        return CloudAvgTimeVO.fromAvgTimeMap((Map)avgTimeMap, (String)storeId, (boolean)hasDay, timeRange);
    }

    private List<String> getTimeWeekRange(int range) {
        LinkedList<String> timeRange = new LinkedList<String>();
        for (int index = 0; index >= range; --index) {
            String firstDate = TimeService.getFirstWeekTimeByNum((int)index).substring(5, 10).replace("-", "/");
            String endDate = TimeService.getEndWeekTimeByNum((int)index).substring(5, 10).replace("-", "/");
            timeRange.add(0, firstDate + "\u81f3" + endDate);
        }
        return timeRange;
    }

    private WanJiMonthSaleQuery getAvgTimeQuery(boolean hasDay) {
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        WanJiMonthSaleQuery saleQuery = new WanJiMonthSaleQuery();
        saleQuery.setWdzEntId(String.valueOf(threadUserDTO.getUserData().getData().getGroupId()));
        if (hasDay) {
            saleQuery.setEndTime(TimeService.getFirstTimeByNum((int)1));
            saleQuery.setStartTime(TimeService.getFirstTimeByNum((int)-6));
        } else {
            saleQuery.setEndTime(TimeService.getFirstWeekTimeByNum((int)1));
            saleQuery.setStartTime(TimeService.getFirstWeekTimeByNum((int)-3));
        }
        return saleQuery;
    }

    private WanJiMonthSaleQuery getMonthSaleQuery() {
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        WanJiMonthSaleQuery saleQuery = new WanJiMonthSaleQuery();
        saleQuery.setNum(Integer.valueOf(10));
        saleQuery.setWdzEntId(String.valueOf(threadUserDTO.getUserData().getData().getGroupId()));
        saleQuery.setStartTime(TimeService.getMonthFirstTime());
        saleQuery.setEndTime(TimeService.getTime());
        return saleQuery;
    }

    private CloudOperateStateVO operateBlackUser(UserUpdateQuery query, boolean pullBlack) {
        Boolean verifyResult = StringUtils.isEmpty((CharSequence)query.getOpenid()) && StringUtils.isEmpty((CharSequence)query.getPhone());
        if (verifyResult.booleanValue()) {
            throw new CloudWatchException(CloudWatchErrorCode.CLIENT_INFO_NOT);
        }
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        OvoparkUserInfoEntity userInfoEntity = threadUserDTO.getUserData().getData();
        PullUserQuery pullUserQuery = new PullUserQuery();
        pullUserQuery.setWdzEntId(String.valueOf(userInfoEntity.getGroupId()));
        if (StringUtils.isNotEmpty((CharSequence)query.getPhone())) {
            pullUserQuery.setPhone(query.getPhone());
        }
        if (StringUtils.isNotEmpty((CharSequence)query.getOpenid())) {
            pullUserQuery.setOpenId(query.getOpenid());
        }
        CloudOperateStateVO result = CloudOperateStateVO.initSuccess();
        try {
            if (pullBlack) {
                this.wanJiForeignService.pullBlackUser(pullUserQuery);
            } else {
                this.wanJiForeignService.resumeBlackUser(pullUserQuery);
            }
        }
        catch (CloudWatchException exception) {
            result.setState(Integer.valueOf(0));
            result.setDescription("\u64cd\u4f5c\u5931\u8d25");
        }
        return result;
    }

    @Override
    public PageBaseResult<List<CloudWatchRecordVO>> queryCloudWatchRecording(PageBaseQuery<CloudManageFilterQuery> query) {
        IPage cloudClientStorePage = query.translatePageQuery();
        List<GetSelectDepByUserIdVo> storeList = this.cloudStoreService.getSelectDeptData("");
        Set storeIdList = storeList.stream().map(item -> String.valueOf(item.getId())).collect(Collectors.toSet());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (storeIdList.size() > 0) {
            queryWrapper.in(CloudClientStoreHistoryDO::getStoreId, storeIdList);
        }
        if (query.getFilter() != null && ((CloudManageFilterQuery)query.getFilter()).getState() != null) {
            queryWrapper.eq(CloudClientStoreHistoryDO::getOperateType, (Object)((CloudManageFilterQuery)query.getFilter()).getState());
        }
        IPage selectPage = this.cloudClientStoreHistoryDao.selectPage(cloudClientStorePage, (Wrapper)queryWrapper);
        ArrayList<CloudWatchRecordVO> cloudWatchRecordList = new ArrayList<CloudWatchRecordVO>();
        List cloudList = selectPage.getRecords().stream().filter(item -> CloudStoreStateEnum.STORE_WATCH_STATE.getCode().equals(item.getOperateType())).map(CloudClientStoreHistoryDO::getCloudClientStoreId).collect(Collectors.toList());
        Map<Object, Object> cloudMap = new HashMap();
        if (cloudList.size() > 0) {
            LambdaQueryWrapper clientOssQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(CloudClientOssDO::getCloudId, cloudList);
            List cloudClientOssList = this.cloudClientOssDao.selectList((Wrapper)clientOssQueryWrapper);
            cloudMap = cloudClientOssList.stream().collect(Collectors.groupingBy(CloudClientOssDO::getCloudId));
        }
        for (CloudClientStoreHistoryDO historyDO : selectPage.getRecords()) {
            CloudWatchRecordVO cloudWatchRecordVO = new CloudWatchRecordVO();
            cloudWatchRecordVO.setStoreName(historyDO.getStoreName());
            cloudWatchRecordVO.setReceptionStaffName(historyDO.getUserName());
            cloudWatchRecordVO.setTime(historyDO.getOperateTime());
            cloudWatchRecordVO.setType(historyDO.getOperateType());
            if (cloudMap.containsKey(historyDO.getCloudClientStoreId()) && CloudStoreStateEnum.STORE_WATCH_STATE.getCode().equals(historyDO.getOperateType())) {
                cloudWatchRecordVO.setImageUrl(((List)cloudMap.get(historyDO.getCloudClientStoreId())).stream().map(CloudClientOssDO::getOssUrl).filter(StringUtils::isNotEmpty).collect(Collectors.toList()));
            }
            cloudWatchRecordList.add(cloudWatchRecordVO);
        }
        PageBaseResult result = new PageBaseResult();
        result.initFromCloudManageFilterQuery(selectPage, query);
        result.setData(cloudWatchRecordList);
        return result;
    }

    @Override
    public PageBaseResult<List<CloudServiceRecordVO>> queryServiceRecording(PageBaseQuery<CloudManageFilterQuery> query) {
        Boolean isAdmin;
        this.validateParams(query);
        CloudManageFilterQuery filter = (CloudManageFilterQuery)query.getFilter();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (threadUserDTO == null || threadUserDTO.getUserData() == null) {
            throw new CloudWatchException(CloudWatchErrorCode.TOKEN_NOT_INVALID);
        }
        OvoparkUserInfoEntity userInfoEntity = threadUserDTO.getUserData().getData();
        List<Integer> depIds = null;
        if (userInfoEntity != null && userInfoEntity.getGroupId() != null && !(isAdmin = this.shopWebCommon.userIsAdmin(threadUserDTO.getToken(), userInfoEntity.getId(), userInfoEntity.getGroupId())).booleanValue() && CollectionUtils.isEmpty(depIds = this.shopWebCommon.getPrivilegeDepIdsByUserId(threadUserDTO.getToken(), userInfoEntity.getId(), userInfoEntity.getGroupId()))) {
            return null;
        }
        if (userInfoEntity.getGroupId() != null) {
            filter.setEnterpriseId(String.valueOf(userInfoEntity.getGroupId()));
        }
        filter.setDepIds(CollectionUtils.isEmpty(depIds) ? null : depIds.stream().map(item -> String.valueOf(item)).collect(Collectors.joining(",")));
        filter.setPageNumber(Long.valueOf(query.getSkip() + 1L));
        filter.setPageSize(query.getLimit());
        filter.setStartTimeStr(filter.getStartTime() == null ? "" : filter.getStartTime());
        filter.setEndTimeStr(filter.getEndTime() == null ? "" : filter.getEndTime());
        filter.setEndTime(null);
        filter.setStartTime(null);
        HttpResponseEntity responseEntity = this.watchForeignService.queryServiceRecordPost(filter);
        PageBaseResult result = new PageBaseResult();
        ArrayList<CloudServiceRecordVO> objectResult = new ArrayList<CloudServiceRecordVO>();
        if (!responseEntity.getIsError().booleanValue()) {
            OrderDetailQuery orderQuery = new OrderDetailQuery();
            orderQuery.setWdzEntId(String.valueOf(threadUserDTO.getUserData().getData().getGroupId()));
            HashSet phoneSet = new HashSet();
            HashSet openIdSet = new HashSet();
            WatchServiceRecordDTO serviceRecordList = (WatchServiceRecordDTO)responseEntity.getData();
            result.initWatchServiceRecordDTO(serviceRecordList, query);
            List records = serviceRecordList.getRecords();
            for (WatchServiceRecordInfoDTO watchServiceRecordInfoDTO : records) {
                CloudServiceRecordVO recordVO = new CloudServiceRecordVO();
                CloudServiceClientInfoVO cloudServiceClientInfoVO = CloudStoreStateVOMapper.INSTANCE.copyCloudService(watchServiceRecordInfoDTO);
                cloudServiceClientInfoVO.setWatchType(watchServiceRecordInfoDTO.getWatchType());
                cloudServiceClientInfoVO.setOrderNum(Integer.valueOf(watchServiceRecordInfoDTO.getOrders() == null ? 0 : watchServiceRecordInfoDTO.getOrders().size()));
                if (StringUtils.isEmpty((CharSequence)cloudServiceClientInfoVO.getNewStoreTime())) {
                    cloudServiceClientInfoVO.setNewStoreTime(watchServiceRecordInfoDTO.getCreateTime());
                }
                if (phoneSet.contains(watchServiceRecordInfoDTO.getPhone()) || openIdSet.contains(watchServiceRecordInfoDTO.getOpenId())) {
                    cloudServiceClientInfoVO.setPullBlack(true);
                }
                if (StringUtils.isNotEmpty((CharSequence)cloudServiceClientInfoVO.getDepartureTime())) {
                    Long setCustomerInStoreTime = TimeService.computeTime((String)cloudServiceClientInfoVO.getNewStoreTime(), (String)cloudServiceClientInfoVO.getDepartureTime());
                    cloudServiceClientInfoVO.setSetCustomerInStoreTime(setCustomerInStoreTime);
                    cloudServiceClientInfoVO.setSetCustomerInStoreTimeFormat(TimeService.formatDuration((Long)setCustomerInStoreTime));
                }
                List cloudServiceEnterStoreList = CloudServiceEnterStoreVO.fromWatchServiceRecordInfoDTO((WatchServiceRecordInfoDTO)watchServiceRecordInfoDTO);
                List clientStore = CloudServiceClientStoreVO.fromWatchServiceRecordInfoDTO((WatchServiceRecordInfoDTO)watchServiceRecordInfoDTO);
                recordVO.setClientInfo(cloudServiceClientInfoVO);
                recordVO.setEnterStore(cloudServiceEnterStoreList);
                recordVO.setClientStore(clientStore);
                objectResult.add(recordVO);
            }
            result.setData(objectResult);
        }
        return result;
    }

    private void validateParams(PageBaseQuery<CloudManageFilterQuery> query) {
        if (query.getCount() == null || !query.getCount().booleanValue()) {
            throw new CloudWatchException(CloudWatchErrorCode.INTERFACE_PAGE_ERROR);
        }
        if (query.getSkip() == null || query.getLimit() == null) {
            throw new CloudWatchException(CloudWatchErrorCode.INTERFACE_PAGE_ERROR);
        }
    }
}

