/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.ovopark.cloud.DTO.CloudStoreDTO;
import com.ovopark.cloud.DTO.NumberWanJiDTO;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.VO.CloudSaleBaseVO;
import com.ovopark.cloud.VO.CloudSaleClientVO;
import com.ovopark.cloud.VO.CloudSaleProductVO;
import com.ovopark.cloud.base.ResponseBaseParent;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.TimeService;
import com.ovopark.cloud.dao.state.CloudClientStoreDao;
import com.ovopark.cloud.entity.CloudClientStoreDO;
import com.ovopark.cloud.query.CloudRangeQuery;
import com.ovopark.cloud.query.WanJiMonthSaleQuery;
import com.ovopark.cloud.query.WanJiStoreQuery;
import com.ovopark.cloud.service.CloudSaleService;
import com.ovopark.cloud.verify.ValidationUtils;
import com.ovopark.cloud.wanji.WanJiForeignService;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudSaleServiceImpl
implements CloudSaleService {
    private static final Logger log = LoggerFactory.getLogger(CloudSaleServiceImpl.class);
    @Autowired
    private WanJiForeignService foreignService;
    @Autowired
    private CloudClientStoreDao cloudClientStoreDao;

    @Override
    public CloudSaleBaseVO selectSaleBaseInfo(CloudRangeQuery query) {
        this.validateQuery(query);
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        CloudSaleBaseVO saleBaseVO = new CloudSaleBaseVO();
        WanJiMonthSaleQuery wanJiMonthSaleQueryDTO = WanJiMonthSaleQuery.fromCloudRangeQuery((CloudRangeQuery)query);
        Future orderNum = this.foreignService.queryCloudOrder(wanJiMonthSaleQueryDTO);
        Future clientNum = this.foreignService.queryCloudClient(wanJiMonthSaleQueryDTO);
        Future saleNum = this.foreignService.queryCloudSales(wanJiMonthSaleQueryDTO);
        Future enterNum = this.foreignService.enterAmount(wanJiMonthSaleQueryDTO);
        saleBaseVO.setStoreId(query.getStoreId());
        WanJiStoreQuery storeQuery = new WanJiStoreQuery();
        storeQuery.setWdzDeptId(query.getStoreId());
        storeQuery.setWdzEntId(String.valueOf(threadUserDTO.getUserData().getData().getGroupId()));
        Future cloudStore = this.foreignService.queryStore(storeQuery);
        try {
            if (cloudStore.get() != null && ((ResponseBaseParent)cloudStore.get()).getData() != null) {
                saleBaseVO.setStoreName(((CloudStoreDTO)((ResponseBaseParent)cloudStore.get()).getData()).getName());
            }
            if (orderNum.get() != null && ((ResponseBaseParent)orderNum.get()).getData() != null) {
                saleBaseVO.setOrderNumMonth((int)((NumberWanJiDTO)((ResponseBaseParent)orderNum.get()).getData()).getNum());
            }
            if (saleNum.get() != null && ((ResponseBaseParent)saleNum.get()).getData() != null) {
                saleBaseVO.setSaleCloudMonth(((NumberWanJiDTO)((ResponseBaseParent)saleNum.get()).getData()).getNum());
            }
            if (clientNum.get() != null && ((ResponseBaseParent)clientNum.get()).getData() != null) {
                saleBaseVO.setNewClientMonth((int)((NumberWanJiDTO)((ResponseBaseParent)clientNum.get()).getData()).getNum());
            }
            if (enterNum.get() != null && ((ResponseBaseParent)enterNum.get()).getData() != null) {
                saleBaseVO.setPersonNumMonth((int)((NumberWanJiDTO)((ResponseBaseParent)enterNum.get()).getData()).getNum());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return saleBaseVO;
    }

    @Override
    public List<CloudSaleProductVO> selectSaleProduct(CloudRangeQuery query) {
        this.validateQuery(query);
        WanJiMonthSaleQuery wanJiMonthSaleQueryDTO = WanJiMonthSaleQuery.fromCloudRangeQueryTop((CloudRangeQuery)query);
        ResponseBaseParent response = this.foreignService.queryGoodsTop(wanJiMonthSaleQueryDTO);
        List responseResult = (List)response.getData();
        return CloudSaleProductVO.fromProductWanJiDTO((List)responseResult);
    }

    @Override
    public List<CloudSaleClientVO> selectSaleClient(CloudRangeQuery query) {
        this.validateQuery(query);
        WanJiMonthSaleQuery wanJiMonthSaleQuery = WanJiMonthSaleQuery.fromCloudRangeQueryTop((CloudRangeQuery)query);
        ResponseBaseParent response = this.foreignService.queryClientTop(wanJiMonthSaleQuery);
        List responseResult = (List)response.getData();
        return CloudSaleClientVO.fromClientWanJiDTO((List)responseResult);
    }

    @Override
    public void validateQuery(CloudRangeQuery query) {
        CloudClientStoreDO cloudClientStoreDO;
        ValidationUtils.verifyParams((Object)query);
        if (StringUtils.isNotEmpty((CharSequence)query.getCloudId()) && (cloudClientStoreDO = (CloudClientStoreDO)this.cloudClientStoreDao.selectById((Serializable)((Object)query.getCloudId()))) != null) {
            query.setStartDate(cloudClientStoreDO.getStartTime());
            if (StringUtils.isNotEmpty((CharSequence)cloudClientStoreDO.getEndTime())) {
                query.setEndDate(cloudClientStoreDO.getEndTime());
            } else {
                query.setEndDate(TimeService.getTime());
            }
        }
        if (StringUtils.isEmpty((CharSequence)query.getStartDate())) {
            query.setStartDate(TimeService.getDate() + " 00:00:00");
        }
        if (StringUtils.isEmpty((CharSequence)query.getEndDate())) {
            query.setEndDate(TimeService.getDate() + " 23:59:59");
        }
        if (query.getStartDate().length() < 19) {
            query.setStartDate(query.getStartDate().substring(0, 10) + " 00:00:00");
        }
        if (query.getEndDate().length() < 19) {
            query.setEndDate(query.getEndDate().substring(0, 10) + " 23:59:59");
        }
    }
}

