/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.ovopark.cloud.BO.DepartmentPojo;
import com.ovopark.cloud.BO.GetPasswordBO;
import com.ovopark.cloud.DTO.CloudStateMessageDTO;
import com.ovopark.cloud.DTO.DutyOnlineDTO;
import com.ovopark.cloud.DTO.GetDepartmentInfoDTO;
import com.ovopark.cloud.DTO.SetCloudGuardStateQuery;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.VO.CloudCheckGroupStateVO;
import com.ovopark.cloud.VO.CloudCheckStateVO;
import com.ovopark.cloud.VO.CloudDeviceGroupListVO;
import com.ovopark.cloud.VO.CloudOperateStateVO;
import com.ovopark.cloud.VO.CloudStateVO;
import com.ovopark.cloud.VO.GetDepartmentInfoVO;
import com.ovopark.cloud.VO.GetDeviceListVO;
import com.ovopark.cloud.VO.WatchPasswordListVO;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.Result;
import com.ovopark.cloud.common.TimeService;
import com.ovopark.cloud.dao.state.CloudClientEventDao;
import com.ovopark.cloud.dao.state.CloudClientOssDao;
import com.ovopark.cloud.dao.state.CloudClientStoreDao;
import com.ovopark.cloud.dao.state.CloudClientStoreHistoryDao;
import com.ovopark.cloud.dao.state.CloudStoreSettingsDao;
import com.ovopark.cloud.entity.CloudClientEventDO;
import com.ovopark.cloud.entity.CloudClientOssDO;
import com.ovopark.cloud.entity.CloudClientStoreDO;
import com.ovopark.cloud.entity.CloudClientStoreHistoryDO;
import com.ovopark.cloud.entity.CloudStoreSettingsDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.enums.CloudStoreStateEnum;
import com.ovopark.cloud.enums.CloudWatchMessageEnum;
import com.ovopark.cloud.enums.EventMsgEnum;
import com.ovopark.cloud.exception.CloudWatchErrorCode;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.cloud.mater.MasterStrokeService;
import com.ovopark.cloud.message.MessageRequestUtils;
import com.ovopark.cloud.query.CloudStateStartQuery;
import com.ovopark.cloud.query.DutyDepartmentQuery;
import com.ovopark.cloud.query.WatchPlayAudioQuery;
import com.ovopark.cloud.service.CloudDeviceService;
import com.ovopark.cloud.service.CloudStateService;
import com.ovopark.cloud.service.ShopWebService;
import com.ovopark.cloud.task.NoticeKafkaProducer;
import com.ovopark.cloud.utils.ShopWebCommon;
import com.ovopark.cloud.wanji.WanJiForeignService;
import com.ovopark.cloud.watch.WatchForeignService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudStateServiceImpl
implements CloudStateService {
    private static final Logger log = LoggerFactory.getLogger(CloudStateServiceImpl.class);
    @Autowired
    private CloudClientStoreDao cloudClientStoreDao;
    @Autowired
    private CloudClientOssDao cloudClientOssDao;
    @Autowired
    private CloudClientStoreHistoryDao historyDao;
    @Autowired
    private WanJiForeignService foreignService;
    @Autowired
    private MasterStrokeService masterStrokeService;
    @Autowired
    private WatchForeignService watchForeignService;
    @Autowired
    private CloudClientEventDao cloudClientEventDao;
    @Autowired
    private ShopWebService shopWebService;
    @Autowired
    private ShopWebCommon shopWebCommon;
    @Autowired
    private MessageRequestUtils messageRequestUtils;
    @Autowired
    private NoticeKafkaProducer noticeKafkaProducer;
    @Autowired
    private CloudDeviceService cloudDeviceService;
    @Autowired
    private CloudStoreSettingsDao cloudStoreSettingsDao;

    @Override
    public CloudStateVO startCloudWatch(CloudStateStartQuery stateStartQuery) {
        SetCloudGuardStateQuery query;
        HttpResponseEntity responseEntity;
        if (StringUtils.isEmpty((CharSequence)stateStartQuery.getStoreId()) && StringUtils.isEmpty((CharSequence)stateStartQuery.getShopId())) {
            log.error("\u6307\u5b9a\u95e8\u5e97id");
            throw new CloudWatchException(CloudWatchErrorCode.STORE_ID_NOT_EXIST);
        }
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (StringUtils.isEmpty((CharSequence)stateStartQuery.getStoreId()) && StringUtils.isNotEmpty((CharSequence)stateStartQuery.getShopId())) {
            Integer storeId = this.translateShopId(stateStartQuery.getShopId(), threadUserDTO);
            stateStartQuery.setStoreId(String.valueOf(storeId));
        }
        CloudStateVO cloudStateVO = CloudStateVO.initSuccess();
        CloudClientStoreDO cloudClientStoreDO = (CloudClientStoreDO)this.cloudClientStoreDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudClientStoreDO::getStatus, (Object)0)).eq(CloudClientStoreDO::getStoreId, (Object)stateStartQuery.getStoreId()));
        if (cloudClientStoreDO != null) {
            log.warn("\u95e8\u5e97{}\u5df2\u7ecf\u5f00\u542f\u4e91\u503c\u5b88\u4e86", (Object)stateStartQuery.getStoreId());
            throw new CloudWatchException(CloudWatchErrorCode.CURRENT_STORE_REPEAT_CLOUD_WATCH_ERROR);
        }
        HttpResponseEntity masterResult = this.masterStrokeService.switchDutyGuardStatus(stateStartQuery.getStoreId(), String.valueOf(CloudStoreStateEnum.STORE_WATCH_STATE.getCode()));
        if (masterResult.getIsError().booleanValue()) {
            log.error("{}\u8c03\u7528\u4e3b\u7ebf\u63a5\u53e3\u5931\u8d25, result:{}", (Object)stateStartQuery.getStoreId(), (Object)masterResult.toString());
            throw new CloudWatchException(CloudWatchErrorCode.MASTER_CLOUD_WATCH_STATE_FAIL);
        }
        GetPasswordBO request = new GetPasswordBO();
        request.setDepId(Integer.valueOf(stateStartQuery.getStoreId()));
        HttpResponseEntity watchResponse = this.watchForeignService.getPasswordList(null, request);
        ArrayList<Integer> doorTypes = new ArrayList<Integer>(Arrays.asList(0, 0));
        if (!watchResponse.getIsError().booleanValue()) {
            List watchPasswordList = (List)watchResponse.getData();
            for (WatchPasswordListVO watchPasswordListVO : watchPasswordList) {
                Integer doorSeq = watchPasswordListVO.getDoorSeq();
                Integer doorType = watchPasswordListVO.getDoorType();
                Integer doorLine = watchPasswordListVO.getDoorLine();
                if (doorSeq == null || doorSeq != 1 && doorSeq != 2) continue;
                int index = doorSeq - 1;
                if (doorType != null && doorType == 1) {
                    if (doorLine == null) continue;
                    if (doorLine == 2) {
                        doorTypes.set(index, 3);
                        continue;
                    }
                    if (doorLine == 4) {
                        doorTypes.set(index, 0);
                        continue;
                    }
                    if (doorLine != 5) continue;
                    doorTypes.set(index, 2);
                    continue;
                }
                if (doorType == null || doorType != 2) continue;
                doorTypes.set(index, 1);
            }
        }
        if ((responseEntity = this.watchForeignService.setCloudGuardState(query = new SetCloudGuardStateQuery("open", Integer.valueOf(stateStartQuery.getStoreId()), doorTypes))).getIsError().booleanValue()) {
            log.error("{}\u8c03\u7528\u8bbe\u5907\u901a\u77e5\u63a5\u53e3\u5931\u8d25, result:{}", (Object)stateStartQuery.getStoreId(), (Object)responseEntity.toString());
            throw new CloudWatchException(CloudWatchErrorCode.DEVICE_CLOUD_WATCH_STATE_FAIL);
        }
        CloudStateMessageDTO cloudStateMessageDTO = new CloudStateMessageDTO(Integer.valueOf(stateStartQuery.getStoreId()), "open");
        boolean result = this.noticeKafkaProducer.send(cloudStateMessageDTO);
        if (!result) {
            log.error("kafka\u901a\u77e5{}\u503c\u5b88\u7aef\u901a\u77e5\u63a5\u53e3\u5931\u8d25", (Object)stateStartQuery.getStoreId());
            throw new CloudWatchException(CloudWatchErrorCode.WATCH_KAKFA_ERROR);
        }
        Result<GetDepartmentInfoVO> departmentInfoVOResult = this.shopWebService.getDepartmentInfo(Integer.valueOf(stateStartQuery.getStoreId()));
        GetDepartmentInfoVO departmentInfoVO = (GetDepartmentInfoVO)departmentInfoVOResult.getData();
        CloudClientStoreDO storeDO = new CloudClientStoreDO();
        storeDO.setStoreId(stateStartQuery.getStoreId());
        storeDO.setUserId(String.valueOf(threadUserDTO.getUserData().getData().getId()));
        storeDO.setStatus(Integer.valueOf(0));
        storeDO.setStartTime(TimeService.getTime());
        storeDO.setRemark(stateStartQuery.getRemark());
        if (departmentInfoVO != null) {
            storeDO.setEnterpriseId(departmentInfoVO.getGroupId());
            storeDO.setDutyGuardServiceOn(departmentInfoVO.getDutyGuardServiceOn());
        }
        this.cloudClientStoreDao.insert((Object)storeDO);
        cloudStateVO.setCloudId((String)storeDO.getId());
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)storeDO.getId())) && stateStartQuery.getFile() != null && !stateStartQuery.getFile().isEmpty()) {
            ArrayList<CloudClientOssDO> picList = new ArrayList<CloudClientOssDO>();
            Sequence sequence = new Sequence();
            for (String fileUrl : stateStartQuery.getFile()) {
                CloudClientOssDO cloudClientOssDO = new CloudClientOssDO((String)storeDO.getId(), fileUrl);
                cloudClientOssDO.setId((Object)String.valueOf(sequence.nextId()));
                picList.add(cloudClientOssDO);
            }
            this.cloudClientOssDao.batchInsert(picList);
        }
        try {
            CloudClientStoreHistoryDO historyDO = new CloudClientStoreHistoryDO();
            historyDO.setCloudClientStoreId((String)storeDO.getId());
            historyDO.setOperateType(CloudStoreStateEnum.STORE_WATCH_STATE.getCode());
            historyDO.setOperateTime(TimeService.getTime());
            historyDO.setUserName(threadUserDTO.getUserData().getData().getUserName());
            historyDO.setUserId(storeDO.getUserId());
            historyDO.setStoreId(storeDO.getStoreId());
            this.historyDao.insert((Object)historyDO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Result<GetDepartmentInfoVO> getDepartmentInfo = this.shopWebService.getDepartmentInfo(Integer.valueOf(stateStartQuery.getStoreId()));
        GetDepartmentInfoVO departmentInfo = (GetDepartmentInfoVO)getDepartmentInfo.getData();
        CloudClientEventDO eventDO = new CloudClientEventDO();
        eventDO.setStoreId(Integer.valueOf(stateStartQuery.getStoreId()));
        eventDO.setUserId(threadUserDTO.getUserData().getData().getId());
        eventDO.setEventType(Integer.valueOf(EventMsgEnum.START_CLOUD_WATCH_EVENT.getType()));
        eventDO.setSource(Integer.valueOf(2));
        eventDO.setEventTime(new Date());
        eventDO.setEventContent(departmentInfo.getDepartmentName());
        this.cloudClientEventDao.insert((Object)eventDO);
        return cloudStateVO;
    }

    private Integer translateShopId(String shopId, ThreadUserDTO threadUserDTO) {
        if (threadUserDTO == null || threadUserDTO.getUserData() == null || threadUserDTO.getUserData().getData() == null) {
            log.error("\u7528\u6237\u4fe1\u606f\u7f3a\u5931");
            throw new CloudWatchException(CloudWatchErrorCode.CLIENT_INFO_NOT);
        }
        Integer groupId = threadUserDTO.getUserData().getData().getGroupId();
        HttpResponseEntity responseEntity = this.masterStrokeService.getDepartmentByShopId(groupId, shopId);
        if (responseEntity == null || responseEntity.getIsError().booleanValue()) {
            log.error("shopId:{} \u548c groupId:{}\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u5931\u8d25\uff1a{}", new Object[]{shopId, groupId, responseEntity});
            throw new CloudWatchException(CloudWatchErrorCode.STORE_QUERY_FALSE);
        }
        return ((DepartmentPojo)responseEntity.getData()).getId();
    }

    @Override
    public CloudOperateStateVO endCloudWatch(CloudStateStartQuery stateStartQuery) {
        SetCloudGuardStateQuery query;
        HttpResponseEntity responseEntity;
        if (StringUtils.isEmpty((CharSequence)stateStartQuery.getStoreId()) && StringUtils.isEmpty((CharSequence)stateStartQuery.getShopId())) {
            throw new CloudWatchException(CloudWatchErrorCode.STORE_ID_NOT_EXIST);
        }
        String storeId = stateStartQuery.getStoreId();
        String shopId = stateStartQuery.getShopId();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (StringUtils.isEmpty((CharSequence)storeId) && StringUtils.isNotEmpty((CharSequence)shopId)) {
            Integer id = this.translateShopId(shopId, threadUserDTO);
            storeId = String.valueOf(id);
        }
        CloudClientStoreDO cloudClientStoreDO = (CloudClientStoreDO)this.cloudClientStoreDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudClientStoreDO::getStatus, (Object)0)).eq(CloudClientStoreDO::getStoreId, (Object)storeId));
        CloudOperateStateVO cloudOperateStateVO = CloudOperateStateVO.initEndCloudSuccess();
        if (cloudClientStoreDO == null) {
            log.warn("\u95e8\u5e97{}\u6ca1\u6709\u6b63\u5728\u4e91\u503c\u5b88\u72b6\u6001\u4e2d", (Object)storeId);
            throw new CloudWatchException(CloudWatchErrorCode.CURRENT_STORE_CLOUD_WATCH_ERROR);
        }
        HttpResponseEntity masterResult = this.masterStrokeService.switchDutyGuardStatus(storeId, String.valueOf(CloudStoreStateEnum.STORE_OPEN_STATE.getCode()));
        if (masterResult.getIsError().booleanValue()) {
            log.warn("{}\u8c03\u7528\u4e3b\u7ebf\u901a\u77e5\u63a5\u53e3\u5931\u8d25, result:{}", (Object)storeId, (Object)masterResult.toString());
            throw new CloudWatchException(CloudWatchErrorCode.MASTER_CLOUD_WATCH_STATE_FAIL);
        }
        GetPasswordBO request = new GetPasswordBO();
        request.setDepId(Integer.valueOf(stateStartQuery.getStoreId()));
        HttpResponseEntity watchResponse = this.watchForeignService.getPasswordList(null, request);
        ArrayList<Integer> doorTypes = new ArrayList<Integer>(Arrays.asList(0, 0));
        if (!watchResponse.getIsError().booleanValue()) {
            List watchPasswordList = (List)watchResponse.getData();
            for (WatchPasswordListVO watchPasswordListVO : watchPasswordList) {
                Integer doorSeq = watchPasswordListVO.getDoorSeq();
                Integer doorType = watchPasswordListVO.getDoorType();
                Integer doorLine = watchPasswordListVO.getDoorLine();
                if (doorSeq == null || doorSeq != 1 && doorSeq != 2) continue;
                int index = doorSeq - 1;
                if (doorType != null && doorType == 1) {
                    if (doorLine == null) continue;
                    if (doorLine == 2) {
                        doorTypes.set(index, 3);
                        continue;
                    }
                    if (doorLine == 4) {
                        doorTypes.set(index, 0);
                        continue;
                    }
                    if (doorLine != 5) continue;
                    doorTypes.set(index, 2);
                    continue;
                }
                if (doorType == null || doorType != 2) continue;
                doorTypes.set(index, 1);
            }
        }
        if ((responseEntity = this.watchForeignService.setCloudGuardState(query = new SetCloudGuardStateQuery("close", Integer.valueOf(stateStartQuery.getStoreId()), doorTypes))).getIsError().booleanValue()) {
            log.warn("{}\u8c03\u7528\u8bbe\u5907\u901a\u77e5\u63a5\u53e3\u5931\u8d25, result:{}", (Object)storeId, (Object)responseEntity.toString());
            throw new CloudWatchException(CloudWatchErrorCode.DEVICE_CLOUD_WATCH_STATE_FAIL);
        }
        CloudStateMessageDTO cloudStateMessageDTO = new CloudStateMessageDTO(Integer.valueOf(storeId), "close");
        boolean result = this.noticeKafkaProducer.send(cloudStateMessageDTO);
        if (!result) {
            log.warn("kafka\u901a\u77e5{}\u503c\u5b88\u7aef\u901a\u77e5\u63a5\u53e3\u5931\u8d25", (Object)storeId);
            throw new CloudWatchException(CloudWatchErrorCode.WATCH_KAKFA_ERROR);
        }
        cloudClientStoreDO.setEndTime(TimeService.getTime());
        cloudClientStoreDO.setWatchTime(TimeService.computeTime((String)cloudClientStoreDO.getStartTime(), (String)cloudClientStoreDO.getEndTime()));
        cloudClientStoreDO.setStatus(Integer.valueOf(1));
        this.cloudClientStoreDao.updateById((Object)cloudClientStoreDO);
        try {
            CloudClientStoreHistoryDO historyDO = new CloudClientStoreHistoryDO();
            historyDO.setCloudClientStoreId((String)cloudClientStoreDO.getId());
            historyDO.setOperateType(CloudStoreStateEnum.STORE_OPEN_STATE.getCode());
            historyDO.setOperateTime(TimeService.getTime());
            historyDO.setUserName(threadUserDTO.getUserData().getData().getUserName());
            historyDO.setUserId(String.valueOf(threadUserDTO.getUserData().getData().getId()));
            historyDO.setStoreId(storeId);
            this.historyDao.insert((Object)historyDO);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Result<GetDepartmentInfoVO> getDepartmentInfo = this.shopWebService.getDepartmentInfo(Integer.valueOf(storeId));
        GetDepartmentInfoVO departmentInfo = (GetDepartmentInfoVO)getDepartmentInfo.getData();
        CloudClientEventDO eventDO = new CloudClientEventDO();
        eventDO.setStoreId(Integer.valueOf(storeId));
        eventDO.setUserId(threadUserDTO.getUserData().getData().getId());
        eventDO.setEventType(Integer.valueOf(EventMsgEnum.END_CLOUD_WATCH_EVENT.getType()));
        eventDO.setSource(Integer.valueOf(2));
        eventDO.setEventTime(new Date());
        eventDO.setEventContent(departmentInfo.getDepartmentName());
        this.cloudClientEventDao.insert((Object)eventDO);
        if (cloudClientStoreDO.getWatchTime() > 120L) {
            try {
                this.sendMessage(departmentInfo, (String)cloudClientStoreDO.getId(), cloudClientStoreDO);
            }
            catch (Exception exception) {
                log.error("\u6d88\u606f\u53d1\u9001\u5f02\u5e38", (Throwable)exception);
            }
        }
        return cloudOperateStateVO;
    }

    public void sendMessage(GetDepartmentInfoVO departmentInfo, String id, CloudClientStoreDO cloudedInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u60a8\u7684\u95e8\u5e97\u3010");
        stringBuilder.append(departmentInfo.getDepartmentName());
        stringBuilder.append("\u3011\u5728");
        stringBuilder.append(cloudedInfo.getStartTime()).append("~");
        stringBuilder.append(cloudedInfo.getEndTime()).append("\u7684\u5b88\u5e97\u62a5\u544a\u5df2\u7ecf\u751f\u6210\uff0c\u70b9\u51fb\u67e5\u770b\u3002");
        List<Integer> toUserIdList = Collections.singletonList(departmentInfo.getShopOwnerId());
        String msgId = this.messageRequestUtils.sendMessage(stringBuilder.toString(), toUserIdList, params, departmentInfo.getGroupId(), CloudWatchMessageEnum.NOTIFY.getTitle(), CloudWatchMessageEnum.NOTIFY.getCode(), Integer.valueOf(CloudWatchMessageEnum.NOTIFY.getType()));
        log.info("\u6d88\u606f\u53d1\u9001\u6210\u529f,msgId:{}", (Object)msgId);
    }

    @Override
    public CloudCheckStateVO checkCloudCustomer(Integer storeId, String shopId) {
        DutyDepartmentQuery request = new DutyDepartmentQuery();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        HttpResponseEntity responseEntity = this.watchForeignService.onlineUsers(threadUserDTO.getToken(), request);
        if (responseEntity.getIsError().booleanValue()) {
            throw new CloudWatchException(CloudWatchErrorCode.CLOUD_WATCH_CUSTOMER_FAIL);
        }
        DutyOnlineDTO dutyOnline = (DutyOnlineDTO)responseEntity.getData();
        if (dutyOnline.isOnline()) {
            return new CloudCheckStateVO(true, "\u6210\u529f");
        }
        return new CloudCheckStateVO(false, CloudWatchErrorCode.CLOUD_WATCH_CUSTOMER_NOT_EXIST.getErrorText(), Integer.valueOf(CloudWatchErrorCode.CLOUD_WATCH_CUSTOMER_NOT_EXIST.getErrorCode()));
    }

    @Override
    public List<CloudCheckGroupStateVO> checkCloudDevice(Integer storeId, String shopId) {
        List<CloudDeviceGroupListVO> deviceList;
        if (storeId == null && StringUtils.isEmpty((CharSequence)shopId)) {
            log.error("\u6307\u5b9a\u95e8\u5e97id");
            throw new CloudWatchException(CloudWatchErrorCode.STORE_ID_NOT_EXIST);
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            throw new CloudWatchException(CloudWatchErrorCode.TOKEN_NOT_EXIST);
        }
        if (storeId == null && StringUtils.isNotEmpty((CharSequence)shopId)) {
            storeId = this.translateShopId(shopId, userInfo);
        }
        if ((deviceList = this.cloudDeviceService.getGroupDeviceList(storeId)) == null || deviceList.isEmpty()) {
            throw new CloudWatchException(CloudWatchErrorCode.BIND_DEVICE);
        }
        ArrayList<CloudCheckGroupStateVO> result = new ArrayList<CloudCheckGroupStateVO>();
        for (CloudDeviceGroupListVO device : deviceList) {
            List deviceGroupList = device.getDeviceList();
            CloudCheckGroupStateVO cloudCheckGroupStateVO = new CloudCheckGroupStateVO();
            cloudCheckGroupStateVO.setGroupName(device.getGroupName());
            ArrayList<CloudCheckStateVO> checkState = new ArrayList<CloudCheckStateVO>();
            for (GetDeviceListVO deviceVO : deviceGroupList) {
                CloudCheckStateVO cloudCheckStateVO = new CloudCheckStateVO();
                cloudCheckStateVO.setTitle(deviceVO.getName());
                cloudCheckStateVO.setDType(deviceVO.getDType());
                cloudCheckStateVO.setDeviceId(deviceVO.getVoiceNo());
                if (deviceVO.getIsOnline() == 1) {
                    cloudCheckStateVO.setSuccess(true);
                    cloudCheckStateVO.setMessage("\u6b63\u5e38");
                } else {
                    cloudCheckStateVO.setSuccess(false);
                    cloudCheckStateVO.setMessage("\u6545\u969c");
                }
                checkState.add(cloudCheckStateVO);
            }
            cloudCheckGroupStateVO.setDeviceList(checkState);
            result.add(cloudCheckGroupStateVO);
        }
        return result;
    }

    @Override
    public CloudStateVO getStoreCloudState(Integer storeId) {
        CloudClientStoreDO cloudClientStoreDO = (CloudClientStoreDO)this.cloudClientStoreDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudClientStoreDO::getStatus, (Object)0)).eq(CloudClientStoreDO::getStoreId, (Object)storeId));
        CloudStateVO cloudStateVO = new CloudStateVO();
        if (cloudClientStoreDO != null) {
            cloudStateVO.setCloudId((String)cloudClientStoreDO.getId());
            cloudStateVO.setState(cloudClientStoreDO.getStatus());
            cloudStateVO.setDescription(cloudClientStoreDO.getRemark());
        } else {
            cloudStateVO.setState(Integer.valueOf(1));
        }
        return cloudStateVO;
    }

    @Override
    public CloudCheckStateVO checkCloudStore(Integer storeId, String shopId) {
        CloudStoreSettingsDO cloudStoreSettings;
        if (storeId == null && StringUtils.isEmpty((CharSequence)shopId)) {
            log.error("\u6307\u5b9a\u95e8\u5e97id");
            throw new CloudWatchException(CloudWatchErrorCode.STORE_ID_NOT_EXIST);
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            throw new CloudWatchException(CloudWatchErrorCode.TOKEN_NOT_EXIST);
        }
        if (storeId == null && StringUtils.isNotEmpty((CharSequence)shopId)) {
            storeId = this.translateShopId(shopId, userInfo);
        }
        CloudCheckStateVO cloudCheckState = new CloudCheckStateVO();
        Result<GetDepartmentInfoVO> result = this.shopWebService.getDepartmentInfo(storeId);
        GetDepartmentInfoVO departmentInfo = (GetDepartmentInfoVO)result.getData();
        if (StringUtils.isEmpty((CharSequence)departmentInfo.getIdNo())) {
            cloudCheckState.setSuccess(false);
            cloudCheckState.setCode(Integer.valueOf(CloudWatchErrorCode.LACK_NO_ERROR.getErrorCode()));
            cloudCheckState.setTitle("\u8bf7\u5b8c\u5584\u95e8\u5e97\u4fe1\u606f");
            cloudCheckState.setMessage(CloudWatchErrorCode.LACK_NO_ERROR.getErrorText());
        } else if (StringUtils.isEmpty((CharSequence)departmentInfo.getLicensePic())) {
            cloudCheckState.setSuccess(false);
            cloudCheckState.setCode(Integer.valueOf(CloudWatchErrorCode.LACK_LICENSE_ERROR.getErrorCode()));
            cloudCheckState.setTitle("\u8bf7\u5b8c\u5584\u95e8\u5e97\u4fe1\u606f");
            cloudCheckState.setMessage(CloudWatchErrorCode.LACK_LICENSE_ERROR.getErrorText());
        } else {
            cloudCheckState.setSuccess(true);
            cloudCheckState.setTitle("\u95e8\u5e97\u4fe1\u606f\u5b8c\u5584");
            cloudCheckState.setMessage("\u901a\u8fc7");
        }
        CloudOperateStateVO cloudOperateStateVO = this.checkDepartmentPermission(storeId);
        if (cloudOperateStateVO.getState() == 0) {
            cloudCheckState.setSuccess(false);
            cloudCheckState.setCode(Integer.valueOf(CloudWatchErrorCode.NO_PERMISSION_ERROR.getErrorCode()));
            cloudCheckState.setTitle("\u65e0\u4e91\u503c\u5b88\u6743\u9650");
            cloudCheckState.setMessage(CloudWatchErrorCode.NO_PERMISSION_ERROR.getErrorText());
        }
        if ((cloudStoreSettings = (CloudStoreSettingsDO)this.cloudStoreSettingsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreSettingsDO::getStoreId, (Object)storeId))) != null && cloudStoreSettings.getDoorCheckStatus() == 0) {
            return cloudCheckState;
        }
        Result<List<GetDeviceListVO>> deviceListResult = this.shopWebService.getDeviceList(storeId);
        if (deviceListResult == null || deviceListResult.getData() == null) {
            throw new CloudWatchException(CloudWatchErrorCode.DEVICE_INFO_FAIL);
        }
        List deviceList = (List)deviceListResult.getData();
        deviceList = deviceList.stream().filter(device -> device.getDType() == 302).collect(Collectors.toList());
        for (GetDeviceListVO device2 : deviceList) {
            if (device2.getInQRStatus() != 0 && device2.getOutQRStatus() != 0) continue;
            cloudCheckState.setSuccess(false);
            cloudCheckState.setCode(Integer.valueOf(CloudWatchErrorCode.DEVICE_DOOR_NOT_BIND_ERROR.getErrorCode()));
            cloudCheckState.setTitle("\u95e8\u7981\u7ed1\u5b9a\u5931\u8d25");
            cloudCheckState.setMessage(CloudWatchErrorCode.DEVICE_DOOR_NOT_BIND_ERROR.getErrorText());
        }
        return cloudCheckState;
    }

    @Override
    public CloudCheckStateVO checkDeviceVoice(Integer deviceId, Integer depId) {
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (deviceId == null) {
            throw new CloudWatchException(CloudWatchErrorCode.DEVICE_ID_NOT_ONLINE);
        }
        WatchPlayAudioQuery request = new WatchPlayAudioQuery();
        request.setAudio_cards(Collections.singletonList(deviceId));
        request.setDepId(depId);
        if (deviceId == 1) {
            request.setUrl("http://ovopark-oss-default.oss-cn-hangzhou.aliyuncs.com/cloud-watch/211/2025/06/10/indoor.mp3");
        } else if (deviceId == 0) {
            request.setUrl("http://ovopark-oss-default.oss-cn-hangzhou.aliyuncs.com/cloud-watch/211/2025/06/10/outdoor.mp3");
        } else {
            throw new CloudWatchException(CloudWatchErrorCode.INDOOR_OUTDOOR_ERROR);
        }
        HttpResponseEntity responseEntity = this.watchForeignService.cloudWatchPlayAudio(threadUserDTO.getToken(), request);
        if (responseEntity.getIsError().booleanValue()) {
            return new CloudCheckStateVO(false, CloudWatchErrorCode.CLOUD_WATCH_PLAY_AUDIO_ERROR.getErrorText(), Integer.valueOf(CloudWatchErrorCode.CLOUD_WATCH_PLAY_AUDIO_ERROR.getErrorCode()));
        }
        return new CloudCheckStateVO(true, "\u6210\u529f", null);
    }

    @Override
    public CloudOperateStateVO checkDepartmentPermission(Integer storeId) {
        if (storeId == null) {
            throw new CloudWatchException(CloudWatchErrorCode.STORE_ID_NOT_EXIST);
        }
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        HttpResponseEntity responseEntity = this.masterStrokeService.getDepartmentInfoById(threadUserDTO.getToken(), storeId);
        if (responseEntity.getIsError().booleanValue()) {
            log.error("\u83b7\u53d6\u95e8\u5e97{}\u4fe1\u606f\u5931\u8d25", (Object)storeId);
            throw new CloudWatchException(CloudWatchErrorCode.MASTER_STORE_INFO_ERROR);
        }
        GetDepartmentInfoDTO departmentInfo = (GetDepartmentInfoDTO)responseEntity.getData();
        CloudOperateStateVO cloudOperateStateVO = new CloudOperateStateVO();
        if (departmentInfo != null && departmentInfo.getDutyGuardServiceOn() != null && departmentInfo.getDutyGuardServiceOn() > 0) {
            cloudOperateStateVO.setState(Integer.valueOf(1));
            cloudOperateStateVO.setDescription("\u95e8\u5e97\u5df2\u6709\u6743\u9650");
        } else {
            cloudOperateStateVO.setState(Integer.valueOf(0));
            cloudOperateStateVO.setDescription("\u95e8\u5e97\u65e0\u6743\u9650");
        }
        return cloudOperateStateVO;
    }

    @Override
    public CloudStateVO startCheckCloudWatch(CloudStateStartQuery stateStartQuery) {
        if (StringUtils.isEmpty((CharSequence)stateStartQuery.getStoreId()) && StringUtils.isEmpty((CharSequence)stateStartQuery.getShopId())) {
            log.error("\u6307\u5b9a\u95e8\u5e97id");
            throw new CloudWatchException(CloudWatchErrorCode.STORE_ID_NOT_EXIST);
        }
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (StringUtils.isEmpty((CharSequence)stateStartQuery.getStoreId()) && StringUtils.isNotEmpty((CharSequence)stateStartQuery.getShopId())) {
            Integer storeId = this.translateShopId(stateStartQuery.getShopId(), threadUserDTO);
            stateStartQuery.setStoreId(String.valueOf(storeId));
        }
        log.info("\u5f00\u59cb\u68c0\u67e5\u95e8\u5e97{}\u4e91\u503c\u5b88\u6743\u9650", (Object)stateStartQuery.getStoreId());
        CloudCheckStateVO storeOperate = this.checkCloudStore(Integer.valueOf(stateStartQuery.getStoreId()), stateStartQuery.getShopId());
        if (!storeOperate.isSuccess()) {
            log.error("\u95e8\u5e97{}\u65e0\u6743\u9650", (Object)stateStartQuery.getStoreId());
            throw new CloudWatchException(storeOperate.getCode().intValue(), storeOperate.getMessage());
        }
        CloudCheckStateVO checkCustomer = this.checkCloudCustomer(Integer.valueOf(stateStartQuery.getStoreId()), stateStartQuery.getShopId());
        if (!checkCustomer.isSuccess()) {
            log.error("\u95e8\u5e97{}\u65e0\u503c\u5b88\u4eba\u5458", (Object)stateStartQuery.getStoreId());
            throw new CloudWatchException(checkCustomer.getCode().intValue(), checkCustomer.getMessage());
        }
        List<CloudCheckGroupStateVO> deviceList = this.checkCloudDevice(Integer.valueOf(stateStartQuery.getStoreId()), stateStartQuery.getShopId());
        for (CloudCheckGroupStateVO device : deviceList) {
            List deviceGroup = device.getDeviceList();
            for (CloudCheckStateVO deviceState : deviceGroup) {
                if (deviceState.isSuccess()) continue;
                log.error("\u95e8\u5e97{}\u8bbe\u5907{}\u79bb\u7ebf", (Object)stateStartQuery.getStoreId(), (Object)deviceState.getTitle());
                throw new CloudWatchException(CloudWatchErrorCode.STORE_DEVICE_OFFLINE);
            }
        }
        log.info("\u95e8\u5e97{}\u4e91\u503c\u5b88\u6743\u9650\u68c0\u67e5\u5b8c\u6210", (Object)stateStartQuery.getStoreId());
        return this.startCloudWatch(stateStartQuery);
    }

    @Override
    public CloudStateVO getStoreShopCloudState(Integer storeId, String shopId) {
        if (storeId == null && StringUtils.isEmpty((CharSequence)shopId)) {
            log.error("\u6307\u5b9a\u95e8\u5e97id");
            throw new CloudWatchException(CloudWatchErrorCode.STORE_ID_NOT_EXIST);
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            throw new CloudWatchException(CloudWatchErrorCode.TOKEN_NOT_EXIST);
        }
        if (storeId == null && StringUtils.isNotEmpty((CharSequence)shopId)) {
            storeId = this.translateShopId(shopId, userInfo);
        }
        return this.getStoreCloudState(storeId);
    }

    @Override
    public boolean checkCloudStoreInfo(Integer storeId, String shopId) {
        Result<GetDepartmentInfoVO> result;
        GetDepartmentInfoVO departmentInfo;
        if (storeId == null && StringUtils.isEmpty((CharSequence)shopId)) {
            log.error("\u6307\u5b9a\u95e8\u5e97id");
            throw new CloudWatchException(CloudWatchErrorCode.STORE_ID_NOT_EXIST);
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            throw new CloudWatchException(CloudWatchErrorCode.TOKEN_NOT_EXIST);
        }
        if (storeId == null && StringUtils.isNotEmpty((CharSequence)shopId)) {
            storeId = this.translateShopId(shopId, userInfo);
        }
        if (StringUtils.isEmpty((CharSequence)(departmentInfo = (GetDepartmentInfoVO)(result = this.shopWebService.getDepartmentInfo(storeId)).getData()).getIdNo()) || StringUtils.isEmpty((CharSequence)departmentInfo.getLicensePic())) {
            throw new CloudWatchException(CloudWatchErrorCode.LACK_NO_ERROR);
        }
        return true;
    }
}

