/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.ovopark.cloud.BO.CloudClientStoreBO;
import com.ovopark.cloud.BO.EnterpriseConfigPojo;
import com.ovopark.cloud.BO.GoodsOrderInfoBO;
import com.ovopark.cloud.BO.UsersPojo;
import com.ovopark.cloud.DTO.CloudWatchStoreNumDTO;
import com.ovopark.cloud.DTO.DepDutyStatisticDTO;
import com.ovopark.cloud.DTO.GetDepartmentInfoDTO;
import com.ovopark.cloud.DTO.GetOrderStatisticsInfoBatchDTO;
import com.ovopark.cloud.DTO.GetOrderStatisticsInfoDTO;
import com.ovopark.cloud.DTO.JobRecordDTO;
import com.ovopark.cloud.DTO.MasterStoreInfo;
import com.ovopark.cloud.DTO.RecordEnterStoreSummary;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.DTO.WatchRecordEnterStoreDTO;
import com.ovopark.cloud.DTO.WatchServiceRecordDTO;
import com.ovopark.cloud.DTO.WatchServiceRecordInfoDTO;
import com.ovopark.cloud.DTO.YibaoAuthDTO;
import com.ovopark.cloud.VO.CloudEventRecordVO;
import com.ovopark.cloud.VO.CloudPaymentContractVO;
import com.ovopark.cloud.VO.CloudPlatformWatchOrderVO;
import com.ovopark.cloud.VO.CloudPlatformWatchRecordVO;
import com.ovopark.cloud.VO.CloudStoreCrmContractVO;
import com.ovopark.cloud.VO.CloudStoreDoorVO;
import com.ovopark.cloud.VO.CloudStoreInsuranceVO;
import com.ovopark.cloud.VO.CloudStoreOverviewVO;
import com.ovopark.cloud.VO.CloudStorePermissionVO;
import com.ovopark.cloud.VO.CloudStoreSettingsVO;
import com.ovopark.cloud.VO.CloudStoreSignVO;
import com.ovopark.cloud.VO.CloudStoreStateVO;
import com.ovopark.cloud.VO.CloudWatchOrderNumVO;
import com.ovopark.cloud.VO.CloudWatchStoreServiceVO;
import com.ovopark.cloud.VO.CustomersTop10VO;
import com.ovopark.cloud.VO.GetDepartmentInfoVO;
import com.ovopark.cloud.VO.GetPeopleComeInfoVO;
import com.ovopark.cloud.VO.GetSelectDepByUserIdVo;
import com.ovopark.cloud.VO.MasterDepartmentWatchVO;
import com.ovopark.cloud.VO.NewQueryOrderVO;
import com.ovopark.cloud.VO.OrderStatisticsVO;
import com.ovopark.cloud.VO.OvoparkUserInfoEntity;
import com.ovopark.cloud.VO.QueryKeepStoreRecordDetailVO;
import com.ovopark.cloud.VO.YzsDeviceFeignVo;
import com.ovopark.cloud.base.IdEntity;
import com.ovopark.cloud.base.IdNumEntity;
import com.ovopark.cloud.base.PageBaseQuery;
import com.ovopark.cloud.base.PageBaseResult;
import com.ovopark.cloud.base.PageInfo;
import com.ovopark.cloud.base.ResponseBaseParent;
import com.ovopark.cloud.base.WanjiResponse;
import com.ovopark.cloud.cache.redis.RedisClient;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.Result;
import com.ovopark.cloud.common.ResultUtil;
import com.ovopark.cloud.common.TimeService;
import com.ovopark.cloud.common.ToolCommon;
import com.ovopark.cloud.dao.state.CloudClientEventDao;
import com.ovopark.cloud.dao.state.CloudClientStoreDao;
import com.ovopark.cloud.dao.state.CloudClientStoreRelationDao;
import com.ovopark.cloud.dao.state.CloudDeviceIpcSignDao;
import com.ovopark.cloud.dao.state.CloudSearchDepartmentsDao;
import com.ovopark.cloud.dao.state.CloudStoreContractDao;
import com.ovopark.cloud.dao.state.CloudStoreInsuranceDao;
import com.ovopark.cloud.dao.state.CloudStoreSettingsDao;
import com.ovopark.cloud.dao.state.PlatformDepartmentsApprovalDao;
import com.ovopark.cloud.entity.CloudClientEventDO;
import com.ovopark.cloud.entity.CloudClientStoreDO;
import com.ovopark.cloud.entity.CloudClientStoreRelationDO;
import com.ovopark.cloud.entity.CloudDeviceIpcSignDO;
import com.ovopark.cloud.entity.CloudSearchDepartmentsDO;
import com.ovopark.cloud.entity.CloudStoreContractDO;
import com.ovopark.cloud.entity.CloudStoreInsuranceDO;
import com.ovopark.cloud.entity.CloudStoreSettingsDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.entity.PlatformDepartmentApprovalDO;
import com.ovopark.cloud.enums.CategoryEnum;
import com.ovopark.cloud.enums.CloudStoreStateEnum;
import com.ovopark.cloud.enums.CloudWatchStateEnum;
import com.ovopark.cloud.enums.EventMsgEnum;
import com.ovopark.cloud.exception.CloudWatchErrorCode;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.cloud.map.CloudStoreStateVOMapper;
import com.ovopark.cloud.mater.MasterStrokeService;
import com.ovopark.cloud.query.CloudDutyPlatformQuery;
import com.ovopark.cloud.query.CloudOrderPlatformQuery;
import com.ovopark.cloud.query.CloudRangeQuery;
import com.ovopark.cloud.query.CloudStorePermissionQuery;
import com.ovopark.cloud.query.CloudStoreRecordQuery;
import com.ovopark.cloud.query.CloudWatchStoreQuery;
import com.ovopark.cloud.query.DepQuery;
import com.ovopark.cloud.query.DutyDepartmentQuery;
import com.ovopark.cloud.query.GetOrderListQuery;
import com.ovopark.cloud.query.GetOrderStatisticsInfoBatchQuery;
import com.ovopark.cloud.query.GetPeopleComeInfoQuery;
import com.ovopark.cloud.query.NewQueryOrderQuery;
import com.ovopark.cloud.service.CloudForeignService;
import com.ovopark.cloud.service.CloudSaleService;
import com.ovopark.cloud.service.CloudStoreService;
import com.ovopark.cloud.utils.Common;
import com.ovopark.cloud.utils.OrderCommon;
import com.ovopark.cloud.utils.ShopWebCommon;
import com.ovopark.cloud.wanji.NewWanJiOrderForeignService;
import com.ovopark.cloud.wanji.WanJiOrderForeignService;
import com.ovopark.cloud.watch.WatchForeignService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CloudStoreServiceImpl
implements CloudStoreService {
    private static final Logger log = LoggerFactory.getLogger(CloudStoreServiceImpl.class);
    @Autowired
    private CloudClientStoreRelationDao cloudClientStoreRelationDao;
    @Autowired
    private CloudClientStoreDao cloudClientStoreDao;
    @Autowired
    private MasterStrokeService masterStrokeService;
    @Autowired
    private CloudSaleService cloudSaleService;
    @Autowired
    private CloudClientEventDao cloudClientEventDao;
    @Autowired
    private WanJiOrderForeignService wanJiOrderForeignService;
    @Autowired
    private WatchForeignService watchForeignService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private ShopWebCommon shopWebCommon;
    @Autowired
    private OrderCommon orderCommon;
    @Autowired
    private CloudSearchDepartmentsDao cloudSearchDepartmentsDao;
    @Autowired
    private PlatformDepartmentsApprovalDao platformDepartmentsApprovalDao;
    @Autowired(required=false)
    private NewWanJiOrderForeignService newWanJiOrderForeignService;
    @Autowired(required=false)
    private Common common;
    @Autowired
    private CloudStoreInsuranceDao cloudStoreInsuranceDao;
    @Autowired
    private CloudDeviceIpcSignDao cloudDeviceIpcSignDao;
    @Autowired
    private CloudStoreSettingsDao cloudStoreSettingsDao;
    @Autowired
    private CloudForeignService cloudForeignService;
    @Autowired
    private CloudStoreContractDao cloudStoreContractDao;

    @Override
    public List<CloudStoreStateVO> fetchAllStoreState() {
        List<Object> storeList = this.getSelectDeptData("");
        List<Object> result = new ArrayList<CloudStoreStateVO>();
        if (storeList.size() > 0 && (storeList = storeList.stream().filter(item -> 1 == item.getOpenStatus()).collect(Collectors.toList())).size() > 0) {
            result = CloudStoreStateVOMapper.INSTANCE.copyStoreStateList(storeList);
            result = this.encapsulateData(result);
        }
        return result;
    }

    @Override
    public List<GetSelectDepByUserIdVo> getSelectDeptData(String depName) {
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        OvoparkUserInfoEntity userData = threadUserDTO.getUserData().getData();
        String groupId = userData.getGroupId() == null ? "" : userData.getGroupId().toString();
        HttpResponseEntity selectDepByUserId = this.masterStrokeService.getDepartmentsByWatch(Integer.valueOf(1), Integer.valueOf(10000), groupId, Integer.valueOf(2));
        if (selectDepByUserId.getIsError().booleanValue()) {
            throw new CloudWatchException(CloudWatchErrorCode.STORE_QUERY_FALSE);
        }
        ArrayList<GetSelectDepByUserIdVo> storeList = ((MasterDepartmentWatchVO)selectDepByUserId.getData()).getRecords();
        if (StringUtils.isNotEmpty((CharSequence)depName)) {
            storeList = CollectionUtils.isEmpty((Collection)storeList) ? new ArrayList<GetSelectDepByUserIdVo>() : storeList.stream().filter(m -> m.getName().contains(depName)).collect(Collectors.toList());
        }
        storeList = CollectionUtils.isEmpty((Collection)storeList) ? new ArrayList() : storeList.stream().limit(100L).collect(Collectors.toList());
        return storeList;
    }

    @Override
    public CloudStoreStateVO fetchDefaultStoreState() {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        Integer storeId = null;
        CloudClientStoreRelationDO cloudClientStoreRelationDO = this.cloudClientStoreRelationDao.selectNewStore(userInfo.getUserData().getData().getId(), null);
        if (cloudClientStoreRelationDO != null) {
            storeId = Integer.valueOf(cloudClientStoreRelationDO.getStoreId());
        } else {
            List<CloudStoreStateVO> allStore = this.fetchAllStoreState();
            Integer n = storeId = !allStore.isEmpty() ? allStore.get(0).getStoreId() : null;
        }
        if (storeId == null) {
            throw new CloudWatchException("\u65e0\u95e8\u5e97");
        }
        CloudStoreStateVO result = new CloudStoreStateVO();
        GetDepartmentInfoVO departmentInfo = this.shopWebCommon.getDepartmentInfo(userInfo.getToken(), storeId);
        result.setStoreId(storeId);
        result.setStoreName(departmentInfo.getDepartmentName());
        result.setImageUrl(departmentInfo.getShopPic());
        result.setBusinessCategory(departmentInfo.getBusinessCategory());
        CloudClientStoreDO cloudClientStore = (CloudClientStoreDO)this.cloudClientStoreDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudClientStoreDO::getStoreId, (Object)storeId)).eq(CloudClientStoreDO::getStatus, (Object)CloudWatchStateEnum.STORE_WATCH_STATE.getCode()));
        if (cloudClientStore != null) {
            result.setStoreStateCode(cloudClientStore.getStatus());
            result.setStoreState(CloudWatchStateEnum.translateWanJiStoreState((int)cloudClientStore.getStatus()));
            result.setCloudId((String)cloudClientStore.getId());
        } else {
            result.setStoreStateCode(CloudWatchStateEnum.STORE_CANCEL_STATE.getCode());
            result.setStoreState(CloudWatchStateEnum.STORE_CANCEL_STATE.getName());
        }
        return result;
    }

    @Override
    public PageBaseResult<List<CloudPlatformWatchRecordVO>> getWatchStoreHistory(PageBaseQuery<CloudDutyPlatformQuery> query) {
        IPage cloudClientStorePage = query.translatePageQuery();
        List<Object> depIds = new ArrayList();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        OvoparkUserInfoEntity userData = threadUserDTO.getUserData().getData();
        if (userData != null && userData.getGroupId() != null) {
            ((CloudDutyPlatformQuery)query.getFilter()).setEnterpriseId(userData.getGroupId());
            Boolean isAdmin = this.shopWebCommon.userIsAdmin(threadUserDTO.getToken(), userData.getId(), userData.getGroupId());
            if (!isAdmin.booleanValue() && CollectionUtils.isEmpty(depIds = this.shopWebCommon.getPrivilegeDepIdsByUserId(threadUserDTO.getToken(), userData.getId(), userData.getGroupId()))) {
                PageBaseResult result = new PageBaseResult();
                result.setData(new ArrayList());
                return result;
            }
        }
        if (userData != null && userData.getGroupId() == null && ((CloudDutyPlatformQuery)query.getFilter()).getEnterpriseId() != null) {
            HttpResponseEntity selectDepByUserId = this.masterStrokeService.getSelectDepByUserId(threadUserDTO.getToken(), ((CloudDutyPlatformQuery)query.getFilter()).getEnterpriseId(), userData.getId(), StringUtils.isEmpty((CharSequence)((CloudDutyPlatformQuery)query.getFilter()).getDepName()) ? "" : ((CloudDutyPlatformQuery)query.getFilter()).getDepName());
            if (!selectDepByUserId.getIsError().booleanValue() && selectDepByUserId.getData() != null) {
                depIds = ((List)selectDepByUserId.getData()).stream().map(GetSelectDepByUserIdVo::getId).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(depIds)) {
                PageBaseResult result = new PageBaseResult();
                result.setData(new ArrayList());
                return result;
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (depIds.size() > 0) {
            queryWrapper.in(CloudClientStoreDO::getStoreId, depIds);
        }
        if (((CloudDutyPlatformQuery)query.getFilter()).getEnterpriseId() != null) {
            queryWrapper.eq(CloudClientStoreDO::getEnterpriseId, (Object)((CloudDutyPlatformQuery)query.getFilter()).getEnterpriseId());
        }
        queryWrapper.eq(((CloudDutyPlatformQuery)query.getFilter()).getDutyGuardServiceOn() != null, CloudClientStoreDO::getDutyGuardServiceOn, (Object)((CloudDutyPlatformQuery)query.getFilter()).getDutyGuardServiceOn());
        queryWrapper.ge(CloudClientStoreDO::getStartTime, (Object)((CloudDutyPlatformQuery)query.getFilter()).getStartTime());
        queryWrapper.le(CloudClientStoreDO::getStartTime, (Object)((CloudDutyPlatformQuery)query.getFilter()).getEndTime());
        queryWrapper.orderByDesc(CloudClientStoreDO::getStartTime);
        IPage selectPage = this.cloudClientStoreDao.selectPage(cloudClientStorePage, (Wrapper)queryWrapper);
        List records = selectPage.getRecords();
        ArrayList<CloudPlatformWatchRecordVO> list = new ArrayList<CloudPlatformWatchRecordVO>();
        List storeIds = records.stream().map(CloudClientStoreDO::getStoreId).map(item -> Integer.valueOf(item)).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(storeIds)) {
            HttpResponseEntity shopInfo = this.masterStrokeService.getDepartmentInfoByIds(storeIds);
            if (shopInfo.getIsError().booleanValue()) {
                throw new CloudWatchException(CloudWatchErrorCode.STORE_QUERY_FALSE);
            }
            List shopInfoData = (List)shopInfo.getData();
            Map<Integer, MasterStoreInfo> storeMap = shopInfoData.stream().collect(Collectors.toMap(MasterStoreInfo::getId, item -> item));
            for (CloudClientStoreDO record : records) {
                String now = LocalDateTime.now(ZoneId.of("Asia/Shanghai")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                DepDutyStatisticDTO sale = this.getDepDutyStatistic(Integer.valueOf(record.getStoreId()), record.getStartTime(), now);
                RecordEnterStoreSummary watchingSummary = this.fetchRecordEnterStoreSummary(Arrays.asList(Integer.valueOf(record.getStoreId())), record.getStartTime(), record.getEndTime());
                CloudPlatformWatchRecordVO cloudPlatformWatchRecordVO = new CloudPlatformWatchRecordVO();
                cloudPlatformWatchRecordVO.setStoreId(Integer.valueOf(Integer.parseInt(record.getStoreId())));
                cloudPlatformWatchRecordVO.setDutyGuardServiceOn(record.getDutyGuardServiceOn());
                MasterStoreInfo storeInfo = storeMap.get(Integer.parseInt(record.getStoreId()));
                if (storeInfo != null) {
                    cloudPlatformWatchRecordVO.setStoreName(storeInfo.getName());
                    cloudPlatformWatchRecordVO.setEnterpriseName(storeInfo.getGroupName());
                }
                cloudPlatformWatchRecordVO.setStartTime(record.getStartTime());
                if (watchingSummary != null) {
                    cloudPlatformWatchRecordVO.setWatchingCount(watchingSummary.getWatchShoreNum());
                    cloudPlatformWatchRecordVO.setCustomerCount(watchingSummary.getEnterStoreNum());
                    cloudPlatformWatchRecordVO.setPersonTime(watchingSummary.getEnterStoreTimes());
                }
                if (sale != null) {
                    cloudPlatformWatchRecordVO.setPayNum(sale.getPayerCount());
                    cloudPlatformWatchRecordVO.setOrderNum(sale.getOrderCount());
                    cloudPlatformWatchRecordVO.setPayAmount(Float.valueOf(sale.getOrderAmount() == null ? 0.0f : sale.getOrderAmount().floatValue()));
                }
                list.add(cloudPlatformWatchRecordVO);
            }
        }
        PageBaseResult result = new PageBaseResult();
        result.initFromCloudManageFilterQuery(selectPage, query);
        result.setData(list);
        return result;
    }

    private DepDutyStatisticDTO getDepDutyStatistic(Integer storeId, String startTime, String endTime) {
        if (storeId == null || StringUtils.isEmpty((CharSequence)startTime) || StringUtils.isEmpty((CharSequence)endTime)) {
            log.warn("\u53c2\u6570\u7f3a\u5931\uff1astoreId={}, startTime={}, endTime={}", new Object[]{storeId, startTime, endTime});
            return null;
        }
        DepQuery depQuery = new DepQuery();
        depQuery.setDepId(storeId);
        depQuery.setStartTime(startTime);
        depQuery.setEndTime(endTime);
        ResponseBaseParent saleResult = this.wanJiOrderForeignService.depDutyStatistic(depQuery);
        log.info("queryOrderSummarize_result:{}", (Object)JSON.toJSONString((Object)saleResult));
        return saleResult != null ? (DepDutyStatisticDTO)saleResult.getData() : null;
    }

    private RecordEnterStoreSummary fetchRecordEnterStoreSummary(List<Integer> storeIds, String startTime, String endTime) {
        if (CollectionUtils.isEmpty(storeIds) || StringUtils.isEmpty((CharSequence)startTime) || StringUtils.isEmpty((CharSequence)endTime)) {
            return null;
        }
        DepQuery depQuery = new DepQuery();
        depQuery.setDepIds(storeIds);
        depQuery.setWdzDeptIds(storeIds);
        depQuery.setStartTime(startTime);
        depQuery.setEndTime(endTime);
        log.info("queryServiceRecordEnterStore_param:{}", (Object)JSON.toJSONString((Object)depQuery));
        HttpResponseEntity watchResult = this.watchForeignService.queryServiceRecordEnterStore(depQuery);
        if (watchResult.getIsError().booleanValue() || CollectionUtils.isEmpty((Collection)((Collection)watchResult.getData()))) {
            throw new CloudWatchException(CloudWatchErrorCode.STORE_QUERY_FALSE);
        }
        List data = (List)watchResult.getData();
        return ((WatchRecordEnterStoreDTO)data.get(0)).getGetServiceRecordEnterStore();
    }

    @Override
    public PageBaseResult<List<CloudPlatformWatchOrderVO>> getWatchOrderHistory(PageBaseQuery<CloudOrderPlatformQuery> query) {
        return null;
    }

    @Override
    public String updateClientStore(CloudClientStoreBO cloudClientStoreBO) {
        CloudClientStoreRelationDO cloudClientStoreRelationDO;
        if (StringUtils.isEmpty((CharSequence)cloudClientStoreBO.getStoreId())) {
            throw new CloudWatchException("\u7f3a\u5c11\u95e8\u5e97id\u4fe1\u606f");
        }
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (StringUtils.isEmpty((CharSequence)cloudClientStoreBO.getUserId())) {
            cloudClientStoreBO.setUserId(String.valueOf(threadUserDTO.getUserData().getData().getId()));
        }
        if ((cloudClientStoreRelationDO = this.cloudClientStoreRelationDao.selectNewStore(Integer.valueOf(Integer.parseInt(cloudClientStoreBO.getUserId())), null)) != null && cloudClientStoreBO.getStoreId().equals(cloudClientStoreRelationDO.getStoreId())) {
            return "\u66f4\u65b0\u6210\u529f";
        }
        cloudClientStoreRelationDO = CloudClientStoreRelationDO.fromCloudClientStore((CloudClientStoreBO)cloudClientStoreBO);
        this.cloudClientStoreRelationDao.insert((Object)cloudClientStoreRelationDO);
        return "\u66f4\u65b0\u6210\u529f";
    }

    @Override
    public CloudStoreStateVO fetchSpecificStoreState(Integer storeId) {
        List<Object> userIdVoList = this.getSelectDeptData("");
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        GetDepartmentInfoVO departmentInfo = this.shopWebCommon.getDepartmentInfo(userInfo.getToken(), storeId);
        GetSelectDepByUserIdVo storeStateVO = (userIdVoList = userIdVoList.stream().filter(item -> 1 == item.getOpenStatus()).collect(Collectors.toList())).stream().filter(item -> storeId.equals(String.valueOf(item.getId()))).findFirst().orElse(null);
        if (storeStateVO == null) {
            throw new CloudWatchException(CloudWatchErrorCode.PERMISSION_REJECT);
        }
        CloudStoreStateVO result = CloudStoreStateVOMapper.INSTANCE.copyStoreState(storeStateVO);
        if ((result = this.encapsulateData(result)) == null) {
            throw new CloudWatchException(CloudWatchErrorCode.STORE_QUERY_FALSE);
        }
        return result;
    }

    @Override
    public CloudWatchOrderNumVO queryStoreService(CloudRangeQuery query) {
        if (StringUtils.isNotEmpty((CharSequence)query.getCloudId()) && StringUtils.isEmpty((CharSequence)query.getStoreId())) {
            query.setStoreId("1");
        }
        this.cloudSaleService.validateQuery(query);
        CloudWatchOrderNumVO orderNumVO = new CloudWatchOrderNumVO();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        GetOrderListQuery queryOrder = new GetOrderListQuery();
        queryOrder.setStartTime(query.getStartDate());
        queryOrder.setEndTime(query.getEndDate());
        queryOrder.setWdzDeptId(query.getStoreId());
        queryOrder.setWdzEntId(String.valueOf(threadUserDTO.getUserData().getData().getGroupId()));
        ResponseBaseParent result = this.wanJiOrderForeignService.queryOrder(queryOrder);
        if (result == null || result.getCode() != 0) {
            throw new CloudWatchException(CloudWatchErrorCode.FOREIGN_INTERFACE_ERROR);
        }
        List responseData = (List)result.getData();
        orderNumVO.setOrderNum(Integer.valueOf(responseData.size()));
        orderNumVO.setStartTime(query.getStartDate());
        orderNumVO.setEndTime(query.getEndDate());
        return orderNumVO;
    }

    @Override
    public List<CloudWatchStoreServiceVO> queryStoreServiceDetail(CloudRangeQuery query) {
        this.cloudSaleService.validateQuery(query);
        ArrayList<CloudWatchStoreServiceVO> result = new ArrayList<CloudWatchStoreServiceVO>();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        int pageIndex = 1;
        int size = 500;
        HttpResponseEntity responseEntity = this.watchForeignService.queryServiceRecord(Integer.valueOf(pageIndex), Integer.valueOf(size), threadUserDTO.getUserData().getData().getGroupId(), query.getStoreId());
        List records = ((WatchServiceRecordDTO)responseEntity.getData()).getRecords();
        int pageSum = ((WatchServiceRecordDTO)responseEntity.getData()).getPages();
        if (pageSum > 1) {
            for (int page = 2; page <= pageSum; ++page) {
                HttpResponseEntity responseEntityTemp = this.watchForeignService.queryServiceRecord(Integer.valueOf(page), Integer.valueOf(size), threadUserDTO.getUserData().getData().getGroupId(), query.getStoreId());
                records.addAll(((WatchServiceRecordDTO)responseEntityTemp.getData()).getRecords());
            }
        }
        boolean choose = StringUtils.isNotEmpty((CharSequence)query.getStartDate()) && StringUtils.isNotEmpty((CharSequence)query.getEndDate());
        for (WatchServiceRecordInfoDTO watchServiceRecordInfoDTO : records) {
            if (choose) {
                boolean filter;
                String time = watchServiceRecordInfoDTO.getEntryTime();
                if (time == null) continue;
                boolean bl = filter = (time = time.replace("T", " ")).compareTo(query.getStartDate()) >= 0 && time.compareTo(query.getEndDate()) <= 0;
                if (!filter) continue;
            }
            CloudWatchStoreServiceVO storeServiceVO = CloudStoreStateVOMapper.INSTANCE.copyWatchCloudService(watchServiceRecordInfoDTO);
            if (watchServiceRecordInfoDTO.getHasOrders().booleanValue()) {
                for (WatchServiceRecordInfoDTO.WatchServiceOrderDTO orderDTO : watchServiceRecordInfoDTO.getOrders()) {
                    CloudWatchStoreServiceVO storeServiceTemp = CloudStoreStateVOMapper.INSTANCE.copyWatchCloudSame(storeServiceVO);
                    storeServiceTemp.setOrderId(orderDTO.getOrderNo());
                    result.add(storeServiceTemp);
                }
                continue;
            }
            result.add(storeServiceVO);
        }
        return result;
    }

    @Override
    public CloudStoreOverviewVO queryStoreOverview(Integer storeId) {
        CloudStoreOverviewVO cloudStoreOverview = new CloudStoreOverviewVO();
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            throw new CloudWatchException("token\u89e3\u6790\u5931\u8d25");
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String startTime = TimeService.getStartTimeDay();
        String endTime = TimeService.getEndTimeDay();
        String beforeStartTime = TimeService.getGapDateStartTime((int)-1);
        String beforeEndTime = TimeService.getGapDateEndTime((int)-1);
        GetOrderStatisticsInfoDTO orderStatisticsInfo = this.orderCommon.getOrderStatisticsInfo(storeId, LocalDateTime.parse(startTime, dateTimeFormatter), LocalDateTime.parse(endTime, dateTimeFormatter), userInfo.getToken(), userInfo.getPlatform());
        GetOrderStatisticsInfoDTO beforeOrderStatisticsInfo = this.orderCommon.getOrderStatisticsInfo(storeId, LocalDateTime.parse(beforeStartTime, dateTimeFormatter), LocalDateTime.parse(beforeEndTime, dateTimeFormatter), userInfo.getToken(), userInfo.getPlatform());
        cloudStoreOverview.setOrderCount(orderStatisticsInfo.getPayOrderNum() == null ? 0 : orderStatisticsInfo.getPayOrderNum());
        cloudStoreOverview.setSales(orderStatisticsInfo.getTurnover() == null ? BigDecimal.ZERO : orderStatisticsInfo.getTurnover());
        cloudStoreOverview.setTotalOrderCount(orderStatisticsInfo.getTotalPayOrderNum() == null ? 0 : orderStatisticsInfo.getTotalPayOrderNum());
        cloudStoreOverview.setTotalSales(orderStatisticsInfo.getTotalTurnover() == null ? BigDecimal.ZERO : orderStatisticsInfo.getTotalTurnover());
        cloudStoreOverview.setOrderCountRate(this.computeRate(orderStatisticsInfo.getPayOrderNum(), beforeOrderStatisticsInfo.getPayOrderNum()));
        cloudStoreOverview.setSalesRate(this.computeRate(orderStatisticsInfo.getTurnover(), beforeOrderStatisticsInfo.getTurnover()));
        cloudStoreOverview.setTotalOrderCountRate(this.computeRate(orderStatisticsInfo.getTotalPayOrderNum(), beforeOrderStatisticsInfo.getTotalPayOrderNum()));
        cloudStoreOverview.setTotalSalesRate(this.computeRate(orderStatisticsInfo.getTotalTurnover(), beforeOrderStatisticsInfo.getTotalTurnover()));
        CloudWatchStoreQuery query = new CloudWatchStoreQuery(storeId, startTime, endTime);
        HttpResponseEntity responseEntity = this.watchForeignService.getServiceRecordEnterStore(query);
        if (responseEntity.getIsError().booleanValue()) {
            log.error("\u83b7\u53d6\u8ba2\u5355\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25:{}", (Object)responseEntity.toString());
            throw new CloudWatchException("\u4ece\u503c\u5b88\u7aef\u83b7\u53d6\u8fdb\u5e97\u4eba\u6570\u5931\u8d25");
        }
        query = new CloudWatchStoreQuery(storeId, beforeStartTime, beforeEndTime);
        HttpResponseEntity beforeResponseEntity = this.watchForeignService.getServiceRecordEnterStore(query);
        if (beforeResponseEntity.getIsError().booleanValue()) {
            log.error("\u83b7\u53d6\u6628\u5929\u8ba2\u5355\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25:{}", (Object)beforeResponseEntity.toString());
            throw new CloudWatchException("\u4ece\u503c\u5b88\u7aef\u83b7\u53d6\u6628\u5929\u8fdb\u5e97\u4eba\u6570\u5931\u8d25");
        }
        List watchStoreNumDTO = (List)responseEntity.getData();
        List beforeWatchStoreNumDTO = (List)beforeResponseEntity.getData();
        Map<Integer, CloudWatchStoreNumDTO.StoreNumDTO> storeNumDTOMap = watchStoreNumDTO.stream().collect(Collectors.toMap(CloudWatchStoreNumDTO::getDepId, CloudWatchStoreNumDTO::getGetServiceRecordEnterStore));
        Map<Integer, CloudWatchStoreNumDTO.StoreNumDTO> beforeStoreNumDTOMap = beforeWatchStoreNumDTO.stream().collect(Collectors.toMap(CloudWatchStoreNumDTO::getDepId, CloudWatchStoreNumDTO::getGetServiceRecordEnterStore));
        CloudWatchStoreNumDTO.StoreNumDTO storeNumD = storeNumDTOMap.get(storeId);
        CloudWatchStoreNumDTO.StoreNumDTO beforeStoreNumD = beforeStoreNumDTOMap.get(storeId);
        if (storeNumD != null) {
            cloudStoreOverview.setInStoreCount(storeNumD.getEnterStoreTimes().intValue());
            cloudStoreOverview.setWatchCount(storeNumD.getWatchShoreNum().intValue());
        }
        if (storeNumD != null && beforeStoreNumD != null) {
            cloudStoreOverview.setInStoreCountRate(this.computeRate(storeNumD.getEnterStoreTimes(), beforeStoreNumD.getEnterStoreTimes()));
        }
        cloudStoreOverview.setStatisticsStartTime(startTime);
        cloudStoreOverview.setStatisticsEndTime(endTime);
        cloudStoreOverview.setWatchTime(this.getTodayWatchTimeByStore(storeId).longValue());
        return cloudStoreOverview;
    }

    private Float computeRate(Integer count, Integer beforeCount) {
        if (beforeCount == null || beforeCount == 0) {
            return null;
        }
        count = count == null ? 0 : count;
        float rate = (float)(count - beforeCount) / (float)beforeCount.intValue() * 100.0f;
        return Float.valueOf((float)((double)Math.round(rate * 10.0f) / 10.0));
    }

    private Float computeRate(BigDecimal count, BigDecimal beforeCount) {
        if (beforeCount == null || beforeCount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        count = count == null ? BigDecimal.ZERO : count;
        float rate = count.subtract(beforeCount).divide(beforeCount, 3, 4).multiply(new BigDecimal(100)).floatValue();
        return Float.valueOf((float)((double)Math.round(rate * 10.0f) / 10.0));
    }

    private Long getTodayWatchTimeByStore(Integer storeId) {
        Long watchTime = 0L;
        String now = TimeService.getTime();
        String start = TimeService.getStartTimeDay();
        CloudClientStoreDO cloudingClient = (CloudClientStoreDO)this.cloudClientStoreDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudClientStoreDO::getStoreId, (Object)storeId)).eq(CloudClientStoreDO::getStatus, (Object)CloudWatchStateEnum.STORE_WATCH_STATE.getCode()));
        List cloudedClientList = this.cloudClientStoreDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudClientStoreDO::getStoreId, (Object)storeId)).eq(CloudClientStoreDO::getStatus, (Object)CloudWatchStateEnum.STORE_FINISH_STATE.getCode())).ge(CloudClientStoreDO::getEndTime, (Object)start));
        if (cloudingClient != null) {
            String startTime = cloudingClient.getStartTime();
            if (startTime.compareTo(start) < 0) {
                startTime = start;
            }
            if (startTime.compareTo(now) < 0) {
                watchTime = watchTime + TimeService.computeTime((String)startTime, (String)now);
            }
        }
        if (cloudedClientList != null && !cloudedClientList.isEmpty()) {
            for (CloudClientStoreDO cloudedClient : cloudedClientList) {
                String startTime = cloudedClient.getStartTime();
                if (startTime.compareTo(start) < 0) {
                    startTime = start;
                }
                if (startTime.compareTo(cloudedClient.getEndTime()) >= 0) continue;
                watchTime = watchTime + TimeService.computeTime((String)startTime, (String)cloudedClient.getEndTime());
            }
        }
        return watchTime;
    }

    @Override
    public CloudStoreOverviewVO queryStoreWatchSale(String cloudId) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            throw new CloudWatchException("token\u89e3\u6790\u5931\u8d25");
        }
        CloudClientStoreDO cloudClientStore = (CloudClientStoreDO)this.cloudClientStoreDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(IdEntity::getId, (Object)cloudId));
        if (cloudClientStore == null) {
            throw new CloudWatchException("\u8be5\u4e91\u503c\u5b88\u4e0d\u5b58\u5728");
        }
        CloudStoreOverviewVO cloudStoreOverview = new CloudStoreOverviewVO();
        cloudStoreOverview.setStatisticsStartTime(cloudClientStore.getStartTime());
        String endTime = cloudClientStore.getEndTime();
        if (StringUtils.isEmpty((CharSequence)endTime)) {
            endTime = TimeService.getTime();
            cloudStoreOverview.setStatisticsEndTime(endTime);
        } else {
            cloudStoreOverview.setStatisticsEndTime(cloudClientStore.getEndTime());
        }
        Integer storeId = Integer.valueOf(cloudClientStore.getStoreId());
        CloudWatchStoreQuery query = new CloudWatchStoreQuery(storeId, cloudClientStore.getStartTime(), endTime);
        HttpResponseEntity responseEntity = this.watchForeignService.getServiceRecordEnterStore(query);
        if (responseEntity.getIsError().booleanValue()) {
            log.error("\u83b7\u53d6\u8ba2\u5355\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25:{}", (Object)responseEntity.toString());
            throw new CloudWatchException("\u4ece\u503c\u5b88\u7aef\u83b7\u53d6\u8fdb\u5e97\u4eba\u6570\u5931\u8d25");
        }
        List watchStoreNumDTO = (List)responseEntity.getData();
        Map<Integer, CloudWatchStoreNumDTO.StoreNumDTO> storeNumDTOMap = watchStoreNumDTO.stream().collect(Collectors.toMap(CloudWatchStoreNumDTO::getDepId, CloudWatchStoreNumDTO::getGetServiceRecordEnterStore));
        CloudWatchStoreNumDTO.StoreNumDTO storeNumD = storeNumDTOMap.get(storeId);
        if (storeNumD != null) {
            cloudStoreOverview.setInStoreCount(storeNumD.getEnterStoreTimes().intValue());
            cloudStoreOverview.setWatchCount(storeNumD.getWatchShoreNum().intValue());
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        GetOrderStatisticsInfoDTO orderStatisticsInfo = this.orderCommon.getOrderStatisticsInfo(Integer.valueOf(cloudClientStore.getStoreId()), LocalDateTime.parse(cloudStoreOverview.getStatisticsStartTime(), dateTimeFormatter), LocalDateTime.parse(cloudStoreOverview.getStatisticsEndTime(), dateTimeFormatter), userInfo.getToken(), userInfo.getPlatform());
        cloudStoreOverview.setOrderCount(orderStatisticsInfo.getPayOrderNum().intValue());
        cloudStoreOverview.setSales(orderStatisticsInfo.getTurnover());
        cloudStoreOverview.setWatchTime(TimeService.computeTime((String)cloudStoreOverview.getStatisticsStartTime(), (String)cloudStoreOverview.getStatisticsEndTime()).longValue());
        return cloudStoreOverview;
    }

    @Override
    public PageBaseResult<List<CloudEventRecordVO>> queryStoreEvent(CloudStoreRecordQuery query) {
        PageBaseResult result = new PageBaseResult();
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        List ipcSignList = this.cloudDeviceIpcSignDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1)).eq(CloudDeviceIpcSignDO::getStoreId, (Object)query.getStoreId())).and(item -> ((LambdaQueryWrapper)((LambdaQueryWrapper)item.eq(CloudDeviceIpcSignDO::getCashDeviceSign, (Object)1)).or()).eq(CloudDeviceIpcSignDO::getEnterDeviceSign, (Object)1)));
        YzsDeviceFeignVo cashDeviceId = null;
        YzsDeviceFeignVo enterDeviceId = null;
        if (!ipcSignList.isEmpty()) {
            Map<Integer, CloudDeviceIpcSignDO> ipcSignMap = ipcSignList.stream().collect(Collectors.toMap(CloudDeviceIpcSignDO::getDeviceId, item -> item));
            List<YzsDeviceFeignVo> deviceList = this.shopWebCommon.getAllDeviceList(query.getStoreId(), null);
            for (YzsDeviceFeignVo device : deviceList) {
                if (!ipcSignMap.containsKey(device.getDeviceStatusId())) continue;
                CloudDeviceIpcSignDO ipcSign = ipcSignMap.get(device.getDeviceStatusId());
                if (ipcSign.getCashDeviceSign() == 1) {
                    cashDeviceId = device;
                }
                if (ipcSign.getEnterDeviceSign() != 1) continue;
                enterDeviceId = device;
            }
        }
        ArrayList<CloudEventRecordVO> data = new ArrayList<CloudEventRecordVO>();
        result.setLimit(Long.valueOf(query.getPageSize().intValue()));
        result.setCurrentPage(Long.valueOf(query.getPageNum().intValue()));
        if (query.getEventType() == null || query.getEventType().isEmpty()) {
            query.setEventType(EventMsgEnum.getShowType());
        }
        if (StringUtils.isNotEmpty((CharSequence)query.getInputQuery())) {
            if (query.getEventType().contains(EventMsgEnum.ORDER_EVENT.getType())) {
                NewQueryOrderQuery request = new NewQueryOrderQuery();
                request.setStartTime(query.getStartDate());
                request.setEndTime(query.getEndDate());
                request.setKeyword(query.getInputQuery());
                request.setWdzDeptId(String.valueOf(query.getStoreId()));
                request.setPageNum(query.getPageNum());
                request.setPageSize(query.getPageSize());
                PageInfo<NewQueryOrderVO> orderListPage = this.orderCommon.getOrderList(threadUserDTO.getToken(), request, threadUserDTO.getPlatform());
                List orderList = orderListPage.getRecords();
                result.setTotalNum(Long.valueOf(orderListPage.getTotal().longValue()));
                for (NewQueryOrderVO order2 : orderList) {
                    CloudEventRecordVO event2 = new CloudEventRecordVO();
                    event2.setTime(order2.getCreateTime());
                    String title = EventMsgEnum.ORDER_EVENT.getName() + " \uffe5" + order2.getTotalPrice().doubleValue();
                    event2.setEventName(title);
                    event2.setEventContent("\u5171" + order2.getTotalQuantity() + "\u4ef6");
                    event2.setPic(order2.getAllGoodsImgs());
                    if (cashDeviceId != null) {
                        event2.setDeviceVideoId(cashDeviceId.getDeviceId());
                        event2.setDeviceName(cashDeviceId.getDeviceName());
                    }
                    event2.setHasRefund(order2.getHasRefund());
                    event2.setOrderStatus(order2.getOrderStatus());
                    event2.setOrderNo(order2.getOrderSn());
                    event2.setEventType(Integer.valueOf(EventMsgEnum.ORDER_EVENT.getType()));
                    data.add(event2);
                }
            }
        } else {
            Integer start = (query.getPageNum() - 1) * query.getPageSize();
            List eventList = this.cloudClientEventDao.queryEventList(query.getStoreId(), query.getStartDate(), query.getEndDate(), start, query.getPageSize(), query.getEventType());
            result.setTotalNum(Long.valueOf(this.cloudClientEventDao.queryEventListCount(query.getStoreId(), query.getStartDate(), query.getEndDate(), Integer.valueOf(8))));
            List orderSnList = eventList.stream().filter(event -> event.getEventType().intValue() == EventMsgEnum.ORDER_EVENT.getType()).map(CloudClientEventDO::getEventContent).collect(Collectors.toList());
            Map<Object, Object> orderMap = new HashMap();
            if (!orderSnList.isEmpty()) {
                NewQueryOrderQuery request = new NewQueryOrderQuery();
                request.setOrderSnList(orderSnList);
                request.setWdzDeptId(String.valueOf(query.getStoreId()));
                PageInfo<NewQueryOrderVO> orderListPage = this.orderCommon.getOrderList(threadUserDTO.getToken(), request, threadUserDTO.getPlatform());
                List orderList = orderListPage.getRecords();
                orderMap = orderList.stream().collect(Collectors.toMap(NewQueryOrderVO::getOrderSn, order -> order));
            }
            List userIdList = eventList.stream().filter(event -> event.getEventType().intValue() == EventMsgEnum.STAFF_CLOSE_DOOR_EVENT.getType() || event.getEventType().intValue() == EventMsgEnum.STAFF_OPEN_DOOR_EVENT.getType() || event.getEventType().intValue() == EventMsgEnum.START_CLOUD_WATCH_EVENT.getType() || event.getEventType().intValue() == EventMsgEnum.END_CLOUD_WATCH_EVENT.getType()).map(CloudClientEventDO::getUserId).distinct().collect(Collectors.toList());
            Map<Object, Object> userMap = new HashMap();
            if (!userIdList.isEmpty()) {
                HttpResponseEntity responseEntity = this.masterStrokeService.getUserById(userIdList);
                if (responseEntity.getIsError().booleanValue()) {
                    log.error("\u4e3b\u7ebf\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25 : {}", (Object)responseEntity.toString());
                } else {
                    userMap = ((List)responseEntity.getData()).stream().collect(Collectors.toMap(UsersPojo::getId, v -> v));
                }
            }
            for (CloudClientEventDO event3 : eventList) {
                UsersPojo user;
                if (!EventMsgEnum.containEvent((Integer)event3.getEventType())) continue;
                CloudEventRecordVO cloudEventRecord = new CloudEventRecordVO();
                cloudEventRecord.setTime(TimeService.getStringByDate((Date)event3.getEventTime()));
                String title = EventMsgEnum.getNameByType((Integer)event3.getEventType());
                String content = "";
                if (event3.getEventType().intValue() == EventMsgEnum.ORDER_EVENT.getType()) {
                    NewQueryOrderVO order3 = (NewQueryOrderVO)orderMap.get(event3.getEventContent());
                    cloudEventRecord.setOrderNo(event3.getEventContent());
                    if (order3 == null) {
                        content = event3.getEventContent();
                    } else {
                        title = title + " \uffe5" + order3.getTotalPrice();
                        content = "\u5171" + order3.getTotalQuantity() + "\u4ef6";
                        cloudEventRecord.setPic(order3.getAllGoodsImgs());
                        cloudEventRecord.setOrderStatus(order3.getOrderStatus());
                        cloudEventRecord.setHasRefund(order3.getHasRefund());
                    }
                } else if (event3.getEventType().intValue() == EventMsgEnum.OPEN_DOOR_EVENT.getType() || event3.getEventType().intValue() == EventMsgEnum.CLOSE_DOOR_EVENT.getType()) {
                    Map eventMap = (Map)JSON.parseObject((String)event3.getEventContent(), Map.class);
                    String phone = (String)eventMap.get("phone");
                    if (StringUtils.isNotEmpty((CharSequence)phone)) {
                        content = ToolCommon.phoneDesensitization((String)phone);
                    }
                } else if (event3.getEventType().intValue() == EventMsgEnum.STAFF_CLOSE_DOOR_EVENT.getType() || event3.getEventType().intValue() == EventMsgEnum.STAFF_OPEN_DOOR_EVENT.getType()) {
                    if (event3.getUserId() != null && userMap.containsKey(event3.getUserId())) {
                        user = (UsersPojo)userMap.get(event3.getUserId());
                        content = user.getShowName();
                        cloudEventRecord.setPic(Collections.singletonList(user.getThumbUrl()));
                    }
                } else if (event3.getEventType().intValue() == EventMsgEnum.START_CLOUD_WATCH_EVENT.getType() || event3.getEventType().intValue() == EventMsgEnum.END_CLOUD_WATCH_EVENT.getType()) {
                    if (event3.getUserId() != null && userMap.containsKey(event3.getUserId())) {
                        user = (UsersPojo)userMap.get(event3.getUserId());
                        content = user.getShowName();
                        cloudEventRecord.setPic(Collections.singletonList(user.getThumbUrl()));
                    }
                } else {
                    content = event3.getEventContent();
                }
                cloudEventRecord.setEventContent(content);
                cloudEventRecord.setEventName(title);
                cloudEventRecord.setEventType(event3.getEventType());
                if (event3.getEventType().intValue() == EventMsgEnum.ORDER_EVENT.getType()) {
                    if (cashDeviceId != null) {
                        cloudEventRecord.setDeviceVideoId(cashDeviceId.getDeviceId());
                        cloudEventRecord.setDeviceName(cashDeviceId.getDeviceName());
                    }
                } else if (enterDeviceId != null) {
                    cloudEventRecord.setDeviceVideoId(enterDeviceId.getDeviceId());
                    cloudEventRecord.setDeviceName(enterDeviceId.getDeviceName());
                }
                data.add(cloudEventRecord);
            }
        }
        long pages = result.getTotalNum() / result.getLimit();
        if (result.getTotalNum() % result.getLimit() != 0L) {
            ++pages;
        }
        result.setPage(Long.valueOf(pages));
        result.setData(data);
        return result;
    }

    @Override
    public PageBaseResult<List<CloudStoreOverviewVO>> queryKeepStoreRecord(Integer storeId, Integer pageNum, Integer pageSize) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            throw new CloudWatchException("token\u89e3\u6790\u5931\u8d25");
        }
        PageBaseResult result = new PageBaseResult();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CloudClientStoreDO::getStoreId, (Object)storeId);
        queryWrapper.orderByDesc(CloudClientStoreDO::getStartTime);
        Page cloudClientStorePage = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        IPage selectPage = this.cloudClientStoreDao.selectPage((IPage)cloudClientStorePage, (Wrapper)queryWrapper);
        List cloudedClientList = selectPage.getRecords();
        result.initFromCloudManageFilterQuery(selectPage, pageNum, pageSize);
        if (cloudedClientList.isEmpty()) {
            return result;
        }
        ArrayList<CloudStoreOverviewVO> data = new ArrayList<CloudStoreOverviewVO>();
        GetOrderStatisticsInfoBatchQuery param = new GetOrderStatisticsInfoBatchQuery();
        param.setDepId(storeId);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ArrayList<JobRecordDTO> recordList = new ArrayList<JobRecordDTO>();
        for (int index = 0; index < cloudedClientList.size(); ++index) {
            CloudClientStoreDO cloudedClient = (CloudClientStoreDO)cloudedClientList.get(index);
            JobRecordDTO model = new JobRecordDTO();
            model.setStart(LocalDateTime.parse(cloudedClient.getStartTime(), dateTimeFormatter));
            if (CloudWatchStateEnum.STORE_FINISH_STATE.getCode().equals(cloudedClient.getStatus())) {
                model.setEnd(LocalDateTime.parse(cloudedClient.getEndTime(), dateTimeFormatter));
            } else {
                model.setEnd(LocalDateTime.now(ZoneId.of("Asia/Shanghai")));
            }
            model.setId(Integer.valueOf(index));
            cloudedClient.setTempId(model.getId());
            cloudedClientList.set(index, cloudedClient);
            recordList.add(model);
        }
        param.setRecordList(recordList);
        List<GetOrderStatisticsInfoBatchDTO> orderStatisticsInfoBatch = this.orderCommon.getOrderStatisticsInfoBatch(param, userInfo.getToken(), userInfo.getPlatform());
        Map<Integer, GetOrderStatisticsInfoBatchDTO> orderStatisticsInfoMap = orderStatisticsInfoBatch.stream().collect(Collectors.toMap(GetOrderStatisticsInfoBatchDTO::getId, v -> v));
        for (CloudClientStoreDO storeDO : cloudedClientList) {
            GetOrderStatisticsInfoBatchDTO orderStatisticsInfo;
            CloudStoreOverviewVO cloudStoreOverview = new CloudStoreOverviewVO();
            cloudStoreOverview.setId((String)storeDO.getId());
            cloudStoreOverview.setStatisticsStartTime(storeDO.getStartTime());
            String endTime = TimeService.getTime();
            if (CloudWatchStateEnum.STORE_FINISH_STATE.getCode().equals(storeDO.getStatus())) {
                cloudStoreOverview.setStatisticsEndTime(storeDO.getEndTime());
                endTime = storeDO.getEndTime();
            } else {
                cloudStoreOverview.setStatisticsEndTime("\u81f3\u4eca");
            }
            CloudWatchStoreQuery query = new CloudWatchStoreQuery(storeId, storeDO.getStartTime(), endTime);
            HttpResponseEntity responseEntity = this.watchForeignService.getServiceRecordEnterStore(query);
            if (responseEntity.getIsError().booleanValue()) {
                log.error("\u83b7\u53d6\u8ba2\u5355\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25:{}", (Object)responseEntity.toString());
                throw new CloudWatchException("\u4ece\u503c\u5b88\u7aef\u83b7\u53d6\u8fdb\u5e97\u4eba\u6570\u5931\u8d25");
            }
            List watchStoreNumDTO = (List)responseEntity.getData();
            Map<Integer, CloudWatchStoreNumDTO.StoreNumDTO> storeNumDTOMap = watchStoreNumDTO.stream().collect(Collectors.toMap(CloudWatchStoreNumDTO::getDepId, CloudWatchStoreNumDTO::getGetServiceRecordEnterStore));
            CloudWatchStoreNumDTO.StoreNumDTO storeNumD = storeNumDTOMap.get(storeId);
            if (storeNumD != null) {
                cloudStoreOverview.setInStoreCount(storeNumD.getEnterStoreTimes().intValue());
                cloudStoreOverview.setWatchCount(storeNumD.getWatchShoreNum().intValue());
            }
            if ((orderStatisticsInfo = orderStatisticsInfoMap.get(storeDO.getTempId())) != null) {
                cloudStoreOverview.setOrderCount(orderStatisticsInfo.getPayOrderNum().intValue());
                cloudStoreOverview.setSales(orderStatisticsInfo.getTurnover());
            }
            data.add(cloudStoreOverview);
        }
        result.setData(data);
        return result;
    }

    @Override
    public QueryKeepStoreRecordDetailVO queryKeepStoreRecordDetail(String id) {
        GetOrderStatisticsInfoDTO orderStatisticsInfo;
        CloudWatchStoreQuery query;
        HttpResponseEntity responseEntity;
        if (id == null) {
            throw new CloudWatchException("\u8bf7\u9009\u62e9\u503c\u5b88\u8bb0\u5f55");
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            throw new CloudWatchException("token\u89e3\u6790\u5931\u8d25");
        }
        CloudClientStoreDO cloudedInfo = (CloudClientStoreDO)this.cloudClientStoreDao.selectById((Serializable)((Object)id));
        if (cloudedInfo == null) {
            throw new CloudWatchException("\u503c\u5b88\u8bb0\u5f55\u5f02\u5e38");
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime start = LocalDateTime.parse(cloudedInfo.getStartTime(), dateTimeFormatter);
        LocalDateTime end = LocalDateTime.now(ZoneId.of("Asia/Shanghai"));
        if (CloudWatchStateEnum.STORE_FINISH_STATE.getCode().equals(cloudedInfo.getStatus())) {
            end = LocalDateTime.parse(cloudedInfo.getEndTime(), dateTimeFormatter);
        }
        QueryKeepStoreRecordDetailVO result = new QueryKeepStoreRecordDetailVO();
        result.setStatisticsStartTime(cloudedInfo.getStartTime());
        if (CloudWatchStateEnum.STORE_FINISH_STATE.getCode().equals(cloudedInfo.getStatus())) {
            result.setStatisticsEndTime(cloudedInfo.getEndTime());
        } else {
            result.setStatisticsEndTime("\u81f3\u4eca");
        }
        long seconds = TimeService.computeTime((String)start.format(dateTimeFormatter), (String)end.format(dateTimeFormatter));
        result.setWatchTime(String.format("%s\u5c0f\u65f6%s\u5206\u949f", BigDecimal.valueOf(Math.floor(seconds / 3600L)).stripTrailingZeros().toPlainString(), BigDecimal.valueOf(Math.ceil(seconds % 3600L / 60L)).stripTrailingZeros().toPlainString()));
        result.setSaveMoney(BigDecimal.valueOf(seconds).divide(BigDecimal.valueOf(3600L), 2, 4).multiply(BigDecimal.valueOf(21L)).setScale(2, 4));
        GetDepartmentInfoVO departmentInfo = this.shopWebCommon.getDepartmentInfo(userInfo.getToken(), Integer.valueOf(cloudedInfo.getStoreId()));
        if (departmentInfo != null) {
            result.setDepartmentName(departmentInfo.getDepartmentName());
            result.setShopPic(departmentInfo.getShopPic());
        }
        if ((responseEntity = this.watchForeignService.getServiceRecordEnterStore(query = new CloudWatchStoreQuery(Integer.valueOf(cloudedInfo.getStoreId()), start.format(dateTimeFormatter), end.format(dateTimeFormatter)))).getIsError().booleanValue()) {
            throw new CloudWatchException("\u4ece\u503c\u5b88\u7aef\u83b7\u53d6\u8fdb\u5e97\u4eba\u6570\u5931\u8d25");
        }
        List watchStoreNumDTO = (List)responseEntity.getData();
        Map<Integer, CloudWatchStoreNumDTO.StoreNumDTO> storeNumDTOMap = watchStoreNumDTO.stream().collect(Collectors.toMap(CloudWatchStoreNumDTO::getDepId, CloudWatchStoreNumDTO::getGetServiceRecordEnterStore));
        CloudWatchStoreNumDTO.StoreNumDTO storeNumD = storeNumDTOMap.get(Integer.valueOf(cloudedInfo.getStoreId()));
        if (storeNumD != null) {
            result.setInStoreCount(storeNumD.getEnterStoreTimes().intValue());
            result.setWatchCount(storeNumD.getWatchShoreNum().intValue());
        }
        if ((orderStatisticsInfo = this.orderCommon.getOrderStatisticsInfo(Integer.valueOf(cloudedInfo.getStoreId()), start, end, userInfo.getToken(), userInfo.getPlatform())) != null) {
            result.setOrderCount(orderStatisticsInfo.getPayOrderNum().intValue());
            result.setSales(orderStatisticsInfo.getTurnover());
        }
        GoodsOrderInfoBO params = new GoodsOrderInfoBO();
        params.setQueryType(Integer.valueOf(1));
        params.setDepId(Integer.valueOf(cloudedInfo.getStoreId()));
        params.setWdzDeptId(Integer.valueOf(cloudedInfo.getStoreId()));
        params.setStartTime(start.format(dateTimeFormatter));
        params.setEndTime(end.format(dateTimeFormatter));
        WanjiResponse res = this.newWanJiOrderForeignService.orderStatistics(userInfo.getToken(), params);
        if (res != null && res.getCode() == 0 && res.getData() != null) {
            result.setAllSales(((OrderStatisticsVO)res.getData()).getTotalRevenue());
        }
        return result;
    }

    private CloudStoreStateVO encapsulateData(final CloudStoreStateVO newStore) {
        ArrayList<CloudStoreStateVO> newStoreList = new ArrayList<CloudStoreStateVO>(){
            {
                this.add(newStore);
            }
        };
        this.encapsulateData((List<CloudStoreStateVO>)newStoreList);
        if (newStoreList.size() > 0) {
            return (CloudStoreStateVO)newStoreList.get(0);
        }
        return null;
    }

    private List<CloudStoreStateVO> encapsulateData(List<CloudStoreStateVO> newStoreList) {
        ArrayList<CloudStoreStateVO> result = new ArrayList<CloudStoreStateVO>();
        List storeSet = newStoreList.stream().map(CloudStoreStateVO::getStoreId).distinct().collect(Collectors.toList());
        List storeListGroup = Lists.partition(storeSet, (int)100);
        List clientStoreDOList = Collections.synchronizedList(new ArrayList());
        CompletionStage future = CompletableFuture.allOf((CompletableFuture[])storeListGroup.stream().map(item -> CompletableFuture.runAsync(() -> {
            List clientStoreDO = this.cloudClientStoreDao.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CloudClientStoreDO::getStoreId, (Collection)item)).eq(CloudClientStoreDO::getStatus, (Object)0));
            clientStoreDOList.addAll(clientStoreDO);
        })).toArray(CompletableFuture[]::new)).whenComplete((res, e) -> {
            if (e != null) {
                log.error("\u591a\u7ebf\u7a0b\u67e5\u8be2\u51fa\u9519");
                e.printStackTrace();
            }
        });
        try {
            ((CompletableFuture)future).get();
        }
        catch (InterruptedException e2) {
            throw new RuntimeException(e2);
        }
        catch (ExecutionException e3) {
            throw new RuntimeException(e3);
        }
        Map<String, CloudClientStoreDO> clientWatchMap = clientStoreDOList.stream().distinct().collect(Collectors.toMap(CloudClientStoreDO::getStoreId, item -> item));
        for (CloudStoreStateVO cloudStoreStateVO : newStoreList) {
            cloudStoreStateVO.setStoreStateCode(CloudStoreStateEnum.STORE_OPEN_STATE.getCode());
            if (clientWatchMap.containsKey(cloudStoreStateVO.getStoreId())) {
                CloudClientStoreDO clientStoreDO = clientWatchMap.get(cloudStoreStateVO.getStoreId());
                cloudStoreStateVO.setStoreStateCode(CloudStoreStateEnum.STORE_WATCH_STATE.getCode());
                cloudStoreStateVO.setCloudId((String)clientStoreDO.getId());
            }
            cloudStoreStateVO.setStoreState(CloudStoreStateEnum.fetchNameByCode((int)cloudStoreStateVO.getStoreStateCode()));
            cloudStoreStateVO.setInitial(ToolCommon.getFirstPinyin((String)cloudStoreStateVO.getStoreName()));
            result.add(cloudStoreStateVO);
        }
        List engList = result.stream().filter(m -> !m.getInitial().equals("#")).collect(Collectors.toList());
        List specList = result.stream().filter(m -> m.getInitial().equals("#")).collect(Collectors.toList());
        result = new ArrayList();
        if (engList != null && engList.size() > 0) {
            result.addAll(engList.stream().sorted(Comparator.comparing(CloudStoreStateVO::getInitial).thenComparing(CloudStoreStateVO::getStoreName)).collect(Collectors.toList()));
        }
        if (specList != null && specList.size() > 0) {
            result.addAll(specList.stream().sorted(Comparator.comparing(CloudStoreStateVO::getStoreName)).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public Result<List<GetPeopleComeInfoVO>> getPeopleComeInfo(GetPeopleComeInfoQuery request) {
        ThreadUserDTO userInfo;
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        if (request.getStoreId() == null) {
            return ResultUtil.error((Integer)1002, (String)"\u8bf7\u9009\u62e9\u95e8\u5e97");
        }
        if (StringUtils.isEmpty((CharSequence)request.getStart()) || StringUtils.isEmpty((CharSequence)request.getEnd())) {
            return ResultUtil.error((Integer)1003, (String)"\u8bf7\u9009\u62e9\u65f6\u95f4");
        }
        if (request.getOrderType() == null) {
            request.setOrderType(Integer.valueOf(0));
        }
        if ((userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo")) == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1004, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        GoodsOrderInfoBO params = new GoodsOrderInfoBO();
        params.setQueryType(request.getOrderType());
        params.setDepId(request.getStoreId());
        params.setWdzDeptId(request.getStoreId());
        params.setStartTime(LocalDateTime.of(LocalDate.parse(request.getStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(0, 0, 0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        params.setEndTime(LocalDateTime.of(LocalDate.parse(request.getEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(23, 59, 59)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        WanjiResponse res = this.newWanJiOrderForeignService.customersTop10(userInfo.getToken(), params);
        if (res == null || res.getCode() != 0) {
            return ResultUtil.error((Integer)1005, (String)"\u6570\u636e\u5f02\u5e38");
        }
        ArrayList<GetPeopleComeInfoVO> list = new ArrayList<GetPeopleComeInfoVO>();
        if (CollectionUtils.isEmpty((Collection)((Collection)res.getData()))) {
            return ResultUtil.success(list);
        }
        GetPeopleComeInfoVO model = new GetPeopleComeInfoVO();
        for (CustomersTop10VO item : (List)res.getData()) {
            model = new GetPeopleComeInfoVO();
            model.setIcon(item.getAvatarUrl());
            model.setUserName(item.getNickName());
            model.setPhone(this.common.getPhone(item.getPhone()));
            model.setCount(item.getVisitCount());
            list.add(model);
        }
        return ResultUtil.success(list);
    }

    @Override
    public String cleanWatchTime() {
        List clientStoreList = this.cloudClientStoreDao.selectList((Wrapper)new LambdaQueryWrapper().eq(CloudClientStoreDO::getStatus, (Object)1));
        for (CloudClientStoreDO item : clientStoreList) {
            Long watchTime = TimeService.computeTime((String)item.getStartTime(), (String)item.getEndTime());
            this.cloudClientStoreDao.updateCloudWatch((String)item.getId(), watchTime);
            log.info("\u66f4\u65b0id{}\u7684\u503c\u5b88\u65f6\u957f\uff1a{}", item.getId(), (Object)watchTime);
        }
        return "\u6210\u529f";
    }

    @Override
    public List<PlatformDepartmentApprovalDO> getApproval(Integer depId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)query.eq(PlatformDepartmentApprovalDO::getDepId, (Object)depId)).orderByAsc(PlatformDepartmentApprovalDO::getId);
        return this.platformDepartmentsApprovalDao.selectList((Wrapper)query);
    }

    @Override
    public void saveApproval(PlatformDepartmentApprovalDO approvalDO) {
        if (approvalDO == null) {
            return;
        }
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        OvoparkUserInfoEntity userData = threadUserDTO.getUserData().getData();
        approvalDO.setUserId(userData.getId());
        approvalDO.setCreateTime(TimeService.getTime());
        approvalDO.setUserName(userData.getUserName());
        log.info("\u4fdd\u5b58\u95e8\u5e97\u8d44\u91d1\u7533\u8bf7\u8bb0\u5f55\uff1a{}", (Object)approvalDO);
        this.platformDepartmentsApprovalDao.insert((Object)approvalDO);
        this.masterStrokeService.updateDutyGuardApplicationStatus(threadUserDTO.getToken(), approvalDO.getDepId(), approvalDO.getApplicationStatus());
        CloudSearchDepartmentsDO departmentsDO = (CloudSearchDepartmentsDO)this.cloudSearchDepartmentsDao.selectById((Serializable)approvalDO.getDepId());
        if (departmentsDO != null) {
            departmentsDO.setActivationStatus(approvalDO.getApplicationStatus());
            departmentsDO.setApplicationStatus(approvalDO.getApplicationStatus());
            this.cloudSearchDepartmentsDao.updateById((Object)departmentsDO);
        }
    }

    @Override
    public void approval(Integer id, Integer status) {
        PlatformDepartmentApprovalDO approvalDO = new PlatformDepartmentApprovalDO();
        approvalDO.setDepId(id);
        approvalDO.setApplicationApply(status);
        this.saveApproval(approvalDO);
    }

    @Override
    public CloudStoreInsuranceVO getStoreInsurance(Integer depId) {
        CloudStoreInsuranceVO result = new CloudStoreInsuranceVO();
        List cloudStoreInsuranceList = this.cloudStoreInsuranceDao.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudStoreInsuranceDO::getStoreId, (Object)depId)).orderByDesc(IdNumEntity::getCreatedTime));
        result.setDepId(depId);
        result.setInsuranceStatus(Integer.valueOf(0));
        if (cloudStoreInsuranceList != null && !cloudStoreInsuranceList.isEmpty()) {
            CloudStoreInsuranceDO cloudStoreInsuranceDO = (CloudStoreInsuranceDO)cloudStoreInsuranceList.get(0);
            if (cloudStoreInsuranceDO.getInsuranceStatus() == 1 || cloudStoreInsuranceDO.getInsuranceStatus() == 2) {
                result.setInsuranceStatus(cloudStoreInsuranceDO.getInsuranceStatus());
            }
            if (cloudStoreInsuranceDO.getInsuranceStatus() == 1) {
                result.setPhone(cloudStoreInsuranceDO.getHolderPhone());
                result.setInsuranceName(cloudStoreInsuranceDO.getInsuranceName());
                result.setPolicyNo(cloudStoreInsuranceDO.getPolicyCode());
                result.setInsuranceStartTime(cloudStoreInsuranceDO.getInsuranceStart());
                result.setInsuranceEndTime(cloudStoreInsuranceDO.getInsuranceEnd());
                HttpResponseEntity masterResponseEntity = this.masterStrokeService.getDepartmentInfoById(null, depId);
                if (masterResponseEntity != null) {
                    GetDepartmentInfoDTO getDepartmentInfo = (GetDepartmentInfoDTO)masterResponseEntity.getData();
                    result.setStoreName(getDepartmentInfo.getName());
                } else {
                    log.error("\u4ece\u4e3b\u7ebf\u4e2d\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5931\u8d25:{}", (Object)masterResponseEntity.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public List<CloudStoreSignVO> queryStoreEventSign() {
        ArrayList<CloudStoreSignVO> result = new ArrayList<CloudStoreSignVO>();
        for (EventMsgEnum item : EventMsgEnum.values()) {
            if (item.getType() == 8) continue;
            CloudStoreSignVO model = new CloudStoreSignVO();
            model.setCode(Integer.valueOf(item.getType()));
            model.setName(item.getName());
            result.add(model);
        }
        return result;
    }

    @Override
    public CloudStoreSettingsVO getStoreSettings(Integer depId) {
        CloudStoreSettingsVO result = new CloudStoreSettingsVO(depId);
        CloudStoreSettingsDO cloudStoreSettings = (CloudStoreSettingsDO)this.cloudStoreSettingsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreSettingsDO::getStoreId, (Object)depId));
        CloudSearchDepartmentsDO cloudSearchDepartments = (CloudSearchDepartmentsDO)this.cloudSearchDepartmentsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudSearchDepartmentsDO::getId, (Object)depId));
        if (cloudStoreSettings != null) {
            result.setDoorStatus(cloudStoreSettings.getDoorStatus());
            result.setDoorCheckStatus(cloudStoreSettings.getDoorCheckStatus());
            result.setRemark(cloudStoreSettings.getRemark());
        }
        if (cloudSearchDepartments != null) {
            result.setBusinessCategory(Integer.valueOf(cloudSearchDepartments.getBusinessCategory()));
            result.setCategoryName(CategoryEnum.getCategoryName((Integer)cloudSearchDepartments.getBusinessCategory()));
            result.setContactPhone(cloudSearchDepartments.getStoreContactPhone());
        }
        return result;
    }

    @Override
    public String updateStoreSettings(CloudStoreSettingsVO cloudStoreSettings) {
        if (cloudStoreSettings.getDepId() == null) {
            throw new CloudWatchException("\u6307\u5b9a\u66f4\u65b0\u95e8\u5e97\u4fe1\u606f");
        }
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        OvoparkUserInfoEntity userData = threadUserDTO.getUserData().getData();
        CloudStoreSettingsDO cloudStore = (CloudStoreSettingsDO)this.cloudStoreSettingsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreSettingsDO::getStoreId, (Object)cloudStoreSettings.getDepId()));
        if (cloudStore != null) {
            this.cloudStoreSettingsDao.updateStoreStatus((Integer)cloudStore.getId(), cloudStoreSettings.getDoorStatus(), cloudStoreSettings.getDoorCheckStatus(), userData.getUserName(), cloudStoreSettings.getRemark(), null);
        } else {
            cloudStore = new CloudStoreSettingsDO();
            cloudStore.setStoreId(cloudStoreSettings.getDepId());
            cloudStore.setDoorStatus(cloudStoreSettings.getDoorStatus());
            cloudStore.setDoorCheckStatus(cloudStoreSettings.getDoorCheckStatus());
            cloudStore.setCreateBy(userData.getUserName());
            cloudStore.setRemark(cloudStoreSettings.getRemark());
            this.cloudStoreSettingsDao.insert((Object)cloudStore);
        }
        return "\u6210\u529f";
    }

    @Override
    public CloudStoreCrmContractVO getCrmContract(Integer depId) {
        CloudStoreCrmContractVO result = new CloudStoreCrmContractVO();
        result.setStoreId(depId);
        result.setStatus(Integer.valueOf(0));
        CloudStoreSettingsDO cloudStoreSettings = (CloudStoreSettingsDO)this.cloudStoreSettingsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreSettingsDO::getStoreId, (Object)depId));
        if (cloudStoreSettings != null) {
            result.setStatus(cloudStoreSettings.getContractStatus());
        }
        return result;
    }

    @Override
    public PageInfo<CloudStorePermissionVO> getPermissionsStore(CloudStorePermissionQuery query) {
        HttpResponseEntity responseEntity;
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        String token = threadUserDTO.getToken();
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new CloudWatchException("\u65e0token\u4fe1\u606f");
        }
        if (threadUserDTO.getUserData().getData().getGroupId() != null) {
            query.setGroupId(threadUserDTO.getUserData().getData().getGroupId());
        }
        if ((responseEntity = this.masterStrokeService.getGuardConfigDepartments(token, query.getName(), query.getGroupId())).getIsError().booleanValue()) {
            log.error("\u4e3b\u7ebf\u63a5\u53e3\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5931\u8d25:{}", (Object)responseEntity.getMessage());
            throw new CloudWatchException("\u4e3b\u7ebf\u63a5\u53e3\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5931\u8d25");
        }
        List pageInfo = (List)responseEntity.getData();
        PageInfo result = new PageInfo();
        List list = new ArrayList();
        if (pageInfo == null) {
            result.setTotal(Integer.valueOf(pageInfo.size()));
            result.setPages(Integer.valueOf(1));
            result.setCurrent(Integer.valueOf(1));
            result.setSize(Integer.valueOf(pageInfo.size()));
            result.setRecords(new ArrayList());
            return result;
        }
        result.setTotal(Integer.valueOf(pageInfo.size()));
        result.setPages(Integer.valueOf(1));
        result.setCurrent(Integer.valueOf(1));
        result.setSize(Integer.valueOf(pageInfo.size()));
        list = pageInfo;
        ArrayList<CloudStorePermissionVO> data = new ArrayList<CloudStorePermissionVO>();
        if (list != null && !list.isEmpty()) {
            List storeId = list.stream().map(GetDepartmentInfoDTO::getId).collect(Collectors.toList());
            List cloudSearchDepartments = this.cloudSearchDepartmentsDao.selectList((Wrapper)new LambdaQueryWrapper().in(CloudSearchDepartmentsDO::getId, storeId));
            Map<Integer, CloudSearchDepartmentsDO> cloudSearchDepartmentsMap = cloudSearchDepartments.stream().collect(Collectors.toMap(CloudSearchDepartmentsDO::getId, item -> item));
            for (GetDepartmentInfoDTO item2 : list) {
                CloudStorePermissionVO model = new CloudStorePermissionVO();
                model.setId(item2.getId());
                model.setName(item2.getName());
                if (cloudSearchDepartmentsMap.containsKey(item2.getId())) {
                    model.setCategoryId(Integer.valueOf(cloudSearchDepartmentsMap.get(item2.getId()).getBusinessCategory()));
                    model.setCategoryName(CategoryEnum.getCategoryName((Integer)cloudSearchDepartmentsMap.get(item2.getId()).getBusinessCategory()));
                }
                data.add(model);
            }
        }
        result.setRecords(data);
        return result;
    }

    @Override
    public CloudStoreDoorVO getStoreDoor(Integer depId) {
        CloudStoreDoorVO result = new CloudStoreDoorVO();
        List<Object> deviceList = this.shopWebCommon.getAllDeviceList(depId, null);
        deviceList = deviceList.stream().filter(item -> item.getDtype().compareTo(302) == 0).collect(Collectors.toList());
        result.setDoorNum(Integer.valueOf(deviceList.size()));
        LinkedList<CloudStoreDoorVO.DoorInfoVO> doorInfo = new LinkedList<CloudStoreDoorVO.DoorInfoVO>();
        for (YzsDeviceFeignVo yzsDeviceFeignVo : deviceList) {
            CloudStoreDoorVO.DoorInfoVO doorInfoVO = new CloudStoreDoorVO.DoorInfoVO();
            doorInfoVO.setIndex(yzsDeviceFeignVo.getIndex());
            doorInfo.add(doorInfoVO);
        }
        result.setDoorInfo(doorInfo);
        return result;
    }

    @Override
    public CloudPaymentContractVO getPaymentContract(Integer depId) {
        CloudPaymentContractVO result = new CloudPaymentContractVO();
        result.setStoreId(depId);
        CloudStoreContractDO cloudStoreContract = (CloudStoreContractDO)this.cloudStoreContractDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudStoreContractDO::getStoreId, (Object)depId)).eq(CloudStoreContractDO::getRowStatus, (Object)1));
        if (cloudStoreContract != null) {
            result.setMerchantNo(cloudStoreContract.getMerchantNo());
            result.setAgreementSignUrl(cloudStoreContract.getAgreementSignUrl());
            result.setWeixinAuth(cloudStoreContract.getWeixinAuth());
            result.setAlipayAuth(cloudStoreContract.getAlipayAuth());
            if (result.getWeixinAuth() == 0 || result.getAlipayAuth() == 0) {
                YibaoAuthDTO yibaoAuth = this.cloudForeignService.getYibaoAuth(cloudStoreContract.getMerchantNo());
                Integer weixinChange = null;
                Integer alipayChange = null;
                if (!Objects.equals(result.getAlipayAuth(), yibaoAuth.getAlipayAuth())) {
                    result.setAlipayAuth(yibaoAuth.getAlipayAuth());
                    alipayChange = result.getAlipayAuth();
                }
                if (!Objects.equals(result.getWeixinAuth(), yibaoAuth.getWeixinAuth())) {
                    result.setWeixinAuth(yibaoAuth.getWeixinAuth());
                    weixinChange = result.getWeixinAuth();
                }
                if (weixinChange != null || alipayChange != null) {
                    this.cloudStoreContractDao.updateAuth((Long)cloudStoreContract.getId(), weixinChange, alipayChange);
                }
            }
            result.setSignStatus(cloudStoreContract.getYibaoSign());
        }
        return result;
    }

    @Override
    public Integer getDurationStoreDuty(Integer depId) {
        List cloudClientStoreDOS = this.cloudClientStoreDao.selectList((Wrapper)new LambdaQueryWrapper().eq(CloudClientStoreDO::getStoreId, (Object)String.valueOf(depId)));
        int hours = 0;
        for (CloudClientStoreDO cloudClientStoreDO : cloudClientStoreDOS) {
            if (cloudClientStoreDO.getStartTime() != null && cloudClientStoreDO.getEndTime() == null) {
                String now = LocalDateTime.now(ZoneId.of("Asia/Shanghai")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                cloudClientStoreDO.setEndTime(now);
            }
            String startTime = cloudClientStoreDO.getStartTime();
            String endTime = cloudClientStoreDO.getEndTime();
            if (!StringUtils.isNotEmpty((CharSequence)startTime) || !StringUtils.isNotEmpty((CharSequence)endTime)) continue;
            LocalDateTime start = LocalDateTime.parse(startTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            LocalDateTime end = LocalDateTime.parse(endTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            hours = (int)Duration.between(start, end).toHours();
        }
        return hours;
    }

    @Override
    public IPage<CloudSearchDepartmentsDO> getCloudSearchDepartments(DutyDepartmentQuery query) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(query.getEnterpriseId() != null, CloudSearchDepartmentsDO::getEnterpriseId, (Object)query.getEnterpriseId());
        queryWrapper.like(StringUtils.isNotEmpty((CharSequence)query.getDepName()), CloudSearchDepartmentsDO::getName, (Object)query.getDepName());
        queryWrapper.eq(query.getBusinessCategory() != null, CloudSearchDepartmentsDO::getBusinessCategory, (Object)query.getBusinessCategory());
        queryWrapper.eq(query.getDutyGuardServiceOn() != null, CloudSearchDepartmentsDO::getDutyGuardServiceOn, (Object)query.getDutyGuardServiceOn());
        queryWrapper.eq(query.getIsOnDutyGuard() != null, CloudSearchDepartmentsDO::getIsOnDutyGuard, (Object)query.getIsOnDutyGuard());
        queryWrapper.or(StringUtils.isNotEmpty((CharSequence)query.getShopManager()), wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(CloudSearchDepartmentsDO::getShopManager, (Object)query.getShopManager())).like(CloudSearchDepartmentsDO::getShopManagerPhone, (Object)query.getShopManager());
        });
        Page page = new Page((long)query.getPageNum().intValue(), (long)query.getPageSize().intValue());
        IPage result = this.cloudSearchDepartmentsDao.selectPage((IPage)page, (Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)result.getRecords())) {
            return result;
        }
        Map<Integer, String> enterpriseNameMap = this.getEnterpriseNameMap(result.getRecords().stream().map(item -> item.getEnterpriseId()).distinct().collect(Collectors.toList()));
        result.getRecords().forEach(item -> {
            item.setEnterpriseName((String)enterpriseNameMap.get(item.getEnterpriseId()));
            item.setBusinessCategoryName(CategoryEnum.getCategoryName((Integer)item.getBusinessCategory()));
        });
        return result;
    }

    public Map<Integer, String> getEnterpriseNameMap(List<Integer> enterpriseIds) {
        HttpResponseEntity baseResult = this.masterStrokeService.getEnterpriseByIdsApi(enterpriseIds);
        Map<Integer, String> enterpriseMap = new HashMap<Integer, String>();
        if (!CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            enterpriseMap = ((List)baseResult.getData()).stream().collect(Collectors.toMap(EnterpriseConfigPojo::getId, EnterpriseConfigPojo::getName));
        }
        return enterpriseMap;
    }

    @Override
    public List<CloudSearchDepartmentsDO> getDepartmentsByStatus(DutyDepartmentQuery query) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(query.getEnterpriseId() != null, CloudSearchDepartmentsDO::getEnterpriseId, (Object)query.getEnterpriseId());
        queryWrapper.like(StringUtils.isNotEmpty((CharSequence)query.getDepName()), CloudSearchDepartmentsDO::getName, (Object)query.getDepName());
        queryWrapper.eq(query.getBusinessCategory() != null, CloudSearchDepartmentsDO::getBusinessCategory, (Object)query.getBusinessCategory());
        queryWrapper.eq(query.getDutyGuardServiceOn() != null, CloudSearchDepartmentsDO::getDutyGuardServiceOn, (Object)query.getDutyGuardServiceOn());
        queryWrapper.eq(query.getIsOnDutyGuard() != null, CloudSearchDepartmentsDO::getIsOnDutyGuard, (Object)query.getIsOnDutyGuard());
        queryWrapper.eq(query.getActivationStatus() != null, CloudSearchDepartmentsDO::getActivationStatus, (Object)query.getActivationStatus());
        queryWrapper.or(StringUtils.isNotEmpty((CharSequence)query.getShopManager()), wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(CloudSearchDepartmentsDO::getShopManager, (Object)query.getShopManager())).like(CloudSearchDepartmentsDO::getShopManagerPhone, (Object)query.getShopManager());
        });
        return this.cloudSearchDepartmentsDao.selectList((Wrapper)queryWrapper);
    }
}

