/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.cloud.BO.GoodsOrderInfoBO;
import com.ovopark.cloud.BO.SummarizeBO;
import com.ovopark.cloud.DTO.BuyerDTO;
import com.ovopark.cloud.DTO.ChartDataDTO;
import com.ovopark.cloud.DTO.CloudReceiverDTO;
import com.ovopark.cloud.DTO.CloudWatchStoreNumDTO;
import com.ovopark.cloud.DTO.GetOrderDetailDTO;
import com.ovopark.cloud.DTO.GetOrderListDTO;
import com.ovopark.cloud.DTO.GetUserIdDTO;
import com.ovopark.cloud.DTO.OrderBuyerDTO;
import com.ovopark.cloud.DTO.OrderDeviceDTO;
import com.ovopark.cloud.DTO.OrderGoodsDetailDTO;
import com.ovopark.cloud.DTO.OrderGoodsInfoDTO;
import com.ovopark.cloud.DTO.OrderInfoDTO;
import com.ovopark.cloud.DTO.ReceiverInfoDTO;
import com.ovopark.cloud.DTO.SummarizeTimeDTO;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.VO.GetCloudServiceOrderBaseInfoVO;
import com.ovopark.cloud.VO.GetDepartmentReportMoneyAllVO;
import com.ovopark.cloud.VO.GetDepartmentReportMoneyVO;
import com.ovopark.cloud.VO.GetDepartmentReportOrderCountAllVO;
import com.ovopark.cloud.VO.GetDepartmentReportOrderCountVO;
import com.ovopark.cloud.VO.GetDepartmentReportOverviewVO;
import com.ovopark.cloud.VO.GetGoodsOrderInfoVO;
import com.ovopark.cloud.VO.GetOrderDetailInfoVO;
import com.ovopark.cloud.VO.GetOrderDetailVO;
import com.ovopark.cloud.VO.GetOrderListVo;
import com.ovopark.cloud.VO.GoodsTop10VO;
import com.ovopark.cloud.VO.NewQueryOrderListVO;
import com.ovopark.cloud.VO.NewQueryOrderVO;
import com.ovopark.cloud.VO.OrderChartVO;
import com.ovopark.cloud.VO.OrderStatisticsVO;
import com.ovopark.cloud.VO.PlatFormOrderVO;
import com.ovopark.cloud.VO.PosRecordDeviceVO;
import com.ovopark.cloud.VO.SummarizeVO;
import com.ovopark.cloud.base.PageInfo;
import com.ovopark.cloud.base.ResponseBaseParent;
import com.ovopark.cloud.base.WanjiResponse;
import com.ovopark.cloud.callCenter.CallCenterForeignService;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.Result;
import com.ovopark.cloud.common.ResultUtil;
import com.ovopark.cloud.common.TimeService;
import com.ovopark.cloud.dao.state.CloudDeviceIpcSignDao;
import com.ovopark.cloud.dao.state.CloudSearchHistoryDao;
import com.ovopark.cloud.entity.CloudDeviceIpcSignDO;
import com.ovopark.cloud.entity.CloudSearchHistoryDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.pos.ShopwebPosForeignService;
import com.ovopark.cloud.query.CloudWatchStoreQuery;
import com.ovopark.cloud.query.GetCloudServiceOrderBaseInfoQuery;
import com.ovopark.cloud.query.GetDepartmentReportQuery;
import com.ovopark.cloud.query.GetGoodsOrderInfoQuery;
import com.ovopark.cloud.query.GetOrderDetailQuery;
import com.ovopark.cloud.query.GetOrderListQuery;
import com.ovopark.cloud.query.NewQueryOrderQuery;
import com.ovopark.cloud.query.PlatFormOrderQueryReq;
import com.ovopark.cloud.query.PosRecordQuery;
import com.ovopark.cloud.service.OrderService;
import com.ovopark.cloud.utils.Common;
import com.ovopark.cloud.utils.OnDutyCommon;
import com.ovopark.cloud.utils.OrderCommon;
import com.ovopark.cloud.wanji.NewWanJiOrderForeignService;
import com.ovopark.cloud.wanji.WanJiOrderForeignService;
import com.ovopark.cloud.watch.WatchForeignService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired(required=false)
    private WanJiOrderForeignService wanJiOrderForeignService;
    @Autowired(required=false)
    private CallCenterForeignService callCenterForeignService;
    @Autowired(required=false)
    private CloudSearchHistoryDao cloudSearchHistoryDao;
    @Autowired(required=false)
    private OrderCommon orderCommon;
    @Autowired(required=false)
    private OnDutyCommon onDutyCommon;
    @Autowired(required=false)
    private NewWanJiOrderForeignService newWanJiOrderForeignService;
    @Autowired
    private WatchForeignService watchForeignService;
    @Autowired
    private ShopwebPosForeignService shopwebPosForeignService;
    @Autowired
    private CloudDeviceIpcSignDao cloudDeviceIpcSignDao;
    @Autowired(required=false)
    private Common common;

    @Override
    public Result<List<GetOrderListVo>> getOrderList(GetOrderListQuery request) {
        ResponseBaseParent result = this.wanJiOrderForeignService.queryOrder(request);
        if (result == null || result.getCode() != 0) {
            return ResultUtil.error((Integer)1001, (String)(result == null ? "\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38" : result.getMessage()));
        }
        ArrayList<GetOrderListVo> response = new ArrayList<GetOrderListVo>();
        GetOrderListVo model = new GetOrderListVo();
        for (GetOrderListDTO item : (List)result.getData()) {
            model = new GetOrderListVo();
            model.setOrderSn(item.getOrderSn());
            model.setCreateTime(item.getCreateTime());
            model.setCustomer(item.getCustomer());
            model.setOrderGoodsDTOList(item.getOrderGoodsDTOList());
            response.add(model);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getKeyWord())) {
            ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(CloudSearchHistoryDO::getUserId, (Object)threadUserDTO.getUserData().getData().getId());
            query.eq(CloudSearchHistoryDO::getType, (Object)1);
            query.last(" limit 10 ");
            List list = this.cloudSearchHistoryDao.selectList((Wrapper)query);
            if (CollectionUtils.isEmpty((Collection)list)) {
                CloudSearchHistoryDO info = new CloudSearchHistoryDO();
                info.setUserId(threadUserDTO.getUserData().getData().getId());
                info.setContent(request.getKeyWord());
                info.setType(Integer.valueOf(1));
                this.cloudSearchHistoryDao.insert((Object)info);
            }
        }
        return ResultUtil.success(response);
    }

    @Override
    public Result<GetOrderDetailVO> getOrderDetail(String orderNo) {
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        GetOrderDetailQuery request = new GetOrderDetailQuery();
        request.setOrderNo(orderNo);
        request.setWdzEntId(threadUserDTO.getUserData().getData().getGroupId().toString());
        ResponseBaseParent result = this.wanJiOrderForeignService.queryOrderDetail(request);
        if (result == null || result.getCode() != 0) {
            return ResultUtil.error((Integer)1001, (String)(result == null ? "\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38" : result.getMessage()));
        }
        GetOrderDetailVO response = new GetOrderDetailVO();
        if (((GetOrderDetailDTO)result.getData()).getOrderInfo() != null) {
            OrderInfoDTO orderInfo = ((GetOrderDetailDTO)result.getData()).getOrderInfo();
            response.setOrderSn(orderInfo.getOrderSn());
            response.setStoreName(orderInfo.getStoreName());
            response.setTotalGoodsPrice(orderInfo.getTotalGoodsPrice());
            response.setTotalPrice(orderInfo.getTotalPrice());
            response.setOrderStatus(orderInfo.getOrderStatus());
            response.setPayStatus(orderInfo.getPayStatus());
            response.setPayType(orderInfo.getPayType());
            response.setCreateTime(orderInfo.getCreateTime());
            response.setPaymentTime(orderInfo.getPaymentTime());
            try {
                ResponseBaseParent callInfo = this.callCenterForeignService.getUserServiceRecord(orderInfo.getOrderSn());
                if (callInfo != null && callInfo.getCode() == 0 && !CollectionUtils.isEmpty((Collection)((Collection)callInfo.getData())) && StringUtils.isNotEmpty((CharSequence)((GetUserIdDTO)((List)callInfo.getData()).get(0)).getServiceUserName())) {
                    response.setServicePeople(((GetUserIdDTO)((List)callInfo.getData()).get(0)).getServiceUserName());
                    response.setEntryTime(((GetUserIdDTO)((List)callInfo.getData()).get(0)).getEntryTime());
                    response.setDepartureTime(((GetUserIdDTO)((List)callInfo.getData()).get(0)).getDepartureTime());
                }
            }
            catch (Exception ex) {
                log.error("\u83b7\u53d6\u503c\u5b88\u4eba\u5458\u5f02\u5e38, ex: {}", (Object)ex.toString());
            }
        }
        if (((GetOrderDetailDTO)result.getData()).getOrderBuyerDto() != null) {
            OrderBuyerDTO orderBuyer = ((GetOrderDetailDTO)result.getData()).getOrderBuyerDto();
            BuyerDTO buyer = new BuyerDTO();
            buyer.setName(orderBuyer.getName());
            buyer.setPhone(orderBuyer.getPhone());
            response.setBuyer(buyer);
        }
        if (((GetOrderDetailDTO)result.getData()).getCloudReceiverDto() != null) {
            CloudReceiverDTO cloudReceiver = ((GetOrderDetailDTO)result.getData()).getCloudReceiverDto();
            ReceiverInfoDTO receiver = new ReceiverInfoDTO();
            receiver.setName(cloudReceiver.getName());
            receiver.setPhone(cloudReceiver.getPhone());
            receiver.setAddressDetail(cloudReceiver.getAddressDetail());
            response.setCloudReceiver(receiver);
        }
        ArrayList<OrderGoodsInfoDTO> orderList = new ArrayList<OrderGoodsInfoDTO>();
        OrderGoodsInfoDTO goodsModel = new OrderGoodsInfoDTO();
        if (!CollectionUtils.isEmpty((Collection)((GetOrderDetailDTO)result.getData()).getOrderGoodsDtoList())) {
            List orderGoodsDtoList = ((GetOrderDetailDTO)result.getData()).getOrderGoodsDtoList();
            for (OrderGoodsDetailDTO item : orderGoodsDtoList) {
                goodsModel = new OrderGoodsInfoDTO();
                goodsModel.setGoodsId(item.getGoodsId());
                goodsModel.setName(item.getName());
                goodsModel.setImg(item.getImg());
                goodsModel.setGoodsPrice(item.getGoodsPrice());
                goodsModel.setQuantity(item.getQuantity());
                goodsModel.setPreferentialDeductionPrice(item.getPreferentialDeductionPrice());
                goodsModel.setAllTotalPrice(item.getAllTotalPrice());
                goodsModel.setTotalPrice(item.getTotalPrice());
                goodsModel.setActualPrice(item.getActualPrice());
                orderList.add(goodsModel);
            }
            response.setOrderList(orderList);
        }
        return ResultUtil.success((Object)response);
    }

    @Override
    public Result<GetCloudServiceOrderBaseInfoVO> getCloudServiceOrderBaseInfo(GetCloudServiceOrderBaseInfoQuery request) {
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)request.getWdzEntId())) {
            return ResultUtil.error((Integer)1002, (String)"\u8bf7\u6838\u5b9e\u8d26\u53f7\u6240\u5c5e\u4f01\u4e1a");
        }
        if (StringUtils.isEmpty((CharSequence)request.getOrders())) {
            return ResultUtil.error((Integer)1003, (String)"\u8bf7\u9009\u62e9\u5177\u4f53\u8ba2\u5355");
        }
        ArrayList<Future> resultList = new ArrayList<Future>();
        for (String string : request.getOrders().split(",")) {
            GetOrderDetailQuery params = new GetOrderDetailQuery();
            params.setOrderNo(string);
            params.setWdzEntId(request.getWdzEntId());
            Future result = this.wanJiOrderForeignService.queryOrderDetailAsync(params);
            resultList.add(result);
        }
        GetCloudServiceOrderBaseInfoVO response = new GetCloudServiceOrderBaseInfoVO();
        if (CollectionUtils.isEmpty(resultList)) {
            return ResultUtil.success((Object)response);
        }
        BigDecimal totalPrice = new BigDecimal(0);
        for (Future future : resultList) {
            OrderInfoDTO orderInfo;
            if (future == null || future.get() == null || ((ResponseBaseParent)future.get()).getCode() != 200 || ((ResponseBaseParent)future.get()).getData() == null) continue;
            if (response.getUserId() == null) {
                OrderBuyerDTO orderBuyer = ((GetOrderDetailDTO)((ResponseBaseParent)future.get()).getData()).getOrderBuyerDto();
                response.setUserId(orderBuyer.getUserId());
                response.setName(orderBuyer.getName());
                response.setPhone(orderBuyer.getPhone());
            }
            if ((orderInfo = ((GetOrderDetailDTO)((ResponseBaseParent)future.get()).getData()).getOrderInfo()) == null || orderInfo.getPayStatus() != 2) continue;
            totalPrice = totalPrice.add(orderInfo.getTotalPrice());
        }
        response.setTotalPrice(totalPrice);
        return ResultUtil.success((Object)response);
    }

    @Override
    public Result<NewQueryOrderListVO> newQueryOrder(NewQueryOrderQuery request) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1001, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        if ((request.getYear() == null || request.getMonth() == null) && (StringUtils.isEmpty((CharSequence)request.getStartTime()) || StringUtils.isEmpty((CharSequence)request.getEndTime()))) {
            return ResultUtil.error((Integer)1002, (String)"\u6307\u5b9a\u5b8c\u6574\u7684\u65f6\u95f4\u53c2\u6570");
        }
        request.setQueryStatus("1");
        if (StringUtils.isEmpty((CharSequence)request.getStartTime()) && StringUtils.isEmpty((CharSequence)request.getEndTime())) {
            request.setStartTime(TimeService.getMonthFirstDay((int)request.getYear(), (int)request.getMonth()));
            request.setEndTime(TimeService.getMonthEndDay((int)request.getYear(), (int)request.getMonth()));
        }
        PageInfo<NewQueryOrderVO> res = this.orderCommon.getOrderList(userInfo.getToken(), request, userInfo.getPlatform());
        SummarizeBO summarizeBO = new SummarizeBO();
        summarizeBO.setWdzDeptId(Integer.valueOf(request.getWdzDeptId()));
        SummarizeTimeDTO summarizeTimeDTO = new SummarizeTimeDTO();
        summarizeTimeDTO.setStartTime(request.getStartTime());
        summarizeTimeDTO.setEndTime(request.getEndTime());
        summarizeBO.setTimeRanges(Collections.singletonList(summarizeTimeDTO));
        WanjiResponse<List<SummarizeVO>> wanjiResponse = this.orderCommon.summarize(summarizeBO, userInfo.getToken(), userInfo.getPlatform());
        if (wanjiResponse.getIsError().booleanValue()) {
            return ResultUtil.error((Integer)1003, (String)"\u83b7\u53d6\u9500\u552e\u989d\u51fa\u9519");
        }
        List data = (List)wanjiResponse.getData();
        if (data.isEmpty()) {
            return ResultUtil.error((Integer)1003, (String)"\u83b7\u53d6\u9500\u552e\u989d\u51fa\u9519");
        }
        SummarizeVO summarizeVO = (SummarizeVO)data.get(0);
        NewQueryOrderListVO result = new NewQueryOrderListVO(request.getStartTime(), request.getEndTime(), summarizeVO.getTotalPayAmount(), request.getYear(), request.getMonth());
        result.setTotal(res.getTotal());
        result.setOrderList(res.getRecords());
        result.setPages(res.getPages());
        result.setSize(res.getSize());
        result.setCurrent(res.getCurrent());
        return ResultUtil.success((Object)result);
    }

    @Override
    public Result<PageInfo<PlatFormOrderVO>> platformQueryOrder(PlatFormOrderQueryReq request) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1001, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        PageInfo<PlatFormOrderVO> res = this.orderCommon.getPlatformOrderList(userInfo.getToken(), request);
        if (CollectionUtils.isEmpty((Collection)res.getRecords())) {
            res.getRecords().stream().forEach(item -> item.setUserPhone(this.common.getPhone(item.getUserPhone())));
        }
        return ResultUtil.success(res);
    }

    @Override
    public Result<GetOrderDetailInfoVO> getOrderDetailInfo(String orderSn, Integer depId) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1001, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)orderSn)) {
            return ResultUtil.error((Integer)1002, (String)"\u7f3a\u5c11\u8ba2\u5355\u4fe1\u606f");
        }
        if (depId == null) {
            return ResultUtil.error((Integer)1004, (String)"\u7f3a\u5c11\u90e8\u95e8id");
        }
        GetOrderDetailInfoVO result = this.orderCommon.getOrderDetailInfo(userInfo.getToken(), orderSn, userInfo.getPlatform());
        if (result == null) {
            return ResultUtil.error((Integer)1003, (String)"\u8ba2\u5355\u83b7\u53d6\u5f02\u5e38");
        }
        ArrayList<Object> deviceList = new ArrayList<Object>();
        List cloudDevice = this.cloudDeviceIpcSignDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1)).eq(CloudDeviceIpcSignDO::getDeviceType, (Object)21)).eq(CloudDeviceIpcSignDO::getStoreId, (Object)depId));
        Set deviceIdSet = cloudDevice.stream().map(CloudDeviceIpcSignDO::getDeviceId).collect(Collectors.toSet());
        Integer cashDevice = cloudDevice.stream().filter(item -> item.getCashDeviceSign() == 1).findFirst().map(CloudDeviceIpcSignDO::getDeviceId).orElse(null);
        List<Object> device = this.onDutyCommon.getDeviceVideo(depId, userInfo.getUserData().getData().getId());
        device = device.stream().filter(item -> deviceIdSet.contains(item.getDeviceStatusId())).collect(Collectors.toList());
        if (cashDevice != null) {
            Integer pos = null;
            for (int index = 0; index < device.size(); ++index) {
                if (!Objects.equals(((OrderDeviceDTO)device.get(index)).getDeviceStatusId(), cashDevice)) continue;
                pos = index;
                break;
            }
            if (pos != null) {
                OrderDeviceDTO cashDeviceDto = (OrderDeviceDTO)device.get(pos);
                device.set(pos, device.get(0));
                device.set(0, cashDeviceDto);
            }
        }
        if (!device.isEmpty()) {
            deviceList.addAll(device);
            PosRecordQuery query = new PosRecordQuery();
            query.setDepId(depId);
            query.setTicketId(orderSn);
            try {
                HttpResponseEntity responseEntity = this.shopwebPosForeignService.getCloudRecordByTicket(userInfo.getToken(), query);
                if (responseEntity != null && responseEntity.getData() != null) {
                    List data = (List)responseEntity.getData();
                    Map<Integer, String> deviceVideoMap = data.stream().collect(Collectors.toMap(PosRecordDeviceVO::getDeviceId, PosRecordDeviceVO::getRecordUrl));
                    for (int index = 0; index < deviceList.size(); ++index) {
                        OrderDeviceDTO orderDeviceDTO = (OrderDeviceDTO)deviceList.get(index);
                        String videoUrl = deviceVideoMap.get(orderDeviceDTO.getDeviceId());
                        if (StringUtils.isNotEmpty((CharSequence)videoUrl)) {
                            orderDeviceDTO.setVideoUrl(videoUrl);
                        }
                        deviceList.set(index, orderDeviceDTO);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4e91\u5f55\u50cf\u5931\u8d25", (Throwable)e);
            }
        }
        result.setDeviceList(deviceList);
        return ResultUtil.success((Object)result);
    }

    @Override
    public Result<List<GetGoodsOrderInfoVO>> getGoodsOrderInfo(GetGoodsOrderInfoQuery request) {
        ThreadUserDTO userInfo;
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        if (request.getStoreId() == null) {
            return ResultUtil.error((Integer)1002, (String)"\u8bf7\u9009\u62e9\u95e8\u5e97");
        }
        if (StringUtils.isEmpty((CharSequence)request.getStart()) || StringUtils.isEmpty((CharSequence)request.getEnd())) {
            return ResultUtil.error((Integer)1003, (String)"\u8bf7\u9009\u62e9\u65f6\u95f4");
        }
        if (request.getOrderType() == null) {
            request.setOrderType(Integer.valueOf(0));
        }
        if ((userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo")) == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1004, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        GoodsOrderInfoBO params = new GoodsOrderInfoBO();
        params.setQueryType(request.getOrderType());
        params.setDepId(request.getStoreId());
        params.setWdzDeptId(request.getStoreId());
        String startTime = !request.getStart().contains(":") ? LocalDateTime.of(LocalDate.parse(request.getStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(0, 0, 0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : request.getStart();
        String endTime = !request.getEnd().contains(":") ? LocalDateTime.of(LocalDate.parse(request.getEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(23, 59, 59)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : request.getEnd();
        params.setStartTime(startTime);
        params.setEndTime(endTime);
        WanjiResponse res = this.newWanJiOrderForeignService.goodsTop10(userInfo.getToken(), params);
        if (res == null || res.getCode() != 0) {
            return ResultUtil.error((Integer)1005, (String)"\u8ba2\u5355\u5f02\u5e38");
        }
        ArrayList<GetGoodsOrderInfoVO> list = new ArrayList<GetGoodsOrderInfoVO>();
        if (CollectionUtils.isEmpty((Collection)((Collection)res.getData()))) {
            return ResultUtil.success(list);
        }
        GetGoodsOrderInfoVO model = new GetGoodsOrderInfoVO();
        for (GoodsTop10VO item : (List)res.getData()) {
            model = new GetGoodsOrderInfoVO();
            model.setName(item.getName());
            model.setImg(item.getImg());
            model.setQuantity(item.getSalesCount());
            list.add(model);
        }
        return ResultUtil.success(list);
    }

    @Override
    public Result<GetDepartmentReportOverviewVO> getDepartmentReportOverview(GetDepartmentReportQuery request) {
        CloudWatchStoreQuery query;
        HttpResponseEntity responseEntity;
        ThreadUserDTO userInfo;
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        if (request.getStoreId() == null) {
            return ResultUtil.error((Integer)1002, (String)"\u8bf7\u9009\u62e9\u95e8\u5e97");
        }
        if (StringUtils.isEmpty((CharSequence)request.getStart()) || StringUtils.isEmpty((CharSequence)request.getEnd())) {
            return ResultUtil.error((Integer)1003, (String)"\u8bf7\u9009\u62e9\u65f6\u95f4");
        }
        if (request.getOrderType() == null) {
            request.setOrderType(Integer.valueOf(0));
        }
        if ((userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo")) == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1004, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        String startTime = LocalDateTime.of(LocalDate.parse(request.getStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(0, 0, 0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String endTime = LocalDateTime.of(LocalDate.parse(request.getEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(23, 59, 59)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        GoodsOrderInfoBO params = new GoodsOrderInfoBO();
        params.setQueryType(request.getOrderType());
        params.setDepId(request.getStoreId());
        params.setWdzDeptId(request.getStoreId());
        params.setStartTime(startTime);
        params.setEndTime(endTime);
        WanjiResponse res = this.newWanJiOrderForeignService.orderStatistics(userInfo.getToken(), params);
        if (res == null || res.getCode() != 0 || res.getData() == null) {
            return ResultUtil.error((Integer)1005, (String)"\u8ba2\u5355\u5f02\u5e38");
        }
        GetDepartmentReportOverviewVO result = new GetDepartmentReportOverviewVO();
        result.setInStoreCount(Integer.valueOf(0));
        result.setOrderCount(((OrderStatisticsVO)res.getData()).getOrderCount());
        result.setSales(((OrderStatisticsVO)res.getData()).getTotalRevenue());
        result.setOrderGoodsCount(((OrderStatisticsVO)res.getData()).getTotalSales());
        if (request.getOrderType() != 2 && (responseEntity = this.watchForeignService.getServiceRecordEnterStore(query = new CloudWatchStoreQuery(request.getStoreId(), startTime, endTime))) != null && responseEntity.getCode() == 0 && !CollectionUtils.isEmpty((Collection)((Collection)responseEntity.getData()))) {
            CloudWatchStoreNumDTO.StoreNumDTO watchStoreNumDTO = ((CloudWatchStoreNumDTO)((List)responseEntity.getData()).get(0)).getGetServiceRecordEnterStore();
            result.setInStoreCount(watchStoreNumDTO.getEnterStoreTimes());
        }
        return ResultUtil.success((Object)result);
    }

    @Override
    public Result<GetDepartmentReportMoneyAllVO> getDepartmentReportMoney(GetDepartmentReportQuery request) {
        ThreadUserDTO userInfo;
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        if (request.getStoreId() == null) {
            return ResultUtil.error((Integer)1002, (String)"\u8bf7\u9009\u62e9\u95e8\u5e97");
        }
        if (StringUtils.isEmpty((CharSequence)request.getStart()) || StringUtils.isEmpty((CharSequence)request.getEnd())) {
            return ResultUtil.error((Integer)1003, (String)"\u8bf7\u9009\u62e9\u65f6\u95f4");
        }
        if (request.getOrderType() == null) {
            request.setOrderType(Integer.valueOf(0));
        }
        if ((userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo")) == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1004, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        String startTime = LocalDateTime.of(LocalDate.parse(request.getStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(0, 0, 0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String endTime = LocalDateTime.of(LocalDate.parse(request.getEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(23, 59, 59)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        GoodsOrderInfoBO params = new GoodsOrderInfoBO();
        params.setQueryType(request.getOrderType());
        params.setDepId(request.getStoreId());
        params.setWdzDeptId(request.getStoreId());
        params.setStartTime(startTime);
        params.setEndTime(endTime);
        WanjiResponse res = this.newWanJiOrderForeignService.orderChart(userInfo.getToken(), params);
        if (res == null || res.getCode() != 0 || res.getData() == null) {
            return ResultUtil.error((Integer)1005, (String)"\u8ba2\u5355\u5f02\u5e38");
        }
        GetDepartmentReportMoneyAllVO result = new GetDepartmentReportMoneyAllVO();
        if (((OrderChartVO)res.getData()).getChart() == null || CollectionUtils.isEmpty((Collection)((OrderChartVO)res.getData()).getChart().getData())) {
            return ResultUtil.success((Object)result);
        }
        List data = ((OrderChartVO)res.getData()).getChart().getData();
        GetDepartmentReportMoneyVO model = new GetDepartmentReportMoneyVO();
        LocalDate start = LocalDate.parse(request.getStart());
        LocalDate end = LocalDate.parse(request.getEnd());
        ArrayList<GetDepartmentReportMoneyVO> segmentStatistics = new ArrayList<GetDepartmentReportMoneyVO>();
        ArrayList<GetDepartmentReportMoneyVO> cumulativeStatistics = new ArrayList<GetDepartmentReportMoneyVO>();
        BigDecimal current = new BigDecimal(0);
        if (start.equals(end)) {
            for (ChartDataDTO item : data) {
                model = new GetDepartmentReportMoneyVO();
                LocalDateTime time = LocalDateTime.parse(item.getTimePoint(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                model.setXName(Integer.valueOf(time.getHour()));
                model.setTotalMoney(item.getAmount());
                model.setLabel(String.format("%s:00 \uff1a%s\u5143", time.getHour(), model.getTotalMoney().stripTrailingZeros().toPlainString()));
                segmentStatistics.add(model);
                current = current.add(item.getAmount());
                model = new GetDepartmentReportMoneyVO();
                model.setXName(Integer.valueOf(time.getHour()));
                model.setTotalMoney(current);
                model.setLabel(String.format("%s:00 \uff1a%s\u5143", time.getHour(), model.getTotalMoney().stripTrailingZeros().toPlainString()));
                cumulativeStatistics.add(model);
            }
        } else {
            for (ChartDataDTO item : data) {
                model = new GetDepartmentReportMoneyVO();
                LocalDateTime time = LocalDateTime.parse(item.getTimePoint(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                model.setXName(Integer.valueOf(time.getDayOfMonth()));
                model.setTotalMoney(item.getAmount());
                model.setLabel(String.format("%s\u6708%s\u65e5\uff1a%s\u5143", time.getMonthValue(), time.getDayOfMonth(), model.getTotalMoney()));
                segmentStatistics.add(model);
                current = current.add(item.getAmount());
                model = new GetDepartmentReportMoneyVO();
                model.setXName(Integer.valueOf(time.getHour()));
                model.setTotalMoney(current);
                model.setLabel(String.format("%s\u6708%s\u65e5\uff1a%s\u5143", time.getMonthValue(), time.getDayOfMonth(), model.getTotalMoney()));
                cumulativeStatistics.add(model);
            }
        }
        result.setCumulativeStatistics(cumulativeStatistics);
        result.setSegmentStatistics(segmentStatistics);
        return ResultUtil.success((Object)result);
    }

    @Override
    public Result<GetDepartmentReportOrderCountAllVO> getDepartmentReportOrderCount(GetDepartmentReportQuery request) {
        ThreadUserDTO userInfo;
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        if (request.getStoreId() == null) {
            return ResultUtil.error((Integer)1002, (String)"\u8bf7\u9009\u62e9\u95e8\u5e97");
        }
        if (StringUtils.isEmpty((CharSequence)request.getStart()) || StringUtils.isEmpty((CharSequence)request.getEnd())) {
            return ResultUtil.error((Integer)1003, (String)"\u8bf7\u9009\u62e9\u65f6\u95f4");
        }
        if (request.getOrderType() == null) {
            request.setOrderType(Integer.valueOf(0));
        }
        if ((userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo")) == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1004, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        String startTime = LocalDateTime.of(LocalDate.parse(request.getStart(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(0, 0, 0)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String endTime = LocalDateTime.of(LocalDate.parse(request.getEnd(), DateTimeFormatter.ofPattern("yyyy-MM-dd")), LocalTime.of(23, 59, 59)).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        GoodsOrderInfoBO params = new GoodsOrderInfoBO();
        params.setQueryType(request.getOrderType());
        params.setDepId(request.getStoreId());
        params.setWdzDeptId(request.getStoreId());
        params.setStartTime(startTime);
        params.setEndTime(endTime);
        WanjiResponse res = this.newWanJiOrderForeignService.orderChart(userInfo.getToken(), params);
        if (res == null || res.getCode() != 0 || res.getData() == null) {
            return ResultUtil.error((Integer)1005, (String)"\u8ba2\u5355\u5f02\u5e38");
        }
        GetDepartmentReportOrderCountAllVO result = new GetDepartmentReportOrderCountAllVO();
        if (((OrderChartVO)res.getData()).getChart() == null || CollectionUtils.isEmpty((Collection)((OrderChartVO)res.getData()).getChart().getData())) {
            return ResultUtil.success((Object)result);
        }
        List data = ((OrderChartVO)res.getData()).getChart().getData();
        GetDepartmentReportOrderCountVO model = new GetDepartmentReportOrderCountVO();
        LocalDate start = LocalDate.parse(request.getStart());
        LocalDate end = LocalDate.parse(request.getEnd());
        ArrayList<GetDepartmentReportOrderCountVO> segmentStatistics = new ArrayList<GetDepartmentReportOrderCountVO>();
        ArrayList<GetDepartmentReportOrderCountVO> cumulativeStatistics = new ArrayList<GetDepartmentReportOrderCountVO>();
        int current = 0;
        if (start.equals(end)) {
            for (ChartDataDTO item : data) {
                model = new GetDepartmentReportOrderCountVO();
                LocalDateTime time = LocalDateTime.parse(item.getTimePoint(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                model.setXName(Integer.valueOf(time.getHour()));
                model.setOrderCount(item.getOrderCount());
                model.setLabel(String.format("%s:00 \uff1a%s\u5355", time.getHour(), model.getOrderCount()));
                segmentStatistics.add(model);
                model = new GetDepartmentReportOrderCountVO();
                model.setXName(Integer.valueOf(time.getHour()));
                model.setOrderCount(Integer.valueOf(current += item.getOrderCount().intValue()));
                model.setLabel(String.format("%s\u70b9:00 \uff1a%s\u5355", time.getHour(), model.getOrderCount()));
                cumulativeStatistics.add(model);
            }
        } else {
            for (ChartDataDTO item : data) {
                model = new GetDepartmentReportOrderCountVO();
                LocalDateTime time = LocalDateTime.parse(item.getTimePoint(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                model.setXName(Integer.valueOf(time.getDayOfMonth()));
                model.setOrderCount(item.getOrderCount());
                model.setLabel(String.format("%s\u6708%s\u65e5\uff1a%s\u5355", time.getMonthValue(), time.getDayOfMonth(), model.getOrderCount()));
                segmentStatistics.add(model);
                model = new GetDepartmentReportOrderCountVO();
                model.setXName(Integer.valueOf(time.getHour()));
                model.setOrderCount(Integer.valueOf(current += item.getOrderCount().intValue()));
                model.setLabel(String.format("%s\u6708%s\u65e5\uff1a%s\u5355", time.getMonthValue(), time.getDayOfMonth(), model.getOrderCount()));
                cumulativeStatistics.add(model);
            }
        }
        result.setCumulativeStatistics(cumulativeStatistics);
        result.setSegmentStatistics(segmentStatistics);
        return ResultUtil.success((Object)result);
    }
}

