/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.cloud.BO.ChangeGoodsPriceBO;
import com.ovopark.cloud.BO.ChangeShelvesBO;
import com.ovopark.cloud.BO.DelHistoryKeyBO;
import com.ovopark.cloud.DTO.GetGoodsListDTO;
import com.ovopark.cloud.DTO.SkuInfoDTO;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.VO.QueryGoodsVO;
import com.ovopark.cloud.base.ResponseBaseParent;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.Result;
import com.ovopark.cloud.common.ResultUtil;
import com.ovopark.cloud.dao.state.CloudSearchHistoryDao;
import com.ovopark.cloud.entity.CloudSearchHistoryDO;
import com.ovopark.cloud.query.GetGoodsListQuery;
import com.ovopark.cloud.query.GetShelvesListQuery;
import com.ovopark.cloud.service.ShopService;
import com.ovopark.cloud.wanji.WanJiShopForeignService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ShopServiceImpl
implements ShopService {
    @Autowired(required=false)
    private WanJiShopForeignService wanJiShopForeignService;
    @Autowired(required=false)
    private CloudSearchHistoryDao cloudSearchHistoryDao;

    @Override
    public Result<List<String>> queryShelves(GetShelvesListQuery request) {
        ResponseBaseParent result = this.wanJiShopForeignService.queryShelves(request);
        if (result == null || result.getCode() != 0) {
            return ResultUtil.error((Integer)1001, (String)(result == null ? "\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38" : result.getMessage()));
        }
        return ResultUtil.success((Object)result.getData());
    }

    @Override
    public Result<List<QueryGoodsVO>> queryGoods(GetGoodsListQuery request) {
        ResponseBaseParent result = this.wanJiShopForeignService.queryGoods(request);
        if (result == null || result.getCode() != 0) {
            return ResultUtil.error((Integer)1001, (String)(result == null ? "\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38" : result.getMessage()));
        }
        ArrayList<QueryGoodsVO> response = new ArrayList<QueryGoodsVO>();
        if (CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return ResultUtil.success(response);
        }
        QueryGoodsVO model = new QueryGoodsVO();
        for (GetGoodsListDTO item : (List)result.getData()) {
            model = new QueryGoodsVO();
            model.setId(item.getId());
            model.setGoodsNo(item.getGoodsNo());
            model.setGoodsName(item.getGoodsName());
            model.setImg(item.getImg());
            model.setShelfLocation(item.getShelfLocation());
            model.setStock(item.getStock());
            if (!CollectionUtils.isEmpty((Collection)item.getSkuLists())) {
                model.setScanGoods(((SkuInfoDTO)item.getSkuLists().get(0)).getScanGoods());
                model.setPrice(((SkuInfoDTO)item.getSkuLists().get(0)).getPrice());
                model.setSkuId(((SkuInfoDTO)item.getSkuLists().get(0)).getId());
            }
            response.add(model);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getGoodsName())) {
            ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(CloudSearchHistoryDO::getUserId, (Object)threadUserDTO.getUserData().getData().getId());
            query.eq(CloudSearchHistoryDO::getType, (Object)0);
            query.last(" limit 10 ");
            List list = this.cloudSearchHistoryDao.selectList((Wrapper)query);
            if (CollectionUtils.isEmpty((Collection)list)) {
                CloudSearchHistoryDO info = new CloudSearchHistoryDO();
                info.setUserId(threadUserDTO.getUserData().getData().getId());
                info.setContent(request.getGoodsName());
                info.setType(Integer.valueOf(0));
                this.cloudSearchHistoryDao.insert((Object)info);
            }
        }
        return ResultUtil.success(response);
    }

    @Override
    public Result changeShelves(ChangeShelvesBO request) {
        ResponseBaseParent result = this.wanJiShopForeignService.changeShelves(request);
        if (result == null || result.getCode() != 0) {
            return ResultUtil.error((Integer)1001, (String)(result == null ? "\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38" : result.getMessage()));
        }
        return ResultUtil.success();
    }

    @Override
    public Result changeGoodsPrice(ChangeGoodsPriceBO request) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1004, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        ResponseBaseParent result = this.wanJiShopForeignService.changeGoodsPrice(userInfo.getToken(), request);
        if (result == null || result.getCode() != 0) {
            return ResultUtil.error((Integer)1001, (String)(result == null ? "\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38" : result.getMessage()));
        }
        return ResultUtil.success();
    }

    @Override
    public Result<List<String>> getHistoryKey(Integer type) {
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(CloudSearchHistoryDO::getUserId, (Object)threadUserDTO.getUserData().getData().getId());
        query.eq(CloudSearchHistoryDO::getType, (Object)type);
        query.last(" limit 10 ");
        List list = this.cloudSearchHistoryDao.selectList((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ResultUtil.success(new ArrayList());
        }
        return ResultUtil.success(list.stream().map(m -> m.getContent()).collect(Collectors.toList()));
    }

    @Override
    public Result delHistoryKey(DelHistoryKeyBO request) {
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        ThreadUserDTO threadUserDTO = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(CloudSearchHistoryDO::getUserId, (Object)threadUserDTO.getUserData().getData().getId());
        query.eq(CloudSearchHistoryDO::getType, (Object)request.getType());
        query.eq(CloudSearchHistoryDO::getContent, (Object)request.getKeyword());
        this.cloudSearchHistoryDao.delete((Wrapper)query);
        return ResultUtil.success();
    }
}

