/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.cloud.BO.EditDepartmentInfoBO;
import com.ovopark.cloud.BO.EditDeviceInfoBO;
import com.ovopark.cloud.BO.GetPasswordBO;
import com.ovopark.cloud.BO.OutLineDeviceBo;
import com.ovopark.cloud.BO.SetAudioVolumeFeignBO;
import com.ovopark.cloud.BO.UpdatePasswordBO;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.Mo.UpdateDeviceNameFeignMo;
import com.ovopark.cloud.VO.CloudStoreBankVO;
import com.ovopark.cloud.VO.CloudStoreCrmContractParamsVO;
import com.ovopark.cloud.VO.CloudStoreReviewStatusVO;
import com.ovopark.cloud.VO.GetDepartmentInfoVO;
import com.ovopark.cloud.VO.GetDeviceListVO;
import com.ovopark.cloud.VO.WanjiDeptCodeConfigVO;
import com.ovopark.cloud.VO.WatchPasswordListVO;
import com.ovopark.cloud.base.DeviceBaseResponse;
import com.ovopark.cloud.base.IdNumEntity;
import com.ovopark.cloud.base.WanjiResponse;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.Result;
import com.ovopark.cloud.common.ResultUtil;
import com.ovopark.cloud.common.ToolCommon;
import com.ovopark.cloud.dao.state.CloudDeviceIpcSignDao;
import com.ovopark.cloud.dao.state.CloudSearchDepartmentsDao;
import com.ovopark.cloud.dao.state.CloudStoreFundsDao;
import com.ovopark.cloud.dao.state.CloudStorePicDao;
import com.ovopark.cloud.dao.state.CloudYiBaoApplyDao;
import com.ovopark.cloud.dao.state.PlatformDepartmentsApprovalDao;
import com.ovopark.cloud.entity.CloudDeviceIpcSignDO;
import com.ovopark.cloud.entity.CloudSearchDepartmentsDO;
import com.ovopark.cloud.entity.CloudStoreFundsDO;
import com.ovopark.cloud.entity.CloudStorePicDO;
import com.ovopark.cloud.entity.CloudYiBaoApplyDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.entity.PlatformDepartmentApprovalDO;
import com.ovopark.cloud.enums.StoreOverallReviewStatusEnum;
import com.ovopark.cloud.enums.StorePicTypeEnum;
import com.ovopark.cloud.enums.StoreReviewStateEnum;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.cloud.mater.DeviceService;
import com.ovopark.cloud.mater.MasterStrokeService;
import com.ovopark.cloud.service.CloudStoreService;
import com.ovopark.cloud.service.ShopWebService;
import com.ovopark.cloud.utils.ShopWebCommon;
import com.ovopark.cloud.wanji.NewWanJiOrderForeignService;
import com.ovopark.cloud.watch.WatchForeignService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShopWebServiceImpl
implements ShopWebService {
    private static final Logger log = LoggerFactory.getLogger(ShopWebServiceImpl.class);
    @Autowired
    private ShopWebCommon shopWebCommon;
    @Autowired
    private CloudSearchDepartmentsDao cloudSearchDepartmentsDao;
    @Autowired
    private MasterStrokeService masterStrokeService;
    @Autowired
    private DeviceService deviceService;
    @Autowired(required=false)
    private NewWanJiOrderForeignService newWanJiOrderForeignService;
    @Autowired(required=false)
    private WatchForeignService watchForeignService;
    @Autowired
    private CloudStoreService cloudStoreService;
    @Autowired
    private CloudStorePicDao cloudStorePicDao;
    @Autowired
    private CloudStoreFundsDao cloudStoreFundsDao;
    @Autowired
    private PlatformDepartmentsApprovalDao platformDepartmentsApprovalDao;
    @Autowired
    private CloudDeviceIpcSignDao cloudDeviceIpcSignDao;
    @Autowired
    private CloudYiBaoApplyDao cloudYiBaoApplyDao;

    @Override
    public Result<GetDepartmentInfoVO> getDepartmentInfo(Integer depId) {
        if (depId == null) {
            return ResultUtil.error((Integer)1001, (String)"\u95e8\u5e97\u4fe1\u606f\u4e22\u5931");
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1002, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        GetDepartmentInfoVO result = this.shopWebCommon.getDepartmentInfo(userInfo.getToken(), depId);
        return ResultUtil.success((Object)result);
    }

    @Override
    public Result editDepartmentInfo(EditDepartmentInfoBO request) {
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        if (request.getDepId() == null) {
            return ResultUtil.error((Integer)1002, (String)"\u7f3a\u5c11\u95e8\u5e97id");
        }
        if (!ToolCommon.isValidate18IdNo((String)request.getIdNo())) {
            log.error("\u95e8\u5e97\u4fe1\u606f\u7f16\u8f91\uff0c\u8bc1\u4ef6\u53f7\u7801\u4e0d\u6b63\u786e\uff0c{}", (Object)request.getIdNo());
            return ResultUtil.error((Integer)1003, (String)"\u8bc1\u4ef6\u53f7\u7801\u4e0d\u6b63\u786e");
        }
        Result<CloudStoreReviewStatusVO> reviewStatusResult = this.getReviewStatus(request.getDepId());
        CloudStoreReviewStatusVO reviewStatusVO = (CloudStoreReviewStatusVO)reviewStatusResult.getData();
        if (reviewStatusVO != null && (StoreReviewStateEnum.REVIEWING.getCode().equals(reviewStatusVO.getReviewStatus()) || StoreReviewStateEnum.TO_BE_APPLY.getCode().equals(reviewStatusVO.getReviewStatus()))) {
            return ResultUtil.error((Integer)1004, (String)"\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u65e0\u6cd5\u4fee\u6539\u95e8\u5e97\u4fe1\u606f");
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        CloudSearchDepartmentsDO params = new CloudSearchDepartmentsDO();
        params.setId(request.getDepId());
        params.setLicensePic(request.getLicensePic());
        params.setLicensePicStartDate(request.getLicensePicStartDate() == null ? "" : request.getLicensePicStartDate());
        params.setLicensePicEndDate(request.getLicensePicEndDate() == null ? "" : request.getLicensePicEndDate());
        params.setIdType(request.getIdType());
        params.setIdNo(request.getIdNo());
        params.setIdFrontPic(request.getIdFrontPic());
        params.setIdBackendPic(request.getIdBackendPic());
        params.setIdName(request.getIdName());
        params.setValidityStatus(request.getValidityStatus());
        params.setValidityStartDate(request.getValidityStartDate());
        params.setValidityEndDate(request.getValidityEndDate());
        params.setProvince(request.getProvince());
        params.setCity(request.getCity());
        params.setDistrict(request.getDistrict());
        params.setIdAddress(request.getIdAddress());
        params.setContactPhone(request.getContactPhone());
        params.setActualOperatorPic(request.getActualOperatorPic());
        params.setRowStatus(Integer.valueOf(1));
        params.setUpdateTime(LocalDateTime.now());
        params.setBusinessCategory(request.getBusinessCategory());
        params.setLegalRepresentative(request.getLegalRepresentative());
        params.setUnifiedSocialCreditCode(request.getUnifiedSocialCreditCode());
        params.setLicenseName(request.getLicenseName());
        params.setBusinessType(Integer.valueOf(request.getBusinessType() == null ? 0 : request.getBusinessType()));
        params.setStoreContactPhone(request.getStoreContactPhone());
        params.setAccountOpeningPermit("");
        CloudSearchDepartmentsDO departmentsDO = (CloudSearchDepartmentsDO)this.cloudSearchDepartmentsDao.selectById((Serializable)request.getDepId());
        if (departmentsDO != null) {
            params.setRowStatus(departmentsDO.getRowStatus());
            params.setCreateTime(departmentsDO.getCreateTime());
            this.cloudSearchDepartmentsDao.updateById((Object)params);
        } else {
            this.cloudSearchDepartmentsDao.upsert(params);
        }
        if (request.getStorePic() != null && !request.getStorePic().isEmpty() || StringUtils.isNotEmpty((CharSequence)request.getDoorPic()) || StringUtils.isNotEmpty((CharSequence)request.getCashPic()) || StringUtils.isNotEmpty((CharSequence)request.getShelvesPic())) {
            CloudStorePicDO cloudStorePicDO2;
            ArrayList<CloudStorePicDO> newPicList = new ArrayList<CloudStorePicDO>();
            List picList = request.getStorePic();
            List cloudStorePicList = this.cloudStorePicDao.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudStorePicDO::getStoreId, (Object)request.getDepId())).eq(CloudStorePicDO::getRowStatus, (Object)1));
            List finalPicList = picList;
            HashMap<Integer, String> picTypeMap = new HashMap<Integer, String>();
            picTypeMap.put(StorePicTypeEnum.DOOR_PIC.getCode(), request.getDoorPic());
            picTypeMap.put(StorePicTypeEnum.CASH_PIC.getCode(), request.getCashPic());
            picTypeMap.put(StorePicTypeEnum.SHELVES_PIC.getCode(), request.getShelvesPic());
            List deletePicIdList = cloudStorePicList.stream().filter(cloudStorePicDO -> {
                if (StorePicTypeEnum.DEFAULT_PIC.getCode().equals(cloudStorePicDO.getPicType()) && finalPicList != null && !finalPicList.isEmpty() && finalPicList.contains(cloudStorePicDO.getPicUrl())) {
                    return false;
                }
                return !picTypeMap.containsKey(cloudStorePicDO.getPicType()) || !((String)picTypeMap.get(cloudStorePicDO.getPicType())).equals(cloudStorePicDO.getPicUrl());
            }).map(IdNumEntity::getId).collect(Collectors.toList());
            Map groupPicMap = cloudStorePicList.stream().collect(Collectors.groupingBy(CloudStorePicDO::getPicType, Collectors.toList()));
            List deletePicList = groupPicMap.get(StorePicTypeEnum.DEFAULT_PIC.getCode());
            if (deletePicList != null && !deletePicList.isEmpty() && picList != null && !picList.isEmpty()) {
                Set oldPicSet = deletePicList.stream().map(CloudStorePicDO::getPicUrl).collect(Collectors.toSet());
                picList = picList.stream().filter(item -> !oldPicSet.contains(item)).collect(Collectors.toList());
                for (String picUrl : picList) {
                    cloudStorePicDO2 = new CloudStorePicDO();
                    cloudStorePicDO2.setStoreId(request.getDepId());
                    cloudStorePicDO2.setPicUrl(picUrl);
                    cloudStorePicDO2.setRowStatus(Integer.valueOf(1));
                    cloudStorePicDO2.setCreateBy(userInfo.getUserData().getData().getUserName());
                    cloudStorePicDO2.setPicType(StorePicTypeEnum.DEFAULT_PIC.getCode());
                    newPicList.add(cloudStorePicDO2);
                }
            }
            for (Map.Entry entry : picTypeMap.entrySet()) {
                List cloudStorePicDOList = groupPicMap.get(entry.getKey());
                if (cloudStorePicDOList != null && !cloudStorePicDOList.isEmpty()) {
                    Set oldPicSet = cloudStorePicDOList.stream().map(CloudStorePicDO::getPicUrl).collect(Collectors.toSet());
                    if (oldPicSet.contains(entry.getValue())) continue;
                    CloudStorePicDO cloudStorePicDO3 = new CloudStorePicDO();
                    cloudStorePicDO3.setStoreId(request.getDepId());
                    cloudStorePicDO3.setPicUrl((String)entry.getValue());
                    cloudStorePicDO3.setRowStatus(Integer.valueOf(1));
                    cloudStorePicDO3.setCreateBy(userInfo.getUserData().getData().getUserName());
                    cloudStorePicDO3.setPicType((Integer)entry.getKey());
                    newPicList.add(cloudStorePicDO3);
                    continue;
                }
                cloudStorePicDO2 = new CloudStorePicDO();
                cloudStorePicDO2.setStoreId(request.getDepId());
                cloudStorePicDO2.setPicUrl((String)entry.getValue());
                cloudStorePicDO2.setRowStatus(Integer.valueOf(1));
                cloudStorePicDO2.setCreateBy(userInfo.getUserData().getData().getUserName());
                cloudStorePicDO2.setPicType((Integer)entry.getKey());
                newPicList.add(cloudStorePicDO2);
            }
            if (!deletePicIdList.isEmpty()) {
                this.cloudStorePicDao.deleteUrlById(deletePicIdList);
            }
            if (!newPicList.isEmpty()) {
                this.cloudStorePicDao.batchInsert(newPicList);
            }
        }
        if (request.getStoreBank() != null) {
            CloudStoreBankVO cloudStoreBank = request.getStoreBank();
            cloudStoreBank.setStoreId(request.getDepId());
            Result result = this.bindBankCard(cloudStoreBank);
            if (result.getCode() != 200) {
                return result;
            }
        }
        if (reviewStatusVO == null || StoreReviewStateEnum.APPROVED.getCode().equals(reviewStatusVO.getReviewStatus()) || StoreReviewStateEnum.REJECTED.getCode().equals(reviewStatusVO.getReviewStatus()) || StoreReviewStateEnum.TO_BE_SUBMITTED.getCode().equals(reviewStatusVO.getReviewStatus())) {
            PlatformDepartmentApprovalDO approvalDO = new PlatformDepartmentApprovalDO();
            approvalDO.setDepId(request.getDepId());
            approvalDO.setApplicationApply(Integer.valueOf(1));
            approvalDO.setApplicationStatus(Integer.valueOf(1));
            approvalDO.setApprovalItem("\u5546\u6237\u63d0\u4ea4");
            this.cloudStoreService.saveApproval(approvalDO);
        }
        return ResultUtil.success();
    }

    @Override
    public Result<List<GetDeviceListVO>> getDeviceList(Integer depId) {
        if (depId == null) {
            return ResultUtil.error((Integer)1001, (String)"\u95e8\u5e97\u4fe1\u606f\u4e22\u5931");
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1002, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        List<GetDeviceListVO> result = this.shopWebCommon.getDeviceList(depId, userInfo.getUserData().getData().getId());
        List flagList = this.cloudDeviceIpcSignDao.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudDeviceIpcSignDO::getRowStatus, (Object)1)).eq(CloudDeviceIpcSignDO::getStoreId, (Object)depId)).eq(CloudDeviceIpcSignDO::getDeviceType, (Object)21));
        Map<String, CloudDeviceIpcSignDO> flagMap = flagList.stream().collect(Collectors.toMap(item -> ToolCommon.getDeviceKey((String)item.getMac(), (Integer)item.getDeviceId()), item -> item));
        WanjiResponse wanjiResponse = this.newWanJiOrderForeignService.queryDeptCodeConfigByDepId(userInfo.getToken(), depId);
        Map<Object, Object> doorSeqMap = new HashMap();
        if (wanjiResponse == null || wanjiResponse.getIsError().booleanValue()) {
            log.error("\u4e07\u96c6\u67e5\u8be2\u90e8\u95e8\u4e8c\u7ef4\u7801\u5931\u8d25");
        } else {
            doorSeqMap = ((List)wanjiResponse.getData()).stream().collect(Collectors.groupingBy(WanjiDeptCodeConfigVO::getDoorSeq));
        }
        GetPasswordBO request = new GetPasswordBO();
        request.setDepId(depId);
        HttpResponseEntity watchResponse = this.watchForeignService.getPasswordList(userInfo.getToken(), request);
        Map<Object, Object> doorSeqPasswordMap = new HashMap();
        if (watchResponse == null || watchResponse.getIsError().booleanValue()) {
            log.error("\u95e8\u5e97\u95e8\u7981\u5bc6\u7801\u67e5\u8be2\u5931\u8d25");
        } else {
            doorSeqPasswordMap = ((List)watchResponse.getData()).stream().collect(Collectors.toMap(WatchPasswordListVO::getDoorSeq, v -> v));
        }
        for (GetDeviceListVO item2 : result) {
            WatchPasswordListVO model;
            String key = ToolCommon.getDeviceKey((String)item2.getMac(), (Integer)item2.getId());
            if (item2.getDType().compareTo(21) == 0 && flagMap.containsKey(key)) {
                CloudDeviceIpcSignDO flag = flagMap.get(key);
                item2.setCashDeviceSign(flag.getCashDeviceSign());
                item2.setMainDeviceSign(flag.getMainDeviceSign());
                item2.setEnterDeviceSign(flag.getEnterDeviceSign());
            }
            if (item2.getDType().compareTo(302) != 0) continue;
            Integer doorSeq = item2.getIndex();
            if (doorSeq == null) {
                log.info("{}\u95e8\u7981\u6ca1\u6709\u95e8\u7f16\u53f7\uff0c\u4e0d\u8bbe\u7f6e\u4e8c\u7ef4\u7801\u4fe1\u606f", (Object)item2.toString());
                continue;
            }
            Integer n = doorSeq;
            doorSeq = doorSeq + 1;
            Integer n2 = doorSeq;
            List doorCodeMap = (List)doorSeqMap.get(doorSeq);
            if (doorCodeMap != null && !doorCodeMap.isEmpty()) {
                for (WanjiDeptCodeConfigVO doorCode : doorCodeMap) {
                    if (doorCode.getOperate() == 0) {
                        item2.setInQR(doorCode.getQrCodeUrl());
                        item2.setInQRStatus(Integer.valueOf(1));
                        item2.setInQRId(doorCode.getId());
                    }
                    if (doorCode.getOperate() != 1) continue;
                    item2.setOutQR(doorCode.getQrCodeUrl());
                    item2.setOutQRStatus(Integer.valueOf(1));
                    item2.setOutQRId(doorCode.getId());
                }
            }
            if ((model = (WatchPasswordListVO)doorSeqPasswordMap.get(doorSeq)) == null) continue;
            item2.setPassword(model.getDoorPwd());
            item2.setUnlockDuration(model.getUnlockDuration());
            item2.setDoorType(model.getDoorType());
            item2.setDoorLine(model.getDoorLine());
        }
        return ResultUtil.success(result);
    }

    @Override
    public Result editDeviceInfo(EditDeviceInfoBO request) {
        UpdatePasswordBO param;
        if (request == null) {
            return ResultUtil.error((Integer)1001, (String)"\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
        }
        if (request.getDepId() == null) {
            return ResultUtil.error((Integer)1006, (String)"\u7f3a\u5c11\u95e8\u5e97\u4fe1\u606f");
        }
        if (request.getId() == null && StringUtils.isEmpty((CharSequence)request.getPassword()) && request.getUnlockDuration() == null && request.getDoorType() == null && request.getDoorLine() == null && (request.getMainDeviceStatusId() == null || request.getVoiceNo() == null && StringUtils.isEmpty((CharSequence)request.getPickupVoiceNo()) || request.getVolume() == null)) {
            return ResultUtil.error((Integer)1002, (String)"\u7f3a\u5c11\u8bbe\u5907\u4fe1\u606f");
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1004, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        if (request.getId() != null) {
            if (StringUtils.isEmpty((CharSequence)request.getName())) {
                return ResultUtil.error((Integer)1003, (String)"\u7f3a\u5c11\u8bbe\u5907\u540d");
            }
            UpdateDeviceNameFeignMo params = new UpdateDeviceNameFeignMo();
            params.setUserId(userInfo.getUserData().getData().getId());
            params.setDeviceName(request.getName());
            params.setDeviceStatusId(request.getId());
            HttpResponseEntity res = this.deviceService.updateDeviceName(params);
            if (res == null || res.getCode() != 0) {
                return ResultUtil.error((Integer)1005, (String)(res == null || StringUtils.isEmpty((CharSequence)res.getMessage()) ? "\u8bbe\u5907\u4fe1\u606f\u4fee\u6539\u5931\u8d25" : res.getMessage()));
            }
        }
        if ((StringUtils.isNotEmpty((CharSequence)request.getPassword()) || request.getUnlockDuration() != null || request.getDoorType() != null || request.getDoorLine() != null) && request.getDoorSeq() != null) {
            param = new UpdatePasswordBO();
            param.setDepId(request.getDepId());
            if (StringUtils.isNotEmpty((CharSequence)request.getPassword())) {
                param.setPwd(request.getPassword());
            }
            if (request.getUnlockDuration() != null) {
                param.setUnlockDuration(request.getUnlockDuration());
            }
            param.setDoorSeq(Integer.valueOf(request.getDoorSeq() + 1));
            param.setDoorType(request.getDoorType());
            param.setDoorLine(request.getDoorLine());
            HttpResponseEntity pRes = this.watchForeignService.updatePassword(userInfo.getToken(), param);
            if (pRes == null || pRes.getCode() != 0) {
                return ResultUtil.error((Integer)1007, (String)(pRes == null || StringUtils.isEmpty((CharSequence)pRes.getMessage()) ? "\u95e8\u7981\u5bc6\u7801\u548c\u843d\u9501\u65f6\u95f4\u4fee\u6539\u5931\u8d25" : pRes.getMessage()));
            }
        }
        if (request.getVolume() != null && request.getVoiceNo() != null) {
            param = new SetAudioVolumeFeignBO();
            param.setMainDeviceStatusId(request.getMainDeviceStatusId());
            param.setCard(request.getVoiceNo());
            param.setAoVolume(request.getVolume());
            param.setUserId(userInfo.getUserData().getData().getId());
            HttpResponseEntity voiceRes = this.deviceService.setAudioVolume((SetAudioVolumeFeignBO)param);
            if (voiceRes == null || voiceRes.getCode() != 0 || voiceRes.getData() == null || !((DeviceBaseResponse)voiceRes.getData()).getStatus().equals("comm_success")) {
                log.error("\u58f0\u5361{}\u8c03\u8282\u97f3\u91cf{}\u5931\u8d25:{}", new Object[]{request.getVoiceNo(), request.getVolume(), ((DeviceBaseResponse)voiceRes.getData()).getMsg()});
                return ResultUtil.error((Integer)1008, (String)(voiceRes != null && voiceRes.getData() != null && StringUtils.isNotEmpty((CharSequence)((DeviceBaseResponse)voiceRes.getData()).getMsg()) ? ((DeviceBaseResponse)voiceRes.getData()).getMsg() : "\u97f3\u54cd\u97f3\u91cf\u8bbe\u7f6e\u5f02\u5e38"));
            }
        }
        if ((request.getVolume() != null || request.getEchoVolume() != null) && StringUtils.isNotEmpty((CharSequence)request.getPickupVoiceNo())) {
            HashMap<Integer, Integer> voiceNoArray = new HashMap<Integer, Integer>();
            if (request.getVolume() != null) {
                voiceNoArray.put(0, request.getVolume());
            }
            if (request.getEchoVolume() != null) {
                voiceNoArray.put(1, request.getEchoVolume());
            }
            List<Object> deviceList = this.shopWebCommon.getDeviceList(request.getDepId(), userInfo.getUserData().getData().getId());
            HashMap<Integer, Integer> aoVolumeMap = new HashMap<Integer, Integer>();
            deviceList = deviceList.stream().filter(item -> item.getDType() == 304).collect(Collectors.toList());
            for (GetDeviceListVO getDeviceListVO : deviceList) {
                aoVolumeMap.put(getDeviceListVO.getVoiceNo(), getDeviceListVO.getVolume());
            }
            for (Map.Entry entry : voiceNoArray.entrySet()) {
                SetAudioVolumeFeignBO param2 = new SetAudioVolumeFeignBO();
                param2.setMainDeviceStatusId(request.getMainDeviceStatusId());
                param2.setCard((Integer)entry.getKey());
                param2.setAiVolume((Integer)entry.getValue());
                if (aoVolumeMap.containsKey(param2.getCard())) {
                    param2.setAoVolume((Integer)aoVolumeMap.get(param2.getCard()));
                }
                param2.setUserId(userInfo.getUserData().getData().getId());
                HttpResponseEntity voiceRes = this.deviceService.setAudioVolume(param2);
                if (voiceRes != null && voiceRes.getCode() == 0 && voiceRes.getData() != null && ((DeviceBaseResponse)voiceRes.getData()).getStatus().equals("comm_success")) continue;
                log.error("\u62fe\u97f3\u5668{}\u8c03\u8282\u97f3\u91cf{}\u5931\u8d25:{}", new Object[]{entry, request.getVolume(), ((DeviceBaseResponse)voiceRes.getData()).getMsg()});
                return ResultUtil.error((Integer)1008, (String)(voiceRes != null && voiceRes.getData() != null && StringUtils.isNotEmpty((CharSequence)((DeviceBaseResponse)voiceRes.getData()).getMsg()) ? ((DeviceBaseResponse)voiceRes.getData()).getMsg() : "\u62fe\u97f3\u5668\u97f3\u91cf\u8bbe\u7f6e\u5f02\u5e38"));
            }
        }
        return ResultUtil.success();
    }

    @Override
    public Result outLineDevice(OutLineDeviceBo deviceRequest) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken())) {
            return ResultUtil.error((Integer)1001, (String)"token\u89e3\u6790\u5931\u8d25");
        }
        HttpResponseEntity result = this.masterStrokeService.outLineDevice(userInfo.getToken(), deviceRequest);
        if (result == null || result.getCode() != 0) {
            String msg = result != null && StringUtils.isNotEmpty((CharSequence)result.getMessage()) ? result.getMessage() : "\u8bbe\u5907\u9000\u7f51\u5931\u8d25";
            return ResultUtil.error((Integer)1001, (String)msg);
        }
        return ResultUtil.success();
    }

    @Override
    public Result bindBankCard(CloudStoreBankVO request) {
        if (request.getStoreId() == null) {
            return ResultUtil.error((Integer)1001, (String)"\u6307\u5b9a\u95e8\u5e97");
        }
        if (StringUtils.isEmpty((CharSequence)request.getCardType())) {
            request.setCardType("DC");
        }
        if (!"DC".equals(request.getCardType())) {
            return ResultUtil.error((Integer)1004, (String)"\u8bf7\u7ed1\u5b9a\u50a8\u84c4\u5361");
        }
        Result<CloudStoreReviewStatusVO> reviewStatusResult = this.getReviewStatus(request.getStoreId());
        CloudStoreReviewStatusVO reviewStatusVO = (CloudStoreReviewStatusVO)reviewStatusResult.getData();
        if (reviewStatusVO != null && (StoreReviewStateEnum.REVIEWING.getCode().equals(reviewStatusVO.getReviewStatus()) || StoreReviewStateEnum.TO_BE_APPLY.getCode().equals(reviewStatusVO.getReviewStatus()))) {
            return ResultUtil.error((Integer)1004, (String)"\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u65e0\u6cd5\u4fee\u6539\u95e8\u5e97\u4fe1\u606f");
        }
        CloudStoreFundsDO cloudStoreFunds = (CloudStoreFundsDO)this.cloudStoreFundsDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudStoreFundsDO::getStoreId, (Object)request.getStoreId())).eq(CloudStoreFundsDO::getRowStatus, (Object)1));
        if (StringUtils.isEmpty((CharSequence)request.getBankName()) || StringUtils.isEmpty((CharSequence)request.getBankAccountNo()) || StringUtils.isEmpty((CharSequence)request.getUserName())) {
            return ResultUtil.error((Integer)1003, (String)"\u5b8c\u5584\u94f6\u884c\u4fe1\u606f");
        }
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        CloudStoreFundsDO cloudStoreFundsDO = new CloudStoreFundsDO();
        cloudStoreFundsDO.setStoreId(request.getStoreId());
        cloudStoreFundsDO.setBindWay(Integer.valueOf(1));
        cloudStoreFundsDO.setBindGroupName(request.getBankName());
        cloudStoreFundsDO.setBindAccountNo(request.getBankAccountNo());
        cloudStoreFundsDO.setBindAccountType(request.getCardType());
        cloudStoreFundsDO.setBindUserName(request.getUserName());
        cloudStoreFundsDO.setBindUserPhone(request.getUserPhone());
        cloudStoreFundsDO.setRowStatus(Integer.valueOf(1));
        cloudStoreFundsDO.setBankFrontPic(request.getBankFrontPic());
        cloudStoreFundsDO.setBankBackendPic(request.getBankBackendPic());
        cloudStoreFundsDO.setType(Integer.valueOf(request.getType() == null ? 0 : request.getType()));
        cloudStoreFundsDO.setBankNo(request.getBankNo() == null ? "" : request.getBankNo());
        cloudStoreFundsDO.setAccountOpeningPermitPic(request.getAccountOpeningPermitPic() == null ? "" : request.getAccountOpeningPermitPic());
        if (cloudStoreFunds == null) {
            cloudStoreFundsDO.setCreateBy(userInfo.getUserData().getData().getUserName());
            this.cloudStoreFundsDao.insert((Object)cloudStoreFundsDO);
        } else {
            cloudStoreFundsDO.setId(cloudStoreFunds.getId());
            cloudStoreFundsDO.setUpdateBy(userInfo.getUserData().getData().getUserName());
            this.cloudStoreFundsDao.updateById((Object)cloudStoreFundsDO);
        }
        if (reviewStatusVO == null || StoreReviewStateEnum.APPROVED.getCode().equals(reviewStatusVO.getReviewStatus()) || StoreReviewStateEnum.REJECTED.getCode().equals(reviewStatusVO.getReviewStatus()) || StoreReviewStateEnum.TO_BE_SUBMITTED.getCode().equals(reviewStatusVO.getReviewStatus())) {
            PlatformDepartmentApprovalDO approvalDO = new PlatformDepartmentApprovalDO();
            approvalDO.setDepId(request.getStoreId());
            approvalDO.setApplicationApply(Integer.valueOf(1));
            approvalDO.setApplicationStatus(Integer.valueOf(1));
            approvalDO.setApprovalItem("\u5546\u6237\u63d0\u4ea4");
            this.cloudStoreService.saveApproval(approvalDO);
        }
        return ResultUtil.success();
    }

    @Override
    public Result<CloudStoreReviewStatusVO> getReviewStatus(Integer depId) {
        StoreOverallReviewStatusEnum overallReview;
        CloudStoreReviewStatusVO reviewStatusVO = new CloudStoreReviewStatusVO(depId);
        CloudSearchDepartmentsDO cloudSearchDepartmentsDO = (CloudSearchDepartmentsDO)this.cloudSearchDepartmentsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudSearchDepartmentsDO::getId, (Object)depId));
        if (cloudSearchDepartmentsDO == null || cloudSearchDepartmentsDO.getApplicationStatus() == null) {
            reviewStatusVO.setReviewStatus(StoreReviewStateEnum.TO_BE_SUBMITTED.getCode());
            reviewStatusVO.setReviewStatusName(StoreReviewStateEnum.TO_BE_SUBMITTED.getName());
        } else if (cloudSearchDepartmentsDO.getApplicationStatus().equals(StoreReviewStateEnum.TO_BE_APPLY.getCode())) {
            reviewStatusVO.setReviewStatus(StoreReviewStateEnum.REVIEWING.getCode());
            reviewStatusVO.setReviewStatusName(StoreReviewStateEnum.REVIEWING.getName());
        } else {
            reviewStatusVO.setReviewStatus(cloudSearchDepartmentsDO.getApplicationStatus());
            reviewStatusVO.setReviewStatusName(StoreReviewStateEnum.getName((Integer)cloudSearchDepartmentsDO.getApplicationStatus()));
        }
        if (reviewStatusVO.getReviewStatus() <= StoreReviewStateEnum.REJECTED.getCode()) {
            reviewStatusVO.setReviewStageName("\u5e73\u53f0\u521d\u5ba1");
            if (reviewStatusVO.getReviewStatus().equals(StoreReviewStateEnum.REJECTED.getCode())) {
                this.getCloudFirstReview(depId, reviewStatusVO);
            }
        } else {
            reviewStatusVO.setReviewStageName("\u652f\u4ed8\u5e73\u53f0\u4e8c\u5ba1");
            if (reviewStatusVO.getReviewStatus().equals(StoreReviewStateEnum.YIBAO_REJECTED.getCode()) || reviewStatusVO.getReviewStatus().equals(StoreReviewStateEnum.YIBAO_FAIL.getCode())) {
                this.getYiBaoSecondReview(depId, reviewStatusVO);
            }
        }
        if ((overallReview = StoreOverallReviewStatusEnum.getOverallReview((Integer)reviewStatusVO.getReviewStatus())) != null) {
            reviewStatusVO.setReviewStatusOverall(overallReview.getCode());
            reviewStatusVO.setReviewStatusNameOverall(overallReview.getName());
        }
        return ResultUtil.success((Object)reviewStatusVO);
    }

    private CloudStoreReviewStatusVO getYiBaoSecondReview(Integer depId, CloudStoreReviewStatusVO reviewStatus) {
        List cloudYiBaoApplyList = this.cloudYiBaoApplyDao.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudYiBaoApplyDO::getStoreId, (Object)depId)).orderByDesc(IdNumEntity::getCreatedTime));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (cloudYiBaoApplyList != null && !cloudYiBaoApplyList.isEmpty()) {
            CloudYiBaoApplyDO cloudYiBaoApplyDO = (CloudYiBaoApplyDO)cloudYiBaoApplyList.get(0);
            reviewStatus.setReviewTime(sdf.format(cloudYiBaoApplyDO.getUpdatedTime()));
            reviewStatus.setReportOpinion(cloudYiBaoApplyDO.getAuditOpinion());
            reviewStatus.setSubmitTime(sdf.format(cloudYiBaoApplyDO.getCreatedTime()));
        }
        return reviewStatus;
    }

    public CloudStoreReviewStatusVO getCloudFirstReview(Integer depId, CloudStoreReviewStatusVO reviewStatus) {
        List approvalList = this.platformDepartmentsApprovalDao.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PlatformDepartmentApprovalDO::getDepId, (Object)depId)).orderByDesc(PlatformDepartmentApprovalDO::getCreateTime));
        if (approvalList != null && !approvalList.isEmpty()) {
            PlatformDepartmentApprovalDO newApproval = (PlatformDepartmentApprovalDO)approvalList.get(0);
            reviewStatus.setReviewTime(newApproval.getCreateTime());
            reviewStatus.setReviewerName(newApproval.getUserName());
            reviewStatus.setReportOpinion(newApproval.getApprovalDescribe());
            reviewStatus.setSubmitTime(((PlatformDepartmentApprovalDO)approvalList.get(approvalList.size() - 1)).getCreateTime());
        }
        return reviewStatus;
    }

    @Override
    public CloudStoreCrmContractParamsVO getCrmContractParams(Integer depId) {
        Result<CloudStoreReviewStatusVO> result = this.getReviewStatus(depId);
        CloudStoreReviewStatusVO reviewStatus = (CloudStoreReviewStatusVO)result.getData();
        if (reviewStatus == null || !StoreReviewStateEnum.APPROVED.getCode().equals(reviewStatus.getReviewStatus())) {
            throw new CloudWatchException("\u4f01\u4e1a\u4fe1\u606f\u9700\u8981\u5ba1\u6838\u901a\u8fc7");
        }
        CloudStoreCrmContractParamsVO contractParams = new CloudStoreCrmContractParamsVO();
        Result<GetDepartmentInfoVO> getDepartmentInfo = this.getDepartmentInfo(depId);
        GetDepartmentInfoVO departmentInfo = (GetDepartmentInfoVO)getDepartmentInfo.getData();
        contractParams.setStoreId(depId);
        if (departmentInfo != null) {
            contractParams.setSignName(departmentInfo.getCompanyName());
            contractParams.setSignPhone(departmentInfo.getContactPhone());
            contractParams.setCreditCode(departmentInfo.getUnifiedSocialCreditCode());
            contractParams.setOperator(departmentInfo.getLegalRepresentative());
        }
        return contractParams;
    }
}

