/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.VO.ZhonganBizContentVO;
import com.ovopark.cloud.VO.ZhonganInsureUserVO;
import com.ovopark.cloud.VO.ZhonganOrderVO;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.TimeService;
import com.ovopark.cloud.dao.state.CloudStoreBizDao;
import com.ovopark.cloud.dao.state.CloudStoreInsuranceDao;
import com.ovopark.cloud.entity.CloudStoreBizDO;
import com.ovopark.cloud.entity.CloudStoreInsuranceDO;
import com.ovopark.cloud.enums.ZhonganInsuranceEnum;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.cloud.service.ZhonganService;
import com.ovopark.cloud.utils.RC4Util;
import com.zhongan.scorpoin.common.ZhongAnNotifyClient;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZhonganServiceImpl
implements ZhonganService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ZhonganServiceImpl.class);
    @Value(value="${zhongan.env}")
    private String zhonganEnv;
    @Value(value="${zhongan.privateKey}")
    private String zhonganPrivateKey;
    @Value(value="${zhongan.rc4Key}")
    private String zhonganRc4Key;
    private ZhongAnNotifyClient notify;
    @Autowired
    private CloudStoreBizDao cloudStoreBizDao;
    @Autowired
    private CloudStoreInsuranceDao cloudStoreInsuranceDao;

    @Override
    public String getZhonganResult(Map<String, String[]> parameterMap) {
        log.info("zhongan request: {}", parameterMap.values());
        try {
            String result = this.notify.parseNotifyRequest(parameterMap);
            log.info("zhongan result: {}", (Object)result);
            ZhonganOrderVO zhonganOrder = (ZhonganOrderVO)JSONObject.parseObject((String)result, ZhonganOrderVO.class);
            ZhonganBizContentVO zhonganBizContentVO = null;
            if (zhonganOrder.getNotifyType() == null) {
                zhonganOrder.setNotifyType(Integer.valueOf(ZhonganInsuranceEnum.ORDER.getCode()));
            }
            if (StringUtils.isEmpty((CharSequence)zhonganOrder.getBizContent())) {
                log.error("processOrder bizContent is null!");
            } else {
                String content = RC4Util.decryRC4(zhonganOrder.getBizContent(), this.zhonganRc4Key);
                try {
                    zhonganBizContentVO = (ZhonganBizContentVO)JSONObject.parseObject((String)content, ZhonganBizContentVO.class);
                }
                catch (Exception e) {
                    log.error("parse zhonganBizContentVO failed!, exception:{}", (Object)e.toString());
                }
                if (zhonganBizContentVO == null) {
                    log.error("parse bizContent fail,bizContent:{}, decry content:{}", (Object)zhonganOrder.getBizContent(), (Object)content);
                } else {
                    this.cloudStoreBizDao.updateStoreBiz(null, Integer.valueOf(1), zhonganOrder.getNotifyType(), zhonganBizContentVO.getId());
                }
            }
            if (zhonganOrder.getNotifyType().intValue() == ZhonganInsuranceEnum.ORDER.getCode()) {
                this.processOrder(zhonganOrder, zhonganBizContentVO);
            } else if (zhonganOrder.getNotifyType().intValue() == ZhonganInsuranceEnum.RENEWAL.getCode()) {
                this.processRenewal(zhonganOrder, zhonganBizContentVO);
            } else if (zhonganOrder.getNotifyType().intValue() == ZhonganInsuranceEnum.CANCEL.getCode()) {
                this.processCancel(zhonganOrder, zhonganBizContentVO);
            }
        }
        catch (Exception e) {
            log.error("parse zhongan request failed! : {}", (Object)e.toString());
            throw new RuntimeException(e);
        }
        try {
            return this.notify.buildNotifyResponse("success");
        }
        catch (ZhongAnOpenException e) {
            log.error("build zhongan response failed! : {}", (Object)e.toString());
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getZhonganBizContent(Integer depId) {
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getToken()) || userInfo.getUserData() == null || userInfo.getUserData().getData() == null || userInfo.getUserData().getData().getId() == null) {
            throw new CloudWatchException("\u6307\u5b9a\u7528\u6237\u4fe1\u606f");
        }
        CloudStoreBizDO cloudStoreBizDO = new CloudStoreBizDO();
        cloudStoreBizDO.setStoreId(depId);
        cloudStoreBizDO.setStatus(Integer.valueOf(0));
        this.cloudStoreBizDao.insert((Object)cloudStoreBizDO);
        ZhonganBizContentVO zhonganBizContentVO = new ZhonganBizContentVO();
        zhonganBizContentVO.setDepId(depId);
        zhonganBizContentVO.setCreatTime(TimeService.getTime());
        zhonganBizContentVO.setUserId(userInfo.getUserData().getData().getId());
        zhonganBizContentVO.setId((Long)cloudStoreBizDO.getId());
        String key = JSONObject.toJSONString((Object)zhonganBizContentVO);
        String encrypt = RC4Util.encryRC4String(key, this.zhonganRc4Key);
        this.cloudStoreBizDao.updateStoreBiz(encrypt, null, null, (Long)cloudStoreBizDO.getId());
        log.info("\u52a0\u5bc6\u6210\u529f\uff0cdepId:{}, key:{}, encrypt:{}", new Object[]{depId, key, encrypt});
        return encrypt;
    }

    private void processCancel(ZhonganOrderVO zhonganOrder, ZhonganBizContentVO zhonganBizContent) {
        CloudStoreInsuranceDO cloudStoreInsurance = (CloudStoreInsuranceDO)this.cloudStoreInsuranceDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreInsuranceDO::getPolicyCode, (Object)zhonganOrder.getPolicyNo()));
        if (cloudStoreInsurance == null) {
            log.error("\u672a\u627e\u5230\u8be5\u4fdd\u5355\uff0c policyNo:{}", (Object)zhonganOrder.getPolicyNo());
            return;
        }
        log.info("\u9000\u4fdd\u5355\u66f4\u65b0\uff0c policyNo:{}", (Object)zhonganOrder.getPolicyNo());
        this.cloudStoreInsuranceDao.updateStatus((Long)cloudStoreInsurance.getId(), zhonganOrder.getEffectiveDate(), Integer.valueOf(3));
    }

    private void processRenewal(ZhonganOrderVO zhonganOrder, ZhonganBizContentVO zhonganBizContent) {
        CloudStoreInsuranceDO oldCloudStoreInsurance = (CloudStoreInsuranceDO)this.cloudStoreInsuranceDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreInsuranceDO::getPolicyCode, (Object)zhonganOrder.getOldPolicyNo()));
        Integer depId = null;
        if (zhonganBizContent != null) {
            depId = zhonganBizContent.getDepId();
        }
        ZhonganInsureUserVO zhonganInsureUserVO = null;
        try {
            String insureUserInfo = zhonganOrder.getInsureUserInfo();
            if (StringUtils.isNotEmpty((CharSequence)insureUserInfo)) {
                zhonganInsureUserVO = (ZhonganInsureUserVO)JSONObject.parseObject((String)zhonganOrder.getInsureUserInfo(), ZhonganInsureUserVO.class);
            }
        }
        catch (Exception e) {
            log.error("renewal parse ZhonganInsureUserVO failed!, exception:{}", (Object)e.toString());
        }
        CloudStoreInsuranceDO cloudStoreInsurance = CloudStoreInsuranceDO.fromZhonganOrder((ZhonganOrderVO)zhonganOrder, zhonganInsureUserVO, (Integer)depId);
        cloudStoreInsurance.setOldPolicyCode(zhonganOrder.getOldPolicyNo());
        if (oldCloudStoreInsurance != null) {
            log.info("update old policy status");
            this.cloudStoreInsuranceDao.updateStatus((Long)oldCloudStoreInsurance.getId(), null, Integer.valueOf(4));
            if (StringUtils.isEmpty((CharSequence)cloudStoreInsurance.getInsuranceName())) {
                cloudStoreInsurance.setInsuranceName(oldCloudStoreInsurance.getInsuranceName());
            }
            if (StringUtils.isEmpty((CharSequence)cloudStoreInsurance.getInsuranceCode())) {
                cloudStoreInsurance.setInsuranceCode(oldCloudStoreInsurance.getInsuranceCode());
            }
            if (cloudStoreInsurance.getStoreId() == null) {
                cloudStoreInsurance.setStoreId(oldCloudStoreInsurance.getStoreId());
            }
            if (StringUtils.isEmpty((CharSequence)cloudStoreInsurance.getHolderName())) {
                cloudStoreInsurance.setHolderName(oldCloudStoreInsurance.getHolderName());
            }
            if (StringUtils.isEmpty((CharSequence)cloudStoreInsurance.getHolderCertiNo())) {
                cloudStoreInsurance.setHolderCertiNo(oldCloudStoreInsurance.getHolderCertiNo());
            }
            if (StringUtils.isEmpty((CharSequence)cloudStoreInsurance.getHolderPhone())) {
                cloudStoreInsurance.setHolderPhone(oldCloudStoreInsurance.getHolderPhone());
            }
        }
        log.info("processRenewal generate cloudStoreInsurance:{}", (Object)cloudStoreInsurance.toString());
        this.cloudStoreInsuranceDao.insert((Object)cloudStoreInsurance);
    }

    private void processOrder(ZhonganOrderVO zhonganOrder, ZhonganBizContentVO zhonganBizContent) {
        if (zhonganBizContent == null) {
            log.error("zhongan bizContent is null");
            return;
        }
        ZhonganInsureUserVO zhonganInsureUserVO = null;
        try {
            List zhonganInsureUserList;
            String insureUserInfo = zhonganOrder.getInsureUserInfo();
            if (StringUtils.isNotEmpty((CharSequence)insureUserInfo) && (zhonganInsureUserList = JSONObject.parseArray((String)zhonganOrder.getInsureUserInfo(), ZhonganInsureUserVO.class)) != null && !zhonganInsureUserList.isEmpty()) {
                zhonganInsureUserVO = (ZhonganInsureUserVO)zhonganInsureUserList.get(0);
            }
        }
        catch (Exception e) {
            log.error("order parse ZhonganInsureUserVO failed!, exception:{}", (Object)e.toString());
        }
        CloudStoreInsuranceDO cloudStoreInsurance = CloudStoreInsuranceDO.fromZhonganOrder((ZhonganOrderVO)zhonganOrder, zhonganInsureUserVO, (Integer)zhonganBizContent.getDepId());
        log.info("processOrder generate cloudStoreInsurance:{}", (Object)cloudStoreInsurance.toString());
        this.cloudStoreInsuranceDao.insert((Object)cloudStoreInsurance);
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.notify = new ZhongAnNotifyClient(this.zhonganEnv, this.zhonganPrivateKey);
        }
        catch (ZhongAnOpenException e) {
            log.error("init zhongan client failed!");
            throw new RuntimeException(e);
        }
    }
}

