/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.service.kafka;

import com.alibaba.fastjson.JSON;
import com.ovopark.cloud.entity.CloudDeviceIpcSignDO;
import com.ovopark.cloud.service.CloudDeviceIpcSignService;
import com.ovopark.cloud.service.kafka.DeviceInOutRecord;
import com.ovopark.cloud.service.kafka.DeviceOnlineLogAddMo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@Component
public class KafkaDeviceConsumerListener {
    private static final Logger log = LoggerFactory.getLogger(KafkaDeviceConsumerListener.class);
    @Resource
    private CloudDeviceIpcSignService cloudDeviceIpcSignService;

    @KafkaListener(topics={"${kafka.topic.topic-device-inAndOut}"}, groupId="cloud-watch")
    public void deviceInAndOutListener(ConsumerRecord<String, String> record) {
        String value = (String)record.value();
        log.info("deviceInAndOutListener \u6d88\u8d39\u6d41\u7a0b\u6570\u636e:{}", (Object)value);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            DeviceInOutRecord deviceInOutRecord = (DeviceInOutRecord)JSON.parseObject((String)value, DeviceInOutRecord.class);
            if (deviceInOutRecord == null || deviceInOutRecord.getDeptId() == null || deviceInOutRecord.getDeviceStatusType() == null || StringUtils.isBlank((CharSequence)deviceInOutRecord.getMac())) {
                log.error("deviceInAndOutListener \u8bbe\u5907\u4fe1\u606f\u4e0d\u5b8c\u6574:{}", (Object)JSON.toJSONString((Object)deviceInOutRecord));
                return;
            }
            Integer deviceStatusType = deviceInOutRecord.getDeviceStatusType();
            if (deviceStatusType == null || deviceStatusType != 240) {
                return;
            }
            CloudDeviceIpcSignDO deviceIpcSignDO = new CloudDeviceIpcSignDO();
            deviceIpcSignDO.setStoreId(deviceInOutRecord.getDeptId());
            deviceIpcSignDO.setMac(deviceInOutRecord.getMac());
            deviceIpcSignDO.setDeviceType(deviceStatusType);
            deviceIpcSignDO.setDeviceId(deviceInOutRecord.getDeviceId());
            deviceIpcSignDO.setDeviceName(deviceInOutRecord.getDeviceName());
            if (deviceInOutRecord.getType() == 1) {
                deviceIpcSignDO.setStatus(Integer.valueOf(1));
                deviceIpcSignDO.setOnOffStatus(Integer.valueOf(1));
                deviceIpcSignDO.setRowStatus(Integer.valueOf(1));
            } else {
                deviceIpcSignDO.setStatus(Integer.valueOf(0));
                deviceIpcSignDO.setOnOffStatus(Integer.valueOf(0));
                deviceIpcSignDO.setRowStatus(Integer.valueOf(0));
            }
            this.cloudDeviceIpcSignService.saveCloudDevice(deviceIpcSignDO);
        }
    }

    @KafkaListener(topics={"${kafka.topic.topic-device-onAndOff}"}, groupId="cloud-watch")
    public void deviceOnAndOffListener(ConsumerRecord<String, String> record) {
        String value = (String)record.value();
        log.info("deviceOnAndOffListener \u6d88\u8d39\u6d41\u7a0b\u6570\u636e:{}", (Object)value);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            DeviceOnlineLogAddMo deviceOnlineLogAddMo = (DeviceOnlineLogAddMo)JSON.parseObject((String)value, DeviceOnlineLogAddMo.class);
            if (deviceOnlineLogAddMo == null || deviceOnlineLogAddMo.getDeptId() == null || StringUtils.isBlank((CharSequence)deviceOnlineLogAddMo.getMac()) || deviceOnlineLogAddMo.getType() == null) {
                log.error("deviceOnAndOffListener \u8bbe\u5907\u4fe1\u606f\u4e0d\u5b8c\u6574:{}", (Object)JSON.toJSONString((Object)deviceOnlineLogAddMo));
                return;
            }
            Integer deviceStatusType = deviceOnlineLogAddMo.getDeviceStatusType();
            if (deviceStatusType == null || deviceStatusType != 20 && deviceStatusType != 21 && deviceStatusType != 240) {
                return;
            }
            CloudDeviceIpcSignDO deviceIpcSignDO = new CloudDeviceIpcSignDO();
            deviceIpcSignDO.setStoreId(deviceOnlineLogAddMo.getDeptId());
            deviceIpcSignDO.setMac(deviceOnlineLogAddMo.getMac());
            deviceIpcSignDO.setDeviceType(deviceStatusType);
            deviceIpcSignDO.setDeviceId(deviceOnlineLogAddMo.getDeviceId());
            deviceIpcSignDO.setDeviceName(deviceOnlineLogAddMo.getDeviceName());
            deviceIpcSignDO.setOnOffStatus(Integer.valueOf(deviceOnlineLogAddMo.getType() == 1 ? 1 : 0));
            this.cloudDeviceIpcSignService.updateCloudDeviceStatus(deviceIpcSignDO);
        }
    }
}

