/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.utils;

import com.ovopark.cloud.DTO.DutyOrderDeviceDTO;
import com.ovopark.cloud.DTO.DutyPersonDTO;
import com.ovopark.cloud.DTO.OnDutyPersonDTO;
import com.ovopark.cloud.DTO.OrderDeviceDTO;
import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.VO.YzsDeviceFeignVo;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.mater.DeviceService;
import com.ovopark.cloud.query.DutyOrderQuery;
import com.ovopark.cloud.watch.WatchForeignService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnDutyCommon {
    @Autowired
    private WatchForeignService watchForeignService;
    @Autowired
    private DeviceService deviceService;

    public OnDutyPersonDTO getOnDutyPersonByOrderNo(String orderNo) {
        OnDutyPersonDTO onDutyPersonDTO = new OnDutyPersonDTO();
        DutyOrderQuery request = new DutyOrderQuery();
        request.setOrderNo(orderNo);
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        HttpResponseEntity responseEntity = this.watchForeignService.getServiceRecordByOrderNo(userInfo.getToken(), request);
        if (responseEntity == null || responseEntity.getCode() != 0 || responseEntity.getIsError().booleanValue() || responseEntity.getData() == null) {
            return null;
        }
        List dutyPersonList = (List)responseEntity.getData();
        if (dutyPersonList.isEmpty()) {
            return null;
        }
        DutyPersonDTO dutyPersonDTO = (DutyPersonDTO)dutyPersonList.get(0);
        onDutyPersonDTO.setName(dutyPersonDTO.getServiceUserName());
        onDutyPersonDTO.setServiceNo(dutyPersonDTO.getServiceRecordId());
        onDutyPersonDTO.setWorkNo(dutyPersonDTO.getServiceUserId());
        return onDutyPersonDTO;
    }

    public List<OrderDeviceDTO> getOnDutyDeviceByOrderNo(String orderNo) {
        ArrayList<OrderDeviceDTO> result = new ArrayList<OrderDeviceDTO>();
        DutyOrderQuery request = new DutyOrderQuery();
        request.setOrderNo(orderNo);
        ThreadUserDTO userInfo = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        HttpResponseEntity responseEntity = this.watchForeignService.getServiceRecordDeviceIdByOrderNo(userInfo.getToken(), request);
        if (responseEntity == null || responseEntity.getCode() != 0 || responseEntity.getIsError().booleanValue() || responseEntity.getData() == null) {
            return null;
        }
        List dutyOrderDeviceList = (List)responseEntity.getData();
        for (DutyOrderDeviceDTO dutyOrderDeviceDTO : dutyOrderDeviceList) {
            OrderDeviceDTO onDutyDevice = new OrderDeviceDTO();
            onDutyDevice.setDeviceId(Integer.valueOf(dutyOrderDeviceDTO.getDeviceId()));
            onDutyDevice.setDeviceName(dutyOrderDeviceDTO.getDeviceName());
            result.add(onDutyDevice);
        }
        return result;
    }

    public List<OrderDeviceDTO> getDeviceVideo(Integer depId, Integer userId) {
        ArrayList<OrderDeviceDTO> result = new ArrayList<OrderDeviceDTO>();
        HttpResponseEntity res = this.deviceService.depDeviceList(depId, userId);
        if (res == null || res.getCode() != 0 || res.getData() == null) {
            return result;
        }
        List dutyOrderDeviceList = (List)res.getData();
        for (YzsDeviceFeignVo dutyOrderDeviceDTO : dutyOrderDeviceList) {
            if (dutyOrderDeviceDTO.getDtype() == null || !dutyOrderDeviceDTO.getDtype().equals(21)) continue;
            OrderDeviceDTO onDutyDevice = new OrderDeviceDTO();
            onDutyDevice.setDeviceId(dutyOrderDeviceDTO.getDeviceId());
            onDutyDevice.setDeviceStatusId(dutyOrderDeviceDTO.getDeviceStatusId());
            onDutyDevice.setDeviceName(dutyOrderDeviceDTO.getDeviceName());
            result.add(onDutyDevice);
        }
        return result;
    }
}

