/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.utils;

import com.ovopark.cloud.BO.DepartmentPojo;
import com.ovopark.cloud.BO.EnterpriseConfigPojo;
import com.ovopark.cloud.BO.SummarizeBO;
import com.ovopark.cloud.DTO.GetOrderStatisticsInfoBatchDTO;
import com.ovopark.cloud.DTO.GetOrderStatisticsInfoDTO;
import com.ovopark.cloud.DTO.GoodsOrderDTO;
import com.ovopark.cloud.DTO.JobRecordDTO;
import com.ovopark.cloud.DTO.NewGoodsOrderDTO;
import com.ovopark.cloud.DTO.NewOrderDetailDTO;
import com.ovopark.cloud.DTO.OnDutyPersonDTO;
import com.ovopark.cloud.DTO.SummarizeTimeDTO;
import com.ovopark.cloud.VO.GetOrderDetailInfoVO;
import com.ovopark.cloud.VO.NewQueryOrderVO;
import com.ovopark.cloud.VO.PlatFormOrderVO;
import com.ovopark.cloud.VO.SummarizeVO;
import com.ovopark.cloud.base.PageInfo;
import com.ovopark.cloud.base.WanjiResponse;
import com.ovopark.cloud.billiards.BilliardsOrderForeignService;
import com.ovopark.cloud.common.ToolCommon;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.enums.CloudPlatformEnum;
import com.ovopark.cloud.mater.MasterStrokeService;
import com.ovopark.cloud.query.GetOrderStatisticsInfoBatchQuery;
import com.ovopark.cloud.query.NewQueryOrderQuery;
import com.ovopark.cloud.query.PlatFormOrderQueryReq;
import com.ovopark.cloud.utils.OnDutyCommon;
import com.ovopark.cloud.wanji.NewWanJiOrderForeignService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrderCommon {
    private static final Logger log = LoggerFactory.getLogger(OrderCommon.class);
    @Autowired(required=false)
    private NewWanJiOrderForeignService newWanJiOrderForeignService;
    @Autowired(required=false)
    private OnDutyCommon onDutyCommon;
    @Autowired(required=false)
    private MasterStrokeService masterStrokeService;
    @Autowired
    private BilliardsOrderForeignService billiardsOrderForeignService;

    public GetOrderStatisticsInfoDTO getOrderStatisticsInfo(Integer depId, LocalDateTime start, LocalDateTime end, String token, String platform) {
        GetOrderStatisticsInfoDTO result = new GetOrderStatisticsInfoDTO();
        result.setOrderCount(Integer.valueOf(0));
        result.setTurnover(BigDecimal.valueOf(0L));
        result.setPayOrderNum(Integer.valueOf(0));
        if (depId == null || start == null || end == null || start.isEqual(end) && start.isAfter(end)) {
            return result;
        }
        GetOrderStatisticsInfoBatchQuery param = new GetOrderStatisticsInfoBatchQuery();
        param.setDepId(depId);
        ArrayList<JobRecordDTO> recordList = new ArrayList<JobRecordDTO>();
        JobRecordDTO model = new JobRecordDTO();
        model.setId(Integer.valueOf(0));
        model.setStart(start);
        model.setEnd(end);
        recordList.add(model);
        param.setRecordList(recordList);
        List<GetOrderStatisticsInfoBatchDTO> res = this.getOrderStatisticsInfoBatch(param, token, platform);
        if (CollectionUtils.isEmpty(res)) {
            return result;
        }
        result.setOrderCount(res.get(0).getOrderCount());
        result.setTurnover(res.get(0).getTurnover());
        result.setPayOrderNum(res.get(0).getPayOrderNum());
        result.setTotalTurnover(res.get(0).getTotalTurnover());
        result.setTotalPayOrderNum(res.get(0).getTotalPayOrderNum());
        return result;
    }

    public WanjiResponse<List<SummarizeVO>> summarize(SummarizeBO request, String token, String platform) {
        WanjiResponse result = null;
        result = CloudPlatformEnum.BILLIARDS.getCode().equals(platform) ? this.billiardsOrderForeignService.summarize(token, request) : this.newWanJiOrderForeignService.summarize(token, request);
        return result;
    }

    public List<GetOrderStatisticsInfoBatchDTO> getOrderStatisticsInfoBatch(GetOrderStatisticsInfoBatchQuery param, String token, String platform) {
        ArrayList<GetOrderStatisticsInfoBatchDTO> result = new ArrayList<GetOrderStatisticsInfoBatchDTO>();
        if (param == null || param.getDepId() == null || CollectionUtils.isEmpty((Collection)param.getRecordList())) {
            return result;
        }
        SummarizeBO request = new SummarizeBO();
        request.setWdzDeptId(param.getDepId());
        ArrayList<SummarizeTimeDTO> timeRanges = new ArrayList<SummarizeTimeDTO>();
        SummarizeTimeDTO timeModel = new SummarizeTimeDTO();
        for (JobRecordDTO item : param.getRecordList()) {
            timeModel = new SummarizeTimeDTO();
            timeModel.setStartTime(item.getStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            timeModel.setEndTime(item.getEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            timeRanges.add(timeModel);
        }
        request.setTimeRanges(timeRanges);
        WanjiResponse res = null;
        res = CloudPlatformEnum.BILLIARDS.getCode().equals(platform) ? this.billiardsOrderForeignService.summarize(token, request) : this.newWanJiOrderForeignService.summarize(token, request);
        if (res == null || res.getCode() != 0 || CollectionUtils.isEmpty((Collection)((Collection)res.getData()))) {
            return result;
        }
        HashMap<String, SummarizeVO> map = new HashMap<String, SummarizeVO>();
        for (SummarizeVO item : (List)res.getData()) {
            if (item.getTimeRange() == null || item.getTimeRange().getStartTime() == null || item.getTimeRange().getEndTime() == null) continue;
            String key = String.format("%s_%s", item.getTimeRange().getStartTime(), item.getTimeRange().getEndTime());
            map.put(key, item);
        }
        GetOrderStatisticsInfoBatchDTO model = new GetOrderStatisticsInfoBatchDTO();
        for (JobRecordDTO item : param.getRecordList()) {
            model = new GetOrderStatisticsInfoBatchDTO();
            model.setId(item.getId());
            model.setOrderCount(Integer.valueOf(0));
            model.setTurnover(BigDecimal.valueOf(0L));
            model.setPayOrderNum(Integer.valueOf(0));
            String key = String.format("%s_%s", item.getStart().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), item.getEnd().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            if (!map.isEmpty() && map.containsKey(key)) {
                SummarizeVO info = (SummarizeVO)map.get(key);
                model.setOrderCount(info.getOrderNum());
                model.setTurnover(info.getPayAmount());
                model.setPayOrderNum(info.getPayOrderNum());
                model.setTotalPayOrderNum(info.getTotalPayOrderNum());
                model.setTotalTurnover(info.getTotalPayAmount());
            }
            result.add(model);
        }
        return result;
    }

    public PageInfo<NewQueryOrderVO> getOrderList(String authorization, NewQueryOrderQuery request, String platform) {
        PageInfo page = new PageInfo();
        ArrayList<NewQueryOrderVO> records = new ArrayList<NewQueryOrderVO>();
        page.setTotal(Integer.valueOf(0));
        page.setRecords(records);
        WanjiResponse result = null;
        result = CloudPlatformEnum.BILLIARDS.getCode().equals(platform) ? this.billiardsOrderForeignService.newQueryOrder(authorization, request) : this.newWanJiOrderForeignService.newQueryOrder(authorization, request);
        if (result == null || result.getCode() != 0 || result.getData() == null) {
            return page;
        }
        List list = ((PageInfo)result.getData()).getRecords() == null ? new ArrayList() : ((PageInfo)result.getData()).getRecords();
        NewQueryOrderVO model = new NewQueryOrderVO();
        for (NewQueryOrderVO item : list) {
            model = new NewQueryOrderVO();
            model.setId(item.getId());
            model.setOrderSn(item.getOrderSn());
            model.setTotalPrice(item.getTotalPrice());
            model.setTotalQuantity(item.getTotalQuantity());
            model.setPayerPhone(ToolCommon.phoneDesensitization((String)item.getPayerPhone()));
            model.setFirstGoodsImg(item.getFirstGoodsImg());
            model.setAllGoodsImgs(item.getAllGoodsImgs());
            model.setServiceStartTime(item.getServiceStartTime());
            model.setServiceEndTime(item.getServiceEndTime());
            model.setCreateTime(item.getCreateTime());
            model.setHasRefund(item.getHasRefund());
            model.setOrderStatus(item.getOrderStatus());
            model.setIsInspectOrder(item.getIsInspectOrder());
            model.setInspectId(item.getInspectId());
            records.add(model);
        }
        page.setTotal(((PageInfo)result.getData()).getTotal());
        page.setRecords(records);
        return page;
    }

    public GetOrderDetailInfoVO getOrderDetailInfo(String authorization, String orderSn, String platform) {
        WanjiResponse res = null;
        if (CloudPlatformEnum.BILLIARDS.getCode().equals(platform)) {
            NewQueryOrderQuery orderQuery = new NewQueryOrderQuery();
            orderQuery.setOrderSn(orderSn);
            res = this.billiardsOrderForeignService.newOrderDetail(authorization, orderQuery);
        } else {
            res = this.newWanJiOrderForeignService.newOrderDetail(authorization, orderSn);
        }
        if (res == null || res.getCode() != 0 || res.getData() == null) {
            return null;
        }
        NewOrderDetailDTO info = (NewOrderDetailDTO)res.getData();
        GetOrderDetailInfoVO result = new GetOrderDetailInfoVO();
        result.setOrderSn(info.getOrderSn());
        result.setCreateTime(info.getCreateTime());
        result.setName(info.getUserName());
        result.setPayerPhone(ToolCommon.phoneDesensitization((String)info.getUserPhone()));
        result.setServiceStartTime(info.getServiceStartTime());
        result.setServiceEndTime(info.getServiceEndTime());
        result.setPaymentTime(info.getPaymentTime());
        result.setCanRefund(info.isCanRefund());
        result.setHasRefund(info.getHasRefund());
        result.setAfterSaleSn(info.getAfterSaleSn());
        result.setPayChannel(info.getPayChannel());
        result.setInspectId(info.getInspectId());
        result.setInspectOrder(info.isInspectOrder());
        result.setFeeAmount(info.getFeeAmount());
        result.setFeeType(info.getFeeType());
        OnDutyPersonDTO person = this.onDutyCommon.getOnDutyPersonByOrderNo(info.getOrderSn());
        result.setWorkName(person != null && StringUtils.isNotEmpty((CharSequence)person.getName()) ? person.getName() : "");
        result.setServiceId(Integer.valueOf(person != null && StringUtils.isNotEmpty((CharSequence)person.getServiceNo()) ? Integer.valueOf(person.getServiceNo()) : 0));
        result.setWorkId(Integer.valueOf(person != null && StringUtils.isNotEmpty((CharSequence)person.getWorkNo()) ? Integer.valueOf(person.getWorkNo()) : 0));
        result.setGoodsList(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)info.getGoodsList())) {
            return result;
        }
        ArrayList<GoodsOrderDTO> goodsList = new ArrayList<GoodsOrderDTO>();
        GoodsOrderDTO model = new GoodsOrderDTO();
        for (NewGoodsOrderDTO item : info.getGoodsList()) {
            model = new GoodsOrderDTO();
            model.setName(item.getName());
            model.setImg(item.getImg());
            model.setGoodsPrice(item.getGoodsPrice());
            model.setQuantity(item.getQuantity());
            model.setActualPrice(item.getTotalPrice());
            model.setGoodsId(item.getGoodsId());
            model.setIfRefunding(item.getIfRefunding());
            model.setRefundQuantity(item.getRefundQuantity());
            model.setRefundAmount(item.getRefundAmount());
            String traceabilityCode = item.getTraceabilityCodes();
            if (StringUtils.isNotEmpty((CharSequence)traceabilityCode)) {
                List<String> traceabilityCodes = Arrays.asList(traceabilityCode.split(","));
                model.setTraceabilityCode(traceabilityCodes);
            }
            goodsList.add(model);
        }
        result.setGoodsList(goodsList);
        return result;
    }

    public PageInfo<PlatFormOrderVO> getPlatformOrderList(String authorization, PlatFormOrderQueryReq request) {
        PageInfo page = new PageInfo();
        ArrayList records = new ArrayList();
        page.setTotal(Integer.valueOf(0));
        page.setRecords(records);
        WanjiResponse result = this.newWanJiOrderForeignService.platformQueryOrder(authorization, request);
        if (result == null || result.getCode() != 0 || result.getData() == null) {
            return page;
        }
        List list = ((PageInfo)result.getData()).getRecords() == null ? new ArrayList() : ((PageInfo)result.getData()).getRecords();
        Map<Integer, String> depNameMap = this.getDepNameMap(list.stream().map(item -> item.getDepId()).distinct().collect(Collectors.toList()));
        Map<Integer, String> enterpriseNameMap = this.getEnterpriseNameMap(list.stream().map(item -> item.getGroupId()).distinct().collect(Collectors.toList()));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PlatFormOrderVO item2;
            item2.setDepName(StringUtils.isNotEmpty((CharSequence)depNameMap.get((item2 = (PlatFormOrderVO)iterator.next()).getDepId())) ? depNameMap.get(item2.getDepId()) : "");
            item2.setEnterpriseName(StringUtils.isNotEmpty((CharSequence)enterpriseNameMap.get(item2.getGroupId())) ? enterpriseNameMap.get(item2.getGroupId()) : "");
            try {
                OnDutyPersonDTO person = this.onDutyCommon.getOnDutyPersonByOrderNo(item2.getOrderSn());
                if (person == null) continue;
                item2.setServiceUserName(StringUtils.isNotEmpty((CharSequence)person.getName()) ? person.getName() : "");
                item2.setServiceNo(StringUtils.isNotEmpty((CharSequence)person.getServiceNo()) ? person.getServiceNo() : "");
            }
            catch (Exception e) {
                item2.setServiceUserName("");
                item2.setServiceNo("");
                log.error("getPlatformOrderList_\u83b7\u53d6\u503c\u5b88\u4eba\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            }
        }
        page.setTotal(((PageInfo)result.getData()).getTotal());
        page.setRecords(list);
        return page;
    }

    public Map<Integer, String> getDepNameMap(List<Integer> depIds) {
        HttpResponseEntity baseResult = this.masterStrokeService.getDepartmentByIds(depIds);
        Map<Integer, String> depMap = new HashMap<Integer, String>();
        if (!CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            depMap = ((List)baseResult.getData()).stream().collect(Collectors.toMap(DepartmentPojo::getId, DepartmentPojo::getName));
        }
        return depMap;
    }

    public Map<Integer, String> getEnterpriseNameMap(List<Integer> enterpriseIds) {
        HttpResponseEntity baseResult = this.masterStrokeService.getEnterpriseByIdsApi(enterpriseIds);
        Map<Integer, String> enterpriseMap = new HashMap<Integer, String>();
        if (!CollectionUtils.isEmpty((Collection)((Collection)baseResult.getData()))) {
            enterpriseMap = ((List)baseResult.getData()).stream().collect(Collectors.toMap(EnterpriseConfigPojo::getId, EnterpriseConfigPojo::getName));
        }
        return enterpriseMap;
    }
}

