/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.cloud.BO.GetAudioVolumeFeignBO;
import com.ovopark.cloud.DTO.AreaCityDTO;
import com.ovopark.cloud.DTO.GetDepartmentInfoDTO;
import com.ovopark.cloud.VO.CloudStoreBankVO;
import com.ovopark.cloud.VO.GetAudioVolumeFeignVO;
import com.ovopark.cloud.VO.GetDepartmentInfoVO;
import com.ovopark.cloud.VO.GetDeviceListVO;
import com.ovopark.cloud.VO.GetSelectDepByUserIdVo;
import com.ovopark.cloud.VO.YzsDeviceFeignVo;
import com.ovopark.cloud.base.DeviceBaseResponse;
import com.ovopark.cloud.dao.state.AreasDao;
import com.ovopark.cloud.dao.state.CloudSearchDepartmentsDao;
import com.ovopark.cloud.dao.state.CloudStoreFundsDao;
import com.ovopark.cloud.dao.state.CloudStorePicDao;
import com.ovopark.cloud.dao.state.CloudStoreSettingsDao;
import com.ovopark.cloud.entity.CloudSearchDepartmentsDO;
import com.ovopark.cloud.entity.CloudStoreFundsDO;
import com.ovopark.cloud.entity.CloudStorePicDO;
import com.ovopark.cloud.entity.CloudStoreSettingsDO;
import com.ovopark.cloud.entity.HttpResponseEntity;
import com.ovopark.cloud.enums.StorePicTypeEnum;
import com.ovopark.cloud.mater.DeviceService;
import com.ovopark.cloud.mater.MasterStrokeService;
import com.ovopark.cloud.wanji.NewWanJiOrderForeignService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ShopWebCommon {
    private static final Logger log = LoggerFactory.getLogger(ShopWebCommon.class);
    @Autowired
    private CloudSearchDepartmentsDao cloudSearchDepartmentsDao;
    @Autowired
    private MasterStrokeService masterStrokeService;
    @Autowired
    private NewWanJiOrderForeignService newWanJiOrderForeignService;
    @Autowired
    private CloudStorePicDao cloudStorePicDao;
    @Autowired
    private CloudStoreFundsDao cloudStoreFundsDao;
    @Autowired
    private DeviceService deviceService;
    @Value(value="#{'${device.type:}'.empty ?  null : '${device.type}'.split(',')}")
    private Set<Integer> deviceTypeSet;
    @Value(value="${device.nvrType}")
    private String nvrType;
    @Autowired
    private AreasDao areasDao;
    @Autowired
    private CloudStoreSettingsDao cloudStoreSettingsDao;

    public GetDepartmentInfoVO getDepartmentInfo(String token, Integer depId) {
        CloudStoreSettingsDO cloudStoreSettings;
        List cloudStorePicList;
        CloudStoreFundsDO cloudStoreFunds;
        HttpResponseEntity res = this.masterStrokeService.getDepartmentInfoById(token, depId);
        if (res == null || res.getCode() != 0 || res.getData() == null) {
            return null;
        }
        GetDepartmentInfoDTO depInfo = (GetDepartmentInfoDTO)res.getData();
        GetDepartmentInfoVO result = new GetDepartmentInfoVO();
        result.setDepId(depId);
        result.setCompanyName(depInfo.getGroupName());
        result.setDepartmentName(depInfo.getName());
        result.setAreaName(depInfo.getLocationName());
        result.setAddress(depInfo.getAddress());
        result.setManagerName(depInfo.getContactor());
        result.setPhone(depInfo.getMobilePhone());
        result.setShopPic(depInfo.getLogoUrl());
        result.setLicensePic("");
        result.setIdType(Integer.valueOf(0));
        result.setIdNo("");
        result.setIdFrontPic("");
        result.setIdBackendPic("");
        result.setGroupId(depInfo.getGroupId());
        result.setShopOwnerId(depInfo.getShopOwnerId());
        result.setIdName("");
        result.setValidityStatus(Integer.valueOf(0));
        result.setValidityStartDate("");
        result.setValidityEndDate("");
        result.setProvince("");
        result.setCity("");
        result.setDistrict("");
        result.setIdAddress("");
        result.setContactPhone("");
        result.setActualOperatorPic("");
        result.setUnifiedSocialCreditCode("");
        result.setLicenseName("");
        result.setLegalRepresentative("");
        result.setBindStatus(Integer.valueOf(0));
        result.setIsOnDutyGuard(depInfo.getIsOnDutyGuard());
        result.setLicensePicStartDate("");
        result.setLicensePicEndDate("");
        result.setDutyGuardServiceOn(depInfo.getDutyGuardServiceOn());
        result.setStoreContactPhone("");
        CloudSearchDepartmentsDO departmentsDO = (CloudSearchDepartmentsDO)this.cloudSearchDepartmentsDao.selectById((Serializable)depId);
        if (departmentsDO != null) {
            result.setLicensePic(departmentsDO.getLicensePic());
            result.setIdType(departmentsDO.getIdType());
            result.setIdNo(departmentsDO.getIdNo());
            result.setIdFrontPic(departmentsDO.getIdFrontPic());
            result.setIdBackendPic(departmentsDO.getIdBackendPic());
            result.setIdName(departmentsDO.getIdName());
            result.setValidityStatus(departmentsDO.getValidityStatus());
            result.setValidityStartDate(departmentsDO.getValidityStartDate());
            result.setValidityEndDate(departmentsDO.getValidityEndDate());
            result.setProvince(departmentsDO.getProvince());
            result.setCity(departmentsDO.getCity());
            result.setDistrict(departmentsDO.getDistrict());
            result.setUnifiedSocialCreditCode(departmentsDO.getUnifiedSocialCreditCode());
            result.setLicenseName(departmentsDO.getLicenseName());
            result.setLicensePicStartDate(departmentsDO.getLicensePicStartDate());
            result.setLicensePicEndDate(departmentsDO.getLicensePicEndDate());
            result.setBusinessType(departmentsDO.getBusinessType());
            result.setStoreContactPhone(departmentsDO.getStoreContactPhone());
            if (departmentsDO.getBusinessCategory() == 0) {
                result.setBusinessCategory(null);
            } else {
                result.setBusinessCategory(Integer.valueOf(departmentsDO.getBusinessCategory()));
            }
            result.setLegalRepresentative(departmentsDO.getLegalRepresentative());
            if (StringUtils.isNotEmpty((CharSequence)result.getDistrict())) {
                AreaCityDTO areaCity = this.areasDao.selectAreaCity(result.getDistrict());
                String cityName = "";
                if (areaCity != null) {
                    cityName = areaCity.getProvinceName() + "/" + areaCity.getCityName() + "/" + areaCity.getAreaName();
                }
                result.setCityName(cityName);
            }
            result.setIdAddress(departmentsDO.getIdAddress());
            result.setContactPhone(departmentsDO.getContactPhone());
            result.setActualOperatorPic(departmentsDO.getActualOperatorPic());
        }
        if ((cloudStoreFunds = (CloudStoreFundsDO)this.cloudStoreFundsDao.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudStoreFundsDO::getStoreId, (Object)depId)).eq(CloudStoreFundsDO::getRowStatus, (Object)1))) != null) {
            result.setBindStatus(Integer.valueOf(1));
            CloudStoreBankVO cloudStoreBank = new CloudStoreBankVO();
            cloudStoreBank.setStoreId(cloudStoreFunds.getStoreId());
            cloudStoreBank.setBankName(cloudStoreFunds.getBindGroupName());
            cloudStoreBank.setBankAccountNo(cloudStoreFunds.getBindAccountNo());
            cloudStoreBank.setUserName(cloudStoreFunds.getBindUserName());
            cloudStoreBank.setUserPhone(cloudStoreFunds.getBindUserPhone());
            cloudStoreBank.setCardType(cloudStoreFunds.getBindAccountType());
            cloudStoreBank.setBankFrontPic(cloudStoreFunds.getBankFrontPic());
            cloudStoreBank.setBankBackendPic(cloudStoreFunds.getBankBackendPic());
            cloudStoreBank.setType(cloudStoreFunds.getType());
            cloudStoreBank.setBankNo(cloudStoreFunds.getBankNo());
            cloudStoreBank.setAccountOpeningPermitPic(cloudStoreFunds.getAccountOpeningPermitPic());
            result.setCloudStoreBankVO(cloudStoreBank);
        }
        if (!(cloudStorePicList = this.cloudStorePicDao.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CloudStorePicDO::getStoreId, (Object)depId)).eq(CloudStorePicDO::getRowStatus, (Object)1))).isEmpty()) {
            Map<Integer, List<CloudStorePicDO>> picMap = cloudStorePicList.stream().collect(Collectors.groupingBy(CloudStorePicDO::getPicType));
            List<CloudStorePicDO> defaultPicList = picMap.get(StorePicTypeEnum.DEFAULT_PIC.getCode());
            List<CloudStorePicDO> doorPicList = picMap.get(StorePicTypeEnum.DOOR_PIC.getCode());
            List<CloudStorePicDO> cashPicList = picMap.get(StorePicTypeEnum.CASH_PIC.getCode());
            List<CloudStorePicDO> shelvesPicList = picMap.get(StorePicTypeEnum.SHELVES_PIC.getCode());
            result.setStorePic(defaultPicList == null || defaultPicList.isEmpty() ? null : defaultPicList.stream().map(CloudStorePicDO::getPicUrl).collect(Collectors.toList()));
            result.setDoorPic(doorPicList == null || doorPicList.isEmpty() ? null : doorPicList.get(0).getPicUrl());
            result.setCashPic(cashPicList == null || cashPicList.isEmpty() ? null : cashPicList.get(0).getPicUrl());
            result.setShelvesPic(shelvesPicList == null || shelvesPicList.isEmpty() ? null : shelvesPicList.get(0).getPicUrl());
        }
        if ((cloudStoreSettings = (CloudStoreSettingsDO)this.cloudStoreSettingsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreSettingsDO::getStoreId, (Object)depId))) != null) {
            result.setRemark(cloudStoreSettings.getRemark());
        }
        return result;
    }

    public List<YzsDeviceFeignVo> getAllDeviceList(Integer depId, Integer userId) {
        HttpResponseEntity res = this.deviceService.depDeviceList(depId, userId);
        if (res == null || res.getCode() != 0 || res.getData() == null) {
            return new ArrayList<YzsDeviceFeignVo>();
        }
        List list = (List)res.getData();
        CloudStoreSettingsDO cloudStoreSettings = (CloudStoreSettingsDO)this.cloudStoreSettingsDao.selectOne((Wrapper)new LambdaQueryWrapper().eq(CloudStoreSettingsDO::getStoreId, (Object)depId));
        if (cloudStoreSettings == null || cloudStoreSettings.getDoorStatus() == 0) {
            list = list.stream().filter(m -> m.getDtype().compareTo(302) != 0 || m.getIndex() != 1).collect(Collectors.toList());
        }
        return list;
    }

    public List<GetDeviceListVO> getDeviceList(Integer depId, Integer userId) {
        List<Object> list = new ArrayList();
        HashMap<Integer, GetAudioVolumeFeignVO> voiceMap = new HashMap<Integer, GetAudioVolumeFeignVO>();
        try {
            list = this.getAllDeviceList(depId, userId);
            if (list.isEmpty()) {
                return new ArrayList<GetDeviceListVO>();
            }
            list = list.stream().filter(item -> item.getDtype().compareTo(304) != 0 || item.getAudioOutputNumber() == null || item.getAudioOutputNumber().compareTo(2) != 0).collect(Collectors.toList());
            List nvrList = list.stream().filter(m -> m.getDtype() != null && m.getDtype() == 20).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((CharSequence)this.nvrType)) {
                nvrList = nvrList.stream().filter(m -> m.getDeviceType().endsWith(this.nvrType)).collect(Collectors.toList());
            }
            Integer deviceStatusId = CollectionUtils.isEmpty(nvrList) ? 0 : ((YzsDeviceFeignVo)nvrList.get(0)).getDeviceStatusId();
            List voiceNoList = list.stream().filter(m -> m.getAudioOutputNumber() != null).map(m -> m.getAudioOutputNumber()).distinct().collect(Collectors.toList());
            voiceNoList = voiceNoList.stream().filter(m -> m != null).collect(Collectors.toList());
            for (Integer no : voiceNoList) {
                GetAudioVolumeFeignBO request = new GetAudioVolumeFeignBO();
                request.setMainDeviceStatusId(deviceStatusId);
                request.setCard(no);
                request.setUserId(userId);
                HttpResponseEntity voiceRes = this.deviceService.getAudioVolume(request);
                if (voiceRes == null || voiceRes.getCode() != 0 || voiceRes.getData() == null || !((DeviceBaseResponse)voiceRes.getData()).getStatus().equals("comm_success") || ((DeviceBaseResponse)voiceRes.getData()).getData() == null) continue;
                GetAudioVolumeFeignVO voice = (GetAudioVolumeFeignVO)((DeviceBaseResponse)voiceRes.getData()).getData();
                voiceMap.put(no, voice);
            }
        }
        catch (Exception e) {
            log.error(String.format("\u8bbe\u5907\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38 ### %s", e.getMessage()), (Throwable)e);
        }
        ArrayList<GetDeviceListVO> result = new ArrayList<GetDeviceListVO>();
        GetDeviceListVO model = new GetDeviceListVO();
        for (YzsDeviceFeignVo yzsDeviceFeignVo : list) {
            GetAudioVolumeFeignVO voice;
            if (this.deviceTypeSet != null && !this.deviceTypeSet.isEmpty() && !this.deviceTypeSet.contains(yzsDeviceFeignVo.getDtype()) || yzsDeviceFeignVo.getDtype().compareTo(304) == 0 && yzsDeviceFeignVo.getAudioOutputNumber() != null && yzsDeviceFeignVo.getAudioOutputNumber() != 0 && yzsDeviceFeignVo.getAudioOutputNumber() != 1 || yzsDeviceFeignVo.getDtype().compareTo(303) == 0 && yzsDeviceFeignVo.getAudioOutputNumber() != null && yzsDeviceFeignVo.getAudioOutputNumber() != 0) continue;
            model = new GetDeviceListVO();
            model.setId(yzsDeviceFeignVo.getDeviceStatusId());
            model.setDeviceVideoId(yzsDeviceFeignVo.getDeviceId());
            model.setDeviceType(yzsDeviceFeignVo.getDeviceType());
            model.setDType(yzsDeviceFeignVo.getDtype());
            model.setName(yzsDeviceFeignVo.getDeviceName());
            model.setPic(yzsDeviceFeignVo.getThumbUrl());
            model.setIsOnline(yzsDeviceFeignVo.getOnline());
            model.setCreateTime(yzsDeviceFeignVo.getCreateTime());
            model.setPid(yzsDeviceFeignVo.getPid());
            model.setMac(yzsDeviceFeignVo.getMac());
            model.setCanOutLine(yzsDeviceFeignVo.getCanOutLine());
            model.setCanUpdateName(yzsDeviceFeignVo.getCanUpdateName());
            model.setVoiceNo(yzsDeviceFeignVo.getAudioOutputNumber());
            model.setIndex(yzsDeviceFeignVo.getIndex());
            model.setVolume(Integer.valueOf(0));
            model.setInQRStatus(Integer.valueOf(0));
            model.setOutQRStatus(Integer.valueOf(0));
            if (yzsDeviceFeignVo.getDtype().compareTo(303) == 0 && !voiceMap.isEmpty()) {
                voice = (GetAudioVolumeFeignVO)voiceMap.get(0);
                if (voice != null) {
                    model.setVolume(voice.getAiVolume());
                }
                if ((voice = (GetAudioVolumeFeignVO)voiceMap.get(1)) != null) {
                    model.setEchoVolume(voice.getAiVolume());
                }
            } else if (yzsDeviceFeignVo.getDtype().compareTo(304) == 0 && yzsDeviceFeignVo.getAudioOutputNumber() != null && !voiceMap.isEmpty() && voiceMap.containsKey(yzsDeviceFeignVo.getAudioOutputNumber())) {
                voice = (GetAudioVolumeFeignVO)voiceMap.get(yzsDeviceFeignVo.getAudioOutputNumber());
                model.setVolume(voice.getAoVolume());
            }
            model.setYzsMainIpc(yzsDeviceFeignVo.getYzsMainIpc());
            result.add(model);
        }
        return result;
    }

    public List<Integer> getPrivilegeDepIdsByUserId(String token, Integer userId, Integer groupId) {
        HttpResponseEntity deps = this.masterStrokeService.getSelectDepByUserId(token, groupId, userId, "");
        if (Objects.isNull(deps) || Objects.isNull(deps.getData())) {
            return null;
        }
        return ((List)deps.getData()).stream().map(GetSelectDepByUserIdVo::getId).collect(Collectors.toList());
    }

    public Boolean userIsAdmin(String token, Integer userId, Integer groupId) {
        HttpResponseEntity isAdmin = this.masterStrokeService.isSuperAdmin(token, userId, groupId);
        if (Objects.isNull(isAdmin) || Objects.isNull(isAdmin.getData())) {
            return false;
        }
        return (Boolean)isAdmin.getData();
    }
}

