/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.log.collect.filter;

import com.ovopark.log.collect.context.LogContext;
import com.ovopark.log.collect.context.SpanIdGenerator;
import com.ovopark.log.collect.model.RpcTrace;
import com.ovopark.log.collect.rpc.LogRpcHandler;
import com.ovopark.log.collect.util.StrUtil;
import java.util.Arrays;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider", "consumer"}, order=-10000)
public class LogDubboFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result = null;
        String side = invoker.getUrl().getParameter("side");
        if (side.equals("provider")) {
            String traceId = invocation.getAttachment("dc-log-trace-id");
            String spanId = invocation.getAttachment("dc-log-span-id");
            String args = invocation.getAttachment("dc-log-args");
            RpcTrace traceChain = new RpcTrace().setTraceId(traceId).setArgs(args).setSpanId(spanId);
            LogRpcHandler.processProviderSide((RpcTrace)traceChain);
            try {
                result = invoker.invoke(invocation);
            }
            finally {
                LogContext.removeAllThreadLocal();
            }
        } else if (side.equals("consumer")) {
            String traceId = LogContext.getTraceId();
            String args = LogContext.getArgs();
            if (StrUtil.isBlank((CharSequence)args)) {
                args = Arrays.toString(invocation.getArguments());
            }
            if (!StrUtil.isBlank((CharSequence)traceId)) {
                RpcContext.getContext().setAttachment("dc-log-trace-id", traceId);
                RpcContext.getContext().setAttachment("dc-log-args", args);
                RpcContext.getContext().setAttachment("dc-log-span-id", SpanIdGenerator.generateNextSpanId());
            }
            result = invoker.invoke(invocation);
        }
        return result;
    }
}

