package com.ovopark.dc.dynamicroute;

import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Configuration for  {@link DynamicRouteListener}.
 *
 * @author <a href="mailto:guyue375@outlook.com">Klaus.turbo</a>
 * @program dc-avengers-ingress
 **/
@Slf4j
@Configuration
public class DynamicRouteAutoConfiguration {
    
    @Bean
    public DynamicRouteListener dynamicRouteListener(RouteLocator routeLocator) {
        log.info("[DynamicRouteListener] init DynamicRouteListener ...");
        return new DynamicRouteListener(routeLocator);
    }
}
