/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.dynamicroute;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.cloud.netflix.zuul.RoutesRefreshedEvent;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;

public class DynamicRouteListener
implements ApplicationListener<RefreshEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DynamicRouteListener.class);
    private final RouteLocator routeLocator;
    private ApplicationContext context;

    public DynamicRouteListener(RouteLocator routeLocator) {
        this.routeLocator = routeLocator;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void onApplicationEvent(@NonNull RefreshEvent refreshEvent) {
        log.warn("[RefreshEvent] Listens to the refresh event and prepares to refresh the application context ...");
        this.context.publishEvent((ApplicationEvent)new RoutesRefreshedEvent(this.routeLocator));
    }
}

