/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.netflix.zuul;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import org.springframework.cloud.netflix.zuul.filters.route.FallbackProvider;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;

public class DefaultFallbackProvider
implements FallbackProvider {
    public String getRoute() {
        return null;
    }

    public ClientHttpResponse fallbackResponse(String route, Throwable cause) {
        if (cause instanceof SocketTimeoutException) {
            return this.response(HttpStatus.GATEWAY_TIMEOUT, route, HttpStatus.INTERNAL_SERVER_ERROR.value(), "Service " + route + " process timeout");
        }
        return this.response(HttpStatus.INTERNAL_SERVER_ERROR, route, HttpStatus.INTERNAL_SERVER_ERROR.value(), "Service " + route + " process failed");
    }

    private ClientHttpResponse response(final HttpStatus status, String route, final int code, final String msg) {
        return new ClientHttpResponse(){

            @NonNull
            public HttpStatus getStatusCode() {
                return status;
            }

            public int getRawStatusCode() {
                return status.value();
            }

            @NonNull
            public String getStatusText() {
                return status.getReasonPhrase();
            }

            public void close() {
            }

            @NonNull
            public InputStream getBody() {
                HashMap<String, Object> resMap = new HashMap<String, Object>(4, 1.0f);
                resMap.put("success", false);
                resMap.put("code", code);
                resMap.put("msg", msg);
                return new ByteArrayInputStream(JSON.toJSONBytes(resMap, (SerializerFeature[])new SerializerFeature[0]));
            }

            @NonNull
            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                return headers;
            }
        };
    }
}

