/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.netflix.zuul;

import com.ovopark.dc.netflix.zuul.DefaultFallbackProvider;
import com.ovopark.dc.netflix.zuul.ZuulPluginProperties;
import com.ovopark.dc.netflix.zuul.ZuulPropertiesBeanPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.zuul.EnableZuulProxy;
import org.springframework.cloud.netflix.zuul.ZuulProxyAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableZuulProxy
@AutoConfigureBefore(value={ZuulProxyAutoConfiguration.class})
@EnableConfigurationProperties(value={ZuulPluginProperties.class, ZuulPluginProperties.ZuulRouterExtendedProperties.class})
@ConditionalOnProperty(prefix="avengers.ingress.zuul", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class ZuulPluginAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ZuulPluginAutoConfiguration.class);

    @Bean
    ZuulPropertiesBeanPostProcessor zuulPropertiesBeanPostProcessor() {
        log.info("[ZuulPluginAutoConfiguration # zuulPropertiesBeanPostProcessor] init ZuulPropertiesBeanPostProcessor ...");
        return new ZuulPropertiesBeanPostProcessor();
    }

    @Bean
    DefaultFallbackProvider defaultFallbackProvider() {
        log.info("[ZuulPluginAutoConfiguration # defaultFallbackProvider] init DefaultFallbackProvider ...");
        return new DefaultFallbackProvider();
    }
}

