/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.netflix.zuul;

import com.ovopark.dc.netflix.zuul.ZuulPluginProperties;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.netflix.zuul.filters.ZuulProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;

public class ZuulPropertiesBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(ZuulPropertiesBeanPostProcessor.class);
    private ApplicationContext context;

    public Object postProcessBeforeInitialization(@NonNull Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        if (bean instanceof ZuulPluginProperties.ZuulRouterExtendedProperties) {
            log.debug("[ZuulPropertiesBeanPostProcessor] {}", bean.getClass());
        }
        if (bean instanceof ZuulProperties) {
            ZuulProperties properties = (ZuulProperties)bean;
            ZuulPluginProperties.ZuulRouterExtendedProperties zep = (ZuulPluginProperties.ZuulRouterExtendedProperties)this.context.getBean(ZuulPluginProperties.ZuulRouterExtendedProperties.class);
            properties.getRoutes().putAll(zep.getRoutes());
            log.info("[ZuulPropertiesBeanPostProcessor] Extended zuul route properties is processed.");
        }
        return bean;
    }

    public void setApplicationContext(@NonNull ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void afterSingletonsInstantiated() {
        ObjectProvider objectProvider = this.context.getBeanProvider(ZuulProperties.class);
        ObjectProvider zuulRouterExtendedProperties = this.context.getBeanProvider(ZuulPluginProperties.ZuulRouterExtendedProperties.class);
        ZuulProperties zuulProperties = (ZuulProperties)objectProvider.getIfAvailable();
        ZuulPluginProperties.ZuulRouterExtendedProperties zep = (ZuulPluginProperties.ZuulRouterExtendedProperties)zuulRouterExtendedProperties.getIfAvailable();
        if (Objects.nonNull(zuulProperties) && Objects.nonNull(zep)) {
            zuulProperties.getRoutes().putAll(zep.getRoutes());
        } else {
            log.warn("[ZuulPropertiesBeanPostProcessor] Something wrong when configure zuul properties.");
        }
    }
}

