package com.ovopark.dc.grayscalepublish;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.Executor;

/**
 * Listener for Gray-Scale config {@link GrayScaleConfigSubscriber} .
 *
 * @author <a href="mailto:guyue375@outlook.com">Klaus.turbo</a>
 * @program dc-avengers-ingress
 **/
@Slf4j
@Configuration
@ConditionalOnProperty(value = "avengers.ingress.gray.config.refresh.enable", havingValue = "true", matchIfMissing = true)
public class GrayScaleConfigSubscriber {
    
    /**
     * dataId : Configuration for Gray.
     */
    private static final String GRAY_DATA_ID = "ingress-grayscale-config.json";
    
    /**
     * group : Gray group.
     */
    private static final String GRAY_GROUP = "DEFAULT_GROUP";
    
    /**
     * Manager for nacos config .
     */
    private final NacosConfigManager nacosConfigManager;
    
    public GrayScaleConfigSubscriber(NacosConfigManager nacosConfigManager) throws NacosException {
        this.nacosConfigManager = nacosConfigManager;
        init();
    }
    
    public void init() throws NacosException {
        ConfigService configService = nacosConfigManager.getConfigService();
        String content = configService.getConfig(GRAY_DATA_ID, GRAY_GROUP, 5000);
        System.out.println("[Gray-Config]: \n" + content);
        configService.addListener(GRAY_DATA_ID, GRAY_GROUP, new Listener() {
            @Override
            public void receiveConfigInfo(String configInfo) {
                log.info("[GrayScaleConfigSubscriber] Gray config refreshed : {}", configInfo);
            }
            
            @Override
            public Executor getExecutor() {
                return null;
            }
        });
    }
}
