package com.ovopark.dc.grayscalepublish;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.exception.NacosException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Configuration for Gray .
 *
 * @author <a href="mailto:guyue375@outlook.com">Klaus.turbo</a>
 * @program dc-avengers-ingress
 **/
@Slf4j
@Configuration
@ConditionalOnProperty(value = "avengers.ingress.gray.enable",havingValue = "true",matchIfMissing = true)
public class GrayScalePublishConfiguration {
    
    private final NacosConfigManager nacosConfigManager;
    
    public GrayScalePublishConfiguration(NacosConfigManager nacosConfigManager) {
        this.nacosConfigManager = nacosConfigManager;
    }
    
    @Bean
    public GrayScaleConfigSubscriber grayScaleConfigSubscriber() throws NacosException {
        log.info("[GrayScalePublishConfiguration] init GrayScaleConfigSubscriber ...");
        return new GrayScaleConfigSubscriber(nacosConfigManager);
    }
    
    @Bean
    public NacosServerListBeanPostProcessor nacosServerListBeanPostProcessor(){
        log.info("[GrayScalePublishConfiguration] init NacosServerListBeanPostProcessor ...");
        return new NacosServerListBeanPostProcessor();
    }
}
