/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.grayscalepublish;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"avengers.ingress.gray.config.refresh.enable"}, havingValue="true", matchIfMissing=true)
public class GrayScaleConfigSubscriber {
    private static final Logger log = LoggerFactory.getLogger(GrayScaleConfigSubscriber.class);
    private static final String GRAY_DATA_ID = "ingress-grayscale-config.json";
    private static final String GRAY_GROUP = "DEFAULT_GROUP";
    private final NacosConfigManager nacosConfigManager;

    public GrayScaleConfigSubscriber(NacosConfigManager nacosConfigManager) throws NacosException {
        this.nacosConfigManager = nacosConfigManager;
        this.init();
    }

    public void init() throws NacosException {
        ConfigService configService = this.nacosConfigManager.getConfigService();
        String content = configService.getConfig(GRAY_DATA_ID, GRAY_GROUP, 5000L);
        System.out.println("[Gray-Config]: \n" + content);
        configService.addListener(GRAY_DATA_ID, GRAY_GROUP, new Listener(){

            public void receiveConfigInfo(String configInfo) {
                log.info("[GrayScaleConfigSubscriber] Gray config refreshed : {}", (Object)configInfo);
            }

            public Executor getExecutor() {
                return null;
            }
        });
    }
}

