/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.grayscalepublish;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.ovopark.dc.grayscalepublish.GrayScaleConfigSubscriber;
import com.ovopark.dc.grayscalepublish.NacosServerListBeanPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"avengers.ingress.gray.enable"}, havingValue="true", matchIfMissing=true)
public class GrayScalePublishConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GrayScalePublishConfiguration.class);
    private final NacosConfigManager nacosConfigManager;

    public GrayScalePublishConfiguration(NacosConfigManager nacosConfigManager) {
        this.nacosConfigManager = nacosConfigManager;
    }

    @Bean
    public GrayScaleConfigSubscriber grayScaleConfigSubscriber() throws NacosException {
        log.info("[GrayScalePublishConfiguration] init GrayScaleConfigSubscriber ...");
        return new GrayScaleConfigSubscriber(this.nacosConfigManager);
    }

    @Bean
    public NacosServerListBeanPostProcessor nacosServerListBeanPostProcessor() {
        log.info("[GrayScalePublishConfiguration] init NacosServerListBeanPostProcessor ...");
        return new NacosServerListBeanPostProcessor();
    }
}

