/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyEventRule;
import com.ovopark.dc.alarm.api.enums.AlarmHistoryStatusEnum;
import com.ovopark.dc.alarm.api.enums.AlarmModeEnum;
import com.ovopark.dc.alarm.api.enums.HandleStateEnum;
import com.ovopark.dc.alarm.api.enums.MonitorResourceEnum;
import com.ovopark.dc.alarm.api.enums.MonitorSourceEnum;
import com.ovopark.dc.alarm.api.model.AlarmStrategyBodyWrapper;
import com.ovopark.dc.alarm.api.model.QuotaEntity;
import java.io.Serializable;
import java.util.Date;

@TableName(value="alarm_event_history")
public class AlarmEventHistory
implements Serializable {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    private Integer dimension;
    private String downResource;
    private Date alarmTime;
    private String resource;
    private String quotaName;
    private String eventDetail;
    private String alarmMode;
    private String source;
    private Integer handleState;
    private String handleBy;
    private Date handleTime;
    private Integer status;
    private Date recoverTime;

    public static AlarmEventHistory convertFrom(AlarmStrategyEventRule eventRule, String downResource, AlarmStrategyBodyWrapper bodyWrapper, QuotaEntity quotaEntity, AlarmHistoryStatusEnum statusEnum) {
        AlarmEventHistory quotaHistory = new AlarmEventHistory();
        quotaHistory.setAlarmTime(new Date());
        quotaHistory.setDownResource(downResource);
        quotaHistory.setDimension(bodyWrapper.getMonitorDimension());
        quotaHistory.setResource(MonitorResourceEnum.matchCode(bodyWrapper.getMonitorResource()).name());
        quotaHistory.setQuotaName(quotaEntity.getQuotaName());
        quotaHistory.setAlarmMode(AlarmModeEnum.matchCode(eventRule.getAlarmMode()).getDesc());
        quotaHistory.setSource(MonitorSourceEnum.matchCode(bodyWrapper.getMonitorSource()).name());
        quotaHistory.setStatus(statusEnum.getCode());
        quotaHistory.setHandleState(HandleStateEnum.\u5f85\u5904\u7406.getCode());
        quotaHistory.setEventDetail("");
        quotaHistory.setHandleBy("");
        quotaHistory.setHandleTime(null);
        if (AlarmHistoryStatusEnum.\u6062\u590d\u6b63\u5e38.equals((Object)statusEnum)) {
            quotaHistory.setRecoverTime(new Date());
        }
        return quotaHistory;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public String getDownResource() {
        return this.downResource;
    }

    public Date getAlarmTime() {
        return this.alarmTime;
    }

    public String getResource() {
        return this.resource;
    }

    public String getQuotaName() {
        return this.quotaName;
    }

    public String getEventDetail() {
        return this.eventDetail;
    }

    public String getAlarmMode() {
        return this.alarmMode;
    }

    public String getSource() {
        return this.source;
    }

    public Integer getHandleState() {
        return this.handleState;
    }

    public String getHandleBy() {
        return this.handleBy;
    }

    public Date getHandleTime() {
        return this.handleTime;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getRecoverTime() {
        return this.recoverTime;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public void setDownResource(String downResource) {
        this.downResource = downResource;
    }

    public void setAlarmTime(Date alarmTime) {
        this.alarmTime = alarmTime;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }

    public void setEventDetail(String eventDetail) {
        this.eventDetail = eventDetail;
    }

    public void setAlarmMode(String alarmMode) {
        this.alarmMode = alarmMode;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setHandleState(Integer handleState) {
        this.handleState = handleState;
    }

    public void setHandleBy(String handleBy) {
        this.handleBy = handleBy;
    }

    public void setHandleTime(Date handleTime) {
        this.handleTime = handleTime;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setRecoverTime(Date recoverTime) {
        this.recoverTime = recoverTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmEventHistory)) {
            return false;
        }
        AlarmEventHistory other = (AlarmEventHistory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$dimension = this.getDimension();
        Integer other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$handleState = this.getHandleState();
        Integer other$handleState = other.getHandleState();
        if (this$handleState == null ? other$handleState != null : !((Object)this$handleState).equals(other$handleState)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$downResource = this.getDownResource();
        String other$downResource = other.getDownResource();
        if (this$downResource == null ? other$downResource != null : !this$downResource.equals(other$downResource)) {
            return false;
        }
        Date this$alarmTime = this.getAlarmTime();
        Date other$alarmTime = other.getAlarmTime();
        if (this$alarmTime == null ? other$alarmTime != null : !((Object)this$alarmTime).equals(other$alarmTime)) {
            return false;
        }
        String this$resource = this.getResource();
        String other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        String this$quotaName = this.getQuotaName();
        String other$quotaName = other.getQuotaName();
        if (this$quotaName == null ? other$quotaName != null : !this$quotaName.equals(other$quotaName)) {
            return false;
        }
        String this$eventDetail = this.getEventDetail();
        String other$eventDetail = other.getEventDetail();
        if (this$eventDetail == null ? other$eventDetail != null : !this$eventDetail.equals(other$eventDetail)) {
            return false;
        }
        String this$alarmMode = this.getAlarmMode();
        String other$alarmMode = other.getAlarmMode();
        if (this$alarmMode == null ? other$alarmMode != null : !this$alarmMode.equals(other$alarmMode)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$handleBy = this.getHandleBy();
        String other$handleBy = other.getHandleBy();
        if (this$handleBy == null ? other$handleBy != null : !this$handleBy.equals(other$handleBy)) {
            return false;
        }
        Date this$handleTime = this.getHandleTime();
        Date other$handleTime = other.getHandleTime();
        if (this$handleTime == null ? other$handleTime != null : !((Object)this$handleTime).equals(other$handleTime)) {
            return false;
        }
        Date this$recoverTime = this.getRecoverTime();
        Date other$recoverTime = other.getRecoverTime();
        return !(this$recoverTime == null ? other$recoverTime != null : !((Object)this$recoverTime).equals(other$recoverTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmEventHistory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $handleState = this.getHandleState();
        result = result * 59 + ($handleState == null ? 43 : ((Object)$handleState).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $downResource = this.getDownResource();
        result = result * 59 + ($downResource == null ? 43 : $downResource.hashCode());
        Date $alarmTime = this.getAlarmTime();
        result = result * 59 + ($alarmTime == null ? 43 : ((Object)$alarmTime).hashCode());
        String $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        String $quotaName = this.getQuotaName();
        result = result * 59 + ($quotaName == null ? 43 : $quotaName.hashCode());
        String $eventDetail = this.getEventDetail();
        result = result * 59 + ($eventDetail == null ? 43 : $eventDetail.hashCode());
        String $alarmMode = this.getAlarmMode();
        result = result * 59 + ($alarmMode == null ? 43 : $alarmMode.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $handleBy = this.getHandleBy();
        result = result * 59 + ($handleBy == null ? 43 : $handleBy.hashCode());
        Date $handleTime = this.getHandleTime();
        result = result * 59 + ($handleTime == null ? 43 : ((Object)$handleTime).hashCode());
        Date $recoverTime = this.getRecoverTime();
        result = result * 59 + ($recoverTime == null ? 43 : ((Object)$recoverTime).hashCode());
        return result;
    }

    public String toString() {
        return "AlarmEventHistory(id=" + this.getId() + ", dimension=" + this.getDimension() + ", downResource=" + this.getDownResource() + ", alarmTime=" + this.getAlarmTime() + ", resource=" + this.getResource() + ", quotaName=" + this.getQuotaName() + ", eventDetail=" + this.getEventDetail() + ", alarmMode=" + this.getAlarmMode() + ", source=" + this.getSource() + ", handleState=" + this.getHandleState() + ", handleBy=" + this.getHandleBy() + ", handleTime=" + this.getHandleTime() + ", status=" + this.getStatus() + ", recoverTime=" + this.getRecoverTime() + ")";
    }
}

