/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyBody;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyNotify;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyRule;
import com.ovopark.dc.alarm.api.enums.AlarmHistoryStatusEnum;
import com.ovopark.dc.alarm.api.enums.AlarmModeEnum;
import com.ovopark.dc.alarm.api.enums.MonitorResourceEnum;
import com.ovopark.dc.alarm.api.enums.MonitorSourceEnum;
import com.ovopark.dc.alarm.api.model.QuotaEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@TableName(value="alarm_quota_history")
public class AlarmQuotaHistory
implements Serializable {
    @TableId(value="id", type=IdType.AUTO)
    private Integer id;
    private Date alarmTime;
    private Integer dimension;
    private String downResource;
    private String resource;
    private String quotaName;
    private String alarmSubject;
    private String alarmDetail;
    private double triggerValue;
    private String source;
    private Integer level;
    private String notifyObject;
    private Integer status;
    private Date recoverTime;
    private String alarmMode;
    private String strategyNo;

    public static AlarmQuotaHistory convertFrom(List<AlarmStrategyNotify> notifies, AlarmStrategyRule rule, String downResource, AlarmStrategyBody alarmStrategyBody, QuotaEntity quotaEntity, double detectValue, AlarmHistoryStatusEnum statusEnum) {
        AlarmQuotaHistory quotaHistory = new AlarmQuotaHistory();
        quotaHistory.setAlarmTime(new Date());
        quotaHistory.setDownResource(downResource);
        quotaHistory.setDimension(alarmStrategyBody.getMonitorDimension());
        quotaHistory.setResource(MonitorResourceEnum.matchCode(alarmStrategyBody.getMonitorResource()).name());
        quotaHistory.setQuotaName(quotaEntity.getQuotaName());
        quotaHistory.setAlarmSubject(quotaEntity.getQuotaName() + " " + rule.getTriggerSymbol() + " " + rule.getTriggerThreshold());
        quotaHistory.setAlarmDetail("");
        quotaHistory.setStrategyNo(alarmStrategyBody.getBodyNo());
        quotaHistory.setTriggerValue(detectValue);
        quotaHistory.setAlarmMode(AlarmModeEnum.matchCode(rule.getAlarmMode()).getDesc());
        quotaHistory.setSource(MonitorSourceEnum.matchCode(alarmStrategyBody.getMonitorSource()).name());
        quotaHistory.setLevel(rule.getAlarmLevel());
        quotaHistory.setStatus(statusEnum.getCode());
        quotaHistory.setNotifyObject(AlarmQuotaHistory.notifyStr(notifies));
        if (AlarmHistoryStatusEnum.\u6062\u590d\u6b63\u5e38.equals((Object)statusEnum)) {
            quotaHistory.setRecoverTime(new Date());
        }
        return quotaHistory;
    }

    private static String notifyStr(List<AlarmStrategyNotify> notifies) {
        StringBuilder sb = new StringBuilder();
        notifies.forEach(n -> sb.append(n.getUserName()).append(","));
        if (sb.length() >= 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public Integer getId() {
        return this.id;
    }

    public Date getAlarmTime() {
        return this.alarmTime;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public String getDownResource() {
        return this.downResource;
    }

    public String getResource() {
        return this.resource;
    }

    public String getQuotaName() {
        return this.quotaName;
    }

    public String getAlarmSubject() {
        return this.alarmSubject;
    }

    public String getAlarmDetail() {
        return this.alarmDetail;
    }

    public double getTriggerValue() {
        return this.triggerValue;
    }

    public String getSource() {
        return this.source;
    }

    public Integer getLevel() {
        return this.level;
    }

    public String getNotifyObject() {
        return this.notifyObject;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Date getRecoverTime() {
        return this.recoverTime;
    }

    public String getAlarmMode() {
        return this.alarmMode;
    }

    public String getStrategyNo() {
        return this.strategyNo;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setAlarmTime(Date alarmTime) {
        this.alarmTime = alarmTime;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public void setDownResource(String downResource) {
        this.downResource = downResource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setQuotaName(String quotaName) {
        this.quotaName = quotaName;
    }

    public void setAlarmSubject(String alarmSubject) {
        this.alarmSubject = alarmSubject;
    }

    public void setAlarmDetail(String alarmDetail) {
        this.alarmDetail = alarmDetail;
    }

    public void setTriggerValue(double triggerValue) {
        this.triggerValue = triggerValue;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setNotifyObject(String notifyObject) {
        this.notifyObject = notifyObject;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setRecoverTime(Date recoverTime) {
        this.recoverTime = recoverTime;
    }

    public void setAlarmMode(String alarmMode) {
        this.alarmMode = alarmMode;
    }

    public void setStrategyNo(String strategyNo) {
        this.strategyNo = strategyNo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmQuotaHistory)) {
            return false;
        }
        AlarmQuotaHistory other = (AlarmQuotaHistory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getTriggerValue(), other.getTriggerValue()) != 0) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$dimension = this.getDimension();
        Integer other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !((Object)this$dimension).equals(other$dimension)) {
            return false;
        }
        Integer this$level = this.getLevel();
        Integer other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Date this$alarmTime = this.getAlarmTime();
        Date other$alarmTime = other.getAlarmTime();
        if (this$alarmTime == null ? other$alarmTime != null : !((Object)this$alarmTime).equals(other$alarmTime)) {
            return false;
        }
        String this$downResource = this.getDownResource();
        String other$downResource = other.getDownResource();
        if (this$downResource == null ? other$downResource != null : !this$downResource.equals(other$downResource)) {
            return false;
        }
        String this$resource = this.getResource();
        String other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        String this$quotaName = this.getQuotaName();
        String other$quotaName = other.getQuotaName();
        if (this$quotaName == null ? other$quotaName != null : !this$quotaName.equals(other$quotaName)) {
            return false;
        }
        String this$alarmSubject = this.getAlarmSubject();
        String other$alarmSubject = other.getAlarmSubject();
        if (this$alarmSubject == null ? other$alarmSubject != null : !this$alarmSubject.equals(other$alarmSubject)) {
            return false;
        }
        String this$alarmDetail = this.getAlarmDetail();
        String other$alarmDetail = other.getAlarmDetail();
        if (this$alarmDetail == null ? other$alarmDetail != null : !this$alarmDetail.equals(other$alarmDetail)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$notifyObject = this.getNotifyObject();
        String other$notifyObject = other.getNotifyObject();
        if (this$notifyObject == null ? other$notifyObject != null : !this$notifyObject.equals(other$notifyObject)) {
            return false;
        }
        Date this$recoverTime = this.getRecoverTime();
        Date other$recoverTime = other.getRecoverTime();
        if (this$recoverTime == null ? other$recoverTime != null : !((Object)this$recoverTime).equals(other$recoverTime)) {
            return false;
        }
        String this$alarmMode = this.getAlarmMode();
        String other$alarmMode = other.getAlarmMode();
        if (this$alarmMode == null ? other$alarmMode != null : !this$alarmMode.equals(other$alarmMode)) {
            return false;
        }
        String this$strategyNo = this.getStrategyNo();
        String other$strategyNo = other.getStrategyNo();
        return !(this$strategyNo == null ? other$strategyNo != null : !this$strategyNo.equals(other$strategyNo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmQuotaHistory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $triggerValue = Double.doubleToLongBits(this.getTriggerValue());
        result = result * 59 + (int)($triggerValue >>> 32 ^ $triggerValue);
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : ((Object)$dimension).hashCode());
        Integer $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Date $alarmTime = this.getAlarmTime();
        result = result * 59 + ($alarmTime == null ? 43 : ((Object)$alarmTime).hashCode());
        String $downResource = this.getDownResource();
        result = result * 59 + ($downResource == null ? 43 : $downResource.hashCode());
        String $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        String $quotaName = this.getQuotaName();
        result = result * 59 + ($quotaName == null ? 43 : $quotaName.hashCode());
        String $alarmSubject = this.getAlarmSubject();
        result = result * 59 + ($alarmSubject == null ? 43 : $alarmSubject.hashCode());
        String $alarmDetail = this.getAlarmDetail();
        result = result * 59 + ($alarmDetail == null ? 43 : $alarmDetail.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $notifyObject = this.getNotifyObject();
        result = result * 59 + ($notifyObject == null ? 43 : $notifyObject.hashCode());
        Date $recoverTime = this.getRecoverTime();
        result = result * 59 + ($recoverTime == null ? 43 : ((Object)$recoverTime).hashCode());
        String $alarmMode = this.getAlarmMode();
        result = result * 59 + ($alarmMode == null ? 43 : $alarmMode.hashCode());
        String $strategyNo = this.getStrategyNo();
        result = result * 59 + ($strategyNo == null ? 43 : $strategyNo.hashCode());
        return result;
    }

    public String toString() {
        return "AlarmQuotaHistory(id=" + this.getId() + ", alarmTime=" + this.getAlarmTime() + ", dimension=" + this.getDimension() + ", downResource=" + this.getDownResource() + ", resource=" + this.getResource() + ", quotaName=" + this.getQuotaName() + ", alarmSubject=" + this.getAlarmSubject() + ", alarmDetail=" + this.getAlarmDetail() + ", triggerValue=" + this.getTriggerValue() + ", source=" + this.getSource() + ", level=" + this.getLevel() + ", notifyObject=" + this.getNotifyObject() + ", status=" + this.getStatus() + ", recoverTime=" + this.getRecoverTime() + ", alarmMode=" + this.getAlarmMode() + ", strategyNo=" + this.getStrategyNo() + ")";
    }
}

