/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.enums;

public enum CurlExitCodeEnum {
    CODE_0("SUCCESS"),
    CODE_1("Unsupported protocol. This build of curl has no support for this protocol."),
    CODE_2("Failed to initialize."),
    CODE_3("URL malformed. The syntax was not correct."),
    CODE_5("Couldn't resolve proxy. The given proxy host could not be resolved."),
    CODE_6("Couldn't resolve host. The given remote host was not resolved."),
    CODE_7("Failed to connect to host."),
    CODE_28("Operation timeout. The specified time-out period was reached according to the conditions."),
    CODE_35("SSL connect error. The SSL handshaking failed."),
    CODE_43("Internal error. A function was called with a bad parameter."),
    CODE_48("Unknown TELNET option specified.");

    private String desc;

    private CurlExitCodeEnum(String desc) {
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getDesc(Integer code) {
        CurlExitCodeEnum[] exitCodeEnums;
        String codeStr = "CODE_" + code;
        for (CurlExitCodeEnum exitCodeEnum : exitCodeEnums = CurlExitCodeEnum.values()) {
            if (!exitCodeEnum.name().equals(codeStr)) continue;
            return exitCodeEnum.getDesc();
        }
        return "Curl \u6267\u884c\u5f02\u5e38\uff1a\u8bf7\u68c0\u67e5 curl \u547d\u4ee4\u662f\u5426\u6b63\u786e";
    }
}

