/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckInstance;
import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckNotify;
import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckStrategy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.collections4.CollectionUtils;
import org.hibernate.validator.constraints.Length;
import org.springframework.beans.BeanUtils;

@ApiModel(description="\u5065\u5eb7\u68c0\u67e5Wrapper")
public class AlarmHealthCheckStrategyWrapper
implements Serializable {
    private static final long serialVersionUID = -2515127450528257190L;
    @ApiModelProperty(value="\u7b56\u7565\u540d\u79f0")
    @NotBlank(message="\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=100, message="\u7b56\u7565\u540d\u79f0\u957f\u5ea6\u6700\u5927 100 \u5b57\u7b26")
    private @NotBlank(message="\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=100, message="\u7b56\u7565\u540d\u79f0\u957f\u5ea6\u6700\u5927 100 \u5b57\u7b26") String strategyName;
    private Integer id;
    @ApiModelProperty(value="\u68c0\u67e5\u5bf9\u8c61")
    @NotNull(message="\u68c0\u67e5\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u68c0\u67e5\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a") Integer checkObject;
    @ApiModelProperty(value="\u68c0\u67e5\u65b9\u5f0f")
    @NotNull(message="\u68c0\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u68c0\u67e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a") Integer checkWay;
    @ApiModelProperty(value="\u68c0\u67e5\u5468\u671f")
    @NotNull(message="\u68c0\u67e5\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u68c0\u67e5\u5468\u671f\u4e0d\u80fd\u4e3a\u7a7a") Integer checkPeriod;
    @ApiModelProperty(value="\u901a\u77e5\u65b9\u5f0fjson")
    @NotBlank(message="\u901a\u77e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u901a\u77e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a") String notifyWay;
    @ApiModelProperty(value="\u662f\u5426\u5065\u5eb7")
    private boolean health;
    @ApiModelProperty(value="\u4e0a\u4e00\u6b21\u5f02\u5e38\u65f6\u95f4")
    private Date lastUnhealthTime;
    @ApiModelProperty(value="\u521b\u5efa\u4eba")
    @JsonIgnore
    private String createBy;
    @ApiModelProperty(value="\u521b\u5efa\u65f6\u95f4")
    @JsonIgnore
    private Date createTime;
    @ApiModelProperty(value="\u4fee\u6539\u4eba")
    @JsonIgnore
    private String modifyBy;
    @ApiModelProperty(value="\u4fee\u6539\u65f6\u95f4")
    @JsonIgnore
    private Date modifyTime;
    @ApiModelProperty(value="\u5f02\u5e38\u9608\u503c")
    private Integer unhealthQuota;
    private Integer status;
    private String uniqueNo;
    @Length(max=3000, message="curl\u8868\u8fbe\u5f0f\u6700\u5927\u957f\u5ea6\u4e3a 3000")
    private @Length(max=3000, message="curl\u8868\u8fbe\u5f0f\u6700\u5927\u957f\u5ea6\u4e3a 3000") String curlExpress;
    @Length(max=500, message="code\u6700\u5927\u957f\u5ea6\u4e3a 500")
    private @Length(max=500, message="code\u6700\u5927\u957f\u5ea6\u4e3a 500") String expectResponseCode;
    @Length(max=500, message="\u83b7\u53d6code\u8868\u8fbe\u5f0f\u6700\u5927\u957f\u5ea6\u4e3a 500")
    private @Length(max=500, message="\u83b7\u53d6code\u8868\u8fbe\u5f0f\u6700\u5927\u957f\u5ea6\u4e3a 500") String expectResponseCodePlaceholder;
    @Valid
    @ApiModelProperty(value="\u68c0\u67e5\u5b9e\u4f8b\u5217\u8868")
    private List<AlarmHealthCheckInstance> instances;
    @Valid
    @ApiModelProperty(value="\u901a\u77e5\u4eba\u5217\u8868")
    @Size(min=1, message="\u68c0\u67e5\u901a\u77e5\u4eba\u6700\u5c0f\u4e3a 1")
    private @Valid @Size(min=1, message="\u68c0\u67e5\u901a\u77e5\u4eba\u6700\u5c0f\u4e3a 1") List<AlarmHealthCheckNotify> notifies;
    @ApiModelProperty(value="\u901a\u77e5\u4eba")
    private String notifyObject;

    public String getCurlExpress() {
        return this.curlExpress;
    }

    public void setCurlExpress(String curlExpress) {
        this.curlExpress = curlExpress;
    }

    public String getExpectResponseCode() {
        return this.expectResponseCode;
    }

    public void setExpectResponseCode(String expectResponseCode) {
        this.expectResponseCode = expectResponseCode;
    }

    public String getExpectResponseCodePlaceholder() {
        return this.expectResponseCodePlaceholder;
    }

    public void setExpectResponseCodePlaceholder(String expectResponseCodePlaceholder) {
        this.expectResponseCodePlaceholder = expectResponseCodePlaceholder;
    }

    public String getNotifyObject() {
        this.notifyObject = "";
        if (CollectionUtils.isNotEmpty(this.notifies)) {
            for (int i = 0; i < this.notifies.size(); ++i) {
                this.notifyObject = i != this.notifies.size() - 1 ? this.notifyObject + this.notifies.get(i).getUserName() + "," : this.notifyObject + this.notifies.get(i).getUserName();
            }
        }
        return this.notifyObject;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getUniqueNo() {
        return this.uniqueNo;
    }

    public void setUniqueNo(String uniqueNo) {
        this.uniqueNo = uniqueNo;
    }

    public Integer getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(Integer checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    public List<AlarmHealthCheckInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<AlarmHealthCheckInstance> instances) {
        this.instances = instances;
    }

    public List<AlarmHealthCheckNotify> getNotifies() {
        return this.notifies;
    }

    public void setNotifies(List<AlarmHealthCheckNotify> notifies) {
        this.notifies = notifies;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getCheckObject() {
        return this.checkObject;
    }

    public void setCheckObject(Integer checkObject) {
        this.checkObject = checkObject;
    }

    public Integer getCheckWay() {
        return this.checkWay;
    }

    public void setCheckWay(Integer checkWay) {
        this.checkWay = checkWay;
    }

    public Integer isCheckPeriod() {
        return this.checkPeriod;
    }

    public String getNotifyWay() {
        return this.notifyWay;
    }

    public void setNotifyWay(String notifyWay) {
        this.notifyWay = notifyWay;
    }

    public boolean isHealth() {
        return this.health;
    }

    public void setHealth(boolean health) {
        this.health = health;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public Date getLastUnhealthTime() {
        return this.lastUnhealthTime;
    }

    public void setLastUnhealthTime(Date lastUnhealthTime) {
        this.lastUnhealthTime = lastUnhealthTime;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getModifyBy() {
        return this.modifyBy;
    }

    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Integer getUnhealthQuota() {
        return this.unhealthQuota;
    }

    public void setUnhealthQuota(Integer unhealthQuota) {
        this.unhealthQuota = unhealthQuota;
    }

    @JsonIgnore
    public AlarmHealthCheckStrategy getAlarmHealthCheckStrategy() {
        AlarmHealthCheckStrategy alarmHealthCheckStrategy = new AlarmHealthCheckStrategy();
        BeanUtils.copyProperties((Object)this, (Object)alarmHealthCheckStrategy);
        return alarmHealthCheckStrategy;
    }
}

