/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.model;

import com.alibaba.fastjson.JSON;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyBody;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyEventRule;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyNotify;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyResource;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyResourceInstance;
import com.ovopark.dc.alarm.api.entity.AlarmStrategyRule;
import com.ovopark.dc.alarm.api.enums.StrategyTypeEnum;
import com.ovopark.dc.alarm.api.model.ServiceInstance;
import com.ovopark.dc.alarm.api.vo.AlarmStrategyBodyVO;
import com.ovopark.dc.alarm.api.vo.AlarmStrategyEventRuleVO;
import com.ovopark.dc.alarm.api.vo.AlarmStrategyResourceInstanceVo;
import com.ovopark.dc.alarm.api.vo.AlarmStrategyResourceVO;
import com.ovopark.dc.alarm.api.vo.AlarmStrategyRuleVO;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AlarmStrategyBodyWrapper
implements Serializable {
    @ApiModelProperty(value="\u81ea\u589e\u4e3b\u952eid")
    private Integer id;
    @ApiModelProperty(value="\u7b56\u7565\u7ec4\u552f\u4e00\u6807\u8bc6")
    private String bodyNo;
    @ApiModelProperty(value="\u544a\u8b66\u7c7b\u578b\uff1a1 \u4e8b\u4ef6 2 \u9608\u503c")
    private Integer type;
    @ApiModelProperty(value="\u7b56\u7565\u540d\u79f0")
    private String groupName;
    @ApiModelProperty(value="\u76d1\u63a7\u8d44\u6e90 1. ECS 2. \u5e94\u7528 ")
    private Integer monitorResource;
    @ApiModelProperty(value="\u76d1\u63a7\u6765\u6e90 1 \u963f\u91cc\u4e91 2 \u817e\u8baf\u4e91 ")
    private Integer monitorSource;
    @ApiModelProperty(value="\u76d1\u63a7\u7ef4\u5ea6 1  \u5b9e\u4f8b 2  \u5e94\u7528")
    private Integer monitorDimension;
    @ApiModelProperty(value="\u76d1\u63a7\u8303\u56f4 1 \u5168\u90e8 2 \u6307\u5b9a")
    private Integer monitorRange;
    @ApiModelProperty(value="\u544a\u8b66\u6a21\u5f0f 1 prometheus 2 shell ")
    private Integer alarmMode;
    @ApiModelProperty(value="\u901a\u77e5\u65b9\u5f0f 1 \u90ae\u4ef6 2  \u77ed\u4fe1  ")
    private String notifyWay;
    @ApiModelProperty(value="\u6267\u884c\u7684shell\u811a\u672c\u7684\u552f\u4e00\u6807\u8bc6")
    private String executeModuleId;
    @ApiModelProperty(value="\u521b\u5efa\u65f6\u95f4")
    private Date createTime;
    @ApiModelProperty(value="\u521b\u5efa\u4eba")
    private String createBy;
    private Date modifyTime;
    private String modifyBy;
    private Integer status;
    private List<AlarmStrategyResource> resources;
    @Valid
    private List<AlarmStrategyRule> rules;
    @Valid
    private List<AlarmStrategyEventRule> eventRules;
    private AlarmStrategyRule usedStrategyRule;
    private ServiceInstance usedServiceInstance;
    private String alarmCallbackUrls;
    private List<AlarmStrategyNotify> notifies;

    public AlarmStrategyBodyWrapper(Integer id) {
        this.id = id;
    }

    public AlarmStrategyBodyWrapper(Integer id, Integer status) {
        this.id = id;
        this.status = status;
    }

    public AlarmStrategyBodyWrapper() {
    }

    public static AlarmStrategyBodyVO transferTo(AlarmStrategyBodyWrapper wrapper) {
        AlarmStrategyBodyVO vo = new AlarmStrategyBodyVO();
        vo.setBodyNo(wrapper.getBodyNo());
        vo.setAlarmMode(wrapper.getAlarmMode());
        vo.setCreateBy(wrapper.getCreateBy());
        vo.setCreateTime(wrapper.getCreateTime());
        vo.setStatus(wrapper.getStatus());
        vo.setModifyTime(wrapper.getModifyTime());
        vo.setId(wrapper.getId());
        vo.setNotifyList(AlarmStrategyNotify.transferToList(wrapper.getNotifies()));
        vo.setGroupName(wrapper.getGroupName());
        vo.setMonitorRange(wrapper.getMonitorRange());
        vo.setMonitorSource(wrapper.getMonitorSource());
        vo.setMonitorDimension(wrapper.getMonitorDimension());
        vo.setMonitorResource(wrapper.getMonitorResource());
        vo.setType(wrapper.getType());
        vo.setNotifyWay(wrapper.getNotifyWay());
        vo.setExecuteModuleId(wrapper.getExecuteModuleId());
        vo.setResources(AlarmStrategyBodyWrapper.toResourceVO(wrapper.getResources()));
        if (StringUtils.isNotBlank((CharSequence)wrapper.getAlarmCallbackUrls()) && wrapper.getAlarmCallbackUrls() != null) {
            vo.setAlarmCallbackUrls(JSON.parseArray((String)JSON.parse((String)wrapper.getAlarmCallbackUrls()).toString()).toJavaList(String.class));
        }
        if (StrategyTypeEnum.EVENT_ALARM.getCode().equals(wrapper.getType())) {
            ArrayList<AlarmStrategyEventRuleVO> eventRuleVOS = new ArrayList<AlarmStrategyEventRuleVO>();
            wrapper.getEventRules().forEach(x -> eventRuleVOS.add(AlarmStrategyEventRule.transferTo(x)));
            vo.setEventRules(eventRuleVOS);
        }
        if (StrategyTypeEnum.QUOTA_ALARM.getCode().equals(wrapper.getType())) {
            vo.setNotifyList(AlarmStrategyNotify.transferToList(wrapper.getNotifies()));
            ArrayList<AlarmStrategyRuleVO> rules = new ArrayList<AlarmStrategyRuleVO>();
            wrapper.getRules().forEach(x -> rules.add(AlarmStrategyRule.transferTo(x)));
            vo.setRules(rules);
        }
        return vo;
    }

    public static AlarmStrategyBodyWrapper transferFrom(AlarmStrategyBodyVO bodyVO) {
        AlarmStrategyBodyWrapper wrapper = new AlarmStrategyBodyWrapper();
        wrapper.setAlarmMode(bodyVO.getAlarmMode());
        wrapper.setBodyNo(bodyVO.getBodyNo());
        wrapper.setCreateBy(bodyVO.getCreateBy());
        wrapper.setCreateTime(bodyVO.getCreateTime());
        wrapper.setId(bodyVO.getId());
        wrapper.setGroupName(bodyVO.getGroupName());
        wrapper.setMonitorRange(bodyVO.getMonitorRange());
        wrapper.setMonitorSource(bodyVO.getMonitorSource());
        wrapper.setMonitorDimension(bodyVO.getMonitorDimension());
        wrapper.setMonitorResource(bodyVO.getMonitorResource());
        wrapper.setType(bodyVO.getType());
        wrapper.setStatus(bodyVO.getStatus());
        wrapper.setModifyTime(bodyVO.getModifyTime());
        wrapper.setNotifyWay(JSON.toJSONString(bodyVO.getNotifyWay()));
        wrapper.setExecuteModuleId(bodyVO.getExecuteModuleId());
        wrapper.setResources(AlarmStrategyBodyWrapper.transferToResourceDto(bodyVO.getResources()));
        wrapper.setNotifies(AlarmStrategyNotify.transferFromList(bodyVO.getNotifyList()));
        if (CollectionUtils.isEmpty(bodyVO.getAlarmCallbackUrls())) {
            wrapper.setAlarmCallbackUrls(JSON.toJSONString(Collections.emptyList()));
        } else {
            wrapper.setAlarmCallbackUrls(JSON.toJSONString(bodyVO.getAlarmCallbackUrls()));
        }
        if (StrategyTypeEnum.EVENT_ALARM.getCode().equals(bodyVO.getType())) {
            ArrayList<AlarmStrategyEventRule> eventRules = new ArrayList<AlarmStrategyEventRule>();
            bodyVO.getEventRules().forEach(x -> eventRules.add(AlarmStrategyEventRule.transferFrom(x)));
            wrapper.setEventRules(eventRules);
        }
        if (StrategyTypeEnum.QUOTA_ALARM.getCode().equals(bodyVO.getType())) {
            ArrayList<AlarmStrategyRule> rules = new ArrayList<AlarmStrategyRule>();
            bodyVO.getRules().forEach(x -> rules.add(AlarmStrategyRule.transferFrom(x)));
            wrapper.setRules(rules);
        }
        return wrapper;
    }

    private static List<AlarmStrategyResource> transferToResourceDto(List<AlarmStrategyResourceVO> resources) {
        ArrayList<AlarmStrategyResource> resourceList = new ArrayList<AlarmStrategyResource>();
        resources.forEach(x -> {
            AlarmStrategyResource resource = new AlarmStrategyResource();
            resource.setResourceName(x.getResourceName());
            resource.setResourceDimension(x.getResourceDimension());
            resource.setStrategyId(x.getStrategyId());
            resource.setResourceSource(x.getResourceSource());
            resource.setId(x.getId());
            ArrayList<AlarmStrategyResourceInstance> instanceList = new ArrayList<AlarmStrategyResourceInstance>();
            x.getInstanceVos().forEach(y -> {
                AlarmStrategyResourceInstance instance = new AlarmStrategyResourceInstance();
                instance.setResourceId(y.getResourceId());
                instance.setPort(y.getPort());
                instance.setPublicIp(y.getPublicIpAddress());
                instance.setPrivateIp(y.getInnerIpAddress());
                instance.setId(y.getId());
                instance.setInstanceId(y.getInstanceId());
                instanceList.add(instance);
            });
            resource.setInstanceList(instanceList);
            resourceList.add(resource);
        });
        return resourceList;
    }

    private static List<AlarmStrategyResourceVO> toResourceVO(List<AlarmStrategyResource> resources) {
        ArrayList<AlarmStrategyResourceVO> voList = new ArrayList<AlarmStrategyResourceVO>();
        resources.forEach(x -> {
            AlarmStrategyResourceVO resourceVO = new AlarmStrategyResourceVO();
            resourceVO.setResourceName(x.getResourceName());
            resourceVO.setResourceDimension(x.getResourceDimension());
            resourceVO.setStrategyId(x.getStrategyId());
            resourceVO.setResourceSource(x.getResourceSource());
            resourceVO.setId(x.getId());
            ArrayList<AlarmStrategyResourceInstanceVo> instanceList = new ArrayList<AlarmStrategyResourceInstanceVo>();
            x.getInstanceList().forEach(y -> {
                AlarmStrategyResourceInstanceVo instanceVo = new AlarmStrategyResourceInstanceVo();
                instanceVo.setResourceId(y.getResourceId());
                instanceVo.setPort(y.getPort());
                instanceVo.setPublicIpAddress(y.getPublicIp());
                instanceVo.setInnerIpAddress(y.getPrivateIp());
                instanceVo.setId(y.getId());
                instanceVo.setInstanceId(y.getInstanceId());
                instanceList.add(instanceVo);
            });
            resourceVO.setInstanceVos(instanceList);
            voList.add(resourceVO);
        });
        return voList;
    }

    public String toString() {
        return "AlarmStrategyBodyWrapper{}";
    }

    public List<Integer> getNotifyWay() {
        return JSON.parseArray((String)JSON.parse((String)this.notifyWay).toString()).toJavaList(Integer.class);
    }

    public AlarmStrategyBodyWrapper transferFrom(AlarmStrategyBody body) {
        this.setAlarmMode(body.getAlarmMode());
        this.setBodyNo(body.getBodyNo());
        this.setCreateBy(body.getCreateBy());
        this.setCreateTime(body.getCreateTime());
        this.setId(body.getId());
        this.setModifyTime(body.getModifyTime());
        this.setStatus(body.getStatus());
        this.setGroupName(body.getGroupName());
        this.setMonitorRange(body.getMonitorRange());
        this.setMonitorSource(body.getMonitorSource());
        this.setMonitorDimension(body.getMonitorDimension());
        this.setMonitorResource(body.getMonitorResource());
        this.setType(body.getType());
        this.setNotifyWay(JSON.toJSONString((Object)body.getNotifyWay()));
        this.setExecuteModuleId(body.getExecuteModuleId());
        this.setAlarmCallbackUrls(JSON.toJSONString((Object)body.getAlarmCallbackUrls()));
        return this;
    }

    public AlarmStrategyBody getStrategyBody() {
        AlarmStrategyBody body = new AlarmStrategyBody();
        body.setBodyNo(this.getBodyNo());
        body.setId(this.getId());
        body.setType(this.getType());
        body.setModifyTime(this.getModifyTime());
        body.setStatus(this.getStatus());
        body.setGroupName(this.getGroupName());
        body.setMonitorResource(this.getMonitorResource());
        body.setMonitorSource(this.getMonitorSource());
        body.setMonitorDimension(this.getMonitorDimension());
        body.setMonitorRange(this.getMonitorRange());
        body.setAlarmMode(this.getAlarmMode());
        body.setNotifyWay(JSON.toJSONString(this.getNotifyWay()));
        body.setExecuteModuleId(this.getExecuteModuleId());
        body.setCreateBy(this.getCreateBy());
        body.setCreateTime(this.getCreateTime());
        body.setAlarmCallbackUrls(this.getAlarmCallbackUrls());
        return body;
    }

    public Integer getId() {
        return this.id;
    }

    public String getBodyNo() {
        return this.bodyNo;
    }

    public Integer getType() {
        return this.type;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Integer getMonitorResource() {
        return this.monitorResource;
    }

    public Integer getMonitorSource() {
        return this.monitorSource;
    }

    public Integer getMonitorDimension() {
        return this.monitorDimension;
    }

    public Integer getMonitorRange() {
        return this.monitorRange;
    }

    public Integer getAlarmMode() {
        return this.alarmMode;
    }

    public String getExecuteModuleId() {
        return this.executeModuleId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public String getModifyBy() {
        return this.modifyBy;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<AlarmStrategyResource> getResources() {
        return this.resources;
    }

    public List<AlarmStrategyRule> getRules() {
        return this.rules;
    }

    public List<AlarmStrategyEventRule> getEventRules() {
        return this.eventRules;
    }

    public AlarmStrategyRule getUsedStrategyRule() {
        return this.usedStrategyRule;
    }

    public ServiceInstance getUsedServiceInstance() {
        return this.usedServiceInstance;
    }

    public String getAlarmCallbackUrls() {
        return this.alarmCallbackUrls;
    }

    public List<AlarmStrategyNotify> getNotifies() {
        return this.notifies;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setBodyNo(String bodyNo) {
        this.bodyNo = bodyNo;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setMonitorResource(Integer monitorResource) {
        this.monitorResource = monitorResource;
    }

    public void setMonitorSource(Integer monitorSource) {
        this.monitorSource = monitorSource;
    }

    public void setMonitorDimension(Integer monitorDimension) {
        this.monitorDimension = monitorDimension;
    }

    public void setMonitorRange(Integer monitorRange) {
        this.monitorRange = monitorRange;
    }

    public void setAlarmMode(Integer alarmMode) {
        this.alarmMode = alarmMode;
    }

    public void setNotifyWay(String notifyWay) {
        this.notifyWay = notifyWay;
    }

    public void setExecuteModuleId(String executeModuleId) {
        this.executeModuleId = executeModuleId;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setResources(List<AlarmStrategyResource> resources) {
        this.resources = resources;
    }

    public void setRules(List<AlarmStrategyRule> rules) {
        this.rules = rules;
    }

    public void setEventRules(List<AlarmStrategyEventRule> eventRules) {
        this.eventRules = eventRules;
    }

    public void setUsedStrategyRule(AlarmStrategyRule usedStrategyRule) {
        this.usedStrategyRule = usedStrategyRule;
    }

    public void setUsedServiceInstance(ServiceInstance usedServiceInstance) {
        this.usedServiceInstance = usedServiceInstance;
    }

    public void setAlarmCallbackUrls(String alarmCallbackUrls) {
        this.alarmCallbackUrls = alarmCallbackUrls;
    }

    public void setNotifies(List<AlarmStrategyNotify> notifies) {
        this.notifies = notifies;
    }
}

