/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.model;

import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckResult;
import com.ovopark.dc.alarm.api.util.TimeUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class BestAndWorstAlive
implements Serializable {
    private static final long serialVersionUID = -8717070583768498770L;
    private Long bestAliveTime;
    private List<AlarmHealthCheckResult> bestAliveResult;
    private Long worstAliveTime;
    private List<AlarmHealthCheckResult> worstAliveResult;
    private String bestAliveDesc;
    private String worstAliveDesc;
    private Integer period;

    public BestAndWorstAlive(Long bestAliveTime, List<AlarmHealthCheckResult> bestAliveResult, Long worstAliveTime, List<AlarmHealthCheckResult> worstAliveResult, Integer period) {
        this.bestAliveTime = bestAliveTime;
        this.bestAliveResult = bestAliveResult;
        this.worstAliveTime = worstAliveTime;
        this.worstAliveResult = worstAliveResult;
        this.period = period;
    }

    public BestAndWorstAlive() {
    }

    public void setAliveDesc(String bestAliveDesc) {
        this.bestAliveDesc = bestAliveDesc;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public String getWorstAliveDesc() {
        if (CollectionUtils.isEmpty(this.worstAliveResult)) {
            return "[\u6700\u8fd1\u4e00\u6b21\u5f00\u542f\u5065\u5eb7\u68c0\u67e5\u8d77] \u670d\u52a1\u975e\u5e38\u5065\u5eb7\uff0c\u65e0\u5f02\u5e38\u68c0\u67e5\u8bb0\u5f55\uff01";
        }
        StringBuilder desc = new StringBuilder("[\u6700\u8fd1\u4e00\u6b21\u5f00\u542f\u52a0\u5165\u5065\u5eb7\u68c0\u67e5\u8d77] \u670d\u52a1 \u6700\u77ed \u5b58\u6d3b\u65f6\u95f4\u4e3a\uff1a" + (String)(this.worstAliveTime / 1000L <= (long)this.period.intValue() ? "< " + this.period + " \u79d2" : TimeUtils.dynamicTimeUnit(this.worstAliveTime)) + "\uff0c\u53d1\u751f\u65f6\u95f4\u70b9\uff1a");
        for (int i = 0; i < this.worstAliveResult.size(); ++i) {
            if (i == this.worstAliveResult.size() - 1) {
                desc.append(DateFormatUtils.format((Date)this.worstAliveResult.get(i).getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(" .\n");
                continue;
            }
            desc.append(DateFormatUtils.format((Date)this.worstAliveResult.get(i).getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(" , ");
        }
        return desc.toString();
    }

    public String getBesttAliveDesc() {
        if (CollectionUtils.isEmpty(this.bestAliveResult)) {
            return "[\u6700\u8fd1\u4e00\u6b21\u5f00\u542f\u52a0\u5165\u5065\u5eb7\u68c0\u67e5\u8d77] \u670d\u52a1\u975e\u5e38\u5065\u5eb7\uff0c\u65e0\u5f02\u5e38\u68c0\u67e5\u8bb0\u5f55\uff01";
        }
        StringBuilder desc = new StringBuilder("[\u6700\u8fd1\u4e00\u6b21\u5f00\u542f\u52a0\u5165\u5065\u5eb7\u68c0\u67e5\u8d77] \u670d\u52a1 \u6700\u957f \u5b58\u6d3b\u65f6\u95f4\u4e3a\uff1a" + (String)(this.bestAliveTime / 1000L <= (long)this.period.intValue() ? "< " + this.period + " \u79d2" : TimeUtils.dynamicTimeUnit(this.bestAliveTime)) + "\uff0c\u53d1\u751f\u65f6\u95f4\u70b9\uff1a");
        for (int i = 0; i < this.bestAliveResult.size(); ++i) {
            if (i == this.bestAliveResult.size() - 1) {
                desc.append(DateFormatUtils.format((Date)this.bestAliveResult.get(i).getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(" .\n");
                continue;
            }
            desc.append(DateFormatUtils.format((Date)this.bestAliveResult.get(i).getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(" , ");
        }
        return desc.toString();
    }

    public Long getBestAliveTime() {
        return this.bestAliveTime;
    }

    public void setBestAliveTime(Long bestAliveTime) {
        this.bestAliveTime = bestAliveTime;
    }

    public List<AlarmHealthCheckResult> getBestAliveResult() {
        return this.bestAliveResult;
    }

    public void setBestAliveResult(List<AlarmHealthCheckResult> bestAliveResult) {
        this.bestAliveResult = bestAliveResult;
    }

    public Long getWorstAliveTime() {
        return this.worstAliveTime;
    }

    public void setWorstAliveTime(Long worstAliveTime) {
        this.worstAliveTime = worstAliveTime;
    }

    public List<AlarmHealthCheckResult> getWorstAliveResult() {
        return this.worstAliveResult;
    }

    public void setWorstAliveResult(List<AlarmHealthCheckResult> worstAliveResult) {
        this.worstAliveResult = worstAliveResult;
    }
}

