/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.model;

import com.ovopark.dc.alarm.api.entity.AlarmHealthCheckResult;
import com.ovopark.dc.alarm.api.util.TimeUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class BestAndWorstRecover
implements Serializable {
    private static final long serialVersionUID = -6666201461564763475L;
    private Long bestRecoverTime;
    private List<AlarmHealthCheckResult> bestRecoverResult;
    private Long worstRecoverTime;
    private List<AlarmHealthCheckResult> worstRecoverResult;
    private String bestRecoverDesc;
    private String worstRecoverDesc;
    private Integer period;

    public BestAndWorstRecover(Long bestRecoverTime, List<AlarmHealthCheckResult> bestRecoverResult, Long worstRecoverTime, List<AlarmHealthCheckResult> worstRecoverResult, Integer period) {
        this.bestRecoverTime = bestRecoverTime;
        this.bestRecoverResult = bestRecoverResult;
        this.worstRecoverTime = worstRecoverTime;
        this.worstRecoverResult = worstRecoverResult;
        this.period = period;
    }

    public BestAndWorstRecover() {
    }

    public String getWorstRecoverDesc() {
        if (CollectionUtils.isEmpty(this.worstRecoverResult)) {
            return "[\u6700\u8fd1\u4e00\u6b21\u5f00\u542f\u5065\u5eb7\u68c0\u67e5\u8d77] \u670d\u52a1\u975e\u5e38\u5065\u5eb7\uff0c\u65e0\u5f02\u5e38\u68c0\u67e5\u8bb0\u5f55\uff01";
        }
        StringBuilder desc = new StringBuilder("[\u6700\u8fd1\u4e00\u6b21\u5f00\u542f\u5065\u5eb7\u68c0\u67e5\u8d77] \u670d\u52a1 \u6700\u6162 \u6062\u590d\u65f6\u95f4\u4e3a\uff1a" + (String)(this.worstRecoverTime / 1000L <= (long)this.period.intValue() ? "< " + this.period + " \u79d2" : TimeUtils.dynamicTimeUnit(this.worstRecoverTime)) + "\uff0c\u53d1\u751f\u65f6\u95f4\u70b9\uff1a");
        for (int i = 0; i < this.worstRecoverResult.size(); ++i) {
            if (i == this.worstRecoverResult.size() - 1) {
                desc.append(DateFormatUtils.format((Date)this.worstRecoverResult.get(i).getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(" .\n");
                continue;
            }
            desc.append(DateFormatUtils.format((Date)this.worstRecoverResult.get(i).getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(" , ");
        }
        return desc.toString();
    }

    public String getBestRecoverDesc() {
        if (CollectionUtils.isEmpty(this.bestRecoverResult)) {
            return "[\u6700\u8fd1\u4e00\u6b21\u5f00\u542f\u5065\u5eb7\u68c0\u67e5\u8d77] \u670d\u52a1\u975e\u5e38\u5065\u5eb7\uff0c\u65e0\u5f02\u5e38\u68c0\u67e5\u8bb0\u5f55\uff01";
        }
        StringBuilder desc = new StringBuilder("[\u6700\u8fd1\u4e00\u6b21\u5f00\u542f\u5065\u5eb7\u68c0\u67e5\u8d77] \u670d\u52a1 \u6700\u5feb \u6062\u590d\u65f6\u95f4\u4e3a\uff1a" + (String)(this.bestRecoverTime / 1000L <= (long)this.period.intValue() ? "< " + this.period + " \u79d2" : TimeUtils.dynamicTimeUnit(this.bestRecoverTime)) + "\uff0c\u53d1\u751f\u65f6\u95f4\u70b9\uff1a");
        for (int i = 0; i < this.bestRecoverResult.size(); ++i) {
            if (i == this.bestRecoverResult.size() - 1) {
                desc.append(DateFormatUtils.format((Date)this.bestRecoverResult.get(i).getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(" .\n");
                continue;
            }
            desc.append(DateFormatUtils.format((Date)this.bestRecoverResult.get(i).getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss")).append(" , ");
        }
        return desc.toString();
    }

    public Long getBestRecoverTime() {
        return this.bestRecoverTime;
    }

    public void setBestRecoverTime(Long bestRecoverTime) {
        this.bestRecoverTime = bestRecoverTime;
    }

    public List<AlarmHealthCheckResult> getBestRecoverResult() {
        return this.bestRecoverResult;
    }

    public void setBestRecoverResult(List<AlarmHealthCheckResult> bestRecoverResult) {
        this.bestRecoverResult = bestRecoverResult;
    }

    public Long getWorstRecoverTime() {
        return this.worstRecoverTime;
    }

    public void setWorstRecoverTime(Long worstRecoverTime) {
        this.worstRecoverTime = worstRecoverTime;
    }

    public List<AlarmHealthCheckResult> getWorstRecoverResult() {
        return this.worstRecoverResult;
    }

    public void setWorstRecoverResult(List<AlarmHealthCheckResult> worstRecoverResult) {
        this.worstRecoverResult = worstRecoverResult;
    }
}

