/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.model;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.dc.alarm.api.entity.AlarmNotifyStrategyDetail;
import com.ovopark.dc.alarm.api.model.AlarmMessageTemplateModel;
import com.ovopark.dc.alarm.api.model.AlarmNotifyModel;
import com.ovopark.dc.alarm.api.model.MessageNotifyMatchConditionModel;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class MessageNotifyStrategyModel {
    private Integer id;
    @NotBlank(message="\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Size(min=4, max=20, message="\u81f3\u5c114\u4e2a\u5b57\u7b26\u6700\u591a\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26")
    private @NotBlank(message="\u7b56\u7565\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") @Size(min=4, max=20, message="\u81f3\u5c114\u4e2a\u5b57\u7b26\u6700\u591a\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26") String strategyName;
    @NotNull(message="\u901a\u77e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u901a\u77e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a") Integer notifyWay;
    @Size(max=100, message="\u6700\u591a\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26")
    private @Size(max=100, message="\u6700\u591a\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26") String wecomRobotKey;
    @NotNull(message="\u6a21\u7248id\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u6a21\u7248id\u4e0d\u80fd\u4e3a\u7a7a") Integer templateId;
    @Valid
    @Size(min=1, message="\u901a\u77e5\u7b56\u7565\u901a\u77e5\u4eba\u6700\u5c0f\u4e3a1")
    private @Valid @Size(min=1, message="\u901a\u77e5\u7b56\u7565\u901a\u77e5\u4eba\u6700\u5c0f\u4e3a1") List<AlarmNotifyModel> notifyModels;
    private AlarmMessageTemplateModel alarmMessageTemplateModel;
    @Valid
    @Size(min=1, message="\u5339\u914d\u6761\u4ef6\u6700\u5c0f\u4e3a 1")
    private @Valid @Size(min=1, message="\u5339\u914d\u6761\u4ef6\u6700\u5c0f\u4e3a 1") List<MessageNotifyMatchConditionModel> matchConditions;
    private boolean alarmConvergence;
    private Long alarmConvergenceTime;
    private List<String> alarmConvergenceConditions;
    private Boolean notifyStrategyEnable;
    private LocalDateTime createTime;
    private LocalDateTime updateTime;

    public static AlarmNotifyStrategyDetail transferFrom(MessageNotifyStrategyModel notifyStrategyModel) {
        AlarmNotifyStrategyDetail notifyStrategyDetail = new AlarmNotifyStrategyDetail();
        notifyStrategyDetail.setId(notifyStrategyModel.getId());
        notifyStrategyDetail.setStrategyName(notifyStrategyModel.getStrategyName());
        notifyStrategyDetail.setNotifyWay(notifyStrategyModel.getNotifyWay());
        notifyStrategyDetail.setWecomRobotKey(notifyStrategyModel.getWecomRobotKey() == null ? "" : notifyStrategyModel.getWecomRobotKey());
        notifyStrategyDetail.setTemplateId(notifyStrategyModel.getTemplateId());
        notifyStrategyDetail.setAlarmConvergence(notifyStrategyModel.alarmConvergence);
        notifyStrategyDetail.setAlarmConvergenceConditions(JSONObject.toJSONString(notifyStrategyModel.getAlarmConvergenceConditions()));
        notifyStrategyDetail.setAlarmConvergenceTime(notifyStrategyModel.getAlarmConvergenceTime());
        notifyStrategyDetail.setNotifyStrategyEnable(notifyStrategyModel.getNotifyStrategyEnable() == null || notifyStrategyModel.getNotifyStrategyEnable() != false);
        return notifyStrategyDetail;
    }

    public static MessageNotifyStrategyModel transferTo(AlarmNotifyStrategyDetail strategyDetail) {
        MessageNotifyStrategyModel notifyStrategyModel = new MessageNotifyStrategyModel();
        notifyStrategyModel.setId(strategyDetail.getId());
        notifyStrategyModel.setNotifyWay(strategyDetail.getNotifyWay());
        notifyStrategyModel.setWecomRobotKey(strategyDetail.getWecomRobotKey());
        notifyStrategyModel.setTemplateId(strategyDetail.getTemplateId());
        notifyStrategyModel.setStrategyName(strategyDetail.getStrategyName());
        notifyStrategyModel.setAlarmConvergence(strategyDetail.isAlarmConvergence());
        notifyStrategyModel.setAlarmConvergenceConditions(JSONObject.parseArray((String)strategyDetail.getAlarmConvergenceConditions(), String.class));
        notifyStrategyModel.setAlarmConvergenceTime(strategyDetail.getAlarmConvergenceTime());
        notifyStrategyModel.setNotifyStrategyEnable(strategyDetail.isNotifyStrategyEnable());
        notifyStrategyModel.setCreateTime(strategyDetail.getCreateTime());
        notifyStrategyModel.setUpdateTime(strategyDetail.getUpdateTime());
        return notifyStrategyModel;
    }

    public static List<MessageNotifyStrategyModel> transferToList(List<AlarmNotifyStrategyDetail> strategyDetails) {
        ArrayList<MessageNotifyStrategyModel> notifyStrategyModels = new ArrayList<MessageNotifyStrategyModel>();
        strategyDetails.forEach(x -> notifyStrategyModels.add(MessageNotifyStrategyModel.transferTo(x)));
        return notifyStrategyModels;
    }

    public Integer getId() {
        return this.id;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public Integer getNotifyWay() {
        return this.notifyWay;
    }

    public String getWecomRobotKey() {
        return this.wecomRobotKey;
    }

    public Integer getTemplateId() {
        return this.templateId;
    }

    public List<AlarmNotifyModel> getNotifyModels() {
        return this.notifyModels;
    }

    public AlarmMessageTemplateModel getAlarmMessageTemplateModel() {
        return this.alarmMessageTemplateModel;
    }

    public List<MessageNotifyMatchConditionModel> getMatchConditions() {
        return this.matchConditions;
    }

    public boolean isAlarmConvergence() {
        return this.alarmConvergence;
    }

    public Long getAlarmConvergenceTime() {
        return this.alarmConvergenceTime;
    }

    public List<String> getAlarmConvergenceConditions() {
        return this.alarmConvergenceConditions;
    }

    public Boolean getNotifyStrategyEnable() {
        return this.notifyStrategyEnable;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public void setNotifyWay(Integer notifyWay) {
        this.notifyWay = notifyWay;
    }

    public void setWecomRobotKey(String wecomRobotKey) {
        this.wecomRobotKey = wecomRobotKey;
    }

    public void setTemplateId(Integer templateId) {
        this.templateId = templateId;
    }

    public void setNotifyModels(List<AlarmNotifyModel> notifyModels) {
        this.notifyModels = notifyModels;
    }

    public void setAlarmMessageTemplateModel(AlarmMessageTemplateModel alarmMessageTemplateModel) {
        this.alarmMessageTemplateModel = alarmMessageTemplateModel;
    }

    public void setMatchConditions(List<MessageNotifyMatchConditionModel> matchConditions) {
        this.matchConditions = matchConditions;
    }

    public void setAlarmConvergence(boolean alarmConvergence) {
        this.alarmConvergence = alarmConvergence;
    }

    public void setAlarmConvergenceTime(Long alarmConvergenceTime) {
        this.alarmConvergenceTime = alarmConvergenceTime;
    }

    public void setAlarmConvergenceConditions(List<String> alarmConvergenceConditions) {
        this.alarmConvergenceConditions = alarmConvergenceConditions;
    }

    public void setNotifyStrategyEnable(Boolean notifyStrategyEnable) {
        this.notifyStrategyEnable = notifyStrategyEnable;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }

    public String toString() {
        return "MessageNotifyStrategyModel(id=" + this.getId() + ", strategyName=" + this.getStrategyName() + ", notifyWay=" + this.getNotifyWay() + ", wecomRobotKey=" + this.getWecomRobotKey() + ", templateId=" + this.getTemplateId() + ", notifyModels=" + this.getNotifyModels() + ", alarmMessageTemplateModel=" + this.getAlarmMessageTemplateModel() + ", matchConditions=" + this.getMatchConditions() + ", alarmConvergence=" + this.isAlarmConvergence() + ", alarmConvergenceTime=" + this.getAlarmConvergenceTime() + ", alarmConvergenceConditions=" + this.getAlarmConvergenceConditions() + ", notifyStrategyEnable=" + this.getNotifyStrategyEnable() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

