/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.dc.alarm.api.model.BaseQuery;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;

public class QuotaHistoryQuery
extends BaseQuery
implements Serializable {
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @ApiModelProperty(value="\u65f6\u95f4\u5f00\u59cb")
    private Date beginTime;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @ApiModelProperty(value="\u65f6\u95f4\u7ed3\u675f")
    private Date endTime;
    @ApiModelProperty(value="\u6545\u969c\u8d44\u6e90\u540d\u79f0")
    private String downResource;
    @ApiModelProperty(value="\u8d44\u6e90\u7c7b\u578b")
    private Integer[] dimensions;
    @ApiModelProperty(value="\u544a\u8b66\u7ea7\u522b")
    private Integer[] levels;
    @ApiModelProperty(value="\u5f53\u524d\u72b6\u6001")
    private Integer[] statuss;
    @ApiModelProperty(value="\u9608\u503c")
    private String[] quotas;
    @ApiModelProperty(value="\u53d1\u751f\u65f6\u95f4\u6392\u5e8f")
    private boolean isDesc = true;
    @ApiModelProperty(value="\u7b56\u7565\u53f7")
    private String strategyNo;
    @ApiModelProperty(value="\u7b56\u7565\u53f7\u5217\u8868")
    private List<String> strategyNos;

    public Date getEndTime() {
        if (this.endTime != null && this.beginTime != null && this.endTime.equals(this.beginTime)) {
            long tomorrow = this.endTime.getTime() + 86400000L;
            return new Date(tomorrow);
        }
        if (this.endTime == null && this.beginTime != null) {
            long tomorrow = this.beginTime.getTime() + 86400000L;
            return new Date(tomorrow);
        }
        return this.endTime;
    }

    @JsonIgnore
    public long getTimeDifference() {
        if (null != this.beginTime && null != this.endTime) {
            return this.endTime.getTime() - this.beginTime.getTime();
        }
        return 0L;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public String getDownResource() {
        return this.downResource;
    }

    public Integer[] getDimensions() {
        return this.dimensions;
    }

    public Integer[] getLevels() {
        return this.levels;
    }

    public Integer[] getStatuss() {
        return this.statuss;
    }

    public String[] getQuotas() {
        return this.quotas;
    }

    public boolean isDesc() {
        return this.isDesc;
    }

    public String getStrategyNo() {
        return this.strategyNo;
    }

    public List<String> getStrategyNos() {
        return this.strategyNos;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setDownResource(String downResource) {
        this.downResource = downResource;
    }

    public void setDimensions(Integer[] dimensions) {
        this.dimensions = dimensions;
    }

    public void setLevels(Integer[] levels) {
        this.levels = levels;
    }

    public void setStatuss(Integer[] statuss) {
        this.statuss = statuss;
    }

    public void setQuotas(String[] quotas) {
        this.quotas = quotas;
    }

    public void setDesc(boolean isDesc) {
        this.isDesc = isDesc;
    }

    public void setStrategyNo(String strategyNo) {
        this.strategyNo = strategyNo;
    }

    public void setStrategyNos(List<String> strategyNos) {
        this.strategyNos = strategyNos;
    }
}

