/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class RAMPager<T>
implements Serializable {
    private List<T> data;
    private int pageSize;

    public RAMPager(List<T> data, int pageSize) {
        this.data = data;
        this.pageSize = pageSize;
    }

    public List<T> page(int pageNum) {
        int to;
        int from;
        if (pageNum < 1) {
            pageNum = 1;
        }
        if ((from = (pageNum - 1) * this.pageSize) > (to = Math.min(pageNum * this.pageSize, this.data.size()))) {
            from = to;
        }
        return this.data.subList(from, to);
    }

    public int getPageCount() {
        if (this.pageSize == 0) {
            return 0;
        }
        return this.data.size() % this.pageSize == 0 ? this.data.size() / this.pageSize : this.data.size() / this.pageSize + 1;
    }

    public Iterator<List<T>> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<List<T>> {
        int page = 1;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.page <= RAMPager.this.getPageCount();
        }

        @Override
        public List<T> next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int i = this.page;
            if (i > RAMPager.this.getPageCount()) {
                return new ArrayList();
            }
            this.page = i + 1;
            return RAMPager.this.page(i);
        }
    }
}

