/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.model;

import com.ovopark.dc.alarm.api.entity.AlarmStrategyResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ServiceInstance
implements Serializable {
    private Integer resourceId;
    private String publicIpAddress;
    private String privateIpAddress;
    private Integer port;
    private String loginPwd;
    private String loginName;
    private String instanceAlias;
    private String instanceId;
    private String ruleNo;

    public static List<ServiceInstance> transferFrom(String ruleNo, List<AlarmStrategyResource> resources) {
        ArrayList<ServiceInstance> instanceList = new ArrayList<ServiceInstance>();
        resources.forEach(resource -> resource.getInstanceList().forEach(instance -> {
            ServiceInstance serviceInstance = new ServiceInstance();
            serviceInstance.setInstanceId(instance.getInstanceId());
            serviceInstance.setRuleNo(ruleNo);
            serviceInstance.setResourceId(resource.getId());
            serviceInstance.setPort(instance.getPort());
            serviceInstance.setPrivateIpAddress(instance.getPrivateIp());
            serviceInstance.setPublicIpAddress(instance.getPublicIp());
            serviceInstance.setInstanceAlias(resource.getResourceName());
            instanceList.add(serviceInstance);
        }));
        return instanceList;
    }

    public String toString() {
        return "ServiceInstance{resourceId=" + this.resourceId + ", publicIpAddress='" + this.publicIpAddress + "', privateIpAddress='" + this.privateIpAddress + "', port=" + this.port + ", loginPwd='" + this.loginPwd + "', loginName='" + this.loginName + "', instanceAlias='" + this.instanceAlias + "', instanceId='" + this.instanceId + "', ruleNo='" + this.ruleNo + "'}";
    }

    public Integer getResourceId() {
        return this.resourceId;
    }

    public String getPublicIpAddress() {
        return this.publicIpAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getLoginPwd() {
        return this.loginPwd;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getInstanceAlias() {
        return this.instanceAlias;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getRuleNo() {
        return this.ruleNo;
    }

    public void setResourceId(Integer resourceId) {
        this.resourceId = resourceId;
    }

    public void setPublicIpAddress(String publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setLoginPwd(String loginPwd) {
        this.loginPwd = loginPwd;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public void setInstanceAlias(String instanceAlias) {
        this.instanceAlias = instanceAlias;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setRuleNo(String ruleNo) {
        this.ruleNo = ruleNo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceInstance)) {
            return false;
        }
        ServiceInstance other = (ServiceInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$resourceId = this.getResourceId();
        Integer other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !((Object)this$resourceId).equals(other$resourceId)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$publicIpAddress = this.getPublicIpAddress();
        String other$publicIpAddress = other.getPublicIpAddress();
        if (this$publicIpAddress == null ? other$publicIpAddress != null : !this$publicIpAddress.equals(other$publicIpAddress)) {
            return false;
        }
        String this$privateIpAddress = this.getPrivateIpAddress();
        String other$privateIpAddress = other.getPrivateIpAddress();
        if (this$privateIpAddress == null ? other$privateIpAddress != null : !this$privateIpAddress.equals(other$privateIpAddress)) {
            return false;
        }
        String this$loginPwd = this.getLoginPwd();
        String other$loginPwd = other.getLoginPwd();
        if (this$loginPwd == null ? other$loginPwd != null : !this$loginPwd.equals(other$loginPwd)) {
            return false;
        }
        String this$loginName = this.getLoginName();
        String other$loginName = other.getLoginName();
        if (this$loginName == null ? other$loginName != null : !this$loginName.equals(other$loginName)) {
            return false;
        }
        String this$instanceAlias = this.getInstanceAlias();
        String other$instanceAlias = other.getInstanceAlias();
        if (this$instanceAlias == null ? other$instanceAlias != null : !this$instanceAlias.equals(other$instanceAlias)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$ruleNo = this.getRuleNo();
        String other$ruleNo = other.getRuleNo();
        return !(this$ruleNo == null ? other$ruleNo != null : !this$ruleNo.equals(other$ruleNo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : ((Object)$resourceId).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $publicIpAddress = this.getPublicIpAddress();
        result = result * 59 + ($publicIpAddress == null ? 43 : $publicIpAddress.hashCode());
        String $privateIpAddress = this.getPrivateIpAddress();
        result = result * 59 + ($privateIpAddress == null ? 43 : $privateIpAddress.hashCode());
        String $loginPwd = this.getLoginPwd();
        result = result * 59 + ($loginPwd == null ? 43 : $loginPwd.hashCode());
        String $loginName = this.getLoginName();
        result = result * 59 + ($loginName == null ? 43 : $loginName.hashCode());
        String $instanceAlias = this.getInstanceAlias();
        result = result * 59 + ($instanceAlias == null ? 43 : $instanceAlias.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $ruleNo = this.getRuleNo();
        result = result * 59 + ($ruleNo == null ? 43 : $ruleNo.hashCode());
        return result;
    }
}

