/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.notify;

import com.ovopark.dc.alarm.api.enums.NotifyWayEnum;
import com.ovopark.dc.alarm.api.notify.Message;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotBlank;

public class EmailMessage
implements Serializable,
Message {
    @NotBlank(message="Email address can not be blank")
    private @NotBlank(message="Email address can not be blank") String email;
    @NotBlank(message="Email subject can not be blank")
    private @NotBlank(message="Email subject can not be blank") String emailSubject;
    private String source;
    private String sender;
    @NotBlank(message="Email content can not be blank")
    private @NotBlank(message="Email content can not be blank") String content;
    private Date sendTime;
    private long delayTimeMs;

    @Override
    public NotifyWayEnum getType() {
        return NotifyWayEnum.E_MAIL;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public String getSource() {
        return this.source;
    }

    public String getSender() {
        return this.sender;
    }

    public String getContent() {
        return this.content;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public long getDelayTimeMs() {
        return this.delayTimeMs;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public static final class EmailMessageEntityBuilder {
        private String email;
        private String emailSubject;
        private String source;
        private String sender;
        private String content;
        private Date sendTime;
        private long delayTimeMs;

        private EmailMessageEntityBuilder() {
        }

        public static EmailMessageEntityBuilder builder() {
            return new EmailMessageEntityBuilder();
        }

        public EmailMessageEntityBuilder withEmail(String email) {
            this.email = email;
            return this;
        }

        public EmailMessageEntityBuilder withEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public EmailMessageEntityBuilder withSource(String source) {
            this.source = source;
            return this;
        }

        public EmailMessageEntityBuilder withSender(String sender) {
            this.sender = sender;
            return this;
        }

        public EmailMessageEntityBuilder withContent(String content) {
            this.content = content;
            return this;
        }

        public EmailMessageEntityBuilder withSendTime(Date sendTime) {
            this.sendTime = sendTime;
            return this;
        }

        public EmailMessageEntityBuilder withDelayTimeMs(long delayTimeMs) {
            this.delayTimeMs = delayTimeMs;
            return this;
        }

        public EmailMessage build() {
            EmailMessage emailMessageEntity = new EmailMessage();
            emailMessageEntity.email = this.email;
            emailMessageEntity.content = this.content;
            emailMessageEntity.sendTime = this.sendTime;
            emailMessageEntity.source = this.source;
            emailMessageEntity.sender = this.sender;
            emailMessageEntity.emailSubject = this.emailSubject;
            emailMessageEntity.delayTimeMs = this.delayTimeMs;
            return emailMessageEntity;
        }
    }
}

