/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.notify.wechat.app;

import com.ovopark.dc.alarm.api.enums.MessageStyleEnum;
import com.ovopark.dc.alarm.api.notify.NotifyUser;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class WeComAppMessage {
    private String touser;
    private String toparty;
    private String totag;
    private String msgtype;
    private Text text;
    private Markdown markdown;
    private Integer agentid;

    public void setTouser(List<NotifyUser> notifyUsers) {
        if (CollectionUtils.isNotEmpty(notifyUsers)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < notifyUsers.size(); ++i) {
                if (i == 0) {
                    stringBuilder.append(notifyUsers.get(i).getUserId());
                    continue;
                }
                stringBuilder.append("|").append(notifyUsers.get(i).getUserId());
            }
            this.touser = stringBuilder.toString();
        }
    }

    public static WeComAppMessage buildMessage(Integer messageStyle, String content, Integer agentid, List<NotifyUser> notifyUsers) {
        WeComAppMessage weComAppMessage = new WeComAppMessage();
        MessageStyleEnum styleEnum = MessageStyleEnum.matchCode(messageStyle);
        if (styleEnum.equals((Object)MessageStyleEnum.TEXT)) {
            weComAppMessage.setText(new Text(content));
        } else if (styleEnum.equals((Object)MessageStyleEnum.MARKDOWN)) {
            weComAppMessage.setMarkdown(new Markdown(content));
        }
        weComAppMessage.setTouser(notifyUsers);
        weComAppMessage.setAgentid(agentid);
        weComAppMessage.setMsgtype(styleEnum.getDesc());
        return weComAppMessage;
    }

    public String getTouser() {
        return this.touser;
    }

    public String getToparty() {
        return this.toparty;
    }

    public String getTotag() {
        return this.totag;
    }

    public String getMsgtype() {
        return this.msgtype;
    }

    public Text getText() {
        return this.text;
    }

    public Markdown getMarkdown() {
        return this.markdown;
    }

    public Integer getAgentid() {
        return this.agentid;
    }

    public void setToparty(String toparty) {
        this.toparty = toparty;
    }

    public void setTotag(String totag) {
        this.totag = totag;
    }

    public void setMsgtype(String msgtype) {
        this.msgtype = msgtype;
    }

    public void setText(Text text2) {
        this.text = text2;
    }

    public void setMarkdown(Markdown markdown) {
        this.markdown = markdown;
    }

    public void setAgentid(Integer agentid) {
        this.agentid = agentid;
    }

    public String toString() {
        return "WeComAppMessage(touser=" + this.getTouser() + ", toparty=" + this.getToparty() + ", totag=" + this.getTotag() + ", msgtype=" + this.getMsgtype() + ", text=" + this.getText() + ", markdown=" + this.getMarkdown() + ", agentid=" + this.getAgentid() + ")";
    }

    public WeComAppMessage(String touser, String toparty, String totag, String msgtype, Text text2, Markdown markdown, Integer agentid) {
        this.touser = touser;
        this.toparty = toparty;
        this.totag = totag;
        this.msgtype = msgtype;
        this.text = text2;
        this.markdown = markdown;
        this.agentid = agentid;
    }

    public WeComAppMessage() {
    }

    public static class Text {
        private String content;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String toString() {
            return "WeComAppMessage.Text(content=" + this.getContent() + ")";
        }

        public Text(String content) {
            this.content = content;
        }
    }

    public static class Markdown {
        private String content;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String toString() {
            return "WeComAppMessage.Markdown(content=" + this.getContent() + ")";
        }

        public Markdown(String content) {
            this.content = content;
        }
    }
}

