/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.notify.wechat.robot;

import com.ovopark.dc.alarm.api.enums.MessageStyleEnum;
import com.ovopark.dc.alarm.api.notify.NotifyUser;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class WeComRobotMessage {
    private String msgtype = "markdown";
    private Markdown markdown;
    private Text text;

    public static WeComRobotMessage buildMessage(Integer messageStyle, String content, List<NotifyUser> users) {
        WeComRobotMessage weComRobotMessage = new WeComRobotMessage();
        MessageStyleEnum styleEnum = MessageStyleEnum.matchCode(messageStyle);
        if (styleEnum.equals((Object)MessageStyleEnum.TEXT)) {
            weComRobotMessage.setText(new Text(content, CollectionUtils.isNotEmpty(users) ? users.stream().map(NotifyUser::getQwUserId).toList() : List.of(), CollectionUtils.isNotEmpty(users) ? users.stream().map(NotifyUser::getPhone).toList() : List.of()));
        } else if (styleEnum.equals((Object)MessageStyleEnum.MARKDOWN)) {
            Markdown md = new Markdown(content);
            if (CollectionUtils.isNotEmpty(users)) {
                md.toUser(users);
            }
            weComRobotMessage.setMarkdown(md);
        }
        weComRobotMessage.setMsgtype(styleEnum.getDesc());
        return weComRobotMessage;
    }

    public String getMsgtype() {
        return this.msgtype;
    }

    public Markdown getMarkdown() {
        return this.markdown;
    }

    public Text getText() {
        return this.text;
    }

    public void setMsgtype(String msgtype) {
        this.msgtype = msgtype;
    }

    public void setMarkdown(Markdown markdown) {
        this.markdown = markdown;
    }

    public void setText(Text text2) {
        this.text = text2;
    }

    public String toString() {
        return "WeComRobotMessage(msgtype=" + this.getMsgtype() + ", markdown=" + this.getMarkdown() + ", text=" + this.getText() + ")";
    }

    public static class Text {
        private String content;
        private List<String> mentioned_list;
        private List<String> mentioned_mobile_list;

        public String getContent() {
            return this.content;
        }

        public List<String> getMentioned_list() {
            return this.mentioned_list;
        }

        public List<String> getMentioned_mobile_list() {
            return this.mentioned_mobile_list;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public void setMentioned_list(List<String> mentioned_list) {
            this.mentioned_list = mentioned_list;
        }

        public void setMentioned_mobile_list(List<String> mentioned_mobile_list) {
            this.mentioned_mobile_list = mentioned_mobile_list;
        }

        public String toString() {
            return "WeComRobotMessage.Text(content=" + this.getContent() + ", mentioned_list=" + this.getMentioned_list() + ", mentioned_mobile_list=" + this.getMentioned_mobile_list() + ")";
        }

        public Text(String content, List<String> mentioned_list, List<String> mentioned_mobile_list) {
            this.content = content;
            this.mentioned_list = mentioned_list;
            this.mentioned_mobile_list = mentioned_mobile_list;
        }

        public Text() {
        }
    }

    public static class Markdown {
        private String content;

        public void toUser(List<NotifyUser> notifyUsers) {
            StringBuilder stringBuilder = new StringBuilder(this.content);
            notifyUsers.forEach(user -> stringBuilder.append("<@").append(user.getUserId()).append(">").append("\n"));
            this.content = stringBuilder.toString();
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String toString() {
            return "WeComRobotMessage.Markdown(content=" + this.getContent() + ")";
        }

        public Markdown(String content) {
            this.content = content;
        }

        public Markdown() {
        }
    }
}

