/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.util;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdGenerator {
    private static Logger logger = LoggerFactory.getLogger(IdGenerator.class);
    private static Random random = new Random();
    private static final long twepoch = 1288834974657L;
    private static final long workerIdBits = 5L;
    private static final long datacenterIdBits = 5L;
    private static final long maxWorkerId = 31L;
    private static final long maxDatacenterId = 31L;
    private static final long sequenceBits = 12L;
    private static final long workerIdShift = 12L;
    private static final long datacenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static IdGenerator idGenerator = new IdGenerator(IdGenerator.getWorkId(), IdGenerator.getDataCenterId());

    public IdGenerator(long workerId, long datacenterId) {
        if (workerId <= 31L && workerId >= 0L) {
            if (datacenterId > 31L || datacenterId < 0L) {
                throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0,datacenterId:%d.", 31L, datacenterId));
            }
        } else {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0,workerId:%d.", 31L, workerId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1288834974657L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public static Long getWorkId() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            int sums = hostAddress.hashCode();
            long id = Math.abs(sums % 32);
            logger.info("\u4f7f\u7528\u7684WorkId:" + id);
            return id;
        }
        catch (UnknownHostException e) {
            long id = IdGenerator.getRandom();
            logger.error("\u83b7\u53d6workid\u5931\u8d25,\u4f7f\u7528\u968f\u673a\u6570." + id + "," + e.getMessage(), (Throwable)e);
            return id;
        }
    }

    public static Long getDataCenterId() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostName();
            int sums = hostAddress.hashCode();
            long id = Math.abs(sums % 32);
            logger.info("\u4f7f\u7528\u7684DataCenterId:" + id);
            return id;
        }
        catch (UnknownHostException e) {
            long id = IdGenerator.getRandom();
            logger.error("\u83b7\u53d6DataCenterId\u5931\u8d25,\u4f7f\u7528\u968f\u673a\u6570." + id + "," + e.getMessage(), (Throwable)e);
            return id;
        }
    }

    private static long getRandom() {
        return random.nextInt(32);
    }

    public static long getNextId() {
        return idGenerator.nextId();
    }
}

