/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.CompositeStringExpression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class JsonUtil {
    private static SpelExpressionParser parser = new SpelExpressionParser();
    private static ParserContext parserContext = new ParserContext(){

        public boolean isTemplate() {
            return true;
        }

        public String getExpressionPrefix() {
            return "[";
        }

        public String getExpressionSuffix() {
            return "]";
        }
    };

    public static boolean isJson(String content) {
        if (StringUtils.isNotBlank((CharSequence)content.trim())) {
            JSONValidator jsonValidator = JSONValidator.from((String)content);
            return jsonValidator.validate();
        }
        return false;
    }

    public static boolean isJsonArray(String content) {
        if (JsonUtil.isJson(content.trim())) {
            return content.charAt(0) == '[' && content.charAt(content.length() - 1) == ']';
        }
        return false;
    }

    public static boolean isJsonObject(String content) {
        if (JsonUtil.isJson(content.trim())) {
            return content.charAt(0) == '{' && content.charAt(content.length() - 1) == '}';
        }
        return false;
    }

    public static String getNestedValue(String content, String keyExpress) {
        if (!JsonUtil.isJson(content)) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684json\u683c\u5f0f\u7684\u5b57\u7b26\u4e32");
        }
        if (StringUtils.isBlank((CharSequence)keyExpress)) {
            return content;
        }
        if (JsonUtil.isJsonObject(content)) {
            JSONObject jsonObject = JSON.parseObject((String)content);
            if (JsonUtil.isNestedKey(keyExpress)) {
                String[] keys = keyExpress.split("\\.");
                if (keys.length >= 1) {
                    Object nestedObj = jsonObject;
                    for (String key : keys) {
                        if (JsonUtil.isArrayKey(key)) {
                            int arrayIdx = JsonUtil.getKeyExpressArrayIndex(key);
                            key = JsonUtil.getKeyExpressLiteral(key);
                            if (nestedObj instanceof JSONObject) {
                                JSONObject nestJsonObj = nestedObj;
                                Object res = nestJsonObj.get((Object)key);
                                if (!JsonUtil.isJsonArray(JSON.toJSONString((Object)res))) {
                                    return null;
                                }
                                JSONArray jsonArray = nestJsonObj.getJSONArray(key);
                                if (jsonArray.size() - 1 < arrayIdx) {
                                    return null;
                                }
                                nestedObj = jsonArray.get(arrayIdx);
                                continue;
                            }
                            return null;
                        }
                        if (nestedObj instanceof JSONObject) {
                            JSONObject nestedJsonObj = nestedObj;
                            if (nestedJsonObj.containsKey((Object)key)) {
                                nestedObj = nestedJsonObj.get((Object)key);
                                continue;
                            }
                            return null;
                        }
                        return null;
                    }
                    return Objects.isNull(nestedObj) ? null : nestedObj.toString();
                }
                return content;
            }
            if (JsonUtil.isArrayKey(keyExpress)) {
                int arrayIdx = JsonUtil.getKeyExpressArrayIndex(keyExpress);
                Object res = jsonObject.get((Object)(keyExpress = JsonUtil.getKeyExpressLiteral(keyExpress)));
                if (!JsonUtil.isJsonArray(JSON.toJSONString((Object)res))) {
                    return null;
                }
                if (res instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)res;
                    if (jsonArray.size() - 1 < arrayIdx) {
                        return null;
                    }
                    return jsonArray.get(arrayIdx) == null ? null : jsonArray.get(arrayIdx).toString();
                }
                return null;
            }
            if (jsonObject.containsKey((Object)keyExpress)) {
                Object o = jsonObject.get((Object)keyExpress);
                return Objects.isNull(o) ? null : o.toString();
            }
            return null;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684json\u683c\u5f0f\u7c7b\u578b");
    }

    private static boolean isArrayKey(String key) {
        return key.contains("[") && key.endsWith("]");
    }

    private static boolean isNestedKey(String key) {
        return key.contains(".");
    }

    private static Integer getKeyExpressArrayIndex(String key) {
        Expression expression = parser.parseExpression(key, parserContext);
        if (expression instanceof CompositeStringExpression) {
            Expression[] expressions;
            CompositeStringExpression compositeStringExpression = (CompositeStringExpression)expression;
            for (Expression exp : expressions = compositeStringExpression.getExpressions()) {
                if (!(exp instanceof SpelExpression)) continue;
                SpelExpression spelExpression = (SpelExpression)exp;
                String index = spelExpression.getExpressionString();
                return Integer.parseInt(index);
            }
        }
        throw new IllegalArgumentException("\u53d6\u503c\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25");
    }

    private static String getKeyExpressLiteral(String key) {
        Expression expression = parser.parseExpression(key, parserContext);
        if (expression instanceof CompositeStringExpression) {
            Expression[] expressions;
            CompositeStringExpression compositeStringExpression = (CompositeStringExpression)expression;
            for (Expression exp : expressions = compositeStringExpression.getExpressions()) {
                if (!(exp instanceof LiteralExpression)) continue;
                LiteralExpression literalExpression = (LiteralExpression)exp;
                return literalExpression.getExpressionString();
            }
        }
        throw new IllegalArgumentException("\u53d6\u503c\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25");
    }

    public static void main(String[] args) {
        String json = "{\n  \"name\": \"zhangsan\",\n  \"age\": 11,\n  \"home\": {\n    \"country\": {\n      \"name\": \"China\",\n      \"squre\": 960,\n      \"hobbies\": [\n        {\n          \"name\": \"\u7bee\u7403\",\n          \"type\": \"ball\"\n        },\n        {\n          \"name\": \"\u8db3\u7403\",\n          \"type\": \"ball\"\n        }\n      ]\n    },\n    \"numbers\": [1,2,3]\n  },\n  \"hobbies\": [\n    {\n      \"name\": \"\u7bee\u7403\",\n      \"type\": \"ball\"\n    },\n    {\n      \"name\": \"\u8db3\u7403\",\n      \"type\": \"ball\"\n    }\n  ],\n  \"numbers\": [\n    1,\n    2\n  ],\n  \"strings\": [\n    \"a\",\n    \"b\"\n  ],\n  \"arrays\": [\n    [],[]\n  ]\n}\n";
        JSONObject j = JSONObject.parseObject((String)json);
        String a = JsonUtil.getNestedValue(JSON.toJSONString((Object)j), "home.country.hobbies[2]");
        System.out.println(a);
    }
}

