/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.vo;

import com.ovopark.dc.alarm.api.entity.AlarmEcsInstance;
import com.ovopark.dc.alarm.api.enums.MonitorDimensionEnum;
import com.ovopark.dc.alarm.api.enums.MonitorResourceEnum;
import com.ovopark.dc.alarm.api.model.hawkeye.ServiceRecords;
import com.ovopark.dc.alarm.api.vo.AlarmStrategyResourceInstanceVo;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class AlarmStrategyResourceVO
implements Serializable {
    @ApiModelProperty(value="\u81ea\u589e\u4e3b\u952eid", readOnly=true)
    private Integer id;
    @ApiModelProperty(value="\u7b56\u7565\u4e3b\u4f53\u81ea\u589e\u4e3b\u952e", readOnly=true)
    private Integer strategyId;
    @ApiModelProperty(value="\u8d44\u6e90\u540d\u79f0\uff1a\u5b9e\u4f8b\u5c31\u4e3a\u5b9e\u4f8b\u540d\uff0c\u5e94\u7528\u5c31\u662f\u5e94\u7528\u540d\u79f0", required=true)
    @NotNull(message="\u8d44\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u8d44\u6e90\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String resourceName;
    @ApiModelProperty(value="\u8d44\u6e90\u6765\u6e90", required=true)
    @NotNull(message="\u8d44\u6e90\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u8d44\u6e90\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a") Integer resourceSource;
    @ApiModelProperty(value="\u8d44\u6e90\u7ef4\u5ea6", required=true)
    @NotNull(message="\u8d44\u6e90\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u8d44\u6e90\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a") Integer resourceDimension;
    @ApiModelProperty(value="\u8d44\u6e90\u5b9e\u4f8b\u4fe1\u606f\u5217\u8868", required=true)
    @Valid
    @NotEmpty(message="\u8d44\u6e90\u5b9e\u4f8b\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a")
    private @Valid @NotEmpty(message="\u8d44\u6e90\u5b9e\u4f8b\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a") List<@Valid AlarmStrategyResourceInstanceVo> instanceVos;
    @ApiModelProperty(value="\u5b9e\u4f8bIP")
    private String instanceIp;
    @ApiModelProperty(value="\u5b9e\u4f8bID,\u53ea\u7528\u4e8e\u7ed9\u524d\u7aef")
    private String resourceInstanceId;
    private String servicePort;
    private String prometheusServiceName;

    public static AlarmStrategyResourceVO transferFromServiceRecord(ServiceRecords.Records vo) {
        AlarmStrategyResourceVO alarmStrategyResourceVO = new AlarmStrategyResourceVO();
        alarmStrategyResourceVO.setResourceName(vo.getApplyName());
        alarmStrategyResourceVO.setResourceDimension(MonitorDimensionEnum.\u5e94\u7528.getCode());
        ArrayList<AlarmStrategyResourceInstanceVo> instanceVoList = new ArrayList<AlarmStrategyResourceInstanceVo>();
        alarmStrategyResourceVO.setId(Integer.valueOf(vo.getId()));
        alarmStrategyResourceVO.setPrometheusServiceName(vo.getProcessName());
        vo.getApplyInstanceVOList().forEach(apply -> Optional.ofNullable(apply.getPublicIpAddress()).ifPresent(inst -> {
            AlarmStrategyResourceInstanceVo instanceVo = new AlarmStrategyResourceInstanceVo();
            instanceVo.setId(Integer.valueOf(apply.getId()));
            instanceVo.setPrometheusInstanceName(apply.getInstance());
            instanceVo.setInnerIpAddress(apply.getInnerIpAddress());
            instanceVo.setPublicIpAddress(apply.getPublicIpAddress());
            instanceVo.setPort(Integer.parseInt(apply.getPort()));
            instanceVo.setInstanceId(apply.getHostInfoId());
            instanceVoList.add(instanceVo);
        }));
        alarmStrategyResourceVO.setInstanceVos(instanceVoList);
        return alarmStrategyResourceVO;
    }

    public static AlarmStrategyResourceVO transferFromEcsInstance(AlarmEcsInstance alarmEcsInstance) {
        AlarmStrategyResourceVO alarmStrategyResourceVO = new AlarmStrategyResourceVO();
        alarmStrategyResourceVO.setResourceName(alarmEcsInstance.getInstanceName());
        alarmStrategyResourceVO.setResourceInstanceId(alarmEcsInstance.getInstanceId());
        alarmStrategyResourceVO.setId((int)alarmEcsInstance.getId());
        alarmStrategyResourceVO.setResourceSource(MonitorResourceEnum.\u4e91\u670d\u52a1\u5668ECS.getCode());
        alarmStrategyResourceVO.setResourceDimension(MonitorDimensionEnum.\u5e94\u7528.getCode());
        alarmStrategyResourceVO.setInstanceIp(alarmEcsInstance.getPublicIp());
        ArrayList<AlarmStrategyResourceInstanceVo> instanceVoList = new ArrayList<AlarmStrategyResourceInstanceVo>();
        AlarmStrategyResourceInstanceVo instanceVo = new AlarmStrategyResourceInstanceVo();
        instanceVo.setInnerIpAddress(alarmEcsInstance.getPrivateIp());
        instanceVo.setPublicIpAddress(alarmEcsInstance.getPublicIp());
        instanceVo.setInstanceId(alarmEcsInstance.getInstanceId());
        instanceVo.setPrometheusInstanceName(alarmEcsInstance.getInstanceName());
        instanceVo.setPort(22);
        instanceVoList.add(instanceVo);
        alarmStrategyResourceVO.setInstanceVos(instanceVoList);
        return alarmStrategyResourceVO;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getStrategyId() {
        return this.strategyId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Integer getResourceSource() {
        return this.resourceSource;
    }

    public Integer getResourceDimension() {
        return this.resourceDimension;
    }

    public List<@Valid AlarmStrategyResourceInstanceVo> getInstanceVos() {
        return this.instanceVos;
    }

    public String getInstanceIp() {
        return this.instanceIp;
    }

    public String getResourceInstanceId() {
        return this.resourceInstanceId;
    }

    public String getServicePort() {
        return this.servicePort;
    }

    public String getPrometheusServiceName() {
        return this.prometheusServiceName;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setStrategyId(Integer strategyId) {
        this.strategyId = strategyId;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public void setResourceSource(Integer resourceSource) {
        this.resourceSource = resourceSource;
    }

    public void setResourceDimension(Integer resourceDimension) {
        this.resourceDimension = resourceDimension;
    }

    public void setInstanceVos(List<@Valid AlarmStrategyResourceInstanceVo> instanceVos) {
        this.instanceVos = instanceVos;
    }

    public void setInstanceIp(String instanceIp) {
        this.instanceIp = instanceIp;
    }

    public void setResourceInstanceId(String resourceInstanceId) {
        this.resourceInstanceId = resourceInstanceId;
    }

    public void setServicePort(String servicePort) {
        this.servicePort = servicePort;
    }

    public void setPrometheusServiceName(String prometheusServiceName) {
        this.prometheusServiceName = prometheusServiceName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmStrategyResourceVO)) {
            return false;
        }
        AlarmStrategyResourceVO other = (AlarmStrategyResourceVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$strategyId = this.getStrategyId();
        Integer other$strategyId = other.getStrategyId();
        if (this$strategyId == null ? other$strategyId != null : !((Object)this$strategyId).equals(other$strategyId)) {
            return false;
        }
        Integer this$resourceSource = this.getResourceSource();
        Integer other$resourceSource = other.getResourceSource();
        if (this$resourceSource == null ? other$resourceSource != null : !((Object)this$resourceSource).equals(other$resourceSource)) {
            return false;
        }
        Integer this$resourceDimension = this.getResourceDimension();
        Integer other$resourceDimension = other.getResourceDimension();
        if (this$resourceDimension == null ? other$resourceDimension != null : !((Object)this$resourceDimension).equals(other$resourceDimension)) {
            return false;
        }
        String this$resourceName = this.getResourceName();
        String other$resourceName = other.getResourceName();
        if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
            return false;
        }
        List<AlarmStrategyResourceInstanceVo> this$instanceVos = this.getInstanceVos();
        List<AlarmStrategyResourceInstanceVo> other$instanceVos = other.getInstanceVos();
        if (this$instanceVos == null ? other$instanceVos != null : !((Object)this$instanceVos).equals(other$instanceVos)) {
            return false;
        }
        String this$instanceIp = this.getInstanceIp();
        String other$instanceIp = other.getInstanceIp();
        if (this$instanceIp == null ? other$instanceIp != null : !this$instanceIp.equals(other$instanceIp)) {
            return false;
        }
        String this$resourceInstanceId = this.getResourceInstanceId();
        String other$resourceInstanceId = other.getResourceInstanceId();
        if (this$resourceInstanceId == null ? other$resourceInstanceId != null : !this$resourceInstanceId.equals(other$resourceInstanceId)) {
            return false;
        }
        String this$servicePort = this.getServicePort();
        String other$servicePort = other.getServicePort();
        if (this$servicePort == null ? other$servicePort != null : !this$servicePort.equals(other$servicePort)) {
            return false;
        }
        String this$prometheusServiceName = this.getPrometheusServiceName();
        String other$prometheusServiceName = other.getPrometheusServiceName();
        return !(this$prometheusServiceName == null ? other$prometheusServiceName != null : !this$prometheusServiceName.equals(other$prometheusServiceName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmStrategyResourceVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $strategyId = this.getStrategyId();
        result = result * 59 + ($strategyId == null ? 43 : ((Object)$strategyId).hashCode());
        Integer $resourceSource = this.getResourceSource();
        result = result * 59 + ($resourceSource == null ? 43 : ((Object)$resourceSource).hashCode());
        Integer $resourceDimension = this.getResourceDimension();
        result = result * 59 + ($resourceDimension == null ? 43 : ((Object)$resourceDimension).hashCode());
        String $resourceName = this.getResourceName();
        result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
        List<AlarmStrategyResourceInstanceVo> $instanceVos = this.getInstanceVos();
        result = result * 59 + ($instanceVos == null ? 43 : ((Object)$instanceVos).hashCode());
        String $instanceIp = this.getInstanceIp();
        result = result * 59 + ($instanceIp == null ? 43 : $instanceIp.hashCode());
        String $resourceInstanceId = this.getResourceInstanceId();
        result = result * 59 + ($resourceInstanceId == null ? 43 : $resourceInstanceId.hashCode());
        String $servicePort = this.getServicePort();
        result = result * 59 + ($servicePort == null ? 43 : $servicePort.hashCode());
        String $prometheusServiceName = this.getPrometheusServiceName();
        result = result * 59 + ($prometheusServiceName == null ? 43 : $prometheusServiceName.hashCode());
        return result;
    }

    public String toString() {
        return "AlarmStrategyResourceVO(id=" + this.getId() + ", strategyId=" + this.getStrategyId() + ", resourceName=" + this.getResourceName() + ", resourceSource=" + this.getResourceSource() + ", resourceDimension=" + this.getResourceDimension() + ", instanceVos=" + this.getInstanceVos() + ", instanceIp=" + this.getInstanceIp() + ", resourceInstanceId=" + this.getResourceInstanceId() + ", servicePort=" + this.getServicePort() + ", prometheusServiceName=" + this.getPrometheusServiceName() + ")";
    }
}

