/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.api.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.dc.alarm.api.enums.AlarmLevelEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

public class AlarmStrategyRuleVO
implements Serializable {
    @ApiModelProperty(value="\u81ea\u589e\u4e3b\u952eid", readOnly=true)
    private Integer id;
    @ApiModelProperty(value="\u9608\u503c\u544a\u8b66\u89c4\u5219\u552f\u4e00\u6807\u8bc6", readOnly=true)
    private String ruleNo;
    @NotNull(message="\u544a\u8b66\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a")
    @ApiModelProperty(value="\u544a\u8b66\u6a21\u5f0f", required=true)
    private @NotNull(message="\u544a\u8b66\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a") Integer alarmMode;
    @ApiModelProperty(value="\u7b56\u7565\u4e3b\u4f53\u81ea\u589e\u4e3b\u952e", readOnly=true)
    private Integer strategyId;
    @NotNull(message="\u6267\u884c\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a")
    @Min(value=1L, message="\u6267\u884c\u9891\u7387\u6700\u5c0f\u4e3a 1")
    @ApiModelProperty(value="\u6267\u884c\u9891\u7387", required=true)
    private @NotNull(message="\u6267\u884c\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=1L, message="\u6267\u884c\u9891\u7387\u6700\u5c0f\u4e3a 1") Integer frequency;
    @NotBlank(message="\u6267\u884c\u9891\u7387\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a")
    @ApiModelProperty(value="\u6267\u884c\u9891\u7387\u5355\u4f4d", required=true)
    private @NotBlank(message="\u6267\u884c\u9891\u7387\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a") String frequencyUnit;
    @ApiModelProperty(value="\u544a\u8b66\u6307\u6807\u552f\u4e00\u6807\u8bc6", readOnly=true, required=true)
    @NotBlank(message="\u7b56\u7565\u6307\u6807\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u7b56\u7565\u6307\u6807\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a") String quotaId;
    @ApiModelProperty(value="\u8fde\u7eed\u6b21\u6570", required=true)
    @NotNull(message="\u6761\u4ef6\u8fde\u7eed\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a")
    @Min(value=1L, message="\u8fde\u7eed\u6b21\u6570\u6700\u5c0f\u4e3a 1")
    private @NotNull(message="\u6761\u4ef6\u8fde\u7eed\u6b21\u6570\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=1L, message="\u8fde\u7eed\u6b21\u6570\u6700\u5c0f\u4e3a 1") Integer consecutiveTimes;
    @NotBlank(message="\u6761\u4ef6\u5224\u65ad\u7b26\u4e0d\u80fd\u4e3a\u7a7a")
    @ApiModelProperty(value="\u6761\u4ef6\u5224\u65ad\u7b26", required=true)
    private @NotBlank(message="\u6761\u4ef6\u5224\u65ad\u7b26\u4e0d\u80fd\u4e3a\u7a7a") String triggerSymbol;
    @Digits(integer=6, fraction=2, message="\u6761\u4ef6\u5224\u65ad\u9600\u503c\u6700\u591a\u652f\u6301 000000.00 ~ 999999.99")
    @Min(value=0L, message="\u6761\u4ef6\u5224\u65ad\u9608\u503c\u6700\u5c0f\u4e3a 0")
    @ApiModelProperty(value="\u6761\u4ef6\u5224\u65ad\u9600\u503c", required=true)
    private @Digits(integer=6, fraction=2, message="\u6761\u4ef6\u5224\u65ad\u9600\u503c\u6700\u591a\u652f\u6301 000000.00 ~ 999999.99") @Min(value=0L, message="\u6761\u4ef6\u5224\u65ad\u9608\u503c\u6700\u5c0f\u4e3a 0") Double triggerThreshold;
    @NotNull(message="\u544a\u8b66\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a")
    @ApiModelProperty(value="\u544a\u8b66\u7ea7\u522b", required=true)
    private @NotNull(message="\u544a\u8b66\u7ea7\u522b\u4e0d\u80fd\u4e3a\u7a7a") Integer alarmLevel;
    @NotNull(message="\u544a\u8b66\u5ef6\u65f6\u4e0d\u80fd\u4e3a\u7a7a")
    @ApiModelProperty(value="\u9996\u6b21\u544a\u8b66\u4e4b\u540e\u540e\u7eed\u544a\u8b66\u5ef6\u65f6", required=true)
    @Min(value=0L, message="\u5ef6\u65f6\u65f6\u95f4\u6700\u5c0f\u4e3a 0")
    private @NotNull(message="\u544a\u8b66\u5ef6\u65f6\u4e0d\u80fd\u4e3a\u7a7a") @Min(value=0L, message="\u5ef6\u65f6\u65f6\u95f4\u6700\u5c0f\u4e3a 0") Integer alarmDelay;
    @NotBlank(message="\u5ef6\u65f6\u65f6\u95f4\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a")
    @ApiModelProperty(value="\u5ef6\u65f6\u65f6\u95f4\u5355\u4f4d", required=true)
    private @NotBlank(message="\u5ef6\u65f6\u65f6\u95f4\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a") String alarmDelayUnit;
    @ApiModelProperty(value="\u7b56\u7565\u6267\u884c\u5907\u6ce8")
    @JsonIgnore
    private String executeRemark;
    @JsonIgnore
    @ApiModelProperty(value="\u7b56\u7565\u6267\u884c\u72b6\u6001")
    private Integer executeState;
    @NotNull(message="\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @ApiModelProperty(value="\u6307\u6807\u540d\u79f0", required=true)
    private @NotNull(message="\u6307\u6807\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String quoteName;
    @ApiModelProperty(value="\u544a\u8b66\u8868\u8fbe\u5f0f")
    private String quoteExpress;

    public String getQuoteExpress() {
        String email = " \u6bcf " + this.getFrequency() + this.getFrequencyUnit() + " \u91c7\u96c6\u4e00\u6b21\u6570\u636e,\u82e5 " + this.getQuoteName() + " \u8fde\u7eed " + this.getConsecutiveTimes() + " \u6b21 " + this.getTriggerSymbol() + this.getTriggerThreshold() + " \u5219\u7acb\u523b\u53d1\u9001 " + AlarmLevelEnum.matchCode(this.getAlarmLevel()) + " \u544a\u8b66,\u540e\u7eed\u6bcf\u6b21\u544a\u8b66\u5ef6\u671f " + this.getAlarmDelay() + this.getAlarmDelayUnit() + " .";
        return email;
    }

    public Integer getId() {
        return this.id;
    }

    public String getRuleNo() {
        return this.ruleNo;
    }

    public Integer getAlarmMode() {
        return this.alarmMode;
    }

    public Integer getStrategyId() {
        return this.strategyId;
    }

    public Integer getFrequency() {
        return this.frequency;
    }

    public String getFrequencyUnit() {
        return this.frequencyUnit;
    }

    public String getQuotaId() {
        return this.quotaId;
    }

    public Integer getConsecutiveTimes() {
        return this.consecutiveTimes;
    }

    public String getTriggerSymbol() {
        return this.triggerSymbol;
    }

    public Double getTriggerThreshold() {
        return this.triggerThreshold;
    }

    public Integer getAlarmLevel() {
        return this.alarmLevel;
    }

    public Integer getAlarmDelay() {
        return this.alarmDelay;
    }

    public String getAlarmDelayUnit() {
        return this.alarmDelayUnit;
    }

    public String getExecuteRemark() {
        return this.executeRemark;
    }

    public Integer getExecuteState() {
        return this.executeState;
    }

    public String getQuoteName() {
        return this.quoteName;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setRuleNo(String ruleNo) {
        this.ruleNo = ruleNo;
    }

    public void setAlarmMode(Integer alarmMode) {
        this.alarmMode = alarmMode;
    }

    public void setStrategyId(Integer strategyId) {
        this.strategyId = strategyId;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public void setFrequencyUnit(String frequencyUnit) {
        this.frequencyUnit = frequencyUnit;
    }

    public void setQuotaId(String quotaId) {
        this.quotaId = quotaId;
    }

    public void setConsecutiveTimes(Integer consecutiveTimes) {
        this.consecutiveTimes = consecutiveTimes;
    }

    public void setTriggerSymbol(String triggerSymbol) {
        this.triggerSymbol = triggerSymbol;
    }

    public void setTriggerThreshold(Double triggerThreshold) {
        this.triggerThreshold = triggerThreshold;
    }

    public void setAlarmLevel(Integer alarmLevel) {
        this.alarmLevel = alarmLevel;
    }

    public void setAlarmDelay(Integer alarmDelay) {
        this.alarmDelay = alarmDelay;
    }

    public void setAlarmDelayUnit(String alarmDelayUnit) {
        this.alarmDelayUnit = alarmDelayUnit;
    }

    @JsonIgnore
    public void setExecuteRemark(String executeRemark) {
        this.executeRemark = executeRemark;
    }

    @JsonIgnore
    public void setExecuteState(Integer executeState) {
        this.executeState = executeState;
    }

    public void setQuoteName(String quoteName) {
        this.quoteName = quoteName;
    }

    public void setQuoteExpress(String quoteExpress) {
        this.quoteExpress = quoteExpress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlarmStrategyRuleVO)) {
            return false;
        }
        AlarmStrategyRuleVO other = (AlarmStrategyRuleVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$alarmMode = this.getAlarmMode();
        Integer other$alarmMode = other.getAlarmMode();
        if (this$alarmMode == null ? other$alarmMode != null : !((Object)this$alarmMode).equals(other$alarmMode)) {
            return false;
        }
        Integer this$strategyId = this.getStrategyId();
        Integer other$strategyId = other.getStrategyId();
        if (this$strategyId == null ? other$strategyId != null : !((Object)this$strategyId).equals(other$strategyId)) {
            return false;
        }
        Integer this$frequency = this.getFrequency();
        Integer other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)this$frequency).equals(other$frequency)) {
            return false;
        }
        Integer this$consecutiveTimes = this.getConsecutiveTimes();
        Integer other$consecutiveTimes = other.getConsecutiveTimes();
        if (this$consecutiveTimes == null ? other$consecutiveTimes != null : !((Object)this$consecutiveTimes).equals(other$consecutiveTimes)) {
            return false;
        }
        Double this$triggerThreshold = this.getTriggerThreshold();
        Double other$triggerThreshold = other.getTriggerThreshold();
        if (this$triggerThreshold == null ? other$triggerThreshold != null : !((Object)this$triggerThreshold).equals(other$triggerThreshold)) {
            return false;
        }
        Integer this$alarmLevel = this.getAlarmLevel();
        Integer other$alarmLevel = other.getAlarmLevel();
        if (this$alarmLevel == null ? other$alarmLevel != null : !((Object)this$alarmLevel).equals(other$alarmLevel)) {
            return false;
        }
        Integer this$alarmDelay = this.getAlarmDelay();
        Integer other$alarmDelay = other.getAlarmDelay();
        if (this$alarmDelay == null ? other$alarmDelay != null : !((Object)this$alarmDelay).equals(other$alarmDelay)) {
            return false;
        }
        Integer this$executeState = this.getExecuteState();
        Integer other$executeState = other.getExecuteState();
        if (this$executeState == null ? other$executeState != null : !((Object)this$executeState).equals(other$executeState)) {
            return false;
        }
        String this$ruleNo = this.getRuleNo();
        String other$ruleNo = other.getRuleNo();
        if (this$ruleNo == null ? other$ruleNo != null : !this$ruleNo.equals(other$ruleNo)) {
            return false;
        }
        String this$frequencyUnit = this.getFrequencyUnit();
        String other$frequencyUnit = other.getFrequencyUnit();
        if (this$frequencyUnit == null ? other$frequencyUnit != null : !this$frequencyUnit.equals(other$frequencyUnit)) {
            return false;
        }
        String this$quotaId = this.getQuotaId();
        String other$quotaId = other.getQuotaId();
        if (this$quotaId == null ? other$quotaId != null : !this$quotaId.equals(other$quotaId)) {
            return false;
        }
        String this$triggerSymbol = this.getTriggerSymbol();
        String other$triggerSymbol = other.getTriggerSymbol();
        if (this$triggerSymbol == null ? other$triggerSymbol != null : !this$triggerSymbol.equals(other$triggerSymbol)) {
            return false;
        }
        String this$alarmDelayUnit = this.getAlarmDelayUnit();
        String other$alarmDelayUnit = other.getAlarmDelayUnit();
        if (this$alarmDelayUnit == null ? other$alarmDelayUnit != null : !this$alarmDelayUnit.equals(other$alarmDelayUnit)) {
            return false;
        }
        String this$executeRemark = this.getExecuteRemark();
        String other$executeRemark = other.getExecuteRemark();
        if (this$executeRemark == null ? other$executeRemark != null : !this$executeRemark.equals(other$executeRemark)) {
            return false;
        }
        String this$quoteName = this.getQuoteName();
        String other$quoteName = other.getQuoteName();
        if (this$quoteName == null ? other$quoteName != null : !this$quoteName.equals(other$quoteName)) {
            return false;
        }
        String this$quoteExpress = this.getQuoteExpress();
        String other$quoteExpress = other.getQuoteExpress();
        return !(this$quoteExpress == null ? other$quoteExpress != null : !this$quoteExpress.equals(other$quoteExpress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlarmStrategyRuleVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $alarmMode = this.getAlarmMode();
        result = result * 59 + ($alarmMode == null ? 43 : ((Object)$alarmMode).hashCode());
        Integer $strategyId = this.getStrategyId();
        result = result * 59 + ($strategyId == null ? 43 : ((Object)$strategyId).hashCode());
        Integer $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)$frequency).hashCode());
        Integer $consecutiveTimes = this.getConsecutiveTimes();
        result = result * 59 + ($consecutiveTimes == null ? 43 : ((Object)$consecutiveTimes).hashCode());
        Double $triggerThreshold = this.getTriggerThreshold();
        result = result * 59 + ($triggerThreshold == null ? 43 : ((Object)$triggerThreshold).hashCode());
        Integer $alarmLevel = this.getAlarmLevel();
        result = result * 59 + ($alarmLevel == null ? 43 : ((Object)$alarmLevel).hashCode());
        Integer $alarmDelay = this.getAlarmDelay();
        result = result * 59 + ($alarmDelay == null ? 43 : ((Object)$alarmDelay).hashCode());
        Integer $executeState = this.getExecuteState();
        result = result * 59 + ($executeState == null ? 43 : ((Object)$executeState).hashCode());
        String $ruleNo = this.getRuleNo();
        result = result * 59 + ($ruleNo == null ? 43 : $ruleNo.hashCode());
        String $frequencyUnit = this.getFrequencyUnit();
        result = result * 59 + ($frequencyUnit == null ? 43 : $frequencyUnit.hashCode());
        String $quotaId = this.getQuotaId();
        result = result * 59 + ($quotaId == null ? 43 : $quotaId.hashCode());
        String $triggerSymbol = this.getTriggerSymbol();
        result = result * 59 + ($triggerSymbol == null ? 43 : $triggerSymbol.hashCode());
        String $alarmDelayUnit = this.getAlarmDelayUnit();
        result = result * 59 + ($alarmDelayUnit == null ? 43 : $alarmDelayUnit.hashCode());
        String $executeRemark = this.getExecuteRemark();
        result = result * 59 + ($executeRemark == null ? 43 : $executeRemark.hashCode());
        String $quoteName = this.getQuoteName();
        result = result * 59 + ($quoteName == null ? 43 : $quoteName.hashCode());
        String $quoteExpress = this.getQuoteExpress();
        result = result * 59 + ($quoteExpress == null ? 43 : $quoteExpress.hashCode());
        return result;
    }

    public String toString() {
        return "AlarmStrategyRuleVO(id=" + this.getId() + ", ruleNo=" + this.getRuleNo() + ", alarmMode=" + this.getAlarmMode() + ", strategyId=" + this.getStrategyId() + ", frequency=" + this.getFrequency() + ", frequencyUnit=" + this.getFrequencyUnit() + ", quotaId=" + this.getQuotaId() + ", consecutiveTimes=" + this.getConsecutiveTimes() + ", triggerSymbol=" + this.getTriggerSymbol() + ", triggerThreshold=" + this.getTriggerThreshold() + ", alarmLevel=" + this.getAlarmLevel() + ", alarmDelay=" + this.getAlarmDelay() + ", alarmDelayUnit=" + this.getAlarmDelayUnit() + ", executeRemark=" + this.getExecuteRemark() + ", executeState=" + this.getExecuteState() + ", quoteName=" + this.getQuoteName() + ", quoteExpress=" + this.getQuoteExpress() + ")";
    }
}

