/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.event.notify;

import com.ovopark.dc.alarm.event.notify.event.Event;
import com.ovopark.dc.alarm.event.notify.listener.Subscriber;
import com.ovopark.dc.alarm.event.notify.publisher.EventPublisher;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class UnifiedNotifyCenter
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnifiedNotifyCenter.class);
    private static ApplicationContext applicationContext;
    private final Map<String, EventPublisher> publisherMap = new ConcurrentHashMap<String, EventPublisher>(16);

    public UnifiedNotifyCenter(Collection<EventPublisher> publishers) {
        LOGGER.info("[EventNotifyAutoConfiguration] init UnifiedNotifyCenter ...");
        publishers.forEach(publisher -> this.publisherMap.putIfAbsent(publisher.getEventType().getCanonicalName(), (EventPublisher)publisher));
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!this.publisherMap.isEmpty()) {
                this.publisherMap.forEach((key, value) -> value.shutdown());
            }
        }));
    }

    public static UnifiedNotifyCenter getInstance() {
        ObjectProvider unifiedNotifyCenters = applicationContext.getBeanProvider(UnifiedNotifyCenter.class);
        return (UnifiedNotifyCenter)unifiedNotifyCenters.getIfAvailable();
    }

    public void registerSubscriber(Subscriber subscriber) {
        String topic = subscriber.subscribeType().getCanonicalName();
        EventPublisher publisher = this.publisherMap.get(topic);
        if (Objects.nonNull(publisher)) {
            publisher.addSubscriber(subscriber);
        }
    }

    public boolean publishEvent(Event event) {
        try {
            return this.publishEvent(event.getClass(), event);
        }
        catch (Throwable ex) {
            LOGGER.error("There was an exception to the message publishing : ", ex);
            return false;
        }
    }

    public boolean publishEvent(Class<? extends Event> eventType, Event event) {
        String topic = eventType.getCanonicalName();
        EventPublisher publisher = this.publisherMap.get(topic);
        if (!Objects.isNull(publisher)) {
            return publisher.publish(event);
        }
        LOGGER.warn("[UnifiedNotifyCenter] There is no [{}] publisher for this event.", (Object)topic);
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        UnifiedNotifyCenter.applicationContext = applicationContext;
    }
}

