/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.alarm.event.notify.publisher;

import com.ovopark.dc.alarm.event.notify.event.Event;
import com.ovopark.dc.alarm.event.notify.listener.Subscriber;
import com.ovopark.dc.alarm.event.notify.publisher.EventPublisher;
import java.util.HashSet;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEventPublisher
implements EventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseEventPublisher.class);
    private final HashSet<Subscriber> subscribers = new HashSet();

    @Override
    public void addSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    @Override
    public void removeSubscriber(Subscriber subscriber) {
        this.subscribers.remove(subscriber);
    }

    @Override
    public boolean publish(Event event) {
        for (Subscriber subscriber : this.subscribers) {
            if (!Objects.nonNull(subscriber)) continue;
            this.notifySubscriber(subscriber, event);
        }
        return true;
    }

    @Override
    public void notifySubscriber(Subscriber subscriber, Event event) {
        subscriber.onEvent(event);
    }
}

